// FILENAME:	StarsiegeArena.cs
// AUTHORS:  	Orogogus
//------------------------------------------------------------------------------

// v1.0:	Hastily converted the Whack-A-Goad script to Starsiege Arena for initial testing
//			Scrapped the AIs, and kit-bashed the teleport code, mostly.


//=============  Server settings

$missionName = "Starsiege Arena";

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");
exec("arenascoring.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = false;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}


//============  Globals

$boxes = 3;
$spawnPoints = 4;   

// spawnpoints are created in the map.  
// Blank triggers with name spawn1, spawn2, spawn3, etc., 
// placed in the box#/ folder.  E.g., /Missiongroup/box1/spawn1


//============  Initializing the boxes

for (%i=0; %i<$boxes; %i++)
{
	$boxFirst[%i] = 0;
}

for (%i=0; %i<$boxes; %i++)
{
	$boxSecond[%i] = 0;
}

for (%i=0; %i<$boxes; %i++)
{
	$boxState[%i] = 0;           // 0 is empty, 1 is waiting, 2 is full
}




//=============  Some default settings for the mission


function onMissionStart()
{
	marsSounds();
}


function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
}


function setDefaultMissionItems() 
{
	exec("defaultVehicles");
	allowComponent("all", true);
	allowWeapon("all", true);
	allowVehicle(17,FALSE);  //KnightDisrupter
	allowVehicle(8,FALSE);//Disrupter
	allowComponent(875,FALSE);//FieldStabilizer
	allowWeapon(3,TRUE);//Disrupter
}


//============= Main body


function BeamHimUp::trigger::onEnter(%this, %vehicleId)
{
	%openings = teleportPlayerCheck();
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);

	if (%openings == 2)
	{
		say(%player, 0, "Sorry, all boxes currently full.  Try again later.");
	}

	if (%openings < 2)
	{
		teleportPlayer(%vehicleId, %openings);
	}
}


function teleportPlayerCheck()
{
	// If a box with one player, waiting for an opponent is available, the bestCase is 1.
	// Next bestCase is a box with no players, where the player can wait for someone to show up.
	// The default case is two, which is a full box.

	%bestCase = 2;

	for ( %i=0; %i<$boxes; %i++ )
	{
		if($boxState[%i] == 1)
		{
			%bestCase = 1;
		}
		else if((%bestCase != 1) && ($boxState[%i] == 0))
		{
			%bestCase = 0;
		}
		else
 		{
		}
	}

	return %bestCase;
}


function teleportPlayer(%vehicleId, %bestCase)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicleId);

	%Scotty = randomInt(0, ($boxes-1));

	if(%bestCase == 0)
	{

		%breaker = 0;
		while($boxState[%Scotty] == 2)
		{
			%Scotty = randomInt(0, ($boxes-1));
			%breaker++;
			if(%breaker > 200)
			{
				say(%player, 0, "Oops.  Infinite loop.  Please step out and try again.");
			}
		}
	}

	else if(%bestCase == 1)
	{
		%breaker = 0;
		while($boxState[%Scotty] != 1)
		{
			%Scotty = randomInt(0, ($boxes-1));
			%breaker++;
			if(%breaker > 200)
			{
				say(%player, 0, "Oops.  Infinite loop.  Please step out and try again.");
			}
		}
	}


	// Check to see if someone's already there, set opponents appropriately

	if ($boxFirst[%Scotty] == 0)
	{
		$boxFirst[%Scotty] = %player;
		$boxState[%Scotty] = 1;
		%player.opponent = 0;
	}

	else
	{
		$boxSecond[%Scotty] = %player;
		$boxState[%Scotty] = 2;
		%player.opponent = $boxFirst[%Scotty];
		%temp = %player.opponent;
		%temp.opponent = %player;
	}


	// Make sure not to spawn too close to the opponent

	%spawnPoint = randomInt(1, $spawnPoints);

	if(%player.opponent != 0)
	{
		%opponentVehId = %player.opponent.vehicleId;
		%nearness = getDistance(%opponentVehId, "MissionGroup/Box"@(%Scotty + 1)@"/spawn"@%spawnPoint);

		%breaker = 0;

		while(%nearness < 50) 
		{
			%spawnPoint = randomInt(1, $spawnPoints);
			%nearness = getDistance(%opponentVehId, "MissionGroup/Box"@(%Scotty + 1)@"/spawn"@%spawnPoint);
			%breaker++;
			if(%breaker > 500)
			{
				say(everybody, 0, "Oops.  Infinite loop.  Restarting server.");
				missionEndConditionMet();
			}
		}

		say(%player, 0, "Your next fight: "@%player.opponent.name@ " ("@%player.opponent.vehicle@")" );
		say(%player.opponent, 0, "Your next fight has arrived: "@%player.name@ " ("@%player.vehicle@")" );
	}


	if(%player.opponent == 0)
	{
		say(%player, 0, "Teleporting to an empty box to wait for opponents");
	}
	

	healObject( %vehicleId, 50000);    // Stopgap measure to help ameliorate lobby fights
	healObject( %vehicleId, 50000);
	reloadObject( %vehicleId, 100);
	healObject( %vehicleId, 50000);


	// And away we go...

	fadeEvent(%player, out, 1.0, 1.0, 1.0, 1.0);
	fadeEvent(%player, in, 1.0, 1.0, 1.0, 1.0);

	%temp1 = getObjectId(%vehicleId);
	%temp2 = "MissionGroup/Box"@(%Scotty + 1)@"/spawn"@%spawnPoint;
	warp(%temp1, %temp2); 

//  Debugging message
//	say(%player, 0, "Box "@%Scotty@", Spawn point "@%spawnPoint); 

	%player.home = %Scotty;

}


//================


function vehicle::onAdd(%vehicle)
{
	%player = playerManager::vehicleIdToPlayerNum(%vehicle);
	setVehicleRadarVisible( %vehicle, False );

    if(%player == 0)
	{
		return;
	}

	%player.home = 100;
	%player.name = getHUDName(%vehicle);
	%player.vehicleId = %vehicle;
	%player.vehicle = getVehicleName(%vehicle);
	%player.opponent = 0;
	%player.lobbyKiller = 0;
	setVehicleRadarVisible( %vehicle, False );
}


function vehicle::onAttacked( %defender, %attacker )
{
	%player = playerManager::vehicleIdToPlayerNum(%defender);
	%player2 = playerManager::vehicleIdToPlayerNum(%attacker);
	
	if( %player.home == 100 && %player.lobbyKiller == 0)
	{
		// No one gets hurt in the lobby, darn it!
		healObject( %defender, 50000 );
		healObject( %defender, 50000 );
		healObject( %defender, 50000 );
		healObject( %defender, 50000 );
		healObject( %defender, 50000 );
	}
}


function vehicle::onDestroyed( %victimVeh, %destroyerVeh )
{
	if( getTeam( %victimVeh ) != *IDSTR_TEAM_PURPLE)
	{

		// Basic settings

		%victim = playerManager::vehicleIdToPlayerNum(%victimVeh);
		%victor = %victim.opponent;
		%box = %victim.home;

		if( %victim.home == 100 || %victim.opponent == 0 )
		{
			%victim.lobbyDeaths++;

			// Try to annoy the attacker a little, too
//			messageBox(%player2, "Lobby kill!");
		}

		if( %victor.home == 100)
		{
			%victor.lobbyKills++;
		}

		if(%box != 100)
		{

//============= Quick and dirty cut and paste.
			// left over from missionStdLib.cs
   			vehicle::onDestroyedLog(%victimVeh, %destroyerVeh);
   
			// this is weird but %destroyer isn't necessarily a vehicle
			%message = getFancyDeathMessage(getHUDName(%victimVeh), getHUDName(%destroyerVeh));
			if(%message != "")
			{
				say( 0, 0, %message);
			}
//=============

			// Victim Code

			%victim.home = 100;
			%victim.opponent = 0;

			// Victor Code


			if(%victor != 0)
			{
				%victor.home = 100;
				%victor.opponent = 0;

				healObject( %victor.vehicleId, 50000);
				healObject( %victor.vehicleId, 50000);
				reloadObject( %victor.vehicleId, 100);
				healObject( %victor.vehicleId, 50000);

				%openings = teleportPlayerCheck();

				if (%openings == 2)
				{
					say(%player, 0, "Sorry, all boxes currently full.  Sending to lobby.");
					randomTransport( %victor.vehicleId, -75, -700, -15, -505 );
				}

				if (%openings < 2)
				{
					teleportPlayer(%victor.vehicleId, %openings);
				}
			}


			//Clear the box

			$boxState[%box] = 0;
			$boxFirst[%box] = 0;
			$boxSecond[%box] = 0;
//			say(everybody, 0, "Box "@%box@" has opened up!");

		}

		else
		{
			// Placeholder for later, when AIs are in place
		}
	}
}


function player::onAdd( %player )
{
	%player.home = 100;
	%player.lobbyKills = 0;
	%player.lobbyDeaths = 0;
	%player.lobbyKiller = 0;
}

function player::onRemove( %player )
{
	%box = %player.home;

	if(%box != 100)
	{
		$boxState[%box]--;

		if(%player == $boxFirst[%box])
		{
			$boxFirst[%box] = 0;
		}

		if(%player == $boxSecond[%box])
		{
			$boxSecond[%box] = 0;
		}
	}
}