$missionName = "Predator's Cage";

exec("multiplayerStdLib.cs");

// ------------------------------------------------------------------------------

MissionBriefObjective  missionObjective1         // Spot and kill turrets
{
	isPrimary           = True;
	status              = *IDSTR_OBJ_ACTIVE;
	shortTxt            = *IDSTR_HA4_OBJ1_SHORT;
	longTxt             = *IDSTR_HA4_OBJ1_LONG;
    bmpname             = *IDSTR_HA4_OBJ1_BMPNAME;
};

MissionBriefObjective missionObjective2         // Destroy comm tower
{
	isPrimary           = True;
	status              = *IDSTR_OBJ_ACTIVE;
	shortTxt            = *IDSTR_HA4_OBJ2_SHORT;
	longTxt             = *IDSTR_HA4_OBJ2_LONG;
    bmpname             = *IDSTR_HA4_OBJ2_BMPNAME;
};

MissionBriefObjective missionObjective3     // Don't destroy hangers
{
	isPrimary           = True;
	status              = *IDSTR_OBJ_ACTIVE;
	shortTxt            = *IDSTR_HA4_OBJ3_SHORT;
	longTxt             = *IDSTR_HA4_OBJ3_LONG;
    bmpname             = *IDSTR_HA4_OBJ3_BMPNAME;
};

MissionBriefObjective missionObjective4                    // Secure base for recovery
{
	isPrimary           = True;
	status              = *IDSTR_OBJ_ACTIVE;
	shortTxt            = *IDSTR_HA4_OBJ4_SHORT;
	longTxt             = *IDSTR_HA4_OBJ4_LONG;
    bmpname             = *IDSTR_HA4_OBJ4_BMPNAME;
};

MissionBriefObjective missionObjective5                    // Destroy all resistance
{
	isPrimary           = False;
	status              = *IDSTR_OBJ_ACTIVE;
	shortTxt            = *IDSTR_HA4_OBJ5_SHORT;
	longTxt             = *IDSTR_HA4_OBJ5_LONG;
    bmpname             = *IDSTR_HA4_OBJ5_BMPNAME;
};


function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}

function setDefaultMissionItems() 
{
// uncomment when mission ready to ship out

//  defineAddons();

}

function defineAddons()
{
// Lights off
allowVehicle(all,FALSE);
allowWeapon(all,FALSE);
allowComponent(all,FALSE);
// Double-dog sure...
function i_said_vanilla_dammit()
{
  for (%i=-32768; %i<32768; %i++) {
    allowVehicle(%i,FALSE);
    allowWeapon(%i,FALSE);
    allowComponent(%i,FALSE);
  }
}
i_said_vanilla_dammit();

// these are the vehicles and items that were availble for me 
// when I played this mission.

allowVehicle(32,TRUE);//Dreadlock
allowVehicle(30,TRUE);//Emancipator
allowVehicle(31,TRUE);//Avenger
allowVehicle(52,TRUE);//PirateEmancipator    Outrider?

allowWeapon(101,TRUE);//Laser
allowWeapon(102,TRUE);//HeavyLaser
allowWeapon(103,TRUE);//CompLaser
allowWeapon(105,TRUE);//Emp
allowWeapon(106,TRUE);//ELF
allowWeapon(107,TRUE);//Blaster

allowWeapon(115,TRUE);//NaniteCannon

allowWeapon(113,TRUE);//MFAC
allowWeapon(116,TRUE);//Autocannon
allowWeapon(117,TRUE);//HvyAutocannon
allowWeapon(119,TRUE);//BlastCannon
allowWeapon(120,TRUE);//HvyBlastCan

allowWeapon(124,TRUE);//PitViper8
allowWeapon(125,TRUE);//PitViper12
allowWeapon(126,TRUE);//Sparrow6
allowWeapon(127,TRUE);//Sparrow10

allowWeapon(128,TRUE);//SWARM6
allowWeapon(129,TRUE);//Minion
allowWeapon(147,TRUE);//Aphid

allowWeapon(134,TRUE);//Proximity6
allowWeapon(135,TRUE);//Proximity10
allowWeapon(136,TRUE);//Proximity15

allowComponent(200,TRUE);//HumanMicroReactor
allowComponent(201,TRUE);//SmallHumanReactor2--small
allowComponent(202,TRUE);//MediumHumanReactor1Standard
allowComponent(203,TRUE);//MediumHumanReactor2medium
allowComponent(204,TRUE);//LargeHumanReactor1--large
allowComponent(205,TRUE);//LargeHumanReactor2--Maxim

allowComponent(300,TRUE);//HumanStandardShield
allowComponent(301,TRUE);//HumanProtectorShield
allowComponent(302,TRUE);//HumanGuardianShield
allowComponent(303,TRUE);//HumanFastChargeShield
allowComponent(304,TRUE);//HumanCenturianShield
allowComponent(305,TRUE);//HumanRepulsorShield
allowComponent(306,TRUE);//HumanTitanShield

allowComponent(400,TRUE);//BasicHumanSensor
allowComponent(401,TRUE);//LongRangeSensor--Ranger
allowComponent(408,TRUE);//StandardHumanSensor
allowComponent(409,TRUE);//HumanLongbowSensor
allowComponent(410,TRUE);//HumanInfiltratorSensor
allowComponent(411,TRUE);//HumanCrossbowSensor
allowComponent(412,TRUE);//HumanUltralightSensor

allowComponent(100,TRUE);//HumanLightVehicleEngine
allowComponent(101,TRUE);//HumanHighOutputLightEngine
allowComponent(102,TRUE);//HumanAgileLightEngine
allowComponent(103,TRUE);//HumanStandardMediumEngine
allowComponent(104,TRUE);//HumanHighOutputMediumEngine
allowComponent(105,TRUE);//HumanMediumAgilityEngine
allowComponent(106,TRUE);//HumanStandardHeavyEngine
allowComponent(107,TRUE);//HumanImprovedHeavyEngine
allowComponent(108,TRUE);//HumanHeavyCruiseEngine
allowComponent(109,TRUE);//HumanHighOutputHeavyEngine
allowComponent(110,TRUE);//HumanAgileHeavyEngine
allowComponent(111,TRUE);//HumanStandardAssaultEngine
allowComponent(112,TRUE);//HumanImprovedAssaultEngine
allowComponent(113,TRUE);//Humanheavyturbineengine
allowComponent(114,TRUE);//HighOutputTurbine(HOT)
allowComponent(115,TRUE);//Humansuperheavyengine

//Armor
allowComponent(926,TRUE);//CarbonFiber(CARLAM)
allowComponent(927,TRUE);//QuadBondedMetaplas(QBM)
allowComponent(928,TRUE);//DURAC(DepletetedUranium)
allowComponent(929,TRUE);//Ceramic
allowComponent(930,TRUE);//Crystaluminum
allowComponent(931,TRUE);//Quicksilver

//InternalComponents
allowComponent(800,TRUE);//HumanBasicComputer
allowComponent(801,TRUE);//HumanImprovedComputer
allowComponent(802,TRUE);//HumanAdvancedComputer

allowComponent(810,TRUE);//GuardianECM
allowComponent(811,TRUE);//DopplegangerECM

allowComponent(820,TRUE);//ThermalDiffuser
allowComponent(830,TRUE);//Chameleon
allowComponent(831,TRUE);//Cuttlefishcloak
allowComponent(840,TRUE);//ShieldModulator
allowComponent(845,TRUE);//ShieldCapacitor
allowComponent(850,TRUE);//ShieldAmplifier(increasesshieldconstant)

allowComponent(865,TRUE);//ExtraBattery
allowComponent(870,TRUE);//ReactorCapacitor
allowComponent(875,TRUE);//FieldStabilizer

allowComponent(880,TRUE);//RocketBooster
allowComponent(885,TRUE);//TurbineBoost

allowComponent(914,TRUE);//UAP
}

// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// Script
// ------------------------------------------------------------------------------
function player::onAdd(%this)
{
    $thePlayerNum = %this;
    $playerAlive = True;


say(0,0,"Welcome to The predator's cage, One of the Human campaign missions.");


}
// ------------------------------------------------------------------------------

function vehicle::onAdd(%this)
{

                                           
// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if(%player == 0) 
      return;


     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);


//if (dropdone == false)
//  {
//    schedule( "distanceChecks();", 10 );
//    $dropdone = true;
//  }

    schedule( "navInit();", 2 );

}

// ------------------------------------------------------------------------------


function onMissionStart()
{
    initPatrols();
    setHostile( *IDSTR_TEAM_PURPLE );
    forceScope("MissionGroup\\vehicles\\rebels\\artillery\\art1", 9999);
    forceScope("MissionGroup\\vehicles\\rebels\\artillery\\art2", 9999);
    forceScope("MissionGroup\\vehicles\\rebels\\artillery\\art3", 9999);
    cdAudioCycle(Gnash, Terror, ss1);
}

// ------------------------------------------------------------------------------

function onMissionLoad()
{
    defineActors();
    
    defineNavMarkers();
    defineCounts();
    defineRoutes();
    initFormations();

    chooseCage();

   distanceChecks();

$gameType = "Multiplayer";

   %rules = "<tIDMULT_WAR_MAPNAME>"       @ 
            $missionName @
   "                                                          " @
   "  Objectives                                              " @
   "   1) Spot and kill turrets                               " @
   "   2) Destroy comm tower                                  " @
   "   3) Don't destroy hangers                               " @
   "   4) Destroy all resistance, hercs and drones            " @
   "                                                          " @
   "                                                          " @
            "                                        " @
            "This is a multiplayer co-operative game. ";

   setGameInfo(%rules);

}

// ------------------------------------------------------------------------------

function defineActors()
{
    $tac    =   "MissionGroup\\vehicles\\rebels\\tacCom1";
    $art    =   "MissionGroup\\vehicles\\rebels\\artillery";
    $art1   =   "MissionGroup\\vehicles\\rebels\\artillery\\art1";
    $art2   =   "MissionGroup\\vehicles\\rebels\\artillery\\art2";
    $art3   =   "MissionGroup\\vehicles\\rebels\\artillery\\art3";
    $artilleryTarget = "";
    
    $imp1   =   "MissionGroup\\vehicles\\imperials\\imp1Group";
    $lead1  =   "MissionGroup\\vehicles\\imperials\\imp1Group\\imp1a";
    $imp2   =   "MissionGroup\\vehicles\\imperials\\imp2Group";
    $lead2  =   "MissionGroup\\vehicles\\imperials\\imp2Group\\imp2a";
    $imp3   =   "MissionGroup\\vehicles\\imperials\\imp3Group";
    $lead3  =   "MissionGroup\\vehicles\\imperials\\imp3Group\\imp3a";
    
    $drones =   "MissionGroup\\vehicles\\imperials\\droneGroup";
    $leadDrone  =   "MissionGroup\\vehicles\\imperials\\droneGroup\\drone1";
    $baseDrone  =   "MissionGroup\\vehicles\\imperials\\droneGroup\\drone2";
    
    $rock1      =   "MissionGroup\\rocks\\rock1";
    $rock2      =   "MissionGroup\\rocks\\rock2";
    $rock3      =   "MissionGroup\\rocks\\rock3";   
}

// ------------------------------------------------------------------------------

function defineNavMarkers()
{
    $navAlpha   =   "MissionGroup\\navMarkers\\navAlpha";
    $navBravo   =   "MissionGroup\\navMarkers\\navBravo";
}

// ------------------------------------------------------------------------------

function defineCounts()
{
    $playerAlive    =   true;
    $tacAlive       =   true;
    $tacAttacked    =   false;
    $tacMoved       =   false;
    $turretAttacked =   false;
    $art1Alive      =   true;
    $art2Alive      =   true;
    $commAlive      =   true;
    $cageAlive      =   true;
    $artilleryAttachedCam = false;
    $attachedFlyCam =   false;
    $recoTalk       =   0;
    $warnTalk       =   0;
    $failTalk       =   0;
    $playerSquad    =   3;
    
    $obj1           =   false;
    $obj2           =   false;
    $obj3           =   false;
    $obj4           =   false;
    $obj5           =   false;
    $missionFailed  =   false;
    
    $imp1Count      =   2;
    $imp2Count      =   3;
    $imp3Count      =   2;
    $totImps        =   8;
    $turretCount    =   4;
    $hangerCount    =   3;
    $boggyCall      =   0;
    $impMoveToggle  =   0;
    $atBravo        =   false;
    $hangerAttack   =   false;
    
}

// ------------------------------------------------------------------------------

function defineRoutes()
{
    $imp1Route  =   "MissionGroup\\imp1Route";
    $imp3Route  =   "MissionGroup\\imp3Route";
    $droneRoute  =   "MissionGroup\\droneRoute";
    $tacRoute   =   "MissionGroup\\tacRoute";
    $baseRoute  =   "MissionGroup\\baseRoute";
}

// ------------------------------------------------------------------------------

function initFormations()
{
    newFormation( wedge,  0,0,0, 
                          -20,-20,0, 
                          20,-20,0 );
    newFormation( wall,   0,0,0, 
                          20,0,0, 
                          40,0,0 );
    newFormation( line,   0,0,0, 
                          0,-20,0, 
                          0,-40,0, 
                          0,-60,0 );
}

// ------------------------------------------------------------------------------

function initPatrols()
{
    // tac
    order( $tac, shutdown, true );
    
    // artillery
    order( $art, shutdown, true );
    setHercOwner( $imp1, $art );
    setHercOwner( $imp2, $art );
    setHercOwner( $imp3, $art );
    setHercOwner( "MissionGroup\\vehicles\\imperials\\guard", $art );
    
    
    // Imp patrol1
    order( $lead1, makeLeader, true );
    //order( $imp1, shutdown, true );


    // Imp patrol2
    order( $lead2, makeLeader, true );
    order( $imp2, guard, "MissionGroup/imp2Route");
    order($imp2, formation, wedge );
    
    // Imp patrol3
    order( $lead3, makeLeader, true );
    order( $imp3, guard, $imp3Route );
    order( $imp3, speed, medium );
    order( $imp3, Formation, wall );
    
    // drones
    order( $drones, shutdown, true );
    schedule( "droneStart();", 30.0 );
    
}

// ------------------------------------------------------------------------------



function navInit()
{
    setNavMarker( getObjectId($navAlpha), true, -1 );
    setNavMarker( getObjectId($navBravo), false );   
}

// ------------------------------------------------------------------------------

function distanceChecks()
{
    MPcheckBoundary( enter, $thePlayer, getObjectId($navAlpha), 1200, nearAlpha );
    $nearAlpha = false;
    MPcheckBoundary( enter, $thePlayer, getObjectId($navAlpha), 200, atAlpha );
    $atAlpha = false;
//    MPcheckBoundary( leave, $thePlayer, getObjectId($navAlpha), 2000, warning );
    $warning = false;
//    MPcheckBoundary( leave, $thePlayer, getObjectId($navAlpha), 2500, fail );
    $fail = false;
//    MPcheckBoundary( enter, $thePlayer, getObjectId($navBravo), 700, atBravo );
}

function artytalks ()
{
    artTalks( *IDSTR_GEN_AR11, "GEN_1ARB01.WAV");  // In position.
}

// ------------------------------------------------------------------------------

function droneStart()
{
    order( $leadDrone, shutdown, false );
    order( $leadDrone, guard, $baseRoute );
    order( $leadDrone, speed, low );
}

// ------------------------------------------------------------------------------

function chooseCage()
{
    $cage = "MissionGroup\\base\\hangers\\hanger" @ randomInt(1, 4 );
    order("MissionGroup\\vehicles\\imperials\\guard", guard, $baseRoute);
    order("MissionGroup\\vehicles\\imperials\\guard", holdposition, true);
}

// ------------------------------------------------------------------------------

function vehicle::onDestroyed(%destroyed, %destroyer)
{
//    if(%destroyed == $thePlayer)
//        $playerAlive = false;
    %team = getTeam(%destroyed);
}

// ------------------------------------------------------------------------------

function nearAlpha()
{
    if( $nearAlpha == false )
    {
        artAwake();
        artytalks ();
        $nearAlpha = true;
    }
}

// ------------------------------------------------------------------------------

function atAlpha()
{
//    if( $atAlpha == false )
//    {

//say (0,0, "DEBUG: At Alpha ");

    MPcheckBoundary( enter, $thePlayer, getObjectId($navBravo), 700, atBravo );

        setNavMarker( getObjectId($navAlpha), false );
        $atAlpha = true;
        setNavMarker( getObjectId($navBravo), true, -1 );
//        MPcheckBoundary( leave, $thePlayer, getObjectId($navBravo), 2000, warning2 );
        $warning2 = false;
//        MPcheckBoundary( leave, $thePlayer, getObjectId($navBravo), 2500, fail );
        $warnTalk2 = 0;
//    }
}

// ------------------------------------------------------------------------------

function artAwake()
{
    order( $art, shutdown, false );
}

// ------------------------------------------------------------------------------

function artAttack( %target )
{
    order( $art, Attack, %target );
    $artilleryTarget = %target;
}

// ------------------------------------------------------------------------------

function vehicle::onSpot(%spotter, %target)
{
    if (%target != "")
    { 
      artAttack(%target);
    }
    else if( (%target == "") && ($artilleryTarget != "") )
    {
      artTalks( *IDSTR_GEN_AR27, "GEN_1ARB07.wav" );
      artilleryClearTarget();
    } 
    if( $attachedFlyCam == false )
    {
        setTowerCamera( "MissionGroup\\vehicles\\rebels\\artillery\\art2", -2549, -47, 226.5 );
        $attachedFlyCam = true;
        schedule( "setPlayerCamera();", 8 );
    }
    if( $boggyCall == 0 )
    {
        schedule( "imp1Talks( *IDSTR_GEN_ICC3, \"GEN_ICCA03.WAV\" );", randomInt(3,10) ); //  Boggies on perimeter.
        $boggyCall++;
    }
    if( $impMoveToggle == 0 )
    {
        imp1Positioning();
        $impMoveToggle = 1;
    }
}

// ------------------------------------------------------------------------------

function vehicle::onMessage(%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{
    if (%message == "ArtilleryOutOfRange")
        echo("Artillery: target ", %_1, " out of range, moving into position");
        
    else if (%message == "ArtilleryOutOfAmmo") 
    {
        artTalks( *IDSTR_GEN_AR25, "GEN_1ARB05.WAV" );
        artilleryClearTarget();
    }
    else if( %message == "TargetDestroyed")
    { 
        if( %this == getObjectId($art1) || %this == getObjectId($art2) || %this == getObjectId($art3) )
        {
            artilleryClearTarget();
        }
    }
}

//------------------------------------------------------------------------------

function artilleryClearTarget()
{
    order( $art, Clear, True );
    $artilleryTarget = "";
}

// ------------------------------------------------------------------------------

function structure::onDestroyed(%destroyed, %destroyer)
{
    if( (%destroyer == $art1) || (%destroyer == $art2) || (%destroyer == $art3) )
        artTalks( *IDSTR_GEN_AR14, "GEN_1ARB04.WAV" );
    if( $boggyCall == 0 )
    {
        droneScatter();
        schedule( "imp1Talks( *IDSTR_GEN_ICC3, \"GEN_ICCA03.WAV\" );", randomInt(3,10) ); //  Boggies on perimeter.
        $boggyCall++;
    }
}

// ------------------------------------------------------------------------------

function imp1Positioning()
{
%playerVeh = pickPlayer();

    %distance1 = getDistance(%playerVeh, getObjectId($rock1));
    %distance2 = getDistance(%playerVeh, getObjectId($rock2));

    if( %distance1 >= %distance2 ) 
    {
        setPosition($lead1, 489, -1676, 163 );
        if( $atBravo == false )
            schedule( "imp1Attack();", 0.5 );
        else
           {
            %playerVeh = pickPlayer();
            order($imp1, attack, %playerVeh );
           }
    }
    else if( %distance1 < %distance2 )
    {
        setPosition($lead1, -1629, -1788, 192 );
        if( $atBravo == false )
            schedule( "imp1Attack();", 0.5 );
        else
           {
            %playerVeh = pickPlayer();
            order($imp1, attack, %playerVeh );
           }

        
    }
}

// ------------------------------------------------------------------------------

function imp1Attack()
{
    order( $imp1, guard, "MissionGroup\\imp1Route" );
    order( $imp1, formation, wall );
    order( $imp1, speed, high );
}

// ------------------------------------------------------------------------------

function turretAttack()
{
   %playerVeh = pickPlayer();
    order( "MissionGroup\\base\\Turrets", Attack, %playerVeh );
}

// ------------------------------------------------------------------------------

function turret::onAttacked(%attd, %attr)
{
    
    if( (getTeam(%attr) == *IDSTR_TEAM_YELLOW) && ($impMoveToggle == 0) )
    {
        droneScatter();
        turretAttack();
        imp1Positioning();
        $impMoveToggle = 1;
        if( $boggyCall == 0 )
        {
            schedule( "imp1Talks( *IDSTR_GEN_ICC03, \"GEN_ICCA03.WAV\" );", randomInt(1,5) ); //  Boggies on perimeter.
            $boggyCall++;
        }    
    }
}

// ------------------------------------------------------------------------------

function vehicle::onTargeted(%targd, %targr)
{
//say (0,0,"DEBUG: %targd, %targr " @ %targd @"  "@ %targr);

    if( ((getTeam(%targr) == *IDSTR_TEAM_YELLOW) && 
         (getTeam(%targd) != *IDSTR_TEAM_YELLOW)) && 
         ($turretAttacked == false) )
    {
        schedule( "imp1Talks(*IDSTR_HA4_IPA01, \"HA4_IPA01.wav\");", 8 );    //  spotter spotted
        turretAttack();
        $turretAttacked = true;
    } 
}

// ------------------------------------------------------------------------------

function droneScatter()
{
    order( $baseDrone, shutdown, false );
    order( $baseDrone, guard, $droneRoute );
    order( $baseDrone, speed, high );
    order( $leadDrone, guard, $droneRoute );
    order( $leadDrone, speed, high );
}

// ------------------------------------------------------------------------------

function turret::onDestroyed(%destroyed, %destroyer)
{
   tankAttack();
    $turretCount--;
    if( $boggyCall == 0 ) 
    {
        schedule( "imp1Talks( *IDSTR_GEN_ICC3, \"GEN_ICCA03.WAV\" );", 1 ); //  Boggies on perimeter.
        $boggyCall++;
        droneScatter();
    }
    if( (%destroyer == getObjectId($art1)) || (%destroyer == getObjectId($art2)) || (%destroyer == getObjectId($art3))  )
    {
        artTalks( *IDSTR_GEN_AR14, "GEN_1ARB04.WAV" );
        droneScatter();
    }
    if( $turretCount == 3)
    {
        order( $imp2, Formation, wedge );
        order( $lead2, guard, $baseRoute);
        order( $imp2, speed, high );
        order( $imp2, holdPosition, true );
    }
    if( $turretCount == 2 )
    {
        if( $obj2 = false )
        {
            checkAddImps();
            order( $imp3, guard, $baseRoute );
            order( $imp3, speed, high );
            schedule( "say(0,5, \"HA4_IMC01.WAV\");", 3 );
            schedule( "say(0,5, \"HA4_STT01.WAV\");", 8 );
        }    
    }    
    if( $turretCount == 0 )
    {
        missionObjective1.status = *IDSTR_OBJ_COMPLETED;
        say( 0, 6, "GEN_OC01.wav" );
        $obj1 = true;
        safeCheck();
        if( $totImps <= 0 )
        { 
            missionObjective4.status = *IDSTR_OBJ_COMPLETED;
            safeCheck();
        }            
    }
}

// ------------------------------------------------------------------------------

function comm::structure::onDestroyed(%destroyed, %destroyer)
{
   checkAddImps();

    $commAlive = false;
    missionObjective2.status = *IDSTR_OBJ_COMPLETED;
    say( 0, 6, "GEN_OC01.wav" );
    droneScatter();
    turretAttack();
    safeCheck();
    if( $turretCount == 4 )
    {
        order( $imp2, Formation, wedge );
        order( $lead2, guard, $baseRoute);
        order( $imp2, speed, high );
        order( $imp2, holdPosition, true );
%playerVeh = pickPlayer();
        order("MissionGroup\\vehicles\\imperials\\guard", attack, %playerVeh);
    }    
    if( $turretCount > 3 )
    {
        order( $imp3, guard, "MissionGroup/extras/point" );
        order( $imp3, holdposition, true );
        order( $imp3, speed, low );
        $totImps = $totImps - 2;
    }
        $obj2 = true;
}

// ------------------------------------------------------------------------------

function atBravo()
{

//say(0,0,"DEBUG: At nav Bravo");

   checkAddImps();

    $atBravo = true;
    setNavMarker( getObjectId($navBravo), false );
%playerVeh = pickPlayer();
    order( $imp1, Attack, %playerVeh );
    order( $imp1, speed, high );
    order( $imp2, holdPosition, false );
%playerVeh = pickPlayer();
    order( $imp2, attack, %playerVeh  );
    order("MissionGroup\\vehicles\\imperials\\guard", holdposition, false);
    safeCheck();
    if( $impMoveToggle == 0 )
    {
        imp1Positioning();
        $impMoveToggle = 1;
    }    
   tankAttack();
}

function tankAttack()
{
echo ("DEBUG: in tank attack");

//    if( ($totImps > 3) && ($obj2 != true) )
//    {
        order( $imp3, Attack, "MissionGroup\\base\\hangers" );

echo( "after attack, before medium,high");

        order( $imp3, speed, high );
        if( $hangerAttack != true )
        {
            artTalks( *IDSTR_HA4_ASC01, "HA4_ASC01.WAV" );
            $hangerAttack = true;
        }
//    } 
echo ("DEBUG:leaving tank attack");

}

// ------------------------------------------------------------------------------

function hang::structure::onDestroyed(%destroyed, %destroyer)
{

    if( %destroyed == getObjectId($cage) )
    {
        missionObjective3.status = *IDSTR_OBJ_FAILED;
        $cageAlive = false;

   $playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < $playerCount ; %i++)
     {
       %player = playerManager::getPlayerNum( %i);

        %playerVeh = playerManager::playerNumToVehicleId( %player);

        setDominantCamera(  getObjectId($cage), %playerVeh , -200,-200, 30 );

     }
//        schedule( "forceToDebrief( *IDSTR_MISSION_FAILED );", 5 );
%txt = "Mission failed, Predator has been destroyed";

schedule ("messageBox(0, " @ %txt @ ");", 18 );
     say(0,0,"Mission failed, Predator has been destroyed");

     schedule( "missionEndConditionMet();", 20 );

    }
    else if( (%destroyed != $cage) && (getGroup(%destroyer) == getObjectId($imp3)) )
    {
//say(0,0, "DEBUG: getobjectID($imp3)= " @ getObjectid($imp3) );
   checkAddImps();
        order($imp3, attack, "MissionGroup\\base\\hangers" );   
    }
}

// ------------------------------------------------------------------------------

function imp::vehicle::onDestroyed(%destroyed, %destroyer)
{
    $totImps--;

    if(isGroupDestroyed($imp1))
    {
        order( $imp2, holdPosition, false );
   %playerVeh = pickPlayer();
        order( $imp2, Attack, %playerVeh  );
    }
    if(isGroupDestroyed($imp2))
    {
        order("MissionGroup\\vehicles\\imperials\\guard", holdposition, false);
        %playerVeh = pickPlayer();
        order("MissionGroup\\vehicles\\imperials\\guard", attack, %playerVeh);
    }
    if( ($totImps <= 4) && ($obj2 = false) ) 
    {
        order( $imp3, guard,  $baseRoute );
        order( $imp3, speed, high );
    }
    if( $totImps <= 0 )
    {
        missionObjective5.status = *IDSTR_OBJ_COMPLETED;
        $obj5 = true;
        safeCheck();
    }
    if( ($totImps <= 0) && ($cageAlive == true) )
    {
        
        $obj3 = true;
        safeCheck();
        if( $recoTalk == 0 )
        {
            say( 0, 6, "GEN_OC01.wav" );
            $recoTalk++;
        }
    }
    if( ($totImps <= 0) && ($obj1 == true) )
    {
        missionObjective4.status = *IDSTR_OBJ_COMPLETED;
        $obj4 = true;
        schedule( "safeCheck();", 3 );
        if( $recoTalk == 0 )
        {
            schedule( "say( 0, 6, \"GEN_OC01.wav\" );", 2 );
            $recoTalk++;
        }
    }
}

// ------------------------------------------------------------------------------

function safeCheck()
{
    if( isSafe(*IDSTR_TEAM_YELLOW, $cage, 1000) )
    {
        
        missionObjective3.status = *IDSTR_OBJ_COMPLETED;
        missionObjective4.status = *IDSTR_OBJ_COMPLETED;
        missionObjective3.status = *IDSTR_OBJ_COMPLETED;
        winCheck();
    }
}

// ------------------------------------------------------------------------------

function winCheck()
{
    if( (missionObjective1.status == *IDSTR_OBJ_COMPLETED) &&
        (missionObjective2.status == *IDSTR_OBJ_COMPLETED) &&
        (missionObjective3.status == *IDSTR_OBJ_COMPLETED) &&
        (missionObjective4.status == *IDSTR_OBJ_COMPLETED) )
    {
        moveTac();
    }        
}

// ------------------------------------------------------------------------------

function moveTac()
{
    if( $tacMoved == false )
    {
//        addGeneralOrder(*IDSTR_ORDER_HA4_1, "radioRecoveryTeam();");
        radioRecoveryTeam();
//        schedule( "repeatGeneralOrder(PlayerManager::playerNumToVehicleId(2049), *IDSTR_ORDER_HA4_1);", 4 );

        setPosition( $tac, 2038,1285,550 );
        schedule( "artTalks( *IDSTR_HA4_TCM01, \"HA4_TCM1.wav\" );", 4 );    // Area secure
        $tacMoved = true;
    } 
}

// ------------------------------------------------------------------------------

function radioRecoveryTeam() 
{
//    dataStore(PlayerManager::playerNumToVehicleId(2049), *IDSTR_ORDER_HA4_1, True);
//    removeGeneralOrder( *IDSTR_ORDER_HA4_1 );
       
    schedule( "recoveryTalks( *IDSTR_HA4_REC01, \"HA4_REC01.wav\");", 5.0 );
    order( $tac, guard, $tacRoute );
    order( $tac, speed, high );
//    schedule( "setDominantCamera( getObjectId($tac), getObjectId($cage), -200,-200, 30 );", 3 );
    setDominantCamera( getObjectId($tac), getObjectId($cage), -200,-200, 30 );
    schedule( "youWin();", 20 );
}

// ------------------------------------------------------------------------------

function warning()
{
    if( ($warnTalk == 0) && ($atAlpha == false) )
    {
        artTalks( *IDSTR_GEN_TCM1, "GEN_TCM01.wav" );  // Off course
        $warnTalk = 1;
    }
}

// ------------------------------------------------------------------------------

function warning2()
{
    if( ($warnTalk2 == 0) && ($atBravo == true) )
    {
        artTalks( *IDSTR_GEN_TCM1, "GEN_TCM01.wav" );  // Off course
        $warnTalk2 = 1;
    }
}

// ------------------------------------------------------------------------------

function fail()
{
    if( $failTalk == 0 )
    {
        artTalks( *IDSTR_GEN_TCM2, "GEN_TCM02.wav" );    // mission failed
//        schedule( "forceToDebrief(*IDSTR_MISSION_FAILED);", 3.0);
        $failTalk++;
    }    
}

// ------------------------------------------------------------------------------

function youWin()
{
     schedule( "missionEndConditionMet();", 8 );
//    updatePlanetInventory(ha4);
//    schedule( "forceToDebrief(*IDSTR_MISSION_SUCCESSFUL);", 3.0);
}

// ------------------------------------------------------------------------------

function win()
{
    missionObjective1.status = *IDSTR_OBJ_COMPLETED;
    missionObjective2.status = *IDSTR_OBJ_COMPLETED;
    missionObjective3.status = *IDSTR_OBJ_COMPLETED;
    missionObjective4.status = *IDSTR_OBJ_COMPLETED;
//    updatePlanetInventory(ha4);
//    schedule( "forceToDebrief(*IDSTR_MISSION_SUCCESSFUL);", 3.0);    

     schedule( "missionEndConditionMet();", 8 );
}

// ------------------------------------------------------------------------------

function tacTalks(%text, %wave)
{
    if( $playerAlive  )
        say( 0, 2, %text, %wav );
    else
    {
        say( 0, 2, "" );
    }        
}

// ------------------------------------------------------------------------------

function artTalks(%text, %wav)
{
    if( $playerAlive  )
        say( 0, 2, %text, %wav );
    else
    {
        say( 0, 2, "" );
    }
}

// ------------------------------------------------------------------------------

function imp1Talks(%text, %wav)
{
    if( $playerAlive  )
        say( 0, 3, %text, %wav );
    else
    {
        say( 0, 3, "" );
    }
}

// ------------------------------------------------------------------------------

function recoveryTalks(%text, %wav)
{
    if( $playerAlive  )
        say( 0, 4, %text, %wav );
    else
    {
        say( 0, 4, "" );
    }
}


// END --------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
// ------------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj1, %obj2, %distance, %callback, %time )
{
if ( %time == "" ) %time = 10;

  $jobRun = false;

//   %obj1 = getObjectId( %obj1 );

   $playerCount = playerManager::getPlayerCount();

//say (0,0, "DEBUG : $playerCount = " @ $playerCount );

   for(%i=0; %i < $playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i);

     %obj1= playerManager::playerNumToVehicleId( %player );

//     %obj2 = getObjectId( %obj2 ); // some other object

// say(0,0, "DEBUG: checkDistance ( "@ %obj1@ " "@ %obj2 @ " ) " @ %distance @ " CALLBACK: " @ %callback );

   %var = getDistance( %obj1, %obj2 );

//say(0,0, "DEBUG: obj1="@ %obj1@ " obj2="@ %obj2 @ " dis " @ %distance @ " CALLBACK: " @ %callback @ " Distance difference($%var)= " @%var );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
           %func = %callback @ "(" @ %obj1 @ ");";
           schedule( %func, 0 );
           $jobRun = true;
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          %func = %callback @ "();";
          schedule( %func, 0 );
          $jobRun = true;
         }
      }
    }
  } // end for loop

  if ($jobRun != true)
   {
   if (%obj1 == "") 
     {
      %obj1 = "a"; // anything so the syntax is ok
     }
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj1 @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );
//say(0,0, "DEBUG: rescheduling job " @ %callback);
   }
 
}

//-----------------------------------------------------------------------------
function pickPlayer ()
{

  %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

  %playerVeh = playerManager::playerNumToVehicleId( %player);

  return %playerVeh;
}

//-----------------------------------------------------------------------------
function checkAddImps()
{
   %playerCount = playerManager::getPlayerCount();
   if ( %playerCount > 4 )
    {
     for(%i=0; %i < %playerCount - 4 ; %i++)
       {
         addImps();
       }
    }
}

//-----------------------------------------------------------------------------
function addImps()
{

  %this = getObjectid($lead1);

     %clone = cloneVehicle(getObjectid($lead1));

%x = getPosition(%this,x )+ randomInt (10,50);
%y = getPosition(%this,y )+ randomInt (10,50);
%z = getPosition(%this,z)+10;

   setPosition(%clone, %x, %y, %z);
   order (%clone, Speed, high);
   addToSet( $imp1, %clone );

    order( $imp1, Formation, line );
$totImps++;


  %this = getObjectid($lead3);

     %clone = cloneVehicle(getObjectid($lead3));

%x = getPosition(%this,x )+ randomInt (10,50);
%y = getPosition(%this,y )+ randomInt (10,50);
%z = getPosition(%this,z)+10;

   setPosition(%clone, %x, %y, %z);
   order (%clone, Speed, high);
   addToSet( $imp3, %clone );

//say (0,0, "before formation wall");

    order( $imp3, Formation, wall );


//say (0,0, "after formation wall");


$totImps++;
}

