$missionName = "PlatinumCity";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = false;
   $server::AllowDeathmatch = true;
   $server::AllowTeamPlay = false;	
}

function onMissionStart()
{
   $HercsAtDoor1 = 0;
   $HercsAtDoor2 = 0;   

   europaSounds();
   windSounds();

   %randomTime = randomInt(60, 90);
   schedule("randomDeathStorm();", %randomTime);
}

function onMissionLoad()
{
   cdAudioCycle("SS4", "SS3", "SS1"); 
}

function door1::trigger::onEnter(%this, %vehicleId)
{
   if($hercsAtDoor1 == 0)
   {
      playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, true);
   }

   $hercsAtDoor1 = $hercsAtDoor1 + 1;
}

function door1::trigger::onLeave(%this, %vehicleId)
{
   $hercsAtDoor1 = $hercsAtDoor1 - 1;
   if($hercsAtDoor1 == 0)
   {
      playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, true);
   }
}

function door2::trigger::onEnter(%this, %vehicleId)
{
   if($hercsAtDoor2 == 0)
   {
      playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, true);
   }

   $hercsAtDoor2 = $hercsAtDoor2 + 1;
}

function door2::trigger::onLeave(%this, %vehicleId)
{
   $hercsAtDoor2 = $hercsAtDoor2 - 1;

   if($hercsAtDoor2 == 0)
   {
      playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, true);
   }
}

function randomDeathStorm()
{
   %nextStorm = randomInt(60, 120);
   Say(0, 0, "Orbital Bombardment Commencing!");

   %dropMeteors = "dropMeteor(\"default\", 1, 2, -200, 200, -3000, -3000,  -400, 400, -400, 400);";

   schedule(%dropMeteors, 2);
   schedule(%dropMeteors, 4);
   schedule(%dropMeteors, 6);
   schedule(%dropMeteors, 8);
   schedule(%dropMeteors, 10);
   schedule(%dropMeteors, 12);
   schedule(%dropMeteors, 14);
   schedule(%dropMeteors, 16);
   schedule(%dropMeteors, 18);
   schedule(%dropMeteors, 20);

   schedule("randomDeathStorm();", %nextStorm);
}

//