// FILENAME:	DM_Moonstrike.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "Pilot Test";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

$server::HudMapViewOffsetX = -1400;
$server::HudMapViewOffsetY = 2400;

Pilot DronePilot
{
   id = 28;
   
   name = "Target Drone";
   
   skill = 2.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 1.0;
   deactivateBuff = 1.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};


 $droneDropPoint = "MissionGroup/droneStuff/droneDropPoints";
 $dronepath = "MissionGroup/droneStuff/path";
 $targetDronet = "MissionGroup/droneStuff/Drone1";

 $dronePath1 = "MissionGroup/droneStuff/path1";
 $dronePath2 = "MissionGroup/droneStuff/path2";
 $dronePath3 = "MissionGroup/droneStuff/path3";
 $dronePath4 = "MissionGroup/droneStuff/path4";

 $dronePathEnd1t = "MissionGroup/droneStuff/path1/endmarker1";
 $dronePathEnd2t = "MissionGroup/droneStuff/path2/endmarker1";
 $dronePathEnd3t = "MissionGroup/droneStuff/path3/endmarker1";
 $dronePathEnd4t = "MissionGroup/droneStuff/path4/endmarker1";




function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionStart()
{
 $dronePathEnd1 = getObjectId($dronePathEnd1t);
 $dronePathEnd2 = getObjectId($dronePathEnd2t);
 $dronePathEnd3 = getObjectId($dronePathEnd3t);
 $dronePathEnd4 = getObjectId($dronePathEnd4t);

 $targetDrone = GetObjectId($targetDronet);
}

function onMissionLoad()
{
   cdAudioCycle("Gnash", "Cloudburst", "Cyberntx"); 


}

function player::onAdd(%this)
{
 setNavMarker( getObjectid ("MissionGroup/navPoints/nav0"), True, -1 );
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function drivingStart::trigger::onEnter(%this, %object)
{

 $startTime = getCurrentTime();
   setHudTimer(60, -1, "Time Elapsed", 1);
 $cntr = 0;

 setNavMarker( getObjectid ("MissionGroup/navPoints/nav0"), False );
 setNavMarker( getObjectid ("MissionGroup/navPoints/nav1"), True, -1 );
 $navPt = 1;
}

function drivingMidPoint::trigger::onEnter(%this, %object)
{

 $cntr++;

 setNavMarker( getObjectid ("MissionGroup/navPoints/nav" @ $navPt), False );
 $navPt++;
 setNavMarker( getObjectid ("MissionGroup/navPoints/nav" @ $navPt), True, -1 );
}


function drivingEnd::trigger::onEnter(%this, %object)
{

 $endTime = getCurrentTime();
 say (0,0, "Course completed in " @ timeDifference($endTime, $startTime) );
 say (0,0, "counter = "@ $cntr );

 setNavMarker( getObjectid ("MissionGroup/navPoints/nav5"), False );
 setNavMarker( getObjectid ("MissionGroup/navPoints/nav0"), True, -1 );
}

function targetStart::trigger::onEnter(%this, %object)
{
 say (0,0, "Comence Firing");
 $hits = 0;
  setNavMarker( getObjectid ("MissionGroup/targeting/targetNav"), True, -1 );

}

function targetEnd::trigger::onEnter(%this, %object)
{

 say (0,0, "Hit count is "@ $hits );
  setNavMarker( getObjectid ("MissionGroup/targeting/targetNav"), False );

}

function vehicle::onAttacked(%attd, %attr)
{
  $hits++;
//say (0,0,"ow, you hit me");
}

function gotobox::structure::onAttacked(%attacked,%attacker)
{
  setPosition (%attacker , -1567.11, -909.677, 1287 );
}

function gotonavcharlie::structure::onAttacked(%attacked,%attacker)
{
  setPosition (%attacker , -697.683, -1024.17, 1183);
}

function gotonavalpha::structure::onAttacked(%attacked,%attacker)
{
  setPosition (%attacker , -408.375, -387.535, 1284 );
}

function gotodriving::structure::onAttacked(%attacked,%attacker)
{
  setPosition (%attacker , -408.375, -387.535, 1284  );
}

function gotodrone::structure::onAttacked(%attacked,%attacker)
{
  setPosition (%attacker , 304, 4786, 1073 );
}

function startdrone::structure::onAttacked(%attacked,%attacker)
{
  startDrone();
}

function startDrone()
{
  $droneHits = 0;

  order ($targetDrone, speed, high);

   %whichPath = RandomInt(2,4);
   say (0,0, "DEBUG:traversing path " @ %whichPath );

   schedule (" order ($targetDrone, guard, $dronePath" @ %whichPath @");", 1);

  $startDroneTime = getCurrentTime();

   setHudTimer(999,1 , "Drone Killer timer", 1);
}

function drone::vehicle::onArrived(%who, %where)
{

if (($dronePathEnd1 == %where) ||
    ($dronePathEnd2 == %where) ||
    ($dronePathEnd3 == %where) ||
    ($dronePathEnd4 == %where))
  {
   %whichPath = RandomInt(2,4);
   say (0,0, "DEBUG:traversing path " @ %whichPath );
   schedule (" order ($targetDrone, guard, $dronePath" @ %whichPath @");", 1);
  }
}

function drone::vehicle::onAttacked(%attd, %attr)
{
  $droneHits++;
}

function drone::vehicle::onDestroyed( %this, %destroyer )
{
  $endDroneTime = getCurrentTime();

say (0,0, "It took you <F1>" @ timeDifference($endDroneTime, $startDroneTime) @"<F3> to destroy the drone." );

 say(0,0,"You hit the drone <F1>" @ $droneHits @ "<F3> Times");

   setHudTimer(0,1 , "Drone Killer timer", 1);

 
   if( %this == $targetDrone )
   {
     %clone = cloneVehicle(%this);

     $targetDrone = %clone;

     setPosition(%clone, 386, 5234, 1049);

     schedule( "deleteObject(" @ %old @ ");", 10 );

     addToSet( "MissionGroup", %clone );

 say(0,0,"<F1>Shoot the Monument to start again.");

//     schedule( "startDrone();", 5 );
   }

}
