//
//Script for HA5_UnderTheGun 
// mods by dolf kooz to make this a multiplayer map, but do a real resuce, don't necessaryly
// kill the good guys

$server::TeamDamage = true;


//Custom Pilots

Pilot pilot1
{
   id = 25;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.6;
   activateDist = 1000.0;
   deactivateBuff = 200.0;
   targetFreq = 1.6;
   trackFreq = 0.6;
   fireFreq = 2.2;
   LOSFreq = 0.8;
   orderFreq = 6.0;
};

Pilot emanPilot
{
   id = 26;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.6;
   activateDist = 1.0;
   deactivateBuff = 1.0;
   targetFreq = 30.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 30.0;
};

$minAIPilotID = 28;
$maxAIPilotID = 31;


Pilot PatrolPilot1
{
   id = 28;
   
   skill = 0.3;
   accuracy = 0.3;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot2
{
   id = 29;
   
   skill = 0.4;
   accuracy = 0.4;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot3
{
   id = 30;
   
   skill = 0.5;
   accuracy = 0.5;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot4
{
   id = 31;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};


$missionName = "Rescue";

$Version = "Version 1.0\nmaps available from www.shadowdragons.org";


//Map config
$server::HudMapViewOffsetX =  2500;
$server::HudMapViewOffsetY =  500;

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = False;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = False;

   // what can the server admin choose for available teams
   $server::disableTeamRed = False;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = False;
   $server::disableTeamPurple = true;

}

//-----------------------------------------------------------------------------
function onMissionLoad()
{

    $textMsg = 
      "Objectives:"@
      "\n1) Locate the captive by scanning buildings"@
      "\n2) Make sure the captive makes it to Nav Bravo safely.   "@
      "\n3) Proceed to Nav Bravo for exit.   "@
   "\nRespawning is not allowed. Team Damage is on, watch your fire.";

   %history = 
"\n\nDate: 2831. Listen up scrub, Three days ago the Imps took a small " @
"city near Tarsus. Most of the citizens fled, the rest were " @
"killed. They also captured a dignitary. We want you to free him. " @
"\n " @
"Here's the plan, at 0730 hours we leave the tunnel. At " @
"0745 we hit the city. By 0800 we should be back in the tunnels. " @
"\n " @
"After you locate the safehouse, we will send in a rescue herc. It has been modified " @
"to hold two people." @
"\n " @
"Don't be a hero. We want everyone to get out alive. " @
 " This " @
"is part of our campaign to harass and impede Imperial forces on Mars.\n\n";

   setGameInfo (  %history @ $textMsg);

}

//-----------------------------------------------------------------------------
function onMissionStart()
{
    initVariables();

    init();

    initActors();

    cdAudioCycle(Watching, Mechsoul, ss3);
    marsSounds();
}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{


say ( %this, 0, $Version @"\n"@ $textMsg );
say ( %this, 0,  "\nCheck the game info tab for more details");
}


//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{


// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) 
      return;

//  messagebox (%player, "Check the game info tab for game details and objectives");


   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);


    }

 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( $navAlpha, true, %this );
}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{

// give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

  if (( isGroupDestroyed ($impPatrol1) == true ) &&
      ( isMember( $impPatrol1, %this ) == true ))
   {
     schedule ("createImpPatrol1();", 5);
   }

  if (( isGroupDestroyed ($impPatrol2) == true ) &&
      ( isMember( $impPatrol2, %this ) == true ))
   {
     schedule ("createImpPatrol2();", 5);
   }

  if (( isGroupDestroyed ($impPatrol3) == true ) &&
      ( isMember( $impPatrol3, %this ) == true ))
   {
     schedule ("createImpPatrol3();", 5);
   }

  if (( isGroupDestroyed ($impPatrol4) == true ) &&
      ( isMember( $impPatrol4, %this ) == true ))
   {
     schedule ("createImpPatrol4();", 5);
   }

  if (( isGroupDestroyed ($impPatrol5) == true ) &&
      ( isMember( $impPatrol5, %this ) == true ))
   {
     schedule ("createImpPatrol5();", 5);
   }

  if ( %this == $rescueHerc )
   {
     
     setNavBravoON();
     $emanDestroyed = True;

     if (  $safehouseDestroyed == True ) return;

     say (0,0,"<f5>Cannot complete mission, rescue Herc has been destroyed. Head for Nav Bravo.");
   }

  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 3 );

    healobject ( %who, 5000 );

    reloadObject(%who, 5000 );

   }

   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }
}

//-----------------------------------------------------------------------------
function init()
{

   $objective1 = False;
   $objective2 = False;

   $emanDestroyed = False;
   $dignitaryInEman = False;

   $actionStarted = False;

  $genGroup = "MissionGroup/rescue";

  newObject( "rescue", SimGroup );
  addToSet( "MissionGroup", "rescue" );

  newObject( "Artillery", SimGroup );
  addToSet( "MissionGroup", "Artillery" );

  $arty = "MissionGroup/Artillery";

  createArty();

  $navAlpha = "MissionGroup/navPoints/NavAlpha";
  $navBravo = "MissionGroup/navPoints/NavBravo";

  $startMarker = "MissionGroup/startMarker";

  $exitPath = "MissionGroup/exitPath";
  $exitPathMarker = getObjectID ( "MissionGroup/exitPath/Marker1" );
  $guardPath1 = "MissionGroup/guardPath1";

  newObject( "impGuard1", SimGroup );
  addToSet( "MissionGroup", "impGuard1" );

  newObject( "impPatrol1", SimGroup );
  addToSet( "MissionGroup", "impPatrol1" );

  newObject( "impPatrol2", SimGroup );
  addToSet( "MissionGroup", "impPatrol2" );

  newObject( "impPatrol3", SimGroup );
  addToSet( "MissionGroup", "impPatrol3" );

  newObject( "impPatrol4", SimGroup );
  addToSet( "MissionGroup", "impPatrol4" );

  newObject( "impPatrol5", SimGroup );
  addToSet( "MissionGroup", "impPatrol5" );

   $impPatrol1 = "MissionGroup/impPatrol1";
   $impPatrol2 = "MissionGroup/impPatrol2";
   $impPatrol3 = "MissionGroup/impPatrol3";
   $impPatrol4 = "MissionGroup/impPatrol4";
   $impPatrol5 = "MissionGroup/impPatrol5";

   $firstGuardPathMarker = getObjectID ("MissionGroup/guardPath1/first");

   MPcheckBoundary( leave, getObjectID ($startMarker) , 400, onLeavestartMarkerWarning, 1 );
   MPcheckBoundary( leave, getObjectID ($startMarker) , 600, onLeavestartMarker, 1 );

}

//-----------------------------------------------------------------------------
function onLeavestartMarkerWarning ()
{
  if ( $warningSaid == true ) return;

  $warningSaid = true;
   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");

}

//-----------------------------------------------------------------------------
function onLeavestartMarker ()
{
   $actionStarted = true;
   createGuardPatrol ( 2 );
   onArriveNavBravo();
}

//-----------------------------------------------------------------------------
function onArriveNavBravo()
{

// can't exit till the rescue herc is down or the objective is completed
  if (( isGroupDestroyed ( "MissionGroup/rescue" ) == False ) &&
      ($objective2 == False))
     {
       schedule ("onArriveNavBravo();", 10 );
       return;
     }

 %obj1 = getObjectID ( $navBravo );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 250 ) %howManyAreClose++;
       }
     }

  if ( %howManyAreClose == %howMany ) 
    {
     shutdownArty();
     schedule("winCondition();", 10);
    }
   else
    {
      schedule ("onArriveNavBravo();", 10 );
    }
}

//-----------------------------------------------------------------------------
function winCondition()
{
  flushConsoleScheduler();
  %howmany = 0;

  %text = "\nDignitary located: ";
  if ( $objective1 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  %text = %text @ %text = "\nDignitary evacuated: ";
  if ( $objective2 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  if ( %howmany == 2 ) %text = %text @ "\nExcellent work team.";

  messageBox(0, "Mission Completed, " @ %howmany @ " of 2 objectives completed. "@ %text );
  missionendconditionmet();
}

//------------------------------------------------------------------------------
function initVariables()
{
    $ambushBegun                         = False;
    $artilleryAttachedCam                = False;
    $rescueOK                            = False;
    $bound1                              = False;
    $EvacChannel                         = 50;
    $TacComChannel                       = 51;
    $evacAttacked                        = False;
    $cnlChannel                          = 52;
    $missionEnd                          = False;
    $line6                               = False;
    $dist2                               = False;
    $dist2a                              = False;
    $reachedWarning                      = False;
    $reachedFail                         = False;
    $blastDoors                          = False;
    $fire                                = true;
    $SafeHouse                           = "";
    $safehouseDestroyed                  = False;
}

//------------------------------------------------------------------------------
function initActors()
{
    $SafeHouse1 = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe1");
    setStaticShapeLongName( $SafeHouse1, "Munitions" );
    $SafeHouse2 = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe2");
    setStaticShapeLongName( $SafeHouse2, "Meeting Hall" );
    $SafeHouse3 = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe3");
    setStaticShapeLongName( $SafeHouse3, "Apartment House" );
    $SafeHouse4 = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe4");
    setStaticShapeLongName( $SafeHouse4, "Liquor Supply" );
    $SafeHouse5 = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe5");
    setStaticShapeLongName( $SafeHouse5, "Apartment House" );


    $SafeHouse = myGetObjectId("MissionGroup/Scenario/TharsisCity/Locations/Safe" @ randomInt(1,5));
    setStaticShapeLongName( $SafeHouse, "Dignitary Captive" );

}


//--common functions------------------------------------------------------------


function myGetObjectId(%this)
{
    %id = getObjectId(%this);
    if (%id == "")
    {
        //say(0,1,"Problem with id for " @ %this);
    }
    else return %id;    
}


//------mission functions--------------------------------------------------------
function Abandoned::structure::onScan(%scanned, %scanner, %string)
{

    if(%scanned == $SafeHouse)
    {
         $objective1 = True;
        say (0,0,"<F5>Safe House Located. Rescue herc is leaving the tunnels, defend the Emanicpator");
        schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
        schedule("beginAmbush();",4);
    }
}

//-----------------------------------------------------------------------------
function Abandoned::structure::onDestroyed(%destroyed, %destroyer)
{

  if ( $emanDestroyed == True )
    {
      return;
    }

    if( %destroyed == $SafeHouse && ( $dignitaryInEman ==  False ))
    {
      $safehouseDestroyed = True;
     say (0,0,"<f5>Cannot complete mission, dignitary has been killed. Head for Nav Bravo.");

     setNavBravoON();

     %target = getObjectID ("MissionGroup/Artillery");

      order ( $rescueherc, Guard, %target);

    }
}

//-----------------------------------------------------------------------------
function beginAmbush()
{
    if ($ambushBegun) {return;}

    $ambushBegun = true;
    say(0,1,"Artillery_warn.wav");

//    schedule("damageObject($SafeHouse, 20000);",4);
//    say(0,1,"SM_Riana_DC1.WAV");

echo("start arty");

    startArtillery(1);
    schedule("startArtillery(2);", randomFloat(0.2,1.2) );
    schedule("startArtillery(3);", randomFloat(0.2,1.2) );
    schedule("startArtillery(4);", randomFloat(0.2,1.2) );
    schedule("startArtillery(5);", randomFloat(0.2,1.2) );
    schedule("startArtillery(6);", randomFloat(0.2,1.2) );
    schedule("$fire = False;", 300);

echo("surprise");
    surprise();

echo("   startemanRecover();");
   startemanRecover();
}


//-----------------------------------------------------------------------------
function startemanRecover()
{
  $rescueHerc = createeman ();
  order ( $rescueHerc, Speed, High );
  order ( $rescueHerc, Guard, $safeHouse );

  checkemanArrive();
}

//-----------------------------------------------------------------------------
function checkemanArrive()
{
  %var = getDistance( $rescueHerc, $safeHouse );

// safehouse was destroyed, mission can't be completed
  if ( $safehouseDestroyed == True ) return;

// eman was destroyed, mission can't be completed

  if ( isGroupDestroyed ( "MissionGroup/rescue" ) == true ) return;

  if ( %var < 90 )
   {
    order ( $rescueHerc, Shutdown, True );
    schedule ("endemanRecover();", 10 );
    say (0,0, "<f5>Dignitary is getting into the Herc");
    $dignitaryInEman =  true;
   }
  else
   {
     order ( $rescueHerc, Guard, $safeHouse );
     schedule ( "checkemanArrive();", 3 );
   }

}

//-----------------------------------------------------------------------------
function endemanRecover()
{
   setNavBravoON();

  order ( $rescueHerc, shutdown, False );
  order ( $rescueHerc, Guard, $exitPath );

  EmanGoesHome();

}

//-----------------------------------------------------------------------------
function EmanGoesHome()
{
  if ( objective2 == true ) return;

  order ( $rescueHerc, Guard, $exitPath );
  schedule ("EmanGoesHome();", 4 );
}

//-----------------------------------------------------------------------------
function startArtillery(%who)
{

    if ( getObjectid ("MissionGroup/Artillery/Artillery"@%who) == "")
     {
       return;
     }

    if ( isGroupDestroyed("MissionGroup/Artillery/Artillery"@%who) )
     {
       return;
     }

    %num = randomInt(1,5); 

    if(%num == 1 )
    {
      %target = pickPlayer();
    }
    else if(%num == 2 )
    {
      %target = pickPlayer();
    }
    else if(%num == 3 )
    {
      %target = getObjectID ( "MissionGroup/Targets/rock" @ randomInt(1,6) );
    }
    else if(%num == 4 )
    {
      %target = getObjectID ( "MissionGroup/Targets/rock" @ randomInt(1,6) );
    }
    else       %target = getObjectID ( "MissionGroup/Targets/rock" @ randomInt(1,6) );

   %what = getObjectID ( "MissionGroup/Artillery/Artillery" @ %who );


    order( %what, Attack, %target);

    if($fire)
     { 
       schedule("startArtillery(" @ %who @ ");", 5);
     }
    else
     {
      order("MissionGroup/Artillery/Artillery" @ %who , HoldFire, true);
     }

}

//-----------------------------------------------------------------------------
function surprise()
{

    setPosition("MissionGroup/Artillery/Artillery1", 241, 3572, 249);
    setPosition("MissionGroup/Artillery/Artillery2", 467, 3875, 190);
    setPosition("MissionGroup/Artillery/Artillery3", 738, 4072, 197);
    setPosition("MissionGroup/Artillery/Artillery4", 3766, -2318, 389);
    setPosition("MissionGroup/Artillery/Artillery5", 3456, -2385, 363);
    setPosition("MissionGroup/Artillery/Artillery6", 3005, -2429, 378);

   %target = pickPlayer();

   %howMany = countLivePlayers ();

  createImpPatrol1();
  %time = Randomint (1, 5);
  schedule ("order ($impPatrol1Lead, attack," @ %target @ ");", %time );

  if ( %howmany > 2 )
   {
     %target = pickPlayer();
     createImpPatrol2();
     %time = Randomint (1, 5 );
     schedule ("order ($impPatrol2Lead, attack," @ %target @ ");", %time );
   }

  if ( %howmany > 4 )
   {
     %target = pickPlayer();
     createImpPatrol3();
     %time = Randomint (1, 10);
     schedule ("order ($impPatrol3Lead, attack," @ %target @ ");", %time );
   }

  if ( %howmany > 6 )
   {
     %target = pickPlayer();
     createImpPatrol4();
     %time = Randomint (1, 10);
     schedule ("order ($impPatrol1Lead, attack," @ %target @ ");", %time );
   }

  if ( %howmany > 8 )
   {
     %target = pickPlayer();
     createImpPatrol5();
     %time = Randomint (1, 10);
     schedule ("order ($impPatrol1Lead, attack," @ %target @ ");", %time );
   }


}

//a quick bit about monuments
function key::structure::onDestroyed(%destroyed,%destroyer)
{
    setShapeVisibility(myGetObjectId("MissionGroup/Scenario/Misc/Plaque"), true);
}

function evacSpeaks(%line, %wav)
{
    if(isGroupDestroyed(myGetObjectId("MissionGroup/RebelEvac"))) {killChannel($EvacChannel); return;}
    say(0,$EvacChannel, *(%line), "HA5_TRK0"@%wav@".wav");
}

function convoyLeaderSpeaks(%line, %wav)
{
    if(isGroupDestroyed(myGetObjectId("MissionGroup/RebelEvac"))) {killChannel($cnlChannel); return;}
    say(0,$cnlChannel, *(%line), "HA5_CNL0"@%wav@".wav");
}

//
//
//
//-----------------------------------------------------------------------------
function createEman ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 52;
  if ( %name == "" ) %name = "eman";

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( "MissionGroup/rescue", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc, 26);

  redrop (%herc);

  return %herc ;
}


//-----------------------------------------------------------------------------
function createArty()
{//2757.17 -4347.32

if (randomInt(1,2) == 2 )
  {
  %y = 4072;
  %x = -1757;
  }
 else
  {
  %y = -4347;
  %x = 2757;
  }



  %herc = createArt ( "Artillery1");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;

  %herc = createArt ( "Artillery2");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;

  %herc = createArt ( "Artillery3");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;

  %herc = createArt ( "Artillery4");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;

  %herc = createArt ( "Artillery5");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;

  %herc = createArt ( "Artillery6");
  placeObject ( %herc, %x, %y);
  %y = %y + 40;
  %x = %x + 40;
}

//-----------------------------------------------------------------------------
function createArt ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 133; // Nike Arty
  if ( %name == "" ) %name = "Arty";

  %herc = NewObject ( %name, Tank, %hercID );

  addToSet( "MissionGroup/Artillery", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
//  setPilotId (%herc,28);

  return %herc ;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}


//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {
         return %playerVeh;
       }
     }
  return 0;
}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}

//-----------------------------------------------------------------------------
function setNavBravoON()
{
   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      setNavMarker( $navbravo, true, %playerVeh  );
     }
}

//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {

         %allDead = False;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}

//-----------------------------------------------------------------------------
function missionFailed()
{
  shutdownArty();
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  schedule("missionendconditionmet();", 3);
}


//-----------------------------------------------------------------------------
function createImpPatrol1()
{
  createImpPatrol ( 1, 2.5 );
}

//-----------------------------------------------------------------------------
function createImpPatrol2()
{
  createImpPatrol ( 2, 2.5 );
}


//-----------------------------------------------------------------------------
function createImpPatrol3()
{
  createImpPatrol ( 3, 2.5 );
}

//-----------------------------------------------------------------------------
function createImpPatrol4()
{
  createImpPatrol ( 4, 2.5 );
}

//-----------------------------------------------------------------------------
function createImpPatrol5()
{
  createImpPatrol ( 5, 2.5 );
}

//-----------------------------------------------------------------------------
function createImpPatrol ( %whichPatrol, %ratio )
{

%Veh[1] = 10;   //,TRUE);//Knight'sApocalypse
%Veh[2] = 11;   //,TRUE);//Knight'sMinotaur
%Veh[3] = 12;   //,TRUE);//Knight'sGorgon
%Veh[4] = 13;   //,TRUE);//Knight'sTalon
%Veh[5] = 14;   //,TRUE);//Knight'sBasilisk
%Veh[6] = 15;   //,TRUE);//KnightPaladin
%Veh[7] = 16;   //,TRUE);//KnightMyrmidon


  if ( %ratio == "" ) %ratio = 1;

  %howMany1 = countLivePlayers ();
  %howMany = %howMany1 * %ratio;

  if ( %howmany > 4 ) %howmany = 4;

  for ( %i = 0; %i < %howMany ; %i++ )
    {

//if ( %i > 10 ) break;

     %name = "Pilot"@ %i;
     %r = randomInt (1, 7);
     %which = %Veh[%r];

   if ((%which == 15) || (%which == 16))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }

     setTeam (%herc, *IDSTR_TEAM_RED);
     %pilotID = randomint ( $minAIPilotID, $maxAIPilotID );
     setPilotId (%herc, %pilotID);

     schedule ( "addToSet( $impPatrol" @ %whichPatrol @ ", "@ %herc @ " );", 1); 

     redrop ( %herc );

     order (%herc, speed, high );

      if ( %i == 0 )
      {
       %target = pickPlayer();
       order (%herc, Attack, %target );
      }
     else
      {
       order (%herc, Guard, %lastHerc );
      }

     %lastHerc = %herc;

    } // end for loop
}

//-----------------------------------------------------------------------------
function createGuardPatrol ( %ratio )
{

%Veh[1] = 10;   //,TRUE);//Knight'sApocalypse
%Veh[2] = 11;   //,TRUE);//Knight'sMinotaur
%Veh[3] = 12;   //,TRUE);//Knight'sGorgon
%Veh[4] = 13;   //,TRUE);//Knight'sTalon
%Veh[5] = 14;   //,TRUE);//Knight'sBasilisk
%Veh[6] = 15;   //,TRUE);//KnightPaladin
%Veh[7] = 16;   //,TRUE);//KnightMyrmidon


  if ( %ratio == "" ) %ratio = 2;

  %howMany1 = countLivePlayers ();
  %howMany = %howMany1 * %ratio;

  if ( %howMany > 6 ) %howMany = 6;

// get the location for the drop

  %xdrop = getPosition ($firstGuardPathMarker, x);
  %ydrop = getPosition ($firstGuardPathMarker, y);


  for ( %i = 0; %i < %howMany ; %i++ )
    {

     %name = "Pilot"@ %i;
     %r = randomInt (1, 7);
     %which = %Veh[%r];

   if ((%which == 15) || (%which == 16))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }

     setTeam (%herc, *IDSTR_TEAM_RED);
     %pilotID = randomint ( $minAIPilotID, $maxAIPilotID );
     setPilotId (%herc, %pilotID);

     addToSet( "MissionGroup/impGuard1",  %herc );

//     redrop ( %herc );
// need em closer to the guard path
     placeObject ( %herc, %xdrop, %ydrop );

     %xdrop = %xdrop - 30;

     order (%herc, speed, high );

      if ( %i == 0 )
      {
       order (%herc, Guard, $guardPath1 );
      }
     else
      {
       order (%herc, Guard, %lastHerc );
      }

     %lastHerc = %herc;

    } // end for loop

}

//-----------------------------------------------------------------------------
function vehicle::onArrived(%who, %where)
{

  if ( $safehouseDestroyed == True ) return;

  if (( %who == $rescueHerc ) &&
      ( %where == $exitPathMarker ) &&
      ( $objective2 == False))
    {
      $objective2 = True;
//1023.96 2182.91 136.977
    order ( $rescueHerc, Shutdown, True );
    setPosition ( $rescueHerc, 1023.96, 2182.91, 137);

//    placeObject ( $rescueHerc, 1042, 2179); // inside tunnel 1042.42 2179.75 137.29

      say (0,0,"<f5>Mission objective completed.");
      say (0,0,"<f5>The dignitary is safe.");
      schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
    }

}

//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

if ( %this == $rescueHerc ) 
   {
     order ( $rescueHerc, Guard, $exitPath );
     return;
   }

// have the enemy pick a new target
// attacker can run into buildings
  if (( %this == getObjectID ("MissionGroup/Artillery/Artillery1")  ) ||
      ( %this == getObjectID ("MissionGroup/Artillery/Artillery2")  ) ||
      ( %this == getObjectID ("MissionGroup/Artillery/Artillery3")  ) ||
      ( %this == getObjectID ("MissionGroup/Artillery/Artillery4")  ) ||
      ( %this == getObjectID ("MissionGroup/Artillery/Artillery5")  ) ||
      ( %this == getObjectID ("MissionGroup/Artillery/Artillery6")  ) )
     {

       if ( %message == "ArtilleryOutOfAmmo" )
         {
          reloadObject ( %this, 5000 );
         }
     }
  else
    {
     %who1 = playerManager::vehicleIdToPlayerNum (%this);
     if ( %who1 != 0 ) return;

     %target = pickPlayer ();

     order (%this, attack, %target);
    }
}


//------------------------------------------------------------------------------
function shutdownArty()
{

  %liveHerc = 0;

  if ( isGroupDestroyed ( $arty ) == False ) 
    {

      %liveHerc = getNextObject ( $arty, %liveHerc);
      while ( %liveherc != 0 )
       {
         order (%liveHerc, shutdown, true);
         order (%liveHerc, clear, true);
         %liveHerc = getNextObject ( $arty, %liveHerc);

       }
    }

}


