// FILENAME:	MoonPatrol.cs
//
// AUTHORS:  	Dolf Kooz
//------------------------------------------------------------------------------
// repair truck code by johnrich

$missionName = "Moon Patrol";

$Version = "Version 1.0\nmaps available from www.shadowdragons.org\nEmail dkooz@yahoo.com with bugs";

// admins should limit the player number to 8 or less

   $ratio = 1.5;


// how many times to drop other random brid drop before stopping
// dont want to many showing up while fighting the brids at the base

$minBridDrops = 1;
$maxBridDrops = 2;

$maxBridDropCount = randomInt ($minBridDrops, $maxBridDrops);

// max number of AI in a squad, to keep lag down
   $aiGroupMax = 10;


$server::TeamDamage = true;

// zen stuff for hidden heal pads
// for blast
exec(multiplayerStdlib);

Pilot bridArty
{
   id = 28;
   name = "//0011100101//";
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 0.9;
   activateDist = 3000.0;
   deactivateBuff = 1000.0;
   targetFreq = 0.8;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 0.1;
};

Pilot guard
{
   id = 27;
   skill = 0.1;
   accuracy = 0.1;
   aggressiveness = 0.9;
   activateDist = 300.0;
   deactivateBuff = 100.0;
   targetFreq = 7.0;
   trackFreq = 4.0;
   fireFreq = 4.0;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

//------------------------------------------------------------------------
$minAIPilotID = 29;
$maxAIPilotID = 33;

Pilot PatrolPilot2
{
   id = 29;
   
   skill = 0.4;
   accuracy = 0.4;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot3
{
   id = 30;
   
   skill = 0.5;
   accuracy = 0.5;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot4
{
   id = 31;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};
Pilot PatrolPilot4
{
   id = 32;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 0.9;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};
Pilot PatrolPilot4
{
   id = 33;
   
   skill = 0.8;
   accuracy = 0.8;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 1.0;
   fireFreq = 0.7;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = False;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = False;

   // what can the server admin choose for available teams
   $server::disableTeamRed = False;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = False;
   $server::disableTeamPurple = true;

}

function onMissionLoad()
{
   cdAudioCycle("Watching", "Terror", "Mechsoul"); 

    $textMsg = 
      "Objectives:"@
      "\n1) Patrol the designated route."@
      "\n2) Destroy all Brids encountered."@
      "\nReturn to your starting location to win\n"@
   "Respawning is not allowed. Team Damage is on, watch your fire.";

   %history = 
"\n\nDate: 2815. This is a standard patrol. Long range sensors " @
"have detected Brid in the area." @
"Proceed from Nav Aplha to Bravo, then Sweep to Charlie.\n" @
" A repair truck has been provided to assist you. One is stationed at each base. " @
"Scan the truck to request repair.\n";

   setGameInfo (  %history @ $textMsg);

}

function onMissionStart()
{

	$healRate = 100;   
	$ammoRate = 3;
   	$padWaitTime = 45;
  	$zenWaitTime = 90;
   	$instantPadWaitTime = 120;
	
	moonSounds();

   	$specialHealRate = 1500;   // special pads
   	$specialAmmoRate = 25;
   
   	$blastRadiusSmall = 75;   // for ammo boxes and special pads
   	$blastDamageSmall = 4000;

   	$blastRadiusLarge = 100;  // for fuel tanks
   	$blastDamageLarge = 8000;
   
	cdAudioCycle("Watching", "Terror", "Mechsoul"); 
   init();

}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{
   say ( %this, 0, $Version @"\n"@ $textMsg );
   say ( %this, 0,  "\nCheck the game info tab for more details");
}


//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// so the arty keep shooting
   if ( %message == "ArtilleryOutOfAmmo" )
   {
      reloadObject ( %this, 5000 );
      return;
   }

// so the arty wont change targets without a reason
   if ( %message == "ArtilleryInRange" )
   {
     return;
   }
   if ( %message == "ArtilleryFired" )
   {
     return;
   }
   if ( %message == "ArtilleryMissed" )
   {
     return;
   }
//keep yellow friendly from attacking player
  if (getTeam (%this) == *IDSTR_TEAM_YELLOW) return;

echo ("message = " @ %message @" " @ %this );


// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

   %target = pickPlayer ();

   order (%this, attack, %target);
}


//-----------------------------------------------------------------------------
function vehicle::onScan (%this, %scanner)
{
// echo (getGroup (%this) @" :: "@$repairGroupID );
 if (getGroup (%this) == $repairGroupID )
 {
// echo("in getgroup");

  %who = playerManager::vehicleIdToPlayerNum(%scanner);

   if ($Repair==false  )
     {

// echo("in if repair" @ %scanner);

// have the repair truck follow the scanner
   order (%this, guard, %scanner);

      $Repair=true;
      healObject(%scanner, 3000);
      reloadObject(%scanner, 300);
      say (%who, 0, "<f5>Repair Truck: Repair and Reload in progress, I'm with ya boss.");
     }
    else
     {
      say (%who, 0, "<f5>Repair Truck: Sorry Boss, I'm REAL busy right now having a smoke.");
     }


   schedule("$Repair=false;", 8);
 }
}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}

//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         return %playerVeh;
       }
     }
  return 0;
}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);

  setPosition (%object, %x, %y, %z + 75, %rot);

//  dropPod (%x, %y, %z);


// debug stuff
  %x = getPosition (%object, x);
  %y = getPosition (%object, y);
// echo("placedObject " @ %object @ " at " @ %x @ " " @ %y );
}

//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

         %allDead = false;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}


//-----------------------------------------------------------------------------
function createRandomBrid ( %x, %y, %group, %name, %which )
{

// echo ("DEBUG: x" @ %x @ " y" @ %y @ " group" @ %group @ " name" @ %name @ " which " @ %which );

%maxVeh = 14;

%Veh[1] = 20;   //,TRUE);//Seeker
%Veh[2] = 21;   //,TRUE);//Goad
%Veh[3] = 22;   //,TRUE);//Shepherd
%Veh[4] = 23;   //,TRUE);//Adjudicator
%Veh[5] = 24;   //,TRUE);//Executioner
%Veh[6] = 25;   //,TRUE);//Bolo
%Veh[7] = 26;   //,TRUE);//Recluse

%Veh[8] = 27;   // * PlatAdjucator
%Veh[9] = 28;   // * PlatExecutor
%Veh[10] = 35;   //MetagenSeeker
%Veh[11] = 36;   //MetagenGoad
%Veh[12] = 37;   //MetagenShepherd
%Veh[13] = 38;   //* MetagenAdjucator
%Veh[14] = 39;   // * MetagenExecutor


  if ( $hercNumber == "" )
    {
     $hercNumber = 1;
    }
   else
    {
     $hercNumber = $hercNumber + 1;
    }


     if ( %name == "" )  %name = "brid";

     if ( %which == "" )
       {
         %r = randomInt (1, %maxVeh);
         %which = %Veh[%r];
       }

   %name = %name @ $hercNumber;

   if ((%which == 25) || (%which == 26))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }


     if ( %x == "" )
      {
       redrop ( %herc );
      }
    else
      {

  %z = getTerrainHeight(%x, %y);
  %z = %z + 75;

  setPosition (%herc, %x, %y, %z );

//  %x = getPosition (%herc, x);
//  %y = getPosition (%herc, y);

//schedule ("dropPod (" @ %x @ "," @ %y @"," @ %z @");",1);

      }

     setTeam(%herc, *IDSTR_TEAM_RED);

     addToSet( %group, %herc );

     %pilotID = randomInt ($minAIPilotID, $maxAIPilotID);
     setPilotId (%herc, %pilotID);

   %target = PickPlayer();
   order (%herc, attack, %target );

   order (%herc, speed, high );

   return %herc;
}

//-----------------------------------------------------------------------------
function setNavMarkerON ( %navMarker )
{
   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      setNavMarker( %navMarker, true, %playerVeh  );
     }
}

//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{


// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) 
      return;

//  messagebox (%player, "Check the game info tab for game details and objectives");


   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);
    }

 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( getObjectid($navBravo), true, %this );
}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{

// player dESTROYED 


   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 5 );

// heal and reload the player
   healobject ( %who, 2000 );

  reloadObject(%who, 200 );


   }

   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }
}






//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//---------------- code specific to this mission -------------------------------------------------------------



//-----------------------------------------------------------------------------
function init()
{
// might be having trouble with the scheduler
// i use this to exit onleave aplha to avoid multiple events
   $actionStarted = false;

   $bridDropCount = 0;

   $stopRandomBridDrop = false;

   $objective1 = false;

   $actionStarted = false;
   $attackStarted = false;

  $navAlpha   = "MissionGroup/redBase/NavAlpha";
  $navBravo   = "MissionGroup/purpleBase/NavBravo";
  $navCharlie = "MissionGroup/yellowBase/NavCharlie";
  $navDelta   = "MissionGroup/blueBase/NavDelta";

  $bridNavMarker = "MissionGroup/navMarkers/NavBrid";

  $bravoArty   = getObjectID("MissionGroup/bridPoints/bravo/arty");
  $charlieArty = getObjectID("MissionGroup/bridPoints/charlie/arty");
  $deltaArty   = getObjectID("MissionGroup/bridPoints/delta/arty");

  $bravoBrid   = getObjectID("MissionGroup/bridPoints/bravo/brid");
  $charlieBrid = getObjectID("MissionGroup/bridPoints/charlie/brid");
  $deltaBrid   = getObjectID("MissionGroup/bridPoints/delta/brid");


  newObject( "arty", SimGroup );
  addToSet( "MissionGroup", "arty" );

  $arty = "MissionGroup/arty";

  newObject( "bridPatrol1", SimGroup );
  addToSet( "MissionGroup", "bridPatrol1" );

  newObject( "bridPatrol2", SimGroup );
  addToSet( "MissionGroup", "bridPatrol2" );

  newObject( "bridPatrol3", SimGroup );
  addToSet( "MissionGroup", "bridPatrol3" );

   $bridPatrol1 = "MissionGroup/bridPatrol1";
   $bridPatrol2 = "MissionGroup/bridPatrol2";
   $bridPatrol3 = "MissionGroup/bridPatrol3";

// used for repairing players
$Repair=false;

  newObject( "Repair", SimGroup );
  addToSet( "MissionGroup", "Repair" );

  $repairGroupID = getObjectId("MissionGroup/Repair"); 
  $repairGroup = "MissionGroup/Repair";

  initRepair();


   MPcheckBoundary( leave, getObjectID ($navAlpha) , 300, onLeaveNavAlphaWarning, 1 );
   MPcheckBoundary( leave, getObjectID ($navAlpha) , 500, onLeaveNavAlpha, 1 );

}

//-----------------------------------------------------------------------------
function onLeaveNavAlphaWarning ()
{
   say (0,0, "<f5>You are leaving the base. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function onLeaveNavAlpha ()
{
  if ( $actionStarted == true ) return;

   $actionStarted = true;

   %newNavPoint = getObjectId ($navBravo ); 
   schedule ("onArriveNavPoint(" @ %newNavPoint @");", 10 );

  %nextDrop = randomInt (20, 60);
  schedule ("randomBridDrop();", %nextDrop );

//pick the random attacks by brids

  %which1 = RandomInt (1,3);

  %which2 = RandomInt (1,3);
  while (%which1 == %which2)
  {
     %which2 = RandomInt (1,3);
  }

  if ((%which1 == 1) || (%which2 == 1))
  {
// echo("brid attack bravo");
     MPcheckBoundary( enter, getObjectID ($navBravo) , 700, bridAttackBravo, 5 );
  }

  if ((%which1 == 2) || (%which2 == 2))
  {
// echo("brid attack charlie");
     MPcheckBoundary( enter, getObjectID ($navCharlie) , 700, bridAttackCharlie, 5 );
  }

  if ((%which1 == 3) || (%which2 == 3))
  {
// echo("brid attack delta");
     MPcheckBoundary( enter, getObjectID ($navDelta) , 700, bridAttackDelta, 5 );
  }

}

//-----------------------------------------------------------------------------
function onArriveNavAlpha()
{

// can't exit till all the players are at Alpha or the objective, destroy
// all brids are destroyed


 %obj1 = getObjectID ( $navAlpha );
// %obj1 = getObjectID ( $navDelta );

 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 250 )
            {
              %howManyAreClose++;

//              if (( isGroupDestroyed ( $bridPatrol1 ) == False ) ||
//                  ( isGroupDestroyed ( $bridPatrol2 ) == False ) ||
//                  ( isGroupDestroyed ( $bridPatrol3 ) == False ) ||
//                  ( isGroupDestroyed ( $arty ) == False ) 
//                 )
//                 {
//                   schedule ("onArriveNavAlpha();", 60 );
//                   markBrid();
//                   return;
//                 }

            }

       }
     }

  if ( %howManyAreClose == %howMany ) 
    {
     shutdownArty();
     schedule("winCondition();", 5);
    }
   else
    {
      schedule ("onArriveNavAlpha();", 10 );
// echo("rescheduling onArriveNavAlpha");
    }
}

//-----------------------------------------------------------------------------
// show the players where the brid is at
function markBrid()
{

// echo ("in mark brid");

%liveHerc = 0;

  if ( isGroupDestroyed ( $bridPatrol1 ) == False )
    {
      %liveHerc = getNextObject ( $bridPatrol1, %liveHerc);
    }
  if ( isGroupDestroyed ( $bridPatrol2 ) == False )
    {
      %liveHerc = getNextObject ( $bridPatrol2, %liveHerc);
    }
  if ( isGroupDestroyed ( $bridPatrol3 ) == False )
    {
      %liveHerc = getNextObject ( $bridPatrol3, %liveHerc);
    }
  if ( isGroupDestroyed ( $arty ) == False ) 
    {
      %liveHerc = getNextObject ( $arty, %liveHerc);
    }
 
 if ( %liveHerc == 0 ) return;

   say (0,0,"<f5>TACOM: Brid units detected, setting nav marker One now");

  %x = getPosition (%liveHerc, x);
  %y = getPosition (%liveHerc, y);

// echo ("live herc = " @ %liveHerc @ " " @ %x @ " " @ %y);

  %z = getTerrainHeight(%x, %y);

  %object = getObjectid($bridNavMarker);

  setPosition (%object, %x, %y, %z);

  setNavMarkerON ( $bridNavMarker );
schedule ("setNavMarkerON ( " @ $navAlpha @ ");", 30);
}

//-----------------------------------------------------------------------------
// this code switches to the next nav point
function onArriveNavPoint( %navPoint )
{

 %obj1 = getObjectID ( %navPoint );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 300 ) %howManyAreClose++;
       }
     }

//echo ("%howManyAreClose , %howMany " @ %howManyAreClose @" "@ %howMany);

  if ( %howManyAreClose == %howMany ) 
    {

// turn back on the random brid drops
      $bridDropCount = 0;
      $maxBridDropCount = randomInt ($minBridDrops, $maxBridDrops);
      %nextDrop = randomInt (40, 60);
      schedule ("randomBridDrop();", %nextDrop );
      switchNavPoints ( %navPoint );

// echo("resetting brid drops to  " @ $maxBridDropCount );

    }
   else
    {
      schedule ("onArriveNavPoint(" @ %navPoint @");", 10 );
    }
}

//-----------------------------------------------------------------------------
// this code switches to the next nav point
function SwitchNavPoints ( %navPoint  )
{
  if ( %navPoint == getObjectId ($navAlpha ) )
    {
      say (0,0, "<f5>Nav Alpha Secure, Proceed to Nav Bravo");
      %newNavPoint = getObjectId ($navBravo ) ;
      schedule ("onArriveNavPoint(" @ %newNavPoint @");", 40 );
    }

  if ( %navPoint == getObjectId ($navBravo ) )
    {
      say (0,0, "<f5>Nav Bravo Secure, Proceed to Nav Charlie");
      %newNavPoint = getObjectId ($navCharlie ) ;
      schedule ("onArriveNavPoint(" @ %newNavPoint @");", 40 );
    }

  if ( %navPoint == getObjectId ($navCharlie ) )
    {
      say (0,0, "<f5>Nav Charlie Secure, Proceed to Nav Delta");
      %newNavPoint = getObjectId ($navDelta ) ;
      schedule ("onArriveNavPoint(" @ %newNavPoint @");", 40 );
    }

  if ( %navPoint == getObjectId ($navDelta ) )
    {
      say (0,0, "<f5>Nav Delta Secure, Proceed to Nav Alpha");
      %newNavPoint = getObjectId ($navAlpha ); 
      schedule ("onArriveNavAlpha();", 50 );

      $maxBridDropCount = randomInt ($minBridDrops, $maxBridDrops + 1);
      %nextDrop = randomInt (40, 60);

    }

  setNavMarkerON ( %newNavPoint );

}


//-----------------------------------------------------------------------------
function bridAttackBravo()
{

  %x = getPosition ( $bravoArty, x );
  %y = getPosition ( $bravoArty, y );

  createBridArty ( $arty, %x, %y );

   %livePlayers = countLivePlayers ();
   %howMany = %livePlayers * $ratio;

  %x = getPosition ( $bravoBrid, x );
  %y = getPosition ( $bravoBrid, y );

  %group = $bridPatrol1;

   for (%p = 0; %p < %howMany; %p++)
   {
      %name = "i8holething" @ %p;
      %herc = createRandomBrid ( %x, %y, %group, %name, %which );
      %y = %y - 30;
      %x = %x + 40;
   }
}
//////////
//-----------------------------------------------------------------------------
function bridAttackCharlie()
{

  %x = getPosition ( $charlieArty, x );
  %y = getPosition ( $charlieArty, y );

  createBridArty ( $arty, %x, %y );

   %livePlayers = countLivePlayers ();
   %howMany = %livePlayers * $ratio;

  %x = getPosition ( $charlieBrid, x );
  %y = getPosition ( $charlieBrid, y );

  %group = $bridPatrol2;

   for (%p = 0; %p < %howMany; %p++)
   {
      %name = "i8holething" @ %p;
      %herc = createRandomBrid ( %x, %y, %group, %name, %which );

      %y = %y - 30;
      %x = %x + 40;
   }
}
//-----------------------------------------------------------------------------
function bridAttackDelta()
{

  schedule ("$stopRandomBridDrop = true;", 10);

  %x = getPosition ( $deltaArty, x );
  %y = getPosition ( $deltaArty, y );

  createBridArty ( $arty, %x, %y );

   %livePlayers = countLivePlayers ();
   %howMany = %livePlayers * $ratio;

  %x = getPosition ( $deltaBrid, x );
  %y = getPosition ( $deltaBrid, y );

  %group = $bridPatrol3;

   for (%p = 0; %p < %howMany; %p++)
   {
      %name = "i8holething" @ %p;
      %herc = createRandomBrid ( %x, %y, %group, %name, %which );
      %y = %y - 30;
      %x = %x + 40;
   }
}

/////////
//-----------------------------------------------------------------------------
function createBridArty ( %group, %x, %y, %howMany )
{

 if (%howMany == "" ) %howMany = 4;

//allowVehicle(90,FALSE);// * Cybrid Artillery

   for (%p = 0; %p < %howMany; %p++)
   {
     %herc = NewObject( "Aunit", Tank, 90); // terran drop ship

     addToSet( %group, %herc );

     setTeam(%herc, *IDSTR_TEAM_RED);
     setPilotId (%herc,28);

     placeObject (%herc, %x, %y);

      %x = %x + 50;
      %y = %y + 60;

      order (%herc, speed, high );

      %target = PickPlayer();
      order (%herc, attack, %target );
   }

}




//-----------------------------------------------------------------------------
function winCondition()
{
  flushConsoleScheduler();
  %howmany = 0;

  %text = "\nBases Patrolled ";
  %text = %text @ "Successful";

  %text = %text @ %text = "\nAll Brids Destroyed ";
  %text = %text @ "Successful";
  %text = %text @ "\nExcellent work team.";

  messageBox(0, "Mission Completed, All objectives completed. "@ %text );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function missionFailed()
{
  shutdownArty();
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  schedule("missionendconditionmet();", 3);
}

//**==REPAIR CLASS==***********************************************************
//-----------------------------------------------------------------------------
function initRepair()
{
  createRepair (-1583, -1778); // alpha
  createRepair (1742, -938 );  //bravo
  createRepair (1723, 782 );   // charlie
  createRepair (-717, 560 );   // delta
}

//-----------------------------------------------------------------------------
function createRepair (%x, %y )
{

// terran utility truck 71

  %herc = NewObject ( "repair1", Tank, 71 );

  addToSet( $repairGroup, %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);

  %z = getTerrainHeight(%x, %y);

  setPosition (%herc, %x, %y, %z + 75, %rot);

}

//-----------------------------------------------------------------------------
function randomBridDrop()
{
// echo ("dropping random brids");
  %target = pickPlayer ();

  %x = getPosition ( %target, x );
  %y = getPosition ( %target, y );

  %loc = randomInt (1,4);

// echo ("loc is " @ %loc @ " x=" @ %x @ " y=" @ %y );

  if ( %loc == 1 ) %x = %x + 700;
  if ( %loc == 2 ) %x = %x - 700;

  if ( %loc == 3 ) %y = %y + 700;
  if ( %loc == 4 ) %y = %y - 700;

// echo ("loc is " @ %loc@ " x="@ %x @" y="@ %y );

  %group = $bridPatrol2;

  %howMany = countLivePlayers ();

  for (%p = 0; %p < %howMany; %p++)
    {
      %herc = createRandomBrid ( %x, %y, %group, "brid", "" );


  %z = getTerrainHeight(%x, %y);
  %z = %z + 75;

  setPosition (%herc, %x, %y, %z );


      %y = %y - 30;
      %x = %x + 40;
    }

  if ( $stopRandomBridDrop == true ) return;

  if ( $bridDropCount >= $maxBridDropCount ) return;

  $bridDropCount = $bridDropCount + 1;

  %nextDrop = randomInt (50,90);
  schedule ("randomBridDrop();", %nextDrop );
}



//-----------------------------------------------------------------------------
function checkPosition (%this)
{
// check to see if the newly dropped vehicle is on the ground, or 
// on top of a building or another vehicle, if so move it, and check again

    %x = getPosition (%this, x);
    %y = getPosition (%this, y);
    %z = getPosition (%this, z);

  %zTerrain = getTerrainHeight(%x, %y);

// echo ("%z/%zterrian " @ %z @" "@ %zTerrain  @" "@  %x  @" "@  %y);

// found some underground
   if ( %z < %zTerrain )
     {
       %z = %zTerrain + 3;
       setPosition (%this, %x, %y, %z);
     }

   if ( %z-10 > %zTerrain )
    {
     %x = %x + RandomInt (-150, 150);
     %y = %y + RandomInt (-150, 150);

     setPosition (%this, %x, %y, %z);
     schedule ("checkPosition (" @ %this @ ");", 4);
    }
}


//------------------------------------------------------------------------------
function shutdownArty()
{
  %liveHerc = 0;

  if ( isGroupDestroyed ( $arty ) == False ) 
    {

      %liveHerc = getNextObject ( $arty, %liveHerc);
      while ( %liveherc != 0 )
       {
         order (%liveHerc, shutdown, true);
         order (%liveHerc, clear, true);
         %liveHerc = getNextObject ( $arty, %liveHerc);
       }
    }

}




//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//----------- code from original map has easter egg n' stuff -------------------


// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

// Instant Pad stuff
//------------------------------------------------------------------------------
function ZenInstant::trigger::onEnter(%this, %object)
{
   Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenInstant::trigger::onContact(%this, %object)
{
   // completely heal and reload instantly -- no reset time
   // shutdown necessary
   Zen::work(%this, %object, 10000, 100, $instantPadWaitTime, true); 
}
function ZenInstant::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}

// Special pads
// no message, no shutdown, no reset
function ZenAll1::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
    Zen::onEnter(%this, %object, "", false, false);  
	if(%this.wait != true){
		Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 20 , false);
	   // damage everyone else within %blastRadiusSmall meters
   		blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);
		explosion1();
	}
}

function ZenAll2::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
    Zen::onEnter(%this, %object, "", false, false);  
	if(%this.wait != true){
		Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 20 , false);
	   // damage everyone else within %blastRadiusSmall meters
   		blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);
		explosion2();
	}
}

function ZenAll3::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
    Zen::onEnter(%this, %object, "", false, false);  
	if(%this.wait != true){
		Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 20 , false);
	   // damage everyone else within %blastRadiusSmall meters
   		blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);
		explosion3();
	}
}

function ZenAll4::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
    Zen::onEnter(%this, %object, "", false, false);  
	if(%this.wait != true){
		Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 20 , false);
	   // damage everyone else within %blastRadiusSmall meters
   		blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);
		explosion4();
	}
} 
function ZenAll1::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function ZenAll2::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function ZenAll3::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function ZenAll4::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}

function explosion1()
{
	dropPod(-686, 688, 117, -759, 688, 117);
	dropPod(-759, 688, 117, -686, 688, 117);
}
function explosion2()
{
	dropPod(-686, 720, 117, -759, 720, 117);
	dropPod(-759, 720, 117, -686, 720, 117);
}
function explosion3()
{
	dropPod(-686, 752, 117, -759, 752, 117);
	dropPod(-759, 752, 117, -686, 752, 117);
}
function explosion4()
{
	dropPod(-686, 784, 117, -759, 784, 117);
	dropPod(-759, 784, 117, -686, 784, 117);
}


// Ammo boxes and special pads
//--------------------------------------------------------------------------------
function BlastDamageSmall::structure::onDestroyed(%this, %object)
{
   // blast everyone around
   // exclude nobody
   blast(%this, $blastRadiusSmall, $blastDamageSmall, 0);
}

// fuel tanks
//--------------------------------------------------------------------------------
function BlastDamageLarge::structure::onDestroyed(%this, %object)
{
   // blast everyone around
   // exclude nobody
   blast(%this, $blastRadiusLarge, $blastDamageLarge, 0);
}


// Easter Egg
//--------------------------------------------------------------------------------
function EasterEgg::trigger::onEnter(%this, %object)
{
	Say(playerManager::vehicleIdToPlayerNum(%object), %object, *IDMULT_MOON_LANDER_FOUND);
}
function EasterEgg::trigger::onContact(%this, %object)
{
	damageObject(%object, 250);
}

// from multiplayerStdLib.cs
//---------------------------------------------------------------------------
// Damage 

function blast(%exploder, %range, %damage, %exclude)
{
   // exploder does some damage
   // find all players within %range and do linear-dropoff %damage
   // note that this only damages players
   
   %count = playerManager::getPlayerCount();
	for(%i = 0; %i < %count; %i = %i + 1)
	{
		%curPlayerNum = playerManager::getPlayerNum(%i);
		%curVehicle = playerManager::playerNumToVehicleId(%curPlayerNum);
      
      if(
         %exclude == 0 ||
         %exclude != %curVehicle
      )
      {      
         %curDist = getDistance(%exploder, %curVehicle);
         
         // see if it is close enough
         if(%curDist < %range)
         {
            %curDamage = (%damage * ((%range - %curDist) / %range));
         
            resetLastHitBy(%curVehicle);
            damageObject(%curVehicle, %curDamage); 
         }
      }
	}
}
// Ammo boxes and special pads
//--------------------------------------------------------------------------------
function structure::onDestroyed(%this, %object)
{

echo("some structure died");
   // blast everyone around
   // exclude nobody
  %blastRadius = randomInt ( $blastRadiusSmall, $blastRadiusLarge);
  %blastDamage = randomInt ( $blastDamageSmall, $blastDamageLarge);
   blast(%this, %blastRadius, %blastDamage, 0);
}

