// FILENAME: humanOnly.cs
// AUTHORS: [OF/CA] Pincushion ASXO tFc
//   v1 May 12, 1999; v2 May 25, 1999
//
// This script gives a Starsiege server administrator precise control over
// the equipment players may use.  By default only the standard equipment is
// enabled.  There are also lines for the non-standard vehicles whose IDs are
// known at this time.  To enable any of them just change the appropriate
// FALSE to TRUE.
//
// Cut and paste the contents of this file at the end of your server script,
// e.g. Server_DM_ALL.cs; or add the line
//
//   exec("vanilla2.cs");
//
// at the end and put this file in your starsiege/scripts folder.

// Lights off
allowVehicle(all,FALSE);
allowWeapon(all,FALSE);
allowComponent(all,FALSE);

// Double-dog sure...
function i_said_vanilla_dammit()
{
  for (%i=-32768; %i<32768; %i++) {
    allowVehicle(%i,FALSE);
    allowWeapon(%i,FALSE);
    allowComponent(%i,FALSE);
  }
}
i_said_vanilla_dammit();

// *SNIIIIIFFFFF*  Ahhhh, fresh as a Spring morning.
// Ok, turn on the standard stuff...

//Vehicles (* denotes a non-standard vehicle)
allowVehicle(1,TRUE);//TerranApocalypse
allowVehicle(2,TRUE);//TerranMinotaur
allowVehicle(3,TRUE);//TerranGorgon
allowVehicle(4,TRUE);//TerranTalon
allowVehicle(5,TRUE);//TerranBasilisk
allowVehicle(6,TRUE);//Paladin
allowVehicle(7,TRUE);//Myrmidon
allowVehicle(8,TRUE);//Disrupter
allowVehicle(9,FALSE);// * Banshee
allowVehicle(10,TRUE);//Knight'sApocalypse
allowVehicle(11,TRUE);//Knight'sMinotaur
allowVehicle(12,TRUE);//Knight'sGorgon
allowVehicle(13,TRUE);//Knight'sTalon
allowVehicle(14,TRUE);//Knight'sBasilisk
allowVehicle(15,TRUE);//KnightPaladin
allowVehicle(16,TRUE);//KnightMyrmidon
allowVehicle(17,TRUE);//KnightDisrupter
allowVehicle(18,FALSE);// * TerranCargo
allowVehicle(19,FALSE);// * TerranEscape

allowVehicle(30,TRUE);//Emancipator
allowVehicle(31,TRUE);//Avenger
allowVehicle(32,TRUE);//Dreadlock
allowVehicle(33,TRUE);//Olympian

allowVehicle(40,FALSE);// * Harabec'sApocalypse
allowVehicle(41,TRUE);//Predator
allowVehicle(42,FALSE);// * Caanon's Basilisk?
allowVehicle(43,FALSE);// * Cinematic Apocalypse
allowVehicle(44,FALSE);// * Cinematic Basilisk
allowVehicle(45,FALSE);// * Super Predator

allowVehicle(50,FALSE);// * Pirateapocalypse
allowVehicle(51,FALSE);// * Piratedreadlock
allowVehicle(52,TRUE);//PirateEmancipator


allowVehicle(60,FALSE);// * Terran Empty Cargo
allowVehicle(61,FALSE);// * Terran Ammo
allowVehicle(62,FALSE);// * Terran Big Ammo
allowVehicle(63,FALSE);// * Terran Big Personnel
allowVehicle(64,FALSE);// * Terran Fuel
allowVehicle(65,FALSE);// * Terran (Mino?)
allowVehicle(66,FALSE);// * Rebel Empty Cargo
allowVehicle(67,FALSE);// * Rebel Ammo
allowVehicle(68,FALSE);// * Rebel Big Cargo
allowVehicle(69,FALSE);// * Rebel Big Box Cargo
allowVehicle(70,FALSE);// * Rebel Box Cargo
allowVehicle(71,FALSE);// * Terran Utility Truck
allowVehicle(72,FALSE);// * Thumper
allowVehicle(73,FALSE);// * Terran Starefield

allowVehicle(90,FALSE);// * Cybrid Artillery
allowVehicle(91,FALSE);// * Cybrid Advocate
allowVehicle(92,FALSE);// * Cybrid Dropship
allowVehicle(93,FALSE);// * Cybrid Consul Bomber
allowVehicle(94,FALSE);// * Cybrid Omnicrawler
allowVehicle(95,FALSE);// * Cybrid Protector
allowVehicle(96,FALSE);// * Cybrid Jammer

allowVehicle(110,FALSE);// * Knight's Banshee
allowVehicle(111,FALSE);// * Knight's Dropship

allowVehicle(130,FALSE);// * Terran Dropship
allowVehicle(131,FALSE);// * Draco Bomber
allowVehicle(132,FALSE);// * Conveyor
allowVehicle(133,FALSE);// * Nike
allowVehicle(134,FALSE);// * Supressor
allowVehicle(135,FALSE);// * Terran Sovereign
allowVehicle(136,FALSE);// * Terran Surveyor
allowVehicle(137,FALSE);// * Rebel Artillery
allowVehicle(138,FALSE);// * Pouncer Bike

allowVehicle(150,FALSE);// * Bus

//weapons
allowWeapon(101,TRUE);//Laser
allowWeapon(102,TRUE);//HeavyLaser
allowWeapon(103,TRUE);//CompLaser

allowWeapon(105,TRUE);//Emp
allowWeapon(106,TRUE);//ELF
allowWeapon(107,TRUE);//Blaster
allowWeapon(108,TRUE);//HeavyBlaster

allowWeapon(110,TRUE);//Plasma

allowWeapon(112,TRUE);//Qgun
allowWeapon(113,TRUE);//MFAC

allowWeapon(115,TRUE);//NaniteCannon
allowWeapon(116,TRUE);//Autocannon
allowWeapon(117,TRUE);//HvyAutocannon

allowWeapon(119,TRUE);//BlastCannon
allowWeapon(120,TRUE);//HvyBlastCan

allowWeapon(124,TRUE);//PitViper8
allowWeapon(125,TRUE);//PitViper12
allowWeapon(126,TRUE);//Sparrow6
allowWeapon(127,TRUE);//Sparrow10
allowWeapon(128,TRUE);//SWARM6
allowWeapon(129,TRUE);//Minion

allowWeapon(147,TRUE);//Aphid



allowWeapon(134,TRUE);//Proximity6
allowWeapon(135,TRUE);//Proximity10
allowWeapon(136,TRUE);//Proximity15

allowWeapon(3,TRUE);//Disrupter
allowWeapon(150,TRUE);//SMARTGun

//Components
//Reactors
allowComponent(200,TRUE);//HumanMicroReactor
allowComponent(201,TRUE);//SmallHumanReactor2--small
allowComponent(202,TRUE);//MediumHumanReactor1Standard
allowComponent(203,TRUE);//MediumHumanReactor2medium
allowComponent(204,TRUE);//LargeHumanReactor1--large
allowComponent(205,TRUE);//LargeHumanReactor2--Maxim

//Shields
allowComponent(300,TRUE);//HumanStandardShield
allowComponent(301,TRUE);//HumanProtectorShield
allowComponent(302,TRUE);//HumanGuardianShield
allowComponent(303,TRUE);//HumanFastChargeShield
allowComponent(304,TRUE);//HumanCenturianShield
allowComponent(305,TRUE);//HumanRepulsorShield
allowComponent(306,TRUE);//HumanTitanShield
allowComponent(307,TRUE);//HumanMedusaShield

//Sensors
allowComponent(400,TRUE);//BasicHumanSensor
allowComponent(401,TRUE);//LongRangeSensor--Ranger
allowComponent(408,TRUE);//StandardHumanSensor
allowComponent(409,TRUE);//HumanLongbowSensor
allowComponent(410,TRUE);//HumanInfiltratorSensor
allowComponent(411,TRUE);//HumanCrossbowSensor
allowComponent(412,TRUE);//HumanUltralightSensor
allowComponent(413,TRUE);//HumanHoundDogSensor
allowComponent(414,TRUE);//ThermalSensor

//Engines
allowComponent(100,TRUE);//HumanLightVehicleEngine
allowComponent(101,TRUE);//HumanHighOutputLightEngine
allowComponent(102,TRUE);//HumanAgileLightEngine
allowComponent(103,TRUE);//HumanStandardMediumEngine
allowComponent(104,TRUE);//HumanHighOutputMediumEngine
allowComponent(105,TRUE);//HumanMediumAgilityEngine
allowComponent(106,TRUE);//HumanStandardHeavyEngine
allowComponent(107,TRUE);//HumanImprovedHeavyEngine
allowComponent(108,TRUE);//HumanHeavyCruiseEngine
allowComponent(109,TRUE);//HumanHighOutputHeavyEngine
allowComponent(110,TRUE);//HumanAgileHeavyEngine
allowComponent(111,TRUE);//HumanStandardAssaultEngine
allowComponent(112,TRUE);//HumanImprovedAssaultEngine
allowComponent(113,TRUE);//Humanheavyturbineengine
allowComponent(114,TRUE);//HighOutputTurbine(HOT)
allowComponent(115,TRUE);//Humansuperheavyengine

//Armor
allowComponent(926,TRUE);//CarbonFiber(CARLAM)
allowComponent(927,TRUE);//QuadBondedMetaplas(QBM)
allowComponent(928,TRUE);//DURAC(DepletetedUranium)
allowComponent(929,TRUE);//Ceramic
allowComponent(930,TRUE);//Crystaluminum
allowComponent(931,TRUE);//Quicksilver

//InternalComponents
allowComponent(800,TRUE);//HumanBasicComputer
allowComponent(801,TRUE);//HumanImprovedComputer
allowComponent(802,TRUE);//HumanAdvancedComputer

allowComponent(810,TRUE);//GuardianECM
allowComponent(811,TRUE);//DopplegangerECM

allowComponent(820,TRUE);//ThermalDiffuser
allowComponent(830,TRUE);//Chameleon
allowComponent(831,TRUE);//Cuttlefishcloak
allowComponent(840,TRUE);//ShieldModulator
allowComponent(845,TRUE);//ShieldCapacitor
allowComponent(850,TRUE);//ShieldAmplifier(increasesshieldconstant)
allowComponent(860,TRUE);//LaserTargetingModule
allowComponent(865,TRUE);//ExtraBattery
allowComponent(870,TRUE);//ReactorCapacitor
allowComponent(875,TRUE);//FieldStabilizer
allowComponent(880,TRUE);//RocketBooster
allowComponent(885,TRUE);//TurbineBoost
allowComponent(890,TRUE);//NanoRepair
allowComponent(900,TRUE);//AngleLifeSupport
allowComponent(910,TRUE);//AgravGenerator
allowComponent(912,TRUE);//ElectroHull
allowComponent(914,TRUE);//UAP
