// FILENAME:	CybridAssault.cs
//
// AUTHORS:  	Dkooz
//------------------------------------------------------------------------------

$missionName = "CybridAssault";

$Version = "Version 1.0\nmaps available from www.shadowdragons.org";

$dropextratime = 60;

$server::TeamDamage = true;

$actionStarted = false;
$attackStarted = false;


Pilot PatrolPilot
{
   id = 28;
   
   skill = 0.3;
   accuracy = 0.3;
   aggressiveness = 0.9;
   activateDist = 600.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.1;
   orderFreq = 4.0;
};

Pilot ShipkillerPilot
{
   id = 29;
   
   skill = 0.3;
   accuracy = 0.3;
   aggressiveness = 0.9;
   activateDist = 500.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 0.8;
   LOSFreq = 0.1;
   orderFreq = 4.0;
};

//-----------------------------------------------------------------------------
function setDefaultMissionOptions()
{

	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

}

//-----------------------------------------------------------------------------
function onMissionStart()
{
   titansounds();
   init();
}

//-----------------------------------------------------------------------------
function onMissionLoad()
{
   cdAudioCycle("Gnash", "Cloudburst", "Cyberntx");


    $textMsg = "Destroy the Cybrid Base at Nav Alpha\n\n"@
      "Complete Objectives:"@
      "\n1) Destroy the Cybrid Supply base."@
      "\nReturn to Nav Bravo for exit\n"@
   "Respawning is not allowed. Destroying an enemy heals your vehicle and"@
   " reloads your weapons. Team Damage is on, watch your fire.";

   %history = 
"\n\nDate: 2832. Your squad has been assigned a hit and run strike mission. TACOM" @
"has detected a Cybrid supply base. Your team will set down @2000M from the base." @
" Proceed to Nav Alpha, destroy the base and any transport ships. The Cybrids will" @
" undoubtly have reinforcements near by. When the base has been destroy return to" @
" the drop ship for exit.";

   setGameInfo ($textMsg @ %history);

}


//-----------------------------------------------------------------------------
function init()
{

  $maxAI = 20;
// number of randomly dropped AI on the map at any given time
// until the base is destroyed
     $maxAIRatio = 2;

$Veh[1] = 20;   //,TRUE);//Seeker
$Veh[2] = 21;   //,TRUE);//Goad
$Veh[3] = 22;   //,TRUE);//Shepherd
$Veh[4] = 23;   //,TRUE);//Adjudicator
$Veh[5] = 24;   //,TRUE);//Executioner
$Veh[6] = 25;   //,TRUE);//Bolo
$Veh[7] = 26;   //,TRUE);//Recluse

$Veh[8] = 27;   //
$Veh[9] = 28;   //
$Veh[10] = 35;   //
$Veh[11] = 36;   //
$Veh[12] = 37;   //
$Veh[13] = 38;   //
$Veh[14] = 39;   //


   $objective1 = false;

   $actionStarted = false;
   $attackStarted = false;

  $navAlpha   = "MissionGroup/navPoints/NavAlpha";
  $navBravo   = "MissionGroup/navPoints/NavBravo";
  $navCharlie = "MissionGroup/navPoints/NavCharlie";

  $bridBase = "MissionGroup/cybridBase";

//  newObject( "bridKillShip", SimGroup );
//  addToSet( "MissionGroup", "bridKillShip" );

  newObject( "dropShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropShipGroup" );

  $dropShip = "MissionGroup/dropShipGroup/Drop Ship";

  newObject( "dropBridShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropBridShipGroup" );

  $dropBridShipGroup = "MissionGroup/dropBridShipGroup";

  $cybridKillShipmarker = getObjectID ( "MissionGroup/bridKillShip/marker1" );


  newObject( "bridPatrol1", SimGroup );
  addToSet( "MissionGroup", "bridPatrol1" );

  $bridPatrol1 = "MissionGroup/bridPatrol1";

  newObject( "bridPatrol2", SimGroup );
  addToSet( "MissionGroup", "bridPatrol2" );

  $bridPatrol2 = "MissionGroup/bridPatrol2";

  newObject( "bridPatrol3", SimGroup );
  addToSet( "MissionGroup", "bridPatrol3" );

  $bridPatrol3 = "MissionGroup/bridPatrol3";


  $bridPath1 = "MissionGroup/bridPath1";
  $bridPath2 = "MissionGroup/bridPath2";
  $bridPath3 = "MissionGroup/bridPath3";

                                       
  createDropShip();

  schedule ("createBridPatrol ( 2, 1 );", 2 );
  schedule ("createBridPatrol ( 3, 1 );", 6);


   MPcheckBoundary( leave, getObjectID ($navBravo) , 300, onLeaveNavBravoWarning, 1 );
   MPcheckBoundary( leave, getObjectID ($navBravo) , 500, onLeaveNavBravo, 5 );

}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{


say ( %this, 0, $Version @"\n"@ $textMsg );
say ( %this, 0,  "Check the game info tab for more details");
say ( %this, 0,  "<F5>Objective: Destroy the Brid base at Nav Alpha");

}

//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{


// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) 
      return;


// messagebox (%player, "Proceed to Nav Alpha and destroy the Brid supply base.");

say (%player, "Proceed to Nav Alpha and destroy the Brid supply base.");
say (%player, "Check the game info tab for game details and objectives");

                                                                                   
   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);
    }

 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{

// player dESTROYED 
   if( %this == getObjectID ( $dropShip) )
   {
     say (0,0,"<f5>\nGreat, there goes our ride home!\n");
     schedule ("setNavCharlieON();", 20 );
   }


   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }


  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 5 );

// heal and reload the player
   healobject ( %who, 5000 );

  reloadObject(%who, 5000 );

   }

   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }
}

//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         return %playerVeh;
       }
     }
  return 0;
}

//-----------------------------------------------------------------------------
function onLeaveNavBravo ()
{

$actionStarted = true;

  schedule ("createBridPatrol ( 1, 1 );", 3);
}

//-----------------------------------------------------------------------------
function onLeaveNavBravoWarning ()
{
   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function onArriveNavBravo()
{

  if ( isGroupDestroyed ( $dropShip) == true ) return;

 %obj1 = getObjectID ( $navBravo );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 200 ) %howManyAreClose++;
       }
     }


  if ( %howManyAreClose == %howMany ) 
    {
     winCondition();
    }
   else
    {
      schedule ("onArriveNavBravo();", 10 );
    }
}

//-----------------------------------------------------------------------------
function onArriveNavCharlie()
{

 %obj1 = getObjectID ( $navCharlie );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 300 ) %howManyAreClose++;
       }
     }

  if ( %howManyAreClose == %howMany ) 
    {
     winCondition();
    }
   else
    {
      schedule ("onArriveNavCharlie();", 10 );
    }
}

//-----------------------------------------------------------------------------
function onArriveNavBravoDropBrid()
{

//  if ( isGroupDestroyed ( $dropShip) == True ) return;

 %obj1 = getObjectID ( $navBravo );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 900 )
            {
              %howManyAreClose++;
            }
       }
     }

  if ( %howManyAreClose > 0 ) 
    {
     createShipKiller(22, "Shepard");
    }
   else
    {
      schedule ("onArriveNavBravoDropBrid();", 5 );
    }
}


//-----------------------------------------------------------------------------
function setNavMarkerON ( %navMarker )
{
   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      setNavMarker( %navMarker, true, %playerVeh  );
     }
}


//-----------------------------------------------------------------------------
function winCondition()
{
  flushConsoleScheduler();
  %howmany = 0;

  %text = "\nBrid Base Destroyed ";
  if ( $objective1 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  if ( %howmany == 1 ) %text = %text @ "\nExcellent work team.";

  messageBox(0, "Mission Completed, " @ %howmany @ " of 1 objectives completed. "@ %text );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function missionFailed()
{
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( $navAlpha, true, %this );
}

//-----------------------------------------------------------------------------
function vehicle::onAttacked ( %attacked, %attacker )
{
if ( $attackStarted == true ) return;

// count only attacks to AI

   %who = playerManager::vehicleIdToPlayerNum (%attacked);


// player attacked AI or AI attacked player

   %who1 = playerManager::vehicleIdToPlayerNum (%attacker);

   if (((%who == 0) && ( %who1 != 0 )) ||
       ((%who != 0) && ( %who1 == 0 )))
       {
         if ( $attackStarted == false )
           {
            %target = pickPlayer();
            order ( $bridPatrol1, attack, %target );

            %target = pickPlayer();
            order ( $bridPatrol3, attack, %target );

            %target = pickPlayer();
            order ( $bridPatrol2, attack, %target );


         $attackStarted = true;
         onArriveNavBravo();
         onArriveNavBravoDropBrid();
         schedule ("dropAnotherBrid();", 60 );
       }
    }
}


//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

   %target = pickPlayer ();

   order (%this, attack, %target);
}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}




//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function createDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 130); // terran drop ship

  addToSet( "MissionGroup/dropShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,28);

  %x = getPosition ( $navBravo, x );
  %y = getPosition ( $navBravo, y );
  %z = getPosition ( $navBravo, z );

  setPosition (%herc, %x, %y, %z );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function createBridDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 92); // * Cybrid Dropship

  addToSet( "MissionGroup/dropBridShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  %x = getPosition ( $navCharlie, x );
  %y = getPosition ( $navCharlie, y );
  %z = getPosition ( $navCharlie, z );

  setPosition (%herc, %x, %y, %z );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function createBridPatrol ( %whichPatrol, %ratio )
{

  if ( %ratio == "" ) %ratio = 1;

  %howMany1 = countLivePlayers ();
  %howMany = %howMany1 * %ratio;

  if ( %howmany > 3 ) %howmany = 3;

//say (0,0,"<F5>DEBUG::create brids count= " @ %howmany @ " ratio"@ %ratio);

  for ( %i = 0; %i < %howMany ; %i++ )
    {
     %name = "brid"@ %i;
     %r = randomInt (1, 14);
     %which = $Veh[%r];

//say (0,0,"<F5>DEBUG::creating brids for patrol#" @ %whichPatrol);

   if ((%which == 25) || (%which == 26))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }
     setTeam(%herc, *IDSTR_TEAM_RED);
     setPilotId (%herc,28);

     schedule ( "addToSet( $bridPatrol" @ %whichPatrol @ ", "@ %herc @ " );", 1);

     redrop ( %herc );

     order (%herc, speed, medium );

     schedule ( " order (" @ %herc @ " , guard, $bridPath" @ %whichPatrol @" );", 1);

  if ( %whichPatrol == 1 )
      schedule ("placeObject (" @ %herc @ ",-516, -77 );", %i * 10 );
//path1 marker at -516.217 -77.1318 79.2878

  if ( %whichPatrol == 2 )
      schedule ("placeObject (" @ %herc @ ",-1175, 723 );", %i * 10 );
//path2 marker at  -1175.2 723.747 62.0171



  if ( %whichPatrol == 3 )
      schedule ("placeObject (" @ %herc @ ",-964, -458 );", %i * 10 );
//path3 marker at -964.15 -458.988 32.8598

    } // end for loop
}

//-----------------------------------------------------------------------------
function createRandomBrid ( %x, %y )
{

     %name = "brid";
     %r = randomInt (1, 14);
     %which = $Veh[%r];

   if ((%which == 25) || (%which == 26))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }
     setTeam(%herc, *IDSTR_TEAM_RED);
     setPilotId (%herc,28);

     addToSet( $bridPatrol3, %herc );

     if ( %x == "" )
      {
       redrop ( %herc );
      }
    else
      {
       PlaceObject ( %herc, %x, %y );
      }

   order (%herc, speed, high );

   %target = PickPlayer();
   order (%herc, attack, %target );
}

//-----------------------------------------------------------------------------
function createSeeker ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 35;
  if ( %name == "" ) %name = "Seeker";

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( "MissionGroup/bridKillShip", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  redrop (%herc);
}

//-----------------------------------------------------------------------------
function orderShipKiller()
{
  order ( "MissionGroup/bridKillShip", Attack, $dropShip );
}

//-----------------------------------------------------------------------------
function createShipKiller( %hercID, %name)
{

 %x = getPosition ( $cybridKillShipmarker, x );
 %y = getPosition ( $cybridKillShipmarker, y );


  if ( %hercID == "" ) %hercID = 35;
  if ( %name == "" ) %name = "Seeker";

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( $dropBridShipGroup, %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId ( %herc, 29 );

  placeObject (%herc, %x, %y );

  order ( %herc, attack, getObjectID ( $dropShip ) );

  %x = %x + 30;
  %y = %y + 30;

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( $dropBridShipGroup, %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId ( %herc, 29 );

 placeObject (%herc, %x, %y );

  order ( %herc, attack, getObjectID ( $dropShip ) );

}

//-----------------------------------------------------------------------------
function setNavCharlieON()
{
  EnableNavMarker ( $navCharlie );
  createBridDropShip();
  say (0,0, "\n<f5>TACOM:: Radar reports a grounded Brid drop ship at Nav Charlie.");
  setNavMarkerON ( $navCharlie );
  onArriveNavCharlie();
}



//-----------------------------------------------------------------------------
function structure::onDestroyed(%this, %who)
{

 if ( isGroupDestroyed ( $bridBase ) )
   {
     say (0,0,"<f5>Brid Base destroyed.");
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
     $objective1 = true;
     setNavMarkerON ( $navBravo );
     $maxAIRatio = 3;
   }
}

//-----------------------------------------------------------------------------
function dropAnotherBrid()
{

   %playerCount = countLivePlayers ();

  %numAI = 0;
  %herc = 0;

  while ( %herc != 0 ) 
    {
      %numAI++;
      %herc = getNextObject ($bridPatrol3, %herc);
    }
  %maxAI = $maxAIRatio * %playerCount;
  if ( %numAI > $maxAI ) return;

 for ( %i=0; %i <= %playerCount; %i++ )
  {
//say(0,0,"<F5>DEBUG:: Createing random Brid");
   createRandomBrid();
  }
  schedule ("dropAnotherBrid();", $dropextratime );

 $dropextratime = $dropextratime - 4 ;

  if ( $dropextratime < 5 ) $dropextratime = 5;

}


