// FILENAME:	Assasination.cs
//
// AUTHORS:  	Dolf Kooz
//------------------------------------------------------------------------------

$missionName = "Assasination";

$Version = "Version 1.0\nmaps available from www.shadowdragons.org";

$server::TeamDamage = true;

//exec("human.cs");

Pilot PatrolPilot
{
   id = 28;
   
   skill = 0.3;
   accuracy = 0.3;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot reservePilot
{
   id = 29;
   
   skill = 0.1;
   accuracy = 0.1;
   aggressiveness = 0.9;
   activateDist = 1000.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 2.3;
   fireFreq = 2.0;
   LOSFreq = 0.1;
   orderFreq = 8.0;
};

Pilot GeneralRaeddeg
{
   id = 30;
   name = "General Raeddeg";
   skill = 0.5;
   accuracy = 0.4;
   aggressiveness = 0.9;
   activateDist = 1.0;
   deactivateBuff = 1.0;
   targetFreq = 0.1;
   trackFreq = 0.1;
   fireFreq = 0.6;
   LOSFreq = 0.1;
   orderFreq = 0.9;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;

}

function onMissionLoad()
{
   cdAudioCycle("Yougot", "SS3", "SS1"); 

    $textMsg = 
      "Objectives:"@
      "\n1) Ambush and kill General Raeddeg"@
      "\n2) Avoid Patrols.   "@
      "\n3) Escape.   "@
      "\nReturn to Nav Bravo to win\n"@
   "Respawning is not allowed. Team Damage is on, watch your fire.";

   %history = 
"\n\nDate: 2830. Listen up scrub, Three days ago the Imps took a small " @
"city near Tarsus. All the citizens fled or were " @
"killed. General Raeddeg, led the troops that did this " @
"to our people, and we want him DEAD! " @
"\n " @
"Here's the plan, at 0430 hours we leave the base. At " @
"0545 we hit dirt outside of the city. At 0600 we hit " @
"em and hit em hard. Our worms inform us that about " @
"twenty or so hercs from the initial raid are holding " @
"the city, so we will want to destroy as many as of the " @
"enemy as we can. They 'should' all be asleep at this " @
"time of the morning, as they are confident there will " @
"not be any action agaisnt them We will need to avoid " @
"any patrols they have. " @
"\n " @
" After we hit them, return to the drop ship for exit. " @
"\n " @
"Don't be a hero. We want everyone to get out alive. " @
 " This " @
"is part of our campaign to harass and impede Imperial forces on Mars.\n\n";

   setGameInfo (  %history @ $textMsg);


}

function onMissionStart()
{
   marsSounds();
   init();
}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{


say ( %this, 0, $Version @"\n"@ $textMsg );
say ( %this, 0,  "\nCheck the game info tab for more details");
}

//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

   %target = pickPlayer ();

   order (%this, attack, %target);
}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}


//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         return %playerVeh;
       }
     }
  return 0;
}

//-----------------------------------------------------------------------------
function init()
{

   $objective1 = false;
   $objective2 = false;

   $actionStarted = false;
   $attackStarted = false;

  $genGroup = "MissionGroup/guard1";
   newFormation( Delta, 0,0,0, 0,-30,0, 20,-40,0, -20,-40,0 ); 
   newFormation( Line,  0,0,0, 0,-40,0, 0,-75,0, 0,-100,0 );

  newObject( "dropShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropShipGroup" );

  newObject( "guard1", SimGroup );
  addToSet( "MissionGroup", "guard1" );

  newObject( "reserve", SimGroup );
  addToSet( "MissionGroup", "reserve" );

  $reserve = "MissionGroup/reserve";

  $hanger = getObjectID("MissionGroup/City/tank1");
  $tank1 = getObjectID("MissionGroup/City/tank1");
  $tank2 = getObjectID("MissionGroup/City/tank2");

  $navAlpha = "MissionGroup/navPoints/NavAlpha";
  $navBravo = "MissionGroup/navPoints/NavBravo";

  $genPath = "MissionGroup/genPath";
  $patrolPath1 = "MissionGroup/patrolPath1";
  $patrolPath2 = "MissionGroup/patrolPath2";

// pick an escape route
  %which = randomInt ( 1,3 );

  $retreatPath = "MissionGroup/retreatPath" @ %which;
  $retreatPathMarker = "MissionGroup/retreatPath" @ %which@ "/marker1";


  newObject( "impPatrol1", SimGroup );
  addToSet( "MissionGroup", "impPatrol1" );

  newObject( "impPatrol2", SimGroup );
  addToSet( "MissionGroup", "impPatrol2" );

  newObject( "impPatrol3", SimGroup );
  addToSet( "MissionGroup", "impPatrol3" );

   $impPatrol1 = "MissionGroup/impPatrol1";
   $impPatrol2 = "MissionGroup/impPatrol2";
   $impPatrol3 = "MissionGroup/impPatrol3";


  startGeneral();

  createDropShip();

  createImpPatrol1();

  createImpPatrol2();

  createReserve ();

  %time = Randomint (5, 30);
  schedule ("doFormation();", %time );// start the general moving

  %time = Randomint (5, 30);
  schedule ("order ($impPatrol1Lead, Guard, $patrolPath1);", %time );

  %time = Randomint (5, 30);
  schedule ("order ($impPatrol2Lead, Guard, $patrolPath2);", %time );

   MPcheckBoundary( leave, getObjectID ($navBravo) , 300, onLeaveNavBravoWarning, 1 );
   MPcheckBoundary( leave, getObjectID ($navBravo) , 500, onLeaveNavBravo, 1 );

//  generalArrivedRock ();

}

//-----------------------------------------------------------------------------
function onLeaveNavBravo ()
{

  showPlayer();

   $actionStarted = true;
}

//-----------------------------------------------------------------------------
function showPlayer()
{

 setFlybyCamera($genLeader);
say (0,0,"Assasinate General Raeddeg");

 %time = 5;
  schedule ("setFlybyCamera($reserveLead);", %time + 5 );
schedule ("say (0,0,\"Destroy the Apocs\");", %time + 5 );



schedule ("say (0,0,\"Avoid the patrols\");", %time + 10  );
  schedule ("setFlybyCamera($impPatrol1Lead);", %time + 10  );
  schedule ("setFlybyCamera($impPatrol2Lead);", %time  + 15 );


schedule("setPlayerCamera();", %time + 20 );
}

//-----------------------------------------------------------------------------
function onLeaveNavBravoWarning ()
{
   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function onArriveNavBravo()
{

 %obj1 = getObjectID ( $navBravo );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 300 ) %howManyAreClose++;
       }
     }

  if ( %howManyAreClose == %howMany ) 
    {
     winCondition();
    }
   else
    {
      schedule ("onArriveNavBravo();", 10 );
    }
}

//-----------------------------------------------------------------------------
function createDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 130); // terran drop ship

  addToSet( "MissionGroup/dropShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,28);

  %x = getPosition ( $navBravo, x );
  %y = getPosition ( $navBravo, y );
  %z = getPosition ( $navBravo, z );

  setPosition (%herc, %x, %y, %z );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function StartGeneral()
{
   createGeneral();

   createDisrupter();
   createGorgon();
   createGorgon();
}

//-----------------------------------------------------------------------------
function doFormation()
{
  order ( $genLeader, makeleader, true );

  order ( $genGroup, formation, Delta );

  order ( $genLeader, Guard, $genPath );

}

//-----------------------------------------------------------------------------
function createGeneral()
{

  %herc = NewObject ( "General Raeddeg", Herc, 14 ); //Knight'sBasilisk

  addToSet( "MissionGroup/guard1", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc, 30);

  $genLeader = %herc;

  redrop (%herc);

}

//-----------------------------------------------------------------------------
function createGorgon ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 3;
  if ( %name == "" ) %name = "Gorgon";

  %herc = NewObject ( %name, Herc, %hercID ); //TerranGorgon, 12 //Knight'sGorgon

  addToSet( "MissionGroup/guard1", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  redrop (%herc);
}


//-----------------------------------------------------------------------------
function createDisrupter ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 17;
  if ( %name == "" ) %name = "Knights Disruptor";

  %herc = NewObject ( %name, Tank, %hercID ); //KnightDisrupter 17

  addToSet( "MissionGroup/guard1", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  redrop (%herc);
}



//-----------------------------------------------------------------------------
function createImpPatrol1()
{

  if ( isGroupDestroyed ($impPatrol1) == False ) return;

  %herc = NewObject( "imp1", Herc, 11);// 11 mino

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol1, %herc );

  redrop ( %herc );

  $lastHerc = %herc;

  $impPatrol1Lead = %herc;

//  order (%herc, makeleader, True);

  %herc = NewObject( "imp2", Herc, 1);// 10  Knight'sApocalypse

  setTeam(%herc, *IDSTR_TEAM_RED);

  setPilotId (%herc,28);

  addToSet( $impPatrol1, %herc );

   redrop ( %herc );

  order ( %herc, guard, $lastHerc );
  $lastHerc = %herc;

  %herc = NewObject( "imp3", Herc, 1);// 10  Knight'sApocalypse

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol1, %herc );

   redrop ( %herc );

//   order ( $impPatrol1, Formation, Line );
  order ( %herc, guard, $lastHerc );

}

//-----------------------------------------------------------------------------
function createImpPatrol2()
{

  if ( isGroupDestroyed ($impPatrol2) == False ) return;


  %herc = NewObject( "imp1", Herc, 1);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol2, %herc );

  redrop ( %herc );

//  order (%herc, makeleader, True);

  $lastHerc = %herc;

  $impPatrol2Lead = %herc;

  %herc = NewObject( "imp2", Herc, 1);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol2, %herc );

  redrop ( %herc );

  order ( %herc, guard, $lastHerc );
  $lastHerc = %herc;

  %herc = NewObject( "imp3", Herc, 1);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol2, %herc );

  redrop ( %herc );

  order ( %herc, guard, $lastHerc );


//   order ( $impPatrol2, Formation, Line );

}



//-----------------------------------------------------------------------------
function createImpPatrol3()
{

  %x = getPosition ($genLeader, x);
  %y = getPosition ($genLeader, y);

     %x = %x + 130;
     %y = %y + 130;


%Veh[1] = 10;   //,TRUE);//Knight'sApocalypse
%Veh[2] = 11;   //,TRUE);//Knight'sMinotaur
%Veh[3] = 12;   //,TRUE);//Knight'sGorgon
%Veh[4] = 13;   //,TRUE);//Knight'sTalon
%Veh[5] = 14;   //,TRUE);//Knight'sBasilisk
%Veh[6] = 15;   //,TRUE);//KnightPaladin
%Veh[7] = 16;   //,TRUE);//KnightMyrmidon

  %lastHerc = $genLeader;

  %howMany = countLivePlayers ();
  %howMany = %howMany * 2.5;

  for ( %i = 0; %i <= %howMany ; %i++ )
    {
     %name = "imp"@ %i;
     %r = randomInt (1, 7);
     %which = %veh[%r];

   if ((%r == 6) || (%r == 7))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }
     setTeam(%herc, *IDSTR_TEAM_RED);
     setPilotId (%herc,28);

     addToSet( $impPatrol3, %herc );

     placeObject ( %herc, %x, %y );

     %x = %x + 40;
     %y = %y + 40;

     order (%herc, Guard, %lastHerc );
     order (%herc, speed, high );

     %lastHerc = %herc;
    }
}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}

//-----------------------------------------------------------------------------
function createReserve ()
{

  $numReserve = 12;
  %xStart = 525;
  %yStart = 390;

  %x = %xStart;
  %y = %yStart;

  for (%i=1 ; %i <= $numReserve; %i++ )
   {
     %name = "Herc" @ %i ;

     %herc = NewObject ( %name, Herc, 10); //Knight'sapoc

     addToSet( $reserve, %herc );

     setTeam(%herc, *IDSTR_TEAM_RED);
     setPilotId (%herc,29);

     placeObject (%herc, %x, %y, 180 );

     order (%herc, Shutdown, True);

     %x = %x + 30;

     if ( %i == 6 )
       {
         %y = %y - 40;
         %x = %xStart;
       }
   }
  $reserveLead = %herc;
}

//-----------------------------------------------------------------------------
function structure::onDestroyed(%this, %who)
{

  if (( %this == $tank1 ) ||
      ( %this == $tank2 ))
   {

    %range    = 500;
    %damage   = 9000;

// exploder does some damage
// find all hercs within %range and do linear-dropoff %damage
   
    %thisHerc = getNextObject ($reserve, 0);

    for (%i = 0; %i < $numReserve; %i++)
      {

       if (%thisHerc == 0) return;

       %curDist = getDistance(%this, %thisHerc);

// see if it is close enough
       if(%curDist < %range)
         {
           %curDamage = -(%damage * ((%range - %curDist) / %range));

           resetLastHitBy (%thisherc);
           healObject (%thisherc, %curDamage); 
         }
           %thisHerc = getNextObject ($reserve, %thisHerc );
       }
  }
}

//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{


// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) 
      return;

//  messagebox (%player, "Check the game info tab for game details and objectives");


   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);


    }

 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( $navAlpha, true, %this );
}

//-----------------------------------------------------------------------------
function vehicle::onAttacked ( %attacked, %attacker )
{

if ( $attackStarted == true ) return;
if ( $actionStarted == false ) return;

// count only attacks to AI

   %who = playerManager::vehicleIdToPlayerNum (%attacked);

  if (( isMember( $reserve, %attacked ) == true ) &&
      ( $attackStarted == false ))
     {
       return;
     }

// player attacked AI or AI attacked player

   %who1 = playerManager::vehicleIdToPlayerNum (%attacker);

   if (((%who == 0) && ( %who1 != 0 )) ||
       ((%who != 0) && ( %who1 == 0 )))
       {
         if ( $attackStarted == false )
           {
            %target = pickPlayer();
            order ( "MissionGroup/guard1", attack, %target );

            generalArrivedRock();

            %target = pickPlayer();
            order ( $impPatrol1, attack, %target );

            %target = pickPlayer();
            order ( $impPatrol2, attack, %target );

            schedule ("wakeReserve();", 4 );

         $attackStarted = true;
         onArriveNavBravo();
       }
    }
}

//-----------------------------------------------------------------------------
function wakeReserve()
{
  
    %thisHerc = getNextObject ($reserve, 0);
    %time =  8;

    for (%i = 0; %i < $numReserve; %i++)
      {

       if (%thisHerc == 0) return;

       schedule ("order ("@ %thisHerc @", shutdown, false );", %time );

       %target = pickPlayer();

       order ( %thisHerc, attack, %target );
       %time = %time + 5;

           %thisHerc = getNextObject ($reserve, %thisHerc );
       }
}
//-----------------------------------------------------------------------------
function setNavBravoON()
{
   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      setNavMarker( $navbravo, true, %playerVeh  );
     }
}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{

// player dESTROYED 
   if( %this == $genLeader )
   {
     say (0,0,"<f5>General Raeddeg has died");
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
     $objective1 = true;
     setNavBravoON();
   }


   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

  if (( isGroupDestroyed ($reserve) == true ) &&
      ( isMember( $reserve, %this ) == true ))
   {
     $objective2 = true;
     say (0,0,"<f5>Apocs Destroyed.");
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );

   }


  if (( isGroupDestroyed ($impPatrol1) == true ) &&
      ( isMember( $impPatrol1, %this ) == true ))
   {
//     schedule ("createImpPatrol1();", 45);
   }

  if (( isGroupDestroyed ($impPatrol2) == true ) &&
      ( isMember( $impPatrol2, %this ) == true ))
   {
//     schedule ("createImpPatrol2();", 45);
   }


  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 5 );

// heal and reload the player
   healobject ( %who, 5000 );
//   healobject ( %who, 5000 );
//   healobject ( %who, 5000 );

//  reloadObject(%who, 5000 );
  reloadObject(%who, 5000 );

//  checkRedropSquad();


   }


   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// if someone kills a friendly AI we can't treat the AI like a human and let em back in
     %player = playerManager::vehicleIdToPlayerNum ( %this );
     if(%player == 0) return;

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }
}

//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

         %allDead = false;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}

//-----------------------------------------------------------------------------
function winCondition()
{
  flushConsoleScheduler();
  %howmany = 0;

  %text = "\nGeneral Raeddeg Assasinated ";
  if ( $objective1 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  %text = %text @ %text = "\nApocs Destroyed ";
  if ( $objective2 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  if ( %howmany == 2 ) %text = %text @ "\nExcellent work team.";

  messageBox(0, "Mission Completed, " @ %howmany @ " of 2 objectives completed. "@ %text );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function missionFailed()
{
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function generalArrivedRock ()
{

  if ( isGroupDestroyed ($genLeader) == true ) return;

   %var = getDistance( $genLeader, getObjectID ( $retreatPathMarker ) );

   if( %var <= 100 )
     {
       createImpPatrol3();

       order ( $genLeader, Guard, $genPath );
       order ( $genLeader, Speed, Medium );

     }
    else
     {
       schedule ("generalArrivedRock ();", 15 );
       order ( $genLeader, guard,  $retreatPath );
       schedule ("order ( $genLeader, guard,  $retreatPath );", 3 );
       schedule ("order ( $genLeader, guard,  $retreatPath );", 6 );
       schedule ("order ( $genLeader, guard,  $retreatPath );", 9 );
       schedule ("order ( $genLeader, guard,  $retreatPath );", 12 );
     }

}


