// title "Fear no Evil"
// final human mission

$Version = "Version 1.0\nmaps available from www.shadowdragons.org";

//$pref::requestTimeoutTime = "9000";
$missionName = "Fear No Evil";

$server::TeamDamage = true;

$actionStarted = False;

// so we know when to create promie guards
 $cybrid15Destroyed = false;
 $cybrid16Destroyed = false; 


$xCybrid = 4485;
%yCybrid = 6005;

Pilot Prometheus
{
   id = 50;
   
   name = "Prometheus";
   skill = 1.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 2000.0;
   deactivateBuff = 300.0;
   targetFreq = 0.4;
   trackFreq = 0.4;
   fireFreq = 0.4;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

Pilot Guard
{
   id = 52;
   
   name = "Guard";
   skill = 0.5;
   accuracy = 0.6;
   aggressiveness = 1.0;
   activateDist = 300.0;
   deactivateBuff = 20.0;
   targetFreq = 0.7;
   trackFreq = 0.4;
   fireFreq = 0.7;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

Pilot Cybrid
{
   id = 53;
   
   name = "Cybrid";
   skill = 0.3;
   accuracy = 0.3;
   aggressiveness = 0.9;
   activateDist = 1000.0;
   deactivateBuff = 200.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};


function setDefaultMissionOptions()
{

	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}

//-----------------------------------------------------------------------------
function onMissionLoad()
{

//   cdAudioCycle("Purge", "Terror", "Watching"); 

$gameType = "Multiplayer";

   %rules = 
      "Complete Objectives:"@
      "\n1) Destroy Prometheus" @
"\nProceed to Nav Omega, engage and kill Prometheus. He will undoubtly "@
"have plenty of support. This is our only chance to win the fight against "@
"the Brids. \n\nGood Luck";


   setGameInfo(%rules);

}

//-----------------------------------------------------------------------------
function setDefaultMissionItems()
{

allowWeapon(150,FALSE);//SMARTGun

}

//-----------------------------------------------------------------------------
function onMissionStart()
{

   cdAudioCycle( CloudBurst, Terror );
  init();
}

function init()
{

  $navAlpha = getObjectId ( "MissionGroup/NavPoints/NavAlpha" );
  $navOmega = getObjectId ( "MissionGroup/NavPoints/NavOmega" );



  createCybrids();
  createDropShip();
  createPromie();



  $markers = getObjectId ( "MissionGroup/bridPath" );

  $marker1 = getObjectId ( "MissionGroup/markers/marker1" );
  $marker2 = getObjectId ( "MissionGroup/markers/marker2" );
  $marker3 = getObjectId ( "MissionGroup/markers/marker3" );
  $marker4 = getObjectId ( "MissionGroup/markers/marker4" );
  $marker5 = getObjectId ( "MissionGroup/markers/marker5" );
  $marker6 = getObjectId ( "MissionGroup/markers/marker6" );
  $marker7 = getObjectId ( "MissionGroup/markers/marker7" );
  $marker8 = getObjectId ( "MissionGroup/markers/marker8" );
  $marker9 = getObjectId ( "MissionGroup/markers/marker9" );


//   $caanon = "MissionGroup/caanon";
//   $bigZedShape = "MissionGroup/cprombase1";
//   $cybrids = "MissionGroup/cybrids";


   $cybrid1 = getObjectId ("MissionGroup/cybrids/cybrid1") ;
   $cybrid2 = getObjectId ("MissionGroup/cybrids/cybrid2") ;
   $cybrid3 = getObjectId ("MissionGroup/cybrids/cybrid3") ;
   $cybrid4 = getObjectId ("MissionGroup/cybrids/cybrid4") ;
   $cybrid5 = getObjectId ("MissionGroup/cybrids/cybrid5") ;
   $cybrid6 = getObjectId ("MissionGroup/cybrids/cybrid6") ;
   $cybrid7 = getObjectId ("MissionGroup/cybrids/cybrid7") ;
   $cybrid8 = getObjectId ("MissionGroup/cybrids/cybrid8") ;
   $cybrid9 = getObjectId ("MissionGroup/cybrids/cybrid9") ;
   $cybrid10 = getObjectId ("MissionGroup/cybrids/cybrid10") ;
   $cybrid11 = getObjectId ("MissionGroup/cybrids/cybrid11") ;
   $cybrid12 = getObjectId ("MissionGroup/cybrids/cybrid12") ;
   $cybrid13 = getObjectId ("MissionGroup/cybrids/cybrid13") ;
   $cybrid14 = getObjectId ("MissionGroup/cybrids/cybrid14") ;
   $cybrid15 = getObjectId ("MissionGroup/cybrids/cybrid15") ;
   $cybrid16 =getObjectId ( "MissionGroup/cybrids/cybrid16") ;

   $hut     = getObjectId ("MissionGroup/hut") ;

   MPcheckBoundary( leave, $navAlpha , 250, onLeaveNavAlphaWarning, 1 );
   MPcheckBoundary( leave, $navAlpha , 400, onLeaveNavAlpha, 1 );

   MPcheckBoundary( enter, $hut, 1250, startPromie, 5);
   MPcheckBoundary( enter, $navOmega, 1600, startAction, 5);
}

//-----------------------------------------------------------------------------
function player::onAdd(%this)
{

say ( %this, 0, $Version @"\n"@ $textMsg );

  say(%this, 0, "Wellcome to campaign mission, Fear no Evil"@
       " Objectives : Destroy Promethesus. Proceed to Nav Omega");
}


//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)
{                                                                                                                                                     
                                                                                    
// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if(%player == 0) 
      return;

 messagebox (%player, "Proceed to Nav Omega, engage and kill Prometheus.");

//say(0,0,"DEBUG: in vehicle::onAdd(%this) "@ %this);

   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);
    }

  setNavMarker( "MissionGroup/NavPoints/NavOmega", true, %this );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}                                                                                                                                                     

//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

   %target = pickPlayer ();

   order (%this, attack, %target);
}

//-----------------------------------------------------------------------------
function startAction()
{

  %where = pickBridDrop();
   schedule( "mDropPod(" @ %where @ "," @ $cybrid1 @ " );", 1 );
  %where = pickBridDrop();
   schedule( "mDropPod( " @ %where @ ", " @ $cybrid2 @ ");", 3 );
  %where = pickBridDrop();
   schedule( "mDropPod( " @ %where @ ", " @ $cybrid3 @ ");", 6 );

}

//-----------------------------------------------------------------------------
function mDropPod (%pos, %whoID)
{

  %x = getPosition (%pos, x);
  %y = getPosition (%pos, y);
  %z = getPosition (%pos, z);

   DropPod( %x, %y, %z);

   schedule ("setPosition ( " @ %whoID @ "," @ %x @ ", " @ %y @ ", " @ %z @ ");", 8);

   %playerVeh = pickPlayer();

   order( %whoID, shutdown, False );
   order( %whoID, Speed, High );
   order (%whoID, Attack, %playerVeh);

}

//-----------------------------------------------------------------------------
function dropMoreCybrid()
{
   $playerCount = playerManager::getPlayerCount();
  if ($playerCount > 2)
  {
     for(%i=0; %i < $playerCount - 2 ; %i++)
      {

        %where = pickBridDrop();

//        %herc = cloneVehicle( $promProtector);

        %randomNum = RandomInt (1, 10);
        %which = $ride[%randomNum];
        %name = "cybrid"@%i;

        %herc = NewObject( %name, Herc, %which);

        setPilotId (%herc, 53);

        addToSet( "MissionGroup", %herc );
        setTeam( %herc, *IDSTR_TEAM_RED );

        mDropPod (%where, %herc);

      }
  }

}

//-----------------------------------------------------------------------------                        
function vehicle::onDestroyed(%this, %who)                                                             
{

   if( %this == $prometheus  )                                                  
   {
                                                                                                
      schedule( "Say( 0, 0, *IDSTR_HE3_CAA12, \"HE3_CAA12.wav\" );", 2 );
      schedule( "Say( 0, 0, *IDSTR_HE3_CAA13, \"HE3_CAA13.wav\" );", 6 );
      schedule( "Say( 0, 0, *IDSTR_HE3_LON01, \"HE3_LON01.wav\" );", 8 );
      schedule( "Say( 0, 0, *IDSTR_HE3_CAA14, \"HE3_CAA14.wav\" );", 12 );

     schedule( "gameOver();", 16 );
   }                                             

    if( getTeam( %this ) == *IDSTR_TEAM_RED )                                                           
    {     

   %where = pickBridDrop();
    
       if( %this ==  $cybrid1  )                                                           
       {
          order ($cybrid1, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid3 );                                  
       }
       if( %this ==  $cybrid2  )                                                           
       {
          order ($cybrid2, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid4 );
       }                                                                                                
       if( %this ==  $cybrid3  )                                                           
       {
          order ($cybrid3, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid5 );
       }                                                                                                
       if( %this ==  $cybrid4  )                                                           
       {
          order ($cybrid4, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid6 );
       }                                                                                                
       if( %this == $cybrid5  )                                                           
       {
          order ($cybrid5, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid7 );
       }                                                                                                
       if( %this ==  $cybrid6  )                                                           
       {
          order ($cybrid6, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid8 );
       }                                                                                                
       if( %this == $cybrid7  )                                                           
       {
          order ($cybrid7, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid9 );
       }                                                                                                
       if( %this ==  $cybrid8  )                                                           
       {
          order ($cybrid8, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid10 );
       }                                                                                                
       if( %this ==  $cybrid9  )                                                           
       {
          order ($cybrid9, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid11 );
       }                                                                                                
       if( %this ==  $cybrid10  )                                                           
       {
          order ($cybrid10, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid12 );
       }                                                                                                
       if( %this ==  $cybrid11  )                                                           
       {
          order ($cybrid11, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid13 );
       }                                                                                                
       if( %this ==  $cybrid12  )                                                           
       {
          order ($cybrid12, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid14 );
       }                                                                                                
       if( %this == $cybrid13  )                                                           
       {
          order ($cybrid13, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid15 );
       }
       if( %this ==  $cybrid14  )                                                           
       {
          order ($cybrid14, guard, $markers );
          dropMoreCybrid();
          mDropPod( %where, $cybrid16 );
       }                                                                                                

       if( %this == $cybrid15  )
       {
          dropMoreCybrid();
          $cybrid15Destroyed = true;
       }
       if( %this == $cybrid16  )
       {

          setNavOmega();

          $cybrid16Destroyed = true;
          say(0,0, " ");
          say(0,0, "TACOM: Go get Prometheus, He's by Nav Omega");
          say(0,0, " ");
       }
// done further down...     schedule ("deleteObject( " @ %this @ " ); ", 5);
    }                                                                                                   



   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 5 );

// heal and reload the player
   healobject ( %who, 5000 );
   healobject ( %who, 5000 );
//   healobject ( %who, 5000 );

  reloadObject(%who, 5000 );
  reloadObject(%who, 5000 );

   }

   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }

}

//-----------------------------------------------------------------------------
function pickBridDrop()
{
 %num = randomInt( 1, 9 );

if (%num == 1)
 {
   return $marker1;
 }

if (%num == 2)
 {
   return $marker2;
 }

if (%num == 3)
 {
   return $marker3;
 }

if (%num == 4)
 {
   return $marker4;
 }

if (%num == 5)
 {
   return $marker5;
 }

if (%num == 6)
 {
   return $marker6;
 }

if (%num == 7)
 {
   return $marker7;
 }

if (%num == 8)
 {
   return $marker8;
 }

if (%num == 9)
 {
   return $marker9;
 }


}

//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         return %playerVeh;
       }
     }
  return 0;

}


//-----------------------------------------------------------------------------
function dropPromGuards()
{
   $playerCount = playerManager::getPlayerCount();

  %cloneNum = 1;

  cloneGuard ();

  if ($playerCount > 2)
  {
     for(%i=0; %i < $playerCount - 2 ; %i++)
      {
       %cloneNum++;
       cloneGuard ();
      }
  }


}

// ------------------------------------------------------------------------------
function cloneGuard ()
{

  %herc = NewObject( "Guard", Herc, 38);// * MetagenAdjucator

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc, 52);

  %x = getPosition($prometheus ,x)+RandomInt(-100, 100);
  %y = getPosition($prometheus ,y)+RandomInt(-100, 100);
  %z = getPosition($prometheus ,z)+50;

   DropPod( %x, %y, %z);

   schedule ("setPosition ( " @ %herc @ "," @ %x @ ", " @ %y @ ", " @ %z @ ");", 7);

   addToSet( "MissionGroup", %herc );

   %target = PickPlayer();

   order( %herc ,attack, %target );
}

// ------------------------------------------------------------------------------
function startPromie ()
{

  %this = PickPlayer();

  playAnimSequence( $hut, 0, 1.0 );

//  createPromie();

  order( $prometheus, shutdown, false );

   order ($prometheus, Guard, %this );

   schedule ("order( " @ $prometheus @ ", Attack,  " @ %this @ " );", 15);

  dropPromGuards();

}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}


//-----------------------------------------------------------------------------
function gameOver()
{
  flushConsoleScheduler();
  missionEndConditionMet();
}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}
//-----------------------------------------------------------------------------
function setNavOmega()
{

   $playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < $playerCount ; %i++)
    {

     %player = playerManager::getPlayerNum( %i );

     %playerVeh = playerManager::playerNumToVehicleId( %player);

     setNavMarker( $navOmega, true, %playerVeh);
    }

}


$ride[1] = 22;//Shepherd
$ride[2] = 23;//Adjudicator
$ride[3] = 24;//Executioner
$ride[4] = 27;// * PlatAdjucator
$ride[5] = 28;// * PlatExecutor
$ride[6] = 37;//MetagenShepherd
$ride[7] = 38;// * MetagenAdjucator
$ride[8] = 39;// * MetagenExecutor
$ride[9] = 55;//PlayerPlatAdjudicator
$ride[10] = 56;//PlayerPlatExecutioner

//-----------------------------------------------------------------------------
function createCybrids()
{

  for (%i = 1;  %i < 17; %i++ )
   {
     %randomNum = RandomInt (1, 10);
     %which = $ride[%randomNum];
     %name = "cybrid"@%i;
     createHerc ( %name, %which );
   }
}

//-----------------------------------------------------------------------------
function createHerc ( %name, %hercID )
{

  %herc = NewObject( %name, Herc, %hercID);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc, 53);

  addToSet ( "MissionGroup/cybrids", %herc );


   placeObject (%herc, $xCybrid, %yCybrid, %rot);

   $xCybrid = $xCybrid + 50;
   %yCybrid = %yCybrid + 50;

   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function createPromie()
{

  %herc = NewObject( "p1", Herc, 29);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc, 50);

   addToSet ( "MissionGroup/proms", %herc );

   $prometheus = %herc;
   order( $prometheus, Speed, High );

   setPosition( $prometheus, -136.82, -1748, 463 );

   order( $prometheus, shutdown, true );

}

//-----------------------------------------------------------------------------
function createDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 130); // terran drop ship

  newObject( "dropShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropShipGroup" );
  addToSet( "MissionGroup/dropShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,28);

//  $cargoShip = "MissionGroup/dropShipGroup/Drop Ship";

  %x = getPosition ($navAlpha, x);
  %y = getPosition ($navAlpha, y);
  %z = getPosition ($navAlpha, z);

  setPosition (%herc, %x, %y, %z );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function onLeaveNavAlphaWarning ()
{

   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function onLeaveNavAlpha ()
{
   $actionStarted = true;

}

//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

         %allDead = false;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}

//-----------------------------------------------------------------------------
function missionFailed()
{
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  missionendconditionmet();
}

