// Locate amd disable Imperial transport ship

//exec ("human.cs");

$Version = "Version 1.0\nmaps available from www.shadowdragons.org";

$OVconvoyTech = 2;

$server::TeamDamage = true;

$actionStarted = false;

$maxRange = 3200;
$minRange = 2800;

// how many player are alive at squad drop time
$numLivePlayers = 0;

// for our passing patrol
Pilot PatrolPilot
{
   id = 28;
   
   skill = 0.4;
   accuracy = 0.4;
   aggressiveness = 0.8;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.4;
   orderFreq = 4.0;
};
   
Pilot backupPilot
{
   id = 29;
   
   skill = 0.4;
   accuracy = 0.3;
   aggressiveness = 0.8;
   activateDist = 1000.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 2.0;
   LOSFreq = 0.1;
   orderFreq = 0.2;
};
   
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function onMissionLoad()
{


   cdAudioCycle("Purge", "Watching", "Mechsoul"); 


    $textMsg = "Avoid the patrols, Go to Nav Alpha, "@
      "Complete Objectives:"@
      "\n1) Destroy the cargo ship"@
      "\n2) Destroy the drones.   "@
      "\n3) Destroy the buildings."@
      "\nReturn here, to Nav Bravo to win\n"@
   "Respawning is not allowed. Destroying an enemy heals your vehicle and"@
   " reloads your weapons. Team Damage is on, watch your fire.";
   %history = 
"\n\nDate: 2829. Your squad has been assigned a standard hit and run strike mission. This " @
"is part of our campaign to harass and impede Imperial forces on Mars.";

   setGameInfo ($textMsg @ %history);
}


//-----------------------------------------------------------------------------
function onMissionStart()
{
   newFormation( Delta, 0,0,0, -60,-60,0, 60,-45,0, 0,-120,0 ); 
   newFormation( Line,  0,0,0, 0,-40,0, 0,-80,0, 0,-120,0 );

   cdAudioCycle( Purge, Terror, gnash);

   marsSounds();
   windSounds();
   init();

}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{
say ( %this, 0, $Version @"\n"@ $textMsg );
say ( %this, 0,  "\nCheck the game info tab for more details");
}

//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{


// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) 
      return;

 messagebox (%player, "Check the game info tab for game details");

                                                                                   
   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);


    }

 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }

}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( $navAlpha, true, %this );
}

//-----------------------------------------------------------------------------
function init()
{

$objective1 = false;
$objective2 = false;
$objective3 = false;

$attackStarted = false;
$buildingsDestroyed = 0;
$workersDestroyedMsg = false;

   $navAlpha = "MissionGroup/NavPoints/NavAlpha";
   $navBravo = "MissionGroup/NavPoints/NavBravo";

   $impPatrol1 = "MissionGroup/impPatrol1";
   $impPatrol2 = "MissionGroup/impPatrol2";
   $impPatrol3 = "MissionGroup/impPatrol3";
   $cargoShip  = "MissionGroup/impBase/Cargo Ship";
   $cargogroup = "MissionGroup/impBase";

   $workers    = "MissionGroup/workers";
   $truck1     = "MissionGroup/workers/truck1";
   $truck2     = "MissionGroup/workers/truck2";
   $truck3     = "MissionGroup/workers/truck3";
   $truck4     = "MissionGroup/workers/truck4";
   $truck5     = "MissionGroup/workers/truck5";
   $truck6     = "MissionGroup/workers/truck6";
   $truck7     = "MissionGroup/workers/truck7";
   $truckPath1 = "MissionGroup/truckPath1";
   $truckPath2 = "MissionGroup/truckPath2";
   $truckPath3 = "MissionGroup/truckPath3";

   $retreatPath = "MissionGroup/retreatPath";


// create the hercs here
   createImpPatrol1();
   createImpPatrol2();
   createImpPatrol3();
   createWorkers();

   createFlyer();

   order( "MissionGroup/impPatrol1/imp1", MakeLeader, True );
   order( $impPatrol1, Speed, High );
   order( $impPatrol1, Formation, Line );

   // sometimes the Basilisk patrol comes from the west, sometimes from the east
   if( randomInt( 1, 2 ) == 1 )
   {
      setPosition( "MissionGroup/impPatrol1/imp1", -412.0, 300.0, 469.0 );
      setPosition( "MissionGroup/impPatrol1/imp2", -412.0, 290.0, 469.0 );

      setPosition( "MissionGroup/impPatrol3/imp1", 2544.0, 3641.0, 605.0 );
      setPosition( "MissionGroup/impPatrol3/imp2", 2534.0, 3641.0, 605.0 );

      $impPatrol1.useAlternateRoute = True;
   }
   
   order( $impPatrol2, Formation, Delta );
   order( $impPatrol2, Speed, Low );
   order( "MissionGroup/impPatrol2/imp1", MakeLeader, True );
   order( $impPatrol2, Guard, "MissionGroup/impPath2" );
   order( $impPatrol2, holdPosition, True );

   order( $impPatrol3, Formation, Delta );
   order( $impPatrol3, Speed, Medium );
   order( "MissionGroup/impPatrol3/imp1", MakeLeader, True );
   
   // randomize stuff
   if( $impPatrol1.useAlternateRoute != True )
   {
      order( $impPatrol3, Guard, "MissionGroup/impPath3" );
   }
   order( $impPatrol3, holdPosition, True );
   


   // when the player nears the action
   MPcheckBoundary( enter, getObjectID ($navAlpha) , 600, onArrivedNavAlpha, 20 );

   MPcheckBoundary( leave, getObjectID ($navBravo) , 400, onLeaveNavBravoWarning, 1 );
   MPcheckBoundary( enter, getObjectID ("MissionGroup/impPatrol1/imp1") , 1200, onLeaveNavBravo, 1 );
// moved to leave bravo   MPcheckBoundary( leave, getObjectID ($navBravo) , 1700, turnLooseImps, 1 );


      order( $truck1, guard, $truckPath1 );
     schedule ("order( $truck2, guard, $truckPath1 );", 5 );
      schedule ("order( $truck3, guard, $truckPath1 );", 10 );
      schedule ("order( $truck4, guard, $truckPath2 );", 15 );
      schedule ("order( $truck5, guard, $truckPath2 );", 20 );
      schedule ("order( $truck6, guard, $truckPath2 );", 25 );
      schedule ("order( $truck7, guard, $truckPath2 );", 30 );
}



//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function structure::onDestroyed(%this, %who)
{
   $buildingsDestroyed++;

   if( $buildingsDestroyed == 5 )
   {
      alarmSoundsOff( getObjectId( "MissionGroup/impBase/hq" ) );
   }

   if( $buildingsDestroyed == 8 )
   {
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
     say (0,0,"<f5>Buildings Destroyed");
     $objective1 = true;
   }
}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{

// player dESTROYED cargo ship
   if( %this == getObjectId( "MissionGroup/impBase/Cargo Ship" ) )
   {
     say (0,0,"<f5>Cargo Ship Destroyed");
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 2 );
     $objective2 = true;
   }


   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }


  if (( isGroupDestroyed ($workers) == true ) &&
      ( $workersDestroyedMsg == false ))
   {
     $workersDestroyedMsg = true;
     say(0,0,"<f5>Drones Destroyed.");
     schedule( "say( 0, 0, \"GEN_OC01.wav\" );", 1 );
     $objective3 = true;
   }

  if ( $actionStarted == true ) checkForPlayersDead();

// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 5 );

// heal and reload the player
   healobject ( %who, 5000 );
   healobject ( %who, 5000 );
   healobject ( %who, 5000 );

  reloadObject(%who, 5000 );
  reloadObject(%who, 5000 );

  checkRedropSquad();

   }

   if ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {
     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }
}


//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {

         %allDead = false;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}

//-----------------------------------------------------------------------------
function winCondition()
{
  flushConsoleScheduler();
  %howmany = 0;

alarmSoundsOff( getObjectId( "MissionGroup/impBase/hq" ) );

  %text = "\nBuildings Destroyed ";
  if ( $objective1 == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  %text = %text @ "\nCargo Ship Destroyed ";
  if ( $objective2 == true )
    {
      %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  %text = %text @ "\nDrones Destroyed ";
  if ( $objective3 == true )
    {
      %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }


  if ( %howmany == 3  ) %text = %text @ " Excellent work team.";

      alarmSoundsOff( getObjectId( "MissionGroup/impBase/hq" ) );

  messageBox(0, "Mission Completed, " @ %howmany @ " of 3 objectives completed. "@ %text );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function missionFailed()
{
  alarmSoundsOff( getObjectId( "MissionGroup/impBase/hq" ) );

  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}


//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         return %playerVeh;
       }
     }
  return 0;

}

//-----------------------------------------------------------------------------
function createImpPatrol1()
{
  %herc = NewObject( "imp1", Herc, 11);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol1, %herc );

  setPosition (%herc, 735, 320, 583);


     %herc = NewObject( "imp2", Herc, 11);


  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol1, %herc );

  setPosition (%herc, 740, 325, 588);


}

//-----------------------------------------------------------------------------
function createImpPatrol2()
{
  %herc = NewObject( "imp1", Herc, 4);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol2, %herc );

  setPosition (%herc, 179, 2086, 565);

  %herc = NewObject( "imp2", Herc, 4);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol2, %herc );

  setPosition (%herc, 170, 2090, 565);

}



//-----------------------------------------------------------------------------
function createImpPatrol3()
{
  %herc = NewObject( "imp1", Herc, 4);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol3, %herc );

  setPosition (%herc, 2544, 3641, 600);

  %herc = NewObject( "imp2", Herc, 4);

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $impPatrol3, %herc );

  setPosition (%herc, 2530, 3649, 600);

}


//-----------------------------------------------------------------------------
function createWorkers()
{

  %herc = NewObject( "truck1", Tank, 71); // ice cream truck

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1434, 1250, 504 );

  %herc = NewObject( "truck2", Tank, 135); // terrran soverian 

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1434, 1350, 504 );

  %herc = NewObject( "truck3", Tank, 73); // terran starfield

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1400, 1400, 504 );

  %herc = NewObject( "truck4", Tank, 63); // big personall carrier

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1450, 1400, 504);

  %herc = NewObject( "truck5", Tank, 61); // Terran Ammo


  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc,  1550, 1350, 504 );

  %herc = NewObject( "truck6", Tank, 73); //terran starfield

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1550, 1450, 504 );

  %herc = NewObject( "truck7", Tank, 71); // ice cream truck

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $workers, %herc );

  setPosition (%herc, 1600, 1450, 504 );


}

function createFlyer()
{
  %herc = NewObject( "Cargo Ship", Flyer, 18); // terran cargo ship

  setTeam(%herc, *IDSTR_TEAM_RED);
  setPilotId (%herc,28);

  addToSet( $cargogroup, %herc );

  setPosition (%herc, 1331.34, 1490.01, 516.88 );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function createDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 130); // terran drop ship

  newObject( "dropShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropShipGroup" );
  addToSet( "MissionGroup/dropShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,28);

  addToSet( $cargogroup, %herc );

  setPosition (%herc, -53.0876, -1895.72, 527 );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function onArrivedNavAlpha()
{

 if ( $attackStarted == true ) return;


   $attackStarted = true;

   setNavBravoON();

      playSound( 0, "alarm2.wav", IDPRF_FIRE, 1191, 2429, 500 );
      alarmSoundsOn( getObjectId( "MissionGroup/impBase/hq" ), "alarm2.wav" );

     %target = pickPlayer ();
      schedule( "order( $impPatrol1, Attack, " @  %target @ ");", 90 );
     %target = pickPlayer ();
      schedule( "order( $impPatrol2, Attack, " @  %target @ " );", 15 );
     %target = pickPlayer ();
      schedule( "order( $impPatrol3, Attack, " @  %target @ " );", 60 );


  say (0,0, "gen_icca03.wav" );
  say (0,0, "cyb_me10.wav" );


   schedule ("say (0,0, \"cyb_ea07.wav\" );", 5);
   schedule ("say (0,0, \"cyb_gn01.wav\" );", 7);

   schedule ("say (0,0, \"cyb_ea02.wav\" );", 20);

  createbackup();

  schedule ("DroneScatter();", 5 );

   order( $impPatrol1, Speed, high );
   order( $impPatrol2, Speed, high );
   order( $impPatrol3, Speed, high );

   createDropShip();
 
   MPcheckBoundary( enter, getObjectID ($navBravo) , 300, onArriveNavBravo, 20 );

// now set the range in to keep the players moving
$maxRange = 1800;
$minRange = 1400;

}

function setNavBravoON()
{
   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      setNavMarker( $navbravo, true, %playerVeh  );
     }
}


//-----------------------------------------------------------------------------
function droneScatter()
{
  order ( $workers, guard, $truckPath3 );
}

//-----------------------------------------------------------------------------
function onLeaveNavBravoWarning ()
{
   $actionStarted = true;
   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function onLeaveNavBravo()
{

  if( $impPatrol1.useAlternateRoute != True )
   {
      order( $impPatrol1 @ "/imp1", Guard, "MissionGroup/impPath1" );
   }
  else
   {
      order( $impPatrol1 @ "/imp1", Guard, "MissionGroup/impPath1_alt" );
   }

  turnLooseImps();

}

//-----------------------------------------------------------------------------
function onArriveNavBravo()
{

 %obj1 = getObjectID ( $navBravo );
 %howMany = countLivePlayers ();

 %howManyAreClose = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
          %var = getDistance( %obj1, %playerVeh );
          if ( %var < 300 ) %howManyAreClose++;
       }
     }

  if ( %howManyAreClose == %howMany ) 
    {
     winCondition();
    }
   else
    {
      schedule ("onArriveNavBravo();", 10 );
    }

}

//-----------------------------------------------------------------------------
function turnLooseImps()
{
  order( $impPatrol3, holdPosition, false );
  order( $impPatrol2, holdPosition, false );

}

//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

   %target = pickPlayer ();

   order (%this, attack, %target);
}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}

//-----------------------------------------------------------------------------
// Immutable vehicle attributes
//   tec: 0 = not applicable, 1 = Cybrid, 2 = Human
//   typ: 0 = not applicable, 1 = Herc, 2 = Tank, 3 = Drone, 4 = Flyer
// * denotes non-standard vehicles ordinarily prohibited to human players
// NA denotes ids for which no vehicle exists
$Vtec[1]=2;$Vtyp[1]=1;//TerranApocalypse
$Vtec[2]=2;$Vtyp[2]=1;//TerranMinotaur
$Vtec[3]=2;$Vtyp[3]=1;//TerranGorgon
$Vtec[4]=2;$Vtyp[4]=1;//TerranTalon
$Vtec[5]=2;$Vtyp[5]=1;//TerranBasilisk
$Vtec[6]=2;$Vtyp[6]=2;//Paladin
$Vtec[7]=2;$Vtyp[7]=2;//Myrmidon
$Vtec[8]=2;$Vtyp[8]=2;//Disrupter
$Vtec[9]=0;$Vtyp[9]=4;// * Banshee
$Vtec[10]=2;$Vtyp[10]=1;//Knight'sApocalypse
$Vtec[11]=2;$Vtyp[11]=1;//Knight'sMinotaur
$Vtec[12]=2;$Vtyp[12]=1;//Knight'sGorgon
$Vtec[13]=2;$Vtyp[13]=1;//Knight'sTalon
$Vtec[14]=2;$Vtyp[14]=1;//Knight'sBasilisk
$Vtec[15]=2;$Vtyp[15]=2;//KnightPaladin
$Vtec[16]=2;$Vtyp[16]=2;//KnightMyrmidon
$Vtec[17]=2;$Vtyp[17]=2;//KnightDisrupter
$Vtec[18]=0;$Vtyp[18]=4;// * TerranCargo
$Vtec[19]=0;$Vtyp[19]=4;// * TerranEscape
$Vtec[20]=1;$Vtyp[20]=1;//Seeker
$Vtec[21]=1;$Vtyp[21]=1;//Goad
$Vtec[22]=1;$Vtyp[22]=1;//Shepherd
$Vtec[23]=1;$Vtyp[23]=1;//Adjudicator
$Vtec[24]=1;$Vtyp[24]=1;//Executioner
$Vtec[25]=1;$Vtyp[25]=2;//Bolo
$Vtec[26]=1;$Vtyp[26]=2;//Recluse
$Vtec[27]=1;$Vtyp[27]=1;// * PlatAdjucator
$Vtec[28]=1;$Vtyp[28]=1;// * PlatExecutor
$Vtec[29]=1;$Vtyp[29]=1;// * Prometheus
$Vtec[30]=2;$Vtyp[30]=1;//Emancipator
$Vtec[31]=2;$Vtyp[31]=2;//Avenger
$Vtec[32]=2;$Vtyp[32]=2;//Dreadlock
$Vtec[33]=2;$Vtyp[33]=1;//Olympian
$Vtec[34]=0;$Vtyp[34]=0;// NA
$Vtec[35]=1;$Vtyp[35]=1;//MetagenSeeker
$Vtec[36]=1;$Vtyp[36]=1;//MetagenGoad
$Vtec[37]=1;$Vtyp[37]=1;//MetagenShepherd
$Vtec[38]=1;$Vtyp[38]=1;// * MetagenAdjucator
$Vtec[39]=1;$Vtyp[39]=1;// * MetagenExecutor
$Vtec[40]=2;$Vtyp[40]=1;// * Harabec'sApocalypse
$Vtec[41]=2;$Vtyp[41]=2;//Predator
$Vtec[42]=2;$Vtyp[42]=1;// * Caanon's Basilisk?
$Vtec[43]=2;$Vtyp[43]=1;// * Cinematic Apocalypse
$Vtec[44]=2;$Vtyp[44]=1;// * Cinematic Basilisk
$Vtec[45]=2;$Vtyp[45]=2;// * Super Predator
$Vtec[46]=0;$Vtyp[46]=0;// NA
$Vtec[47]=0;$Vtyp[47]=0;// NA
$Vtec[48]=0;$Vtyp[48]=0;// NA
$Vtec[49]=0;$Vtyp[49]=0;// NA
$Vtec[50]=2;$Vtyp[50]=1;// * PirateApocalypse
$Vtec[51]=2;$Vtyp[51]=2;// * PirateDreadlock
$Vtec[52]=2;$Vtyp[52]=1;//PirateEmancipator
$Vtec[53]=0;$Vtyp[53]=0;// NA
$Vtec[54]=0;$Vtyp[54]=0;// NA
$Vtec[55]=1;$Vtyp[55]=1;//PlayerPlatAdjudicator
$Vtec[56]=1;$Vtyp[56]=1;//PlayerPlatExecutioner
$Vn = 57;
//-----------------------------------------------------------------------------
function VehicleTech(%v)
{
	if ((%v >= 1) && (%v < $Vn)) %t = $Vtec[%v];
	else if ((%v >= 60) && (%v <= 73)) %t = 0;
	else if (%v == 90) %t = 1;
	else if ((%v >= 91) && (%v <= 93)) %t = 0;
	else if ((%v >= 94) && (%v <= 96)) %t = 0;
	else if ((%v >= 110) && (%v <= 111)) %t = 0;
	else if ((%v >= 130) && (%v <= 132)) %t = 0;
	else if ((%v >= 133) && (%v <= 134)) %t = 2;
	else if ((%v >= 135) && (%v <= 136)) %t = 0;
	else if ((%v >= 137) && (%v <= 138)) %t = 2;
	else if (%v == 150) %t = 2;
	else %t = 0;

    return %t;

//	if (%t == 1) return "C";
//	if (%t == 2) return "H";
	return "?";
}

//-----------------------------------------------------------------------------
// this function uses less AI, all standard
function getRandomAI( %vehicleTech )
{

  %vehTech = -1;
%cntr = 0;

  while (( %vehTech != %vehicleTech ) ||
         ( %vehicleTech == 3 ))
   {
// check for valid ranges
     %i = RandomInt(1,28);
     if ( %i>8 && %i<10 )
        %i = RandomInt(1,8);
     if ( %i>17 && %i<20 )
        %i = RandomInt(20,28);

// get appropriate type Tank or Herc
     %type = Herc;
     if ( %i>5  && %i<= 8 )   %type = Tank;
     if ( %i>14 && %i<= 17 )  %type = Tank;
     if ( %i>24 && %i<= 26 )  %type = Tank;

     %vehTech = VehicleTech(%i);

%cntr++;

if ( %cntr > 10) break;
  }

   return NewObject( "AI" @ %i, %type, %i );
}

//-----------------------------------------------------------------------------
function createbackup()
{

 $numLivePlayers = countLivePlayers ();

     if ( $numLivePlayers >= 1 )  findSquadDropPoint ( getObjectid ($navAlpha), 3, "squad1" );
     if ( $numLivePlayers >= 2 )  schedule ("createSquadTwo();", 3 );
     if ( $numLivePlayers >= 3 )  schedule ("createSquadThree();", 5 );
     if ( $numLivePlayers >= 4 )  schedule ("createSquadFour();", 8 );
     if ( $numLivePlayers >= 5 )  schedule ("createSquadFive();", 9 );
     if ( $numLivePlayers >= 6 )  schedule ("createSquadSix();", 10 );
     if ( $numLivePlayers >= 7 )  schedule ("createSquadSeven();", 11 );
     if ( $numLivePlayers >= 8 )  schedule ("createSquadEight();", 12 );
}

function createSquadTwo ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 3, "squad2" );
}

function createSquadThree()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 3, "squad3" );
}

function createSquadFour ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 2, "squad4" );
}

function createSquadFive ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 2, "squad5" );
}

function createSquadSix ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 2, "squad6" );
}

function createSquadSeven ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 2, "squad7" );
}

function createSquadEight ()
{
  findSquadDropPoint ( getObjectid ($navAlpha), 4, "squad8" );
}

//-----------------------------------------------------------------------------
function dropSquad(%x, %y, %howMany, %newGroup )
{
 if ( %howMany > 10 ) %howMany = 10;

  %thisGroup = "MissionGroup/" @ %newgroup;

  newObject( %newGroup, SimGroup );
  addToSet( "MissionGroup", %newGroup );

  for ( %i=0; %i < %howMany; %i++ )
    {
      %herc = getRandomAI( $OVconvoyTech );

      setTeam (%herc, *IDSTR_TEAM_RED);
      setpilotID ( %herc, 29);

      placeObject ( %herc, %x, %y, 0);

  addToSet(  %thisGroup, %herc );

      %x = %x + 100 ;
      %y = %y + 100 ;

      if ( %i == 0 )
       {
         %leadHerc = %herc;
       }


      order (%herc, speed, high);

      if ( RandomInt (1,2) == 1 )
        {
          %targetPlayer = pickPlayer();
          order ( %herc, attack, %targetPlayer );
        }
      else
        {
          order ( %thisGroup, guard, $retreatPath );
        }
    }

//    order (%leadherc, makeleader, true);
//    order ( %thisGroup, formation, Delta );

}

//-----------------------------------------------------------------------------
function structure::onAttacked (%attacked,%attacker)
{

// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%attacker);
  if ( %who1 == 0 ) return;

 if ( $attackStarted == false )  onArrivedNavAlpha();

  $attackStarted = true;
}

//-----------------------------------------------------------------------------
function vehicle::onAttacked ( %attacked, %attacker )
{

// count only attacks to AI

   %who = playerManager::vehicleIdToPlayerNum (%attacked);


// player attacked AI
   if (%who == 0)
     {
   %who1 = playerManager::vehicleIdToPlayerNum (%attacker);
     if ( %who1 != 0 )
       {
         if ( $attackStarted == false )  onArrivedNavAlpha();

         $attackStarted = true;
       }
    }
}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == false))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function checkRedropSquad()
{
 %howMany = countLivePlayers ();

     if (( %howMany >= 1 ) &&
         ( isGroupDestroyed ("MissionGroup/squad1") == true ))
       {
         %center = pickPlayer();
         findSquadDropPoint ( %center, 3, "squad1" );
       }

     if (( %howMany >= 2 ) &&
         ( isGroupDestroyed ("MissionGroup/squad2") == true ))
       {
         %center = pickPlayer();
         findSquadDropPoint ( %center, 3, "squad2" );
       }

     if (( %howMany >= 3 ) &&
         ( isGroupDestroyed ("MissionGroup/squad3") == true ))
       {
         %center = pickPlayer();
         findSquadDropPoint ( %center, 2, "squad3" );
       }

     if (( %howMany >= 4 ) &&
         ( isGroupDestroyed ("MissionGroup/squad4") == true ))
       {
         %center = pickPlayer();
         findSquadDropPoint ( %center, 2, "squad4" );
       }
}

//-----------------------------------------------------------------------------
function abs(%n)
{
  if ( %n < 0 ) 
    {
      %n = %n * -1;
      return %n;
    }
   else
    {
      return %n;
    }
}

//-----------------------------------------------------------------------------
function findSquadDropPoint ( %centerObject, %howMany, %squadName )
{

%cntr = 0;

     %maxRange = $maxRange;
     %minRange = $minRange;

// not really a target, but the center of attention
   %target = %centerObject;

   %OVbaseX = getPosition (%target, x);
   %OVbaseY = getPosition (%target, y);

// select a drop zone
  %xDrop = RandomInt ( %OVbaseX-%maxRange, %OVbaseX+%maxRange );
  %yDrop = RandomInt ( %OVbaseY-%maxRange, %OVbaseY+%maxRange );

  %deltaX = %OVbaseX - %xDrop;
  %deltaY = %OVbaseY - %yDrop;

  %deltaX = abs ( %deltaX );
  %deltaY = abs ( %deltaY );

  %dropDistance = sqrt ( (%deltaX*%deltaX) + (%deltaY*%deltaY) );

  if  (( %dropDistance < %minRange ) ||
       ( %dropDistance > %maxRange ))
   {
     %dropDistance = randomInt ( %minRange, %maxRange );

// keep X position, for no particluar reason
      %temp = (( %xDrop * %xDrop ) - ( %dropDistance * %dropDistance ));
      %temp = abs ( %temp );
      %yDrop = sqrt ( %temp );

   while (1)
   {

// select a drop zone
     %xDrop = RandomInt ( %OVbaseX-%maxRange, %OVbaseX+%maxRange );
     %yDrop = RandomInt ( %OVbaseY-%maxRange, %OVbaseY+%maxRange );

     %deltaX = %OVbaseX - %xDrop;
     %deltaY = %OVbaseY - %yDrop;

     %deltaX = abs ( %deltaX );
     %deltaY = abs ( %deltaY );

     %dropDistance = sqrt ( (%deltaX*%deltaX) + (%deltaY*%deltaY) );


  if  (( %dropDistance > %minRange ) &&
       ( %dropDistance < %maxRange ))    break;

%cntr++;
 if ( %cntr > 20 ) break;

   }

   }

   dropSquad (%xDrop, %yDrop, %howMany, %squadName);

}

