//---- HC3 script file, DefendSaThauri
//===========================================
// repair truck code by johnrich

// admins should limit the player number to 6 or less

   $ratio = 1.4;


// max number of AI in a squad, to keep lag down
   $aiGroupMax = 10;

$actionStarted = false;

$server::TeamDamage = true;

$missionName = "DefendSaThauti";

$Version = "Version 1.0\nmaps available from www.shadowdragons.org\nEmail dkooz@yahoo.com with bugs";

Pilot Captain
{
   id = 28;
   name = Captain;
   skill = 0.1;
   accuracy = 0.1;
   aggressiveness = 0.9;
   activateDist = 300.0;
   deactivateBuff = 100.0;
   targetFreq = 4.0;
   trackFreq = 2.0;
   fireFreq = 4.0;
   LOSFreq = 0.8;
   orderFreq = 2.0;
};

Pilot guard
{
   id = 27;
   skill = 0.1;
   accuracy = 0.1;
   aggressiveness = 0.9;
   activateDist = 300.0;
   deactivateBuff = 100.0;
   targetFreq = 7.0;
   trackFreq = 4.0;
   fireFreq = 4.0;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

//------------------------------------------------------------------------
$minAIPilotID = 29;
$maxAIPilotID = 33;

Pilot PatrolPilot2
{
   id = 29;
   
   skill = 0.4;
   accuracy = 0.4;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot3
{
   id = 30;
   
   skill = 0.5;
   accuracy = 0.5;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

Pilot PatrolPilot4
{
   id = 31;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 1.0;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};
Pilot PatrolPilot4
{
   id = 32;
   
   skill = 0.6;
   accuracy = 0.6;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 2.0;
   fireFreq = 0.9;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};
Pilot PatrolPilot4
{
   id = 33;
   
   skill = 0.8;
   accuracy = 0.8;
   aggressiveness = 0.9;
   activateDist = 450.0;
   deactivateBuff = 300.0;
   targetFreq = 5.4;
   trackFreq = 1.0;
   fireFreq = 0.7;
   LOSFreq = 0.2;
   orderFreq = 4.0;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = False;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = False;

   // what can the server admin choose for available teams
   $server::disableTeamRed = False;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = False;
   $server::disableTeamPurple = true;

}

//-----------------------------------------------------------------------------
function onMissionLoad()
{
    $textMsg = 
      "Objectives:"@
      "\n1) Defend the Power generators"@
      "\n2) Get the MFAC turrets online.   "@
      "\n3) Destroy all the Cybrid hercs in the Brid attack force.   "@
   "\nRespawning is not allowed. Team Damage is on, watch your fire.";

   %history = "\nDate:2830\n About time, Commander. Pay attention!\n\n The time has come for the Alliance to leave Venus. "
  @ "Again, we will be the last evac. Unfortunately, right now we lack a safe exit window "
  @ "through the Oberwind. We must hold on until one opens. \n\nTo make our stay more ... comfortable, "
  @ "the tech caravans have jury-rigged a defense perimeter using M-FACs we brought from "
  @ "Mars. However, they need to make final adjustments before the perimeter goes operational. "
  @ "Keep the Cybrids at bay while the caravans do their work.\n\nDismissed."
  @ "\n\n\nTACTICAL ADDENDUM:\n\n\x97\tDue to tactical concerns, the caravan tech will deploy to the "
  @ "assignments only according to your orders.";

   setGameInfo (  %history @ $textMsg);

}

//-----------------------------------------------------------------------------
function onMissionStart()
{
    cdAudioCycle(ss4, Mechsoul, Terror);

    venusSounds();
    earthquakeSounds();

    init();
}

//-----------------------------------------------------------------------------
function player::onAdd(%this)                                                                                                                        
{
   say ( %this, 0, $Version @"\n"@ $textMsg );
   say ( %this, 0,  "\nCheck the game info tab for more details");
}

//-----------------------------------------------------------------------------
function vehicle::onAdd(%this)                                                                                                                        
{

// see if it is a player, if not exit
   %player = playerManager::vehicleIdToPlayerNum(%this);

   if (%player == 0) return;

   if (getTeam (%this) != *IDSTR_TEAM_YELLOW)
    {
     setTeam(%this, *IDSTR_TEAM_YELLOW);
     redrop(%this);
    }

 if ( $actionStarted == true )
   {
    if ( %player.state == "tked" )  
        {
   	%player.state = "";
        }
      else
        {
        schedule ("healObject(" @ %this @ ", -50000);", 3);
        Say(%player,0,"Sorry, you can't join until the next game.");
       }
   }
 schedule( "setEnemyNavPoint(" @ %this @ ");", 3 );

}

//-----------------------------------------------------------------------------
function setEnemyNavPoint( %this )
{
  setNavMarker( $navAlpha, true, %this );
}

//-----------------------------------------------------------------------------
function MPcheckBoundary( %dir, %obj2, %distance, %callback, %time )
{
// This is a modification of the campaign function "CheckBoundary"
//
// %dir  - enter or leave
// %obj2 - any object you want the players distance compared to
//         must be an ID (use getObjectid) and not a string ("MissionGroup/RedHerc/h1")
// %distance - if entering, they'd be within this range to run the function
//             if leaving, they'd be outside this range to run the function
// %callback - name of the function to run
// %time - when to reschedule the next check

  %jobRun = false;

   %playerCount = playerManager::getPlayerCount();

   for(%i=0; %i < %playerCount ; %i++)
     {
     %player = playerManager::getPlayerNum( %i );

     %obj1= playerManager::playerNumToVehicleId( %player);

   %var = getDistance( %obj1, %obj2 );

    if (%var != "0")
     {
     if( %dir == "enter" || %dir == "Enter" )
       {
        if( %var <= %distance )
          {
          if ( %jobRun == false )
            {
              %func = %callback @ "(" @ %obj1 @ ");";
              schedule( %func, 0 );
              %jobRun = true;
            }
          }
       }
    else if( %dir == "leave" || %dir == "Leave" )
      {
       if( %var >= %distance )
         {
          if ( %jobRun == false )
            {
              %func = %callback @ "();";
              schedule( %func, 0 );
              %jobRun = true;
            }
         }
      }
    }
  } // end for loop

  if  (%jobRun != true )
   {
   schedule( "MPcheckBoundary( "
             @ %dir @ ", "
             @ %obj2 @ ", "
             @ %distance @ ", "
             @ %callback @ ", "
             @ %time @ ");",
             %time );

   }

}


//-----------------------------------------------------------------------------
function pickPlayer ()
{

// 100 so we can be assured of getting a live player
   for (%p = 0; %p < 100; %p++)
     {
      %player = playerManager::getPlayerNum( randomInt( 0, playerManager::getPlayerCount() - 1 ) );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {
         return %playerVeh;
       }
     }
  return 0;
}

//-----------------------------------------------------------------------------
function countLivePlayers ()
{

  %count = 0;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {
         %count++;
       }
     }
  return %count;

}

//-----------------------------------------------------------------------------
function placeObject (%object, %x, %y, %rot)
{

  if ( %rot == "" ) %rot = 0;

  %z = getTerrainHeight(%x, %y);
  setPosition (%object, %x, %y, %z + 2, %rot);

}
//-----------------------------------------------------------------------------
function checkForPlayersDead()
{
  %allDead = true;

   %playerCount = playerManager::getPlayerCount();

   for (%p = 0; %p < %playerCount; %p++)
     {
      %player = playerManager::getPlayerNum( %p );

      %playerVeh = playerManager::playerNumToVehicleId( %player);

      if (( %playerVeh != "" ) &&
          (isGroupDestroyed (%playerVeh) == False))
       {

         %allDead = False;
       }
     }

  if ( %allDead == true ) schedule ("missionFailed();", 3);

}

//-----------------------------------------------------------------------------
function vehicle::onDestroyed(%this, %who)
{
// actors destroyed here
//

// captain killed by our team

// see if it is a player, if so start the E brid group right away
   %player = playerManager::vehicleIdToPlayerNum(%this);

  if (( %this == $guardleader ) &&
      ((%this != %who) &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW)))
    {
      schedule("startCybridE();", 40.0);
    }


// give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%who));
   if(%message != "")
   {
      say( 0, 0, %message);
   }



  if ( %this == $repairid )
   {

    if($repaironliningTurret)
        setHudTimer(-1, 0, *IDSTR_TIMER_HC3_1, 1);
    schedule( "deleteObject(" @ %this @ ");", 20 );     
   }

  if ( isMember( $cybridA, %this ) == true )
    {
      $cybridAcount = $cybridAcount - 1;
      checkHercsDestroyed();
    }

  if ( isMember( $cybridB, %this ) == true )
    {
       $cybridBcount = $cybridBcount - 1;
      checkHercsDestroyed();
    }

  if ( isMember( $cybridC, %this ) == true )
    {
      $cybridCcount = $cybridCcount - 1;
      checkHercsDestroyed();
    }

  if ( isMember( $cybridD, %this ) == true )
    {
       $cybridDcount = $cybridDcount - 1;
      checkHercsDestroyed();
    }

  if ( isMember( $cybridE, %this ) == true )
    {
      $cybridEcount = $cybridEcount - 1;
      checkHercsDestroyed();
    }

// END actors destroyed here
//


// see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);


   %whoDunit = playerManager::vehicleIdToPlayerNum (%who);

   if(%player == 0) 
   {
    schedule( "deleteObject(" @ %this @ ");", 8 );

    if ( %whoDunit != 0 )
     {
      healobject ( %who, 5000 );

      reloadObject(%who, 5000 );
     }
   }


   if ((%this != %who) &&
      (%whoDunit != 0)  &&
      (getTeam(%this) == getTeam(%who)) &&
      (getTeam(%this) == *IDSTR_TEAM_YELLOW))
    {

     %killerName = getHudName ( %who );
     %name = getHudName ( %this );

// Team kill, take action
     say(0,0,%killerName@" is being kicked for team-killing "@%name@".");
     say(%who, %who, "", "rules_violated.wav");
     %player = playerManager::vehicleIdToPlayerNum ( %who );
     kick ( %player, *IDMULT_CHAT_TEAM_KILL_KICK );

// allow TKed player to return
     say(%this, %this, "A teammate killed you. You may respawn.");
     %this.state = "tked";
    }


  if ( $actionStarted == true ) checkForPlayersDead();

}


function init()
{

// set up the brid drop points for randomness attacks
$point1used = false;
$point2used = false;
$point3used = false;
$point4used = false;

$point1x = -2225;
$point1y = 3020;

$point2x = -1363;
$point2y = -1492;

$point3x = -3711;
$point3y = 236;

$point4x = 660;
$point4y = -651;


// has the guard talked? used to keep players from scanning all the 
// gens before talking to the guard
$guardStarted = False;


// used for repairing players
$Repair=false;

// need to create these here to avoid lots of errors from onarrive
// they are duplicated in the initcybridXXX function

    $cybridA = getObjectId("MissionGroup/cybridA");
    $cybridB = getObjectId("MissionGroup/cybridB");
    $cybridC = getObjectId("MissionGroup/cybridC");
    $cybridD = getObjectId("MissionGroup/cybridD");
    $cybridE = getObjectId("MissionGroup/cybridE");



  $navAlpha = "MissionGroup/navMarkers/navAlpha";
  $navBravo = "MissionGroup/navMarkers/navBravo";


  newObject( "dropShipGroup", SimGroup );
  addToSet( "MissionGroup", "dropShipGroup" );

  createDropShip();

$missionObj1Status = True; // base destroyed 
$missionObj2Status = False; // all turrets online
$missionObj3Status = False; // all brids destroyed

    initFormations();
    initRepair();
    initBase();
    initMfac();


// from initPlayer()

	order("MissionGroup/mfac/turret1", ShutDown, true);
	order("MissionGroup/mfac/turret2", ShutDown, true);
	order("MissionGroup/mfac/turret3", ShutDown, true);
	order("MissionGroup/mfac/turret4", ShutDown, true);

    initGuard();

   MPcheckBoundary( leave, getObjectID ($navBravo) , 300, onLeaveNavBravoWarning, 1 );
   MPcheckBoundary( leave, getObjectID ($navBravo) , 500, onLeaveNavBravo, 1 );

   MPcheckBoundary( enter, getObjectID ($guardleader) , 150, onArriveGuard, 1 );

 $cybridAcount = 0;
 $cybridBcount = 0;
 $cybridCcount = 0;
 $cybridDcount = 0;
 $cybridEcount = 0;

}

//-----------------------------------------------------------------------------
function onArriveGuard()
{
  if ( $guardStarted == False )
   {
//    schedule("actorTalks($guardleader, \"CAPTAIN: Guardian, this is Warwolf.  Glad you folks could make it.  We're going to intercept a Cybrid raiding squad East of this location.  You stay here and hold the back door in case some glitches slip by us.  We need those turrets online.\", \"HC3_POC01.wav\");", 1.0);

Say(0, 0, "CAPTAIN: Guardian, this is Warwolf.  Glad you folks could make it.  We're going to intercept a Cybrid raiding squad East of this location.  You stay here and hold the back door in case some glitches slip by us.  We need those turrets online.");

//   messagebox(0,"Scaning the power generators will signal the repair truck to repair them. Do ONLY one at a time");


    schedule("guardBegin();", 8.0);

    schedule("startCybridA();", 5.0);

    $guardStarted = True;
   }
}
//-----------------------------------------------------------------------------
function onLeaveNavBravoWarning ()
{
   say (0,0, "<f5>You are leaving the drop zone. By doing so you will start the mission.");
}

//-----------------------------------------------------------------------------
function onLeaveNavBravo ()
{
   say (0, 0, "<f5>TACCOM: Rendevous with the Basilisk at Nav Alpha.");
   $actionStarted = true;
}

//-----------------------------------------------------------------------------
function createDropShip()
{
  %herc = NewObject( "Drop Ship", Flyer, 130); // terran drop ship

  addToSet( "MissionGroup/dropShipGroup", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);


  %x = getPosition ( $navBravo, x );
  %y = getPosition ( $navBravo, y );
  %z = getPosition ( $navBravo, z );

  setPosition (%herc, %x, %y, %z );

// don't let that ship take off!
   order( %herc, shutdown, True );
}

//-----------------------------------------------------------------------------
function createRandomBrid ( %x, %y, %group, %name, %which )
{

//echo ("DEBUG: x" @ %x @ " y" @ %y @ " group" @ %group @ " name" @ %name @ " which " @ %which );

%maxVeh = 14;

%Veh[1] = 20;   //,TRUE);//Seeker
%Veh[2] = 21;   //,TRUE);//Goad
%Veh[3] = 22;   //,TRUE);//Shepherd
%Veh[4] = 23;   //,TRUE);//Adjudicator
%Veh[5] = 24;   //,TRUE);//Executioner
%Veh[6] = 25;   //,TRUE);//Bolo
%Veh[7] = 26;   //,TRUE);//Recluse

%Veh[8] = 27;   // * PlatAdjucator
%Veh[9] = 28;   // * PlatExecutor
%Veh[10] = 35;   //MetagenSeeker
%Veh[11] = 36;   //MetagenGoad
%Veh[12] = 37;   //MetagenShepherd
%Veh[13] = 38;   //* MetagenAdjucator
%Veh[14] = 39;   // * MetagenExecutor


  if ( $hercNumber == "" )
    {
     $hercNumber = 1;
    }
   else
    {
     $hercNumber = $hercNumber + 1;
    }


     if ( %name == "" )  %name = "brid";

     if ( %which == "" )
       {
         %r = randomInt (1, %maxVeh);
         %which = %Veh[%r];
       }

   %name = %name @ $hercNumber;

   if ((%which == 25) || (%which == 26))
    {
     %herc = NewObject( %name, Tank, %which);
    }
   else
    {
     %herc = NewObject( %name, Herc, %which);
    }
     setTeam(%herc, *IDSTR_TEAM_RED);

     %pilotID = randomInt ($minAIPilotID, $maxAIPilotID);
     setPilotId (%herc, %pilotID);

     addToSet( %group, %herc );

     if ( %x == "" )
      {
       redrop ( %herc );
      }
    else
      {
       PlaceObject ( %herc, %x, %y );
      }

   order (%herc, speed, high );

//   %target = PickPlayer();
//   order (%herc, attack, %target );
}

//-----------------------------------------------------------------------------
function createplatExec ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 28;
  if ( %name == "" ) %name = "Exec";

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( "MissionGroup/bridMain", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  redrop (%herc);

     %pilotID = randomInt ($minAIPilotID, $maxAIPilotID);
     setPilotId (%herc, %pilotID);


}

//-----------------------------------------------------------------------------
function createplatAdjunc ( %name, %hercID )
{

  if ( %hercID == "" ) %hercID = 27;
  if ( %name == "" ) %name = "Adjunc";

  %herc = NewObject ( %name, Herc, %hercID );

  addToSet( "MissionGroup/bridMain", %herc );

  setTeam(%herc, *IDSTR_TEAM_RED);
  redrop (%herc);

     %pilotID = randomInt ($minAIPilotID, $maxAIPilotID);
     setPilotId (%herc, %pilotID);


}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------    Init Stuff   ---------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------

//**==GUARD CLASS==***********************************************************
function initGuard()
{

//-----------------------------------------------------------------------------


  %herc = NewObject( "guard1", Herc, 14);

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,28);

  addToSet( "MissionGroup/guard", %herc );

  placeObject ( %herc, -1187, 866 );

  $lastHerc = %herc;


//  order (%herc, makeleader, True);

  %herc = NewObject( "guard2", Herc, 11);

  setTeam(%herc, *IDSTR_TEAM_YELLOW);

  setPilotId (%herc,27);

  addToSet( "MissionGroup/guard", %herc );

   placeObject ( %herc, -1375, 717 );

  order ( %herc, guard, $lastHerc );
  $lastHerc = %herc;

  %herc = NewObject( "guard3", Herc, 11);

  setTeam(%herc, *IDSTR_TEAM_YELLOW);
  setPilotId (%herc,27);

  addToSet( "MissionGroup/guard", %herc );

   placeObject ( %herc, -1494, 630 );

  order ( %herc, guard, $lastHerc );

    $guard = getObjectId("MissionGroup/guard");
    $guardleader = getObjectId("MissionGroup/guard/guard1");
    $guardlast = getObjectId("MissionGroup/guard/route/last");
       
    order($guardleader, MakeLeader, true);
    order($guardleader, Speed, High);
    order($guard, Formation, guardFormation);
    $guardengaged = false;

}   

//-----------------------------------------------------------------------------   
function guardBegin()
{
    order($guardleader, Guard, "MissionGroup/guard/route");
    repairBegin();
    guardDistCheck();
}


//-----------------------------------------------------------------------------   
function guardTalks(%snd, %txt)
{
    if($guardcount > 0)
        say(0, 0, *(%txt), %snd);        
}

//-----------------------------------------------------------------------------
function guardDistCheck()
{
  if (!isGroupDestroyed ($cybridE))
   {
    if(getDistance($guardleader, $cybridEleader) < 700)
    {
        say (0,0, "CAPTAIN: Warwolf to Guardian.  We have visual on the raiders -- Good Lord, these things are HUGE...!  We'll hold them as long as we can!", "HC3_POC02.wav"); 
    }       
    else
        schedule("guardDistCheck();", 10.0);      
   }
}


//**==MFAC CLASS==***********************************************************
function initMfac()
{
    $mfac = getObjectId("MissionGroup/mfac");
    $mfacid1 = getObjectId("MissionGroup/mfac/turret1");
    $mfacid2 = getObjectId("MissionGroup/mfac/turret2");
    $mfacid3 = getObjectId("MissionGroup/mfac/turret3");
    $mfacid4 = getObjectId("MissionGroup/mfac/turret4");

       $poweronline1 = False;
       $poweronline2 = False;
       $poweronline3 = False;
       $poweronline4 = False;

}

//-----------------------------------------------------------------------------
function initFormations()
{
    newFormation(guardFormation, 0,0,0,     // 1st 
                                 20,-30,0,    // 2nd
                                -20,-30,0    // 3rd
                                );
                                
    newFormation(wideForm,0,0,0,            //1st
                          100,-20,0,
                          -100,-20,0);
                                
    newFormation(genericFormation, 0,0,0,     // 1st 
                                  20,0,0,    // 2nd
                                 -20,0,0,    // 3rd
                                  40,0,0,    // etc
                                 -40,0,0, 
                                  60,0,0, 
                                 -60,0,0, 
                                  80,0,0, 
                                 -80,0,0, 
                                  100,0,0 
                                );

}


//-----------------------------------------------------------------------------

//**==REPAIR CLASS==***********************************************************
function initRepair()
{
// terran utility truck 71

  %herc = NewObject ( "repair1", Tank, 71 );

  addToSet( "MissionGroup/Repair", %herc );

  setTeam(%herc, *IDSTR_TEAM_YELLOW);

  placeObject (%herc, -1187, 256);

    order("MissionGroup/Repair/repair1", Speed, Medium);
    $repair = getObjectId("MissionGroup/Repair"); 
    $repairid = getObjectId("MissionGroup/Repair/repair1"); 

    $repairturretSelected = 0;
    $repaircurrentOrder   = 0;
    $repairbriefing       = false;
    $repaircount          = 1;
    $repairengaged        = false;
    $repaironliningTurret = false;
    $repairCommandGiven   = false;
    $repairturretsOnlined = 0;  

}
//-----------------------------------------------------------------------------
function repairBegin()
{

    if($repairturretSelected == 0)
    {

        %playerVeh = pickPlayer();
        order($repairid, guard, %playerVeh);
        repairDistanceCheck(%playerVeh);


    }
    else
        $repairbriefing = true;

}

//-----------------------------------------------------------------------------
function repairDistanceCheck(%playerVeh)
{

    if(!$repairbriefing && $repairturretSelected == 0)
    {
        if(getDistance($repairid, %playerVeh) < 80)
        {
            $repairbriefing = true;
            order($repairid, ShutDown, true);
   messagebox(0,"Scaning the power generators will signal the repair truck to repair them. Do ONLY one at a time");
        }
        else
        {
          if ( isGroupDestroyed (%playerVeh) == False)
            {
               %playerVeh = pickPlayer();
            }
          schedule("repairDistanceCheck(" @ %playerVeh @ ");", 4.0);
        }
    }

}

//-----------------------------------------------------------------------------
function stopRepair()
{
    $repairturretSelected = 0;

    $repaircurrentOrder   = 0;
    $repaironliningTurret = false;
    $repairCommandGiven = false;
    order($repairid, ShutDown, false);
    setHudTimer(-1, 0, *IDSTR_TIMER_HC3_1, 1);
}


//-----------------------------------------------------------------------------
function vehicle::onScan (%this, %scanner)
{

echo ("before if");

 if ( %this == $repairid )
  {


    if ( $missionObj2Status == False) // all turrets online
      {
         say (0,0, "REPAIR-ONE: We need to get those turrets on line first Commander. Just a few more seconds...", "HC3_CAR03.wav");
         return;
      }

  if ($Repair==false  )
    {
     $Repair=true;
     healObject(%scanner, 2000);
     reloadObject(%scanner, 100);

    }
   
   schedule("$Repair=false;", 5);


  }
}

//-----------------------------------------------------------------------------
function power::structure::onScan(%scanned, %scanner, %string)
{
  if ( $guardStarted == False )
   {
     %target = PickPlayer();
     order ($guardleader, guard, %target );
   }

   %orderNum = 0;

    if($repairCommandGiven == true)
      {
        say (0,0, "REPAIR-ONE: Goin' as fast as we can, Commander. Just a few more seconds...", "HC3_CAR03.wav");
        return;
      }

   if ( %scanned == $powerid1 )
     {
       if ( $poweronline1 == True )
         {
            say (0,0,"That turret is alreay online");
            return;
         }
       %orderNum = 1;
       %turretId = $mfacid1;
       $poweronline1 = True;
//       $repairCommandGiven = true;
     }

   if ( %scanned == $powerid2 ) 
     {
       if ( $poweronline2 == True )
         {
            say (0,0,"That turret is alreay online");
            return;
         }
       %orderNum = 2;
       %turretId = $mfacid2;
       $poweronline2 = True;
//       $repairCommandGiven = true;
     }

   if ( %scanned == $powerid3 )
     {
       if ( $poweronline3 == True )
         {
            say (0,0,"That turret is alreay online");
            return;
         }
       %orderNum = 3;
       %turretId = $mfacid3;
       $poweronline3 = True;
//       $repairCommandGiven = true;
     }

   if ( %scanned == $powerid4 )
     {
       if ( $poweronline4 == True )
         {
            say (0,0,"That turret is alreay online");
            return;
         }
       %orderNum = 4;
       %turretId = $mfacid4;
       $poweronline4 = True;
//       $repairCommandGiven = true;
     }

//  Get the turret ID and call the code to online the turret

   if (( %orderNum != 0 ) && isGroupDestroyed (%turretId) == False)
     {
        selectTurret(%turretId, %orderNum);
     }
    else
     {
       say (0,0, "That turret is destroyed");
     }
}

//-----------------------------------------------------------------------------
function selectTurret(%turretId, %orderNum)
{

    if($repairCommandGiven == true)
      {

        say (0,0, "REPAIR-ONE: Goin' as fast as we can, Commander. Just a few more seconds...", "HC3_CAR03.wav");
    }                    
    else
    { 
        $repairCommandGiven = true;
        $repaircurrentOrder = %orderNum;
        order($repairid, ShutDown, false);
                
        say (0,0, "REPAIR-ONE: Roj that, Commander.", "HC3_CAR01.wav");  
        order($repairid, Guard, getTurretMarkerId($repaircurrentOrder)); 
        $repairturretSelected = %turretId;  
    }       
}

//-----------------------------------------------------------------------------
function turretOnlined(%turretId)
{
    if($repaircount > 0 && $repairturretSelected != 0 && $repaircurrentOrder != 0)
    {               

        order(%turretId, ShutDown, false);
        setTeam(%turretId, *IDSTR_TEAM_YELLOW);
        
        $repairturretsOnlined++;
        if($repairturretsOnlined == 4)
        {
            $missionObj2Status = True;
            playSound(0, "GEN_OC01.wav", IDPRF_2D);
            say (0,0, "All turrets on -line." );
        }
        
//        actorTalks($repairid, *IDSTR_HC3_CAR02, "HC3_CAR02.wav");
   say (0,0, *IDSTR_HC3_CAR02, "HC3_CAR02.wav");

        stopRepair();        
    }
}


//-----------------------------------------------------------------------------
function getTurretId(%n)
{
    return getObjectId("MissionGroup/mfac/turret" @ %n);
}

//-----------------------------------------------------------------------------
function getTurretMarkerId(%n)
{
    return getObjectId("MissionGroup/repair/route/marker" @ %n); 
}

//-----------------------------------------------------------------------------
function vehicle::onArrived(%this, %where)
{

 if ( %this == $repairid )
  {


// %where == getTurretMarkerId($repaircurrentOrder)
    if ( $repaircurrentOrder != 0  && 
       !($repaironliningTurret) && %where != 0 )
    {

        %turretId = getTurretId($repaircurrentOrder);

        schedule("turretOnlined(" @ %turretId @ ");",30.0);
        $repaironliningTurret = true;
        order($repair, ShutDown, true);
        
        setHudTimer(30, -1, *IDSTR_TIMER_HC3_1, 1);    
    }
   return;
  }


// ================= guard stuff here ====================================
   if ( %this == $guardleader )
    {

    if(%where == $guardlast)
    {
        order($guardleader, Guard, %where);
        order($guard, Formation, wideForm);
    }

// if someone kills the captain, we start bridE at that event
    if(%where == getObjectId("MissionGroup/guard/route/marker2"))
      {
        schedule("startCybridE();", 140.0);
      }

    return;
  }

  if (!isGroupDestroyed ($cybridA))
   if ( %this == $cybridAleader )
    {
    if(%where == $cybridAlast)
        cybridAttacks($cybridA);
    return;
    }



  if (!isGroupDestroyed ($cybridB))
   if ( %this == $cybridBleader )
    {
    if(%where == $cybridBlast)
        cybridAttacks($cybridB);
     return;
    }


  if (!isGroupDestroyed ($cybridC))
   if ( %this == $cybridC )
    {
    if(%where == $cybridClast)
        cybridAttacks($cybridC);
    return;
    }

  if (!isGroupDestroyed ($cybridD))
   if ( %this == $cybridDleader )
    {
    if(%where == $cybridDlast)
        cybridAttacks($cybridD);
    return;
    }

  if (!isGroupDestroyed ($cybridE))
   if ( %this == $cybridEleader )
    {
    if(%where == $cybridElast)
        cybridAttacks($cybridE);
    return;
    }

}

//====================  End repair truck Stuff =====================


//-----------------------------------------------------------------------------
function actorTalks(%id, %txt, %snd)
{
   Say(0, 0, *(%txt), %snd);
}


// ON Destroyed stuff
//-----------------------------------------------------------------------------
function mfac::turret::onDestroyed(%this, %who)
{
    if(%this == $repairturretSelected)
        stopRepair();   
}

// BASE FUNCTIONS
function initBase()
{
    $base = getObjectId("MissionGroup/base");
    $command = getObjectId("MissionGroup/base/command");
    $power = getObjectId("MissionGroup/base/power");
    $barracks = getObjectId("MissionGroup/base/barracks");

    $commandattacked   = false;   
    $powerattacked     = false;
    $barracksattacked  = false;

    $powerid1 = getObjectId("MissionGroup/base/power/power1");
    $powerid2 = getObjectId("MissionGroup/base/power/power2");
    $powerid3 = getObjectId("MissionGroup/base/power/power3");
    $powerid4 = getObjectId("MissionGroup/base/power/power4");

    $poweronline1 = False;
    $poweronline2 = False;
    $poweronline3 = False;
    $poweronline4 = False;


    $basedestroyed = 0;    
}

function command::structure::onAttacked(%this, %who)
{
    if(!$commandattacked)
        baseAttacked(%this, %who, command);        
}

function power::structure::onAttacked(%this, %who)
{
    if(!$powerattacked)
        baseAttacked(%this, %who, power);     
}

function barracks::structure::onAttacked(%this, %who)
{
    if(!$barracksattacked)
        baseAttacked(%this, %who, barracks);      
}

function command::structure::onDestroyed(%this, %who)
{
    $basedestroyed++;
    checkBaseDestroyed();
}

function power::structure::onDestroyed(%this, %who)
{
    $basedestroyed++;
    $missionObj3Status = False;
    
    if(%this == $powerid1)
    {

        damageObject($mfacid1, 10000);
    }
    
    if(%this == $powerid2)             
    {

        damageObject($mfacid2, 10000);
    }

    if(%this == $powerid3)
    {

        damageObject($mfacid3, 10000);
    }

    if(%this == $powerid4)
    {

        damageObject($mfacid4, 10000);
    }
    checkBaseDestroyed();
}

function barracks::structure::onDestroyed(%this, %who)
{
    $basedestroyed++;
    checkBaseDestroyed();
}



// used by onattack & ondestroyed
//-----------------------------------------------------------------------------
function baseAttacked(%this, %who, %class)
{
    %chance = randomInt(1,10);

    if(%chance > 5 && getTeam(%this) != getTeam(%who))
    {
        %snd = "";
        %txt = "";
        
        //switch 
        if(%class == command)
        {


            %snd = "HC3_WU01.wav";
            %txt = "TAC-COM: Commander, this is TAC-COM. The operations center is under attack.";
            $commandattacked = true;
            schedule("$commandattacked = false;", 15.0); 
        }
        if(%class == power)
        {

            %snd = "HC3_WU03.wav";
            %txt = "TAC-COM: TAC-COM to Guardian One. Power generators are under attack.";
            $powerattacked = true;
            schedule("$powerattacked = false;", 10.0);
        }
        if(%class == barracks)
        {

            %snd = "HC3_WU02.wav";
            %txt = "TAC-COM: TAC-COM here, sir.  The barracks are under attack.";
            $barracksattacked = true;
            schedule("$barracksattacked = false;", 10.0);
        }
        
        say (0, 0, %txt, %snd);
    }
}

//-----------------------------------------------------------------------------
function checkBaseDestroyed()
{

    if($basedestroyed > 3)
    {
        $missionObj1Status = False;
        say (0,0,"<f5>Mission objective failed. Base destroyed");

    }
}



//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
function cybridAttacks(%id)
{
    //pick random target
    %n = randomInt(1,4);
    %target = pickPLayer();
    
    if(%n == 2)
      {
        %target = $power;
        if ( isGroupDestroyed ( $power))  %target = $command;
      }

    if(%n == 3)
      {
        %target = $command;
        if ( isGroupDestroyed ( $command))  %target = $barracks;
      }

    if(%n == 4)
      {
        %target = $barracks;
        if ( isGroupDestroyed ( $barracks))  %target = pickPLayer();
      }

//    %name = getObjectName(%target);

    order(%id, Attack, %target);
//    order(%id, HoldPosition, true);
}

//-----------------------------------------------------------------------------
function vehicle::onMessage (%this, %message, %_1, %_2, %_3, %_4, %_5, %_6, %_7, %_8, %_9)
{

// have the enemy pick a new target
// attacker can run into buildings
  %who1 = playerManager::vehicleIdToPlayerNum (%this);
  if ( %who1 != 0 ) return;

 if ( getGroup ( %this ) == $guard ) return;

   cybridAttacks(%this);
}


//-----------------------------------------------------------------------------   
function vehicle::onAttacked(%this, %who)
{


  if ( %this == $guardleader )
   {
    if(!($guardengaged) && %this != %who)
    {
        $guardengaged = true;
        order($guardleader, Attack, %who);
        order ($guard, attack, $cybridE);
    }
  }

// kill off the guards quick
  if (( getGroup ( %this ) == $guard ) &&
      ($guardengaged == true ))
     {
       healObject (%this, -5000);
     }

// end guard

  if ( %this == $cybridAleader )
   {

    if( getTeam(%this) != getTeam(%who) && !$cybridAattacked)
    {
        $cybridAattacked = true;
        schedule("startCybridB();", 0.5);        
    }
   }

  if ( %this == $cybridBleader )
   {

    if( getTeam(%this) != getTeam(%who) && !$cybridBattacked)
    {
        $cybridBattacked = true;
        schedule("startCybridC();", 1.5);        
    }
   }

  if ( %this == $cybridCleader )
   {
    if( getTeam(%this) != getTeam(%who) && !$cybridCattacked)
    {
        $cybridCattacked = true;
        schedule("startCybridD();", 2.0);        
    }
   }

}





//--CYBRID A

//=================================================================
function initCybridA()
{
 %timeDelay = 1;

 $hercNumber = 0;

    %howMany = countLivePlayers();
    %howMany = %howMany * $ratio ;

    if ( %howMany > $aiGroupMax ) %howMany = $aiGroupMax;


//    %x = -2225;
//    %y = 3020;

    %which = pickBridDrop();
    %x = getBridDropX (%which);
    %y = getBridDropY (%which);

    for (%i=0; %i < %howMany; %i++ )
     {
       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridA\", \"a\" );", %timeDelay );
       %x = %x + 40;
       %y = %y + 40;
       %timeDelay = %timeDelay + 1;
//schedule("order"MissionGroup/cybridA/a
       $cybridAcount = $cybridAcount + 1;
     }

  schedule ("finalInitCybridA();" , %timeDelay );
//    $cybridAcount = %howMany;

}

function finalInitCybridA()
{
    $cybridAroute = getObjectId("MissionGroup/cybridA/route");
    $cybridAlast = getObjectId("MissionGroup/cybridA/route/last");
    $cybridAleader = getObjectId("MissionGroup/cybridA/a1");
    $cybridAattacked = false;
    
//    order($cybridAleader, MakeLeader, true);
//    order($cybridAleader, Speed, High);
//    order($cybridA, Formation, genericFormation);

//    order($cybridAleader, Guard, $cybridAroute);
    order($cybridA, Guard, $cybridAroute);
}

function startCybridA()
{
    initCybridA();
}

//--CYBRID B
function initCybridB()
{
 %timeDelay = 1;

 $hercNumber = 0;

    %howMany = countLivePlayers();
    %howMany = %howMany * $ratio ;

    if ( %howMany > $aiGroupMax ) %howMany = $aiGroupMax;

//    %x = -1363;
//    %y = -1492;

    %which = pickBridDrop();
    %x = getBridDropX (%which);
    %y = getBridDropY (%which);

    for (%i=0; %i < %howMany; %i++ )
     {
       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridB\", \"b\" );", %timeDelay );
//       createRandomBrid ( %x, %y, "MissionGroup/cybridB", "b" );
       %x = %x + 30;
       %y = %y + 30;
         %timeDelay = %timeDelay + 1;
       $cybridBcount = $cybridBcount + 1;
     }
       %timeDelay = %timeDelay + 1;

  schedule ("finalInitCybridB();" , %timeDelay );

//    $cybridBcount = %howMany;

}

function finalInitCybridB()
{
    $cybridB = getObjectId("MissionGroup/cybridB");
    $cybridBroute = getObjectId("MissionGroup/cybridB/route");
    $cybridBlast = getObjectId("MissionGroup/cybridB/route/last");
    $cybridBleader = getObjectId("MissionGroup/cybridB/b1");
    $cybridBattacked = false;
    
//    order($cybridBleader, MakeLeader, true);
//    order($cybridBleader, Speed, High);
//    order($cybridB, Formation, genericFormation);
//    order($cybridBleader, Guard, $cybridBroute);
    order($cybridB, Guard, $cybridBroute);
}

function startCybridB()
{
   initCybridB();
//   order($cybridBleader, Guard, $cybridBroute);
}

//--CYBRID C
function initCybridC()
{
 %timeDelay = 1;

 $hercNumber = 0;

    %howMany = countLivePlayers();
    %howMany = %howMany * $ratio ;

    if ( %howMany > $aiGroupMax ) %howMany = $aiGroupMax;


//    %x = -3711;
//    %y = 236;

    %which = pickBridDrop();
    %x = getBridDropX (%which);
    %y = getBridDropY (%which);

    for (%i=0; %i < %howMany; %i++ )
     {
       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridC\", \"c\" );", %timeDelay );

//       createRandomBrid ( %x, %y, "MissionGroup/cybridC", "c" );
       %x = %x + 30;
       %y = %y + 30;
       %timeDelay = %timeDelay + 1;
       $cybridCcount = $cybridCcount + 1;
     }
       %timeDelay = %timeDelay + 1;

  schedule ("finalInitCybridC();" , %timeDelay );

//    $cybridCcount = %howMany;
}

function finalInitCybridC()
{
    $cybridC = getObjectId("MissionGroup/cybridC");
    $cybridCroute = getObjectId("MissionGroup/cybridC/route");
    $cybridClast = getObjectId("MissionGroup/cybridC/route/last");
    $cybridCleader = getObjectId("MissionGroup/cybridC/c1");
    $cybridCattacked = false;
    
//    order($cybridCleader, MakeLeader, true);
//    order($cybridCleader, Speed, High);
//    order($cybridC, Formation, genericFormation);
//    order($cybridCleader, Guard, $cybridCroute);
    order($cybridC, Guard, $cybridCroute);
}

function startCybridC()
{
   initCybridC();
//   order($cybridCleader, Guard, $cybridCroute);
}

//--CYBRID D
function initCybridD()
{
 %timeDelay = 1;

 $hercNumber = 0;

    %howMany = countLivePlayers();
    %howMany = %howMany * $ratio ;

    if ( %howMany > $aiGroupMax ) %howMany = $aiGroupMax;

//    %x = 660;
//    %y = -651;

    %which = pickBridDrop();
    %x = getBridDropX (%which);
    %y = getBridDropY (%which);

    for (%i=0; %i < %howMany; %i++ )
     {
       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridD\", \"d\" );", %timeDelay );
//       createRandomBrid ( %x, %y, "MissionGroup/cybridD", "d" );
       %x = %x + 30;
       %y = %y + 30;
       %timeDelay = %timeDelay + 1;
       $cybridDcount = $cybridDcount + 1;
     }
       %timeDelay = %timeDelay + 1;

  schedule ("finalInitCybridD();" , %timeDelay );

//    $cybridDcount = %howMany;
}

function finalInitCybridD()
{
    $cybridD = getObjectId("MissionGroup/cybridD");
    $cybridDroute = getObjectId("MissionGroup/cybridD/route");
    $cybridDlast = getObjectId("MissionGroup/cybridD/route/last");
    $cybridDleader = getObjectId("MissionGroup/cybridD/d1");
    
//    order($cybridDleader, MakeLeader, true);
//    order($cybridDleader, Speed, High);
//    order($cybridD, Formation, genericFormation);
//    order($cybridDleader, Guard, $cybridDroute);
    order($cybridD, Guard, $cybridDroute);
}

function startCybridD()
{
   initCybridD();
//   order($cybridDleader, Guard, $cybridDroute);
}

//--CYBRID E
function initCybridE()
{
 %timeDelay = 1;

 $hercNumber = 0;

echo("Creating CBrid group E");

    %howMany = countLivePlayers();

    %howMany = %howMany; // * $ratio ;

    if ( %howMany > $aiGroupMax ) %howMany = $aiGroupMax;

    %x = 2217;
    %y = 1029;

    for (%i=0; %i < %howMany; %i++ )
     {

       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridE\", \"e\",27 );", %timeDelay );
       %timeDelay = %timeDelay + 1;

//       createRandomBrid ( %x, %y, "MissionGroup/cybridE", "e", 27 );
       %x = %x + 30;
       %y = %y + 30;
       $cybridEcount = $cybridEcount + 1;

       schedule ("createRandomBrid ( " @ %x @","@ %y@", \"MissionGroup/cybridE\", \"e\",28 );", %timeDelay );
       %timeDelay = %timeDelay + 1;
//       createRandomBrid ( %x, %y, "MissionGroup/cybridE", "e", 28 );
       %x = %x + 30;
       %y = %y + 30;
       $cybridEcount = $cybridEcount + 1;
     }

       %timeDelay = %timeDelay + 1;
  schedule ("finalInitCybridE();" , %timeDelay );

//    $cybridEcount = %howMany * 2;
}
function finalInitCybridE()
{
    $cybridE = getObjectId("MissionGroup/cybridE");
    $cybridEroute = getObjectId("MissionGroup/cybridE/route");
    $cybridElast = getObjectId("MissionGroup/cybridE/route/last");
    $cybridEleader = getObjectId("MissionGroup/cybridE/e1");

//    order($cybridEleader, MakeLeader, true);
//    order($cybridEleader, Speed, High);
//    order($cybridE, Formation, genericFormation); 

//    order($cybridEleader, Guard, $cybridEroute);

   schedule (" order($cybridE, Guard, $cybridEroute); ", 1);
}

function startCybridE()
{
   initCybridE();
}


function checkHercsDestroyed()
{

echo ("brid counts are " @ $cybridAcount @ " "@ $cybridBcount @ " "@ $cybridCcount @ " "@ $cybridDcount @ " "@ $cybridEcount @ "<");

    if($cybridAcount <= 0 && $cybridBcount <= 0 && $cybridCcount <= 0 &&
       $cybridDcount <= 0 && $cybridEcount <= 0 )
    {
         $missionObj3Status = True;

        playSound(0, "GEN_OC01.wav", IDPRF_2D);
        say (0,0,"Mission Objective completed, All brids destroyed");


        schedule("winCondition();", 5.0);
    }       
}


//-----------------------------------------------------------------------------
function missionFailed()
{
  flushConsoleScheduler();
  messageBox(0, "Mission Failed" );
  missionendconditionmet();
}

//-----------------------------------------------------------------------------
function winCondition()
{

//$missionObj1Status = True; // base destroyed 
//$missionObj2Status = False; // all turrets online
//$missionObj3Status = False; // all brids destroyed

  flushConsoleScheduler();
  %howmany = 0;

  %text = "\nBase was not destroyed ";
  if ( $missionObj1Status == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  %text = %text @ %text = "\nAll turrets online ";
  if ( $missionObj2Status == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }


  %text = %text @ %text = "\nAll Brids Destroyed ";
  if ( $missionObj3Status == true )
    {
     %howmany++;
     %text = %text @ "Successful";
    }
   else
    {
     %text = %text @ "Failed";
    }

  if ( %howmany == 3 ) %text = %text @ "\nExcellent work team.";

  messageBox(0, "Mission Completed, " @ %howmany @ " of 3 objectives completed. "@ %text );
  missionendconditionmet();
}

function pickBridDrop()
{

  %notFound = true;

  %exitCntr = 0;

 while ( %notFound )
   {

    %which = randomInt (1,4);

    if (( $point1used == False ) && 
        ( %which == 1 ))
      {
        %notFound = false;
        $point1used = True;
        return %which;
      }

    if (( $point2used == False )  && 
        ( %which == 2 ))
      {
        %notFound = false;
        $point2used = True;
        return %which;
      }

    if (( $point3used == False )  && 
        ( %which == 3 ))
      {
        %notFound = false;
        $point3used = True;
        return %which;
      }

    if (( $point4used == False )  && 
        ( %which == 4 ))
      {
        %notFound = false;
        $point4used = True;
        return %which;
      }

  %exitCntr = %exitCntr + 1;
  if  ( %exitCntr > 100 )
    {
      echo ("Random drid drop pick failed");
      return %which;
    }

   }

}

function getBridDropX (%which)
{
  if ( %which == 1 ) return $point1x;
  if ( %which == 2 ) return $point2x;
  if ( %which == 3 ) return $point3x;
  if ( %which == 4 ) return $point4x;
}


function getBridDropY (%which)
{
  if ( %which == 1 ) return $point1y;
  if ( %which == 2 ) return $point2y;
  if ( %which == 3 ) return $point3y;
  if ( %which == 4 ) return $point4y;
}


