// FILENAME:	Mi_Casa_3.cs
//
// AUTHORS:     Maria Wolfe
//------------------------------------------------------------------------------

$missionName = "Mi_Casa_3";

$server::HudMapViewOffsetX = -3500; 
$server::HudMapViewOffsetY = 0; 

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = false;

	$server::disableTeamYellow = false;
	$server::disableTeamBlue = true;
	$server::disableTeamRed = false;
	$server::disableTeamPurple = true;

}

function onMissionStart()
{
	earthquakeSounds();
	venusSounds();
}

function onMissionLoad()
{
   cdAudioCycle("Cloudburst", "Terror", "Watching"); 
   %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
            "<tIDMULT_STD_HEAL>"       @
            "<tIDMULT_STD_RELOAD>";

   setGameInfo(%rules);

order("MissionGroup/AITeam1",speed,high);
order("MissionGroup/AITeam1",guard,"MissionGroup/AITeam1/Path");

order("MissionGroup/AITeam2",speed,medium);
order("MissionGroup/AITeam2",guard,"MissionGroup/AITeam2/Path");

order("MissionGroup/AITeam3",speed,medium);
order("MissionGroup/AITeam3",guard,"MissionGroup/AITeam3/Path");

order("MissionGroup/AITeam4",speed,high);
order("MissionGroup/AITeam4",guard,"MissionGroup/AITeam4/Path");

order("MissionGroup/AITeam5",speed,high);
order("MissionGroup/AITeam5",guard,"MissionGroup/AITeam5/Path");     

}

function ZenTransporter::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 8400, 1900, 400);
}

function ZenTransporter2::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 0, 6500, 400);
}

function ZenTransporter3::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -6600, -6900, 400);
}
