$missionName = "MercTraining";

$server::HudMapViewOffsetX = 500; 
$server::HudMapViewOffsetY = 4000; 

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = false;
   $server::AllowDeathmatch = false;
   $server::AllowTeamPlay = true;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = false;
   $server::AllowTeamYellow = true;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed =false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
   mercurySounds();
   $dead = 0;
}

function onMissionLoad()
{
   cdAudioCycle("SS3", "Watching", "Cloudburst"); 
}

function vehicle::onDestroyed(%this, %destroyer);
{
   %teamdead = getTeam(%this);

   if( %teamdead == *ID_STR_TEAM_YELLOW )
   {
      $dead++
      checkforWin();
   }
   else
   {
      setDominantCamera(%destroyer, %this);
   }
}

function checkforWin()
{
   if( $dead == 21 )
   {
      setDominantCamera(%destroyer, %this);
      order( %destroyer, Guard, "MissionGroup/RedBase" );

      fadeEvent( 0, out, 30, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 30 );
   }
   else
   {
      order( "MissionCleanup" Attack, %destroyer );
   }
}

//