$missionName = "CraterBase";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = false;
   $server::AllowDeathmatch = true;
   $server::AllowTeamPlay = true;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = false;
   $server::AllowTeamYellow = true;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed =false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}


function onMissionStart()
{
	marsSounds();
	windSounds();
}

function onMissionLoad()
{
   cdAudioCycle("Mechsoul", "Terror", "Cybernetix"); 
}

function deathmatchTransport(%this, %vehicleId)
{
   %teamName = getTeam(%vehicleId);
   
   %huh = randomInt(1, 5);
   if(%huh == 1)
   {
      transportToYellowBase(%vehicleId);
   }
   else if(%huh == 2)
   {
      transportToBlueBase(%vehicleId);
   }
   else if(%huh == 3)
   {
      transportToRedBase(%vehicleId);
   }
   else if(%huh == 4)
   {
      transportToPurpleBase(%vehicleId);
   }
   else
   {
      transportToMountain(%vehicleId);
   }
}

function YellowTransporter::trigger::onEnter(%this, %vehicleId)
{
   if($server::TeamPlay == false)
   {
      deathmatchTransport(%this, %vehicleId);
      return;
   }

   %teamName = getTeam(%vehicleId);
   
   if(%teamName == *IDSTR_TEAM_YELLOW)
   {
      %huh = randomInt(1, 4);
      if(%huh == 1)
      {
         transportToBlueBase(%vehicleId);
      }
      else if(%huh == 2)
      {
         transportToBlueBase(%vehicleId);
      }
      else if(%huh == 3)
      {
         transportToBlueBase(%vehicleId);
      }
      else
      {
         transportToMountain(%vehicleId);
      }
   }
   else
   {
      transportToRedBase(%vehicleId);
   }
}

function BlueTransporter::trigger::onEnter(%this, %vehicleId)
{
   if($server::TeamPlay == false)
   {
      deathmatchTransport(%this, %vehicleId);
      return;
   }

   %teamName = getTeam(%vehicleId);
  
   if(%teamName == *IDSTR_TEAM_BLUE)
   {
      %huh = randomInt(1, 4);
      if(%huh == 1)
      {
         transportToYellowBase(%vehicleId);
      }
      else if(%huh == 2)
      {
         transportToRedBase(%vehicleId);
      }
      else if(%huh == 3)
      {
         transportToPurpleBase(%vehicleId);
      }
      else
      {
         transportToMountain(%vehicleId);
      }
   }
   else
   {
      transportToHomeBase(%vehicleId);
   }
}

function RedTransporter::trigger::onEnter(%this, %vehicleId)
{
   if($server::TeamPlay == false)
   {
      deathmatchTransport(%this, %vehicleId);
      return;
   }
   
   %teamName = getTeam(%vehicleId);
   
   if(%teamName == *IDSTR_TEAM_RED)
   {
      %huh = randomInt(1, 4);

      if(%huh == 1)
      {
         transportToYellowBase(%vehicleId);
      }
      else if(%huh == 2)
      {
         transportToYellowBase(%vehicleId);
      }
      else if(%huh == 3)
      {
         transportToYellowBase(%vehicleId);
      }
      else
      {
         transportToMountain(%vehicleId);
      }
   }
   else
   {
      transportToYellowBase(%vehicleId);
   }
}

function PurpleTransporter::trigger::onEnter(%this, %vehicleId)
{
   if($server::TeamPlay == false)
   {
      deathmatchTransport(%this, %vehicleId);
      return;
   }

   %teamName = getTeam(%vehicleId);

   if(%teamName == *IDSTR_TEAM_PURPLE)
   {
      %huh = randomInt(1, 4);
      
      if(%huh == 1)
      {
         transportToBlueBase(%vehicleId);
      }
      else if(%huh == 2)
      {
         transportToRedBase(%vehicleId);
      }
      else if(%huh == 3)
      {
         transportToYellowBase(%vehicleId);
      }
      else
      {
         transportToMountain(%vehicleId);
      }
   }
   else
   {
      transportToHomeBase(%vehicleId);
   }
}

function transportToBlueBase(%vehicleId)
{
   echo("Transporting to Blue Base");
   randomTransport(%vehicleId, 2800, 1055, 2800);
}

function transportToYellowBase(%vehicleId)
{
   echo("Transporting to Yellow Base");
   randomTransport(%vehicleId, 2519, 950, 2519);
}

function transportToRedBase(%vehicleId)
{
   echo("Transporting to Red Base");
   randomTransport(%vehicleId, 2800, 1055, 2800);
}

function transportToPurpleBase(%vehicleId)
{
   echo("Transporting to Purple Base");
   randomTransport(%vehicleId, 2519, 950, 2519);
}

function transportToMountain(%vehicleId)
{
   randomTransport(%vehicleId, 2800, 1055, 2800);
}

function transportToHomeBase(%vehicleId)
{
   %teamName = getTeam(%vehicleId);

   if(%teamName == *IDSTR_TEAM_YELLOW)
   {
      transportToYellowBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_RED)
   {
      transportToRedBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_BLUE)
   {
      transportToBlueBase(%vehicleId);
   }
   else
   {
      transportToPurpleBase(%vehicleId);
   }   
}

//