// FILENAME:	Lumberjack.cs
//
// AUTHORS:  	   Orogogus
// EMAIL:        h2liu@iname.com
// WEBSITE:      http://home.san.rr.com/orogogus
// LAST UPDATED: 12:08 AM 2/9/00
//
//------------------------------------------------------------------------------


$missionName = "Dystopia";
$nameOfTheGame = "test";
exec("multiplayerStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

  // what can the server admin choose for available teams
  $server::disableTeamRed = true;
  $server::disableTeamBlue = false;
  $server::disableTeamYellow = true;
  $server::disableTeamPurple = false;
}


setDefaultMissionOptions();



Pilot GoadMole
{
   id = 28;
   
   skill = 0.8;
   accuracy = 0.8;
   aggressiveness = 0.5;
   activateDist = 2000.0;
   deactivateBuff = 3000.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "GoadMole";
};


$totalFlags = 4;

$blueStands = 4;          // Normally, I would expect all these to be the same
$purpleStands = 4;        // However, there's nothing that says they have to be
$redStands = 0;           // And it's easier to make it more flexible the first
$yellowStands = 0;        // time than to change it later
$blueToWin = 4;
$purpleToWin = 4;
$redToWin = 4;
$yellowToWin = 4;


$blueScore = 0;
$purpleScore = 0;
$pointsToWin = 5;

exec("FnRStdLib.cs");



function setDefaultMissionItems() 
{
	exec("defaultVehicles");
  allowComponent("all", true);
  allowWeapon("all", true);
}


function onMissionStart()
{
  throwTrees();
}


function throwTrees()
{
  %x1 = getPosition($blueStand[1], x);
  %x2 = getPosition($purpleStand[1], x);
  %y1 = getPosition($blueStand[1], y);
  %y2 = getPosition($purpleStand[1], y);

  %baseX = (%x1 + %x2) / 2;
  %baseY = (%y1 + %y2) / 2;
  %z = getTerrainHeight(%x, %y);

  %center = getObjectId("MissionGroup\\center");
  setPosition(%center, %baseX, %baseY, %baseZ);

  %rangeX = getDistance(%center, $blueStand[1]);
  %rangeY = 0.5 * getDistance(%center, $blueStand[1]);

  %xA = %baseX - %rangeX;
  %xB = %baseX + %rangeX;
  %yA = %baseY - %rangeY;
  %yB = %baseY + %rangeY;

  for(%i = 1; %i < ($totalFlags+1); %i++)
  {
    %x = randomInt(%xA, %xB);
    %y = randomInt(%yA, %yB);
    %z = getTerrainHeight(%x, %y);

    dropPod(%x, %y, %z, %flag[%i]);

    schedule("setPosition(" @ $flag[%i] @ ", " @ %x @ ", " @ %y @ ", " @ %z @ ");", 5);
    schedule("setPosition(" @ $flagTrigger[%i] @ ", " @ %x @ ", " @ %y @ ", " @ %z @ ");", 5);
  }

    $gameOver = 0;
    say("everyone", 0, "Flags on the playing field!");
}



function flag::structure::OnAttacked(%target, %attacker)
{
  %player = playerManager::vehicleIdToPlayerNum(%attacker);
  %target = getObjectId(%target);

  %tTempX = getPosition(%target, x);
  %tTempY = getPosition(%target, y);

  %aTempX = getPosition(%attacker, x);
  %aTempY = getPosition(%attacker, y);

  %tVectorX = %aTempX - %tTempX;
  %tVectorY = %aTempY - %tTempY;

  %howFar = getDistance(%target, %attacker) / (40);

  $ShotNumber++;
  %striker = $ShotNumber;
  $moveCounter = 1;
  schedule("gradMove("@%target@", "@%tTempX@", "@%tTempY@", "@%TVectorX@", "@%TVectorY@", "@%howFar@", "@%striker@");", 0.01);
}


function gradMove(%target, %tTempX, %tTempY, %tVectorX, %tVectorY, %howFar, %striker)
{
  if(%striker != $ShotNumber)
  {
    return;
  }

  %TXa = %tVectorX / %howFar;
  %TYa = %tVectorY / %howFar;

  %TXb = $moveCounter / 100;
  %TYb = $moveCounter / 100;

  %newTX =  %TXa * %TXb;
  %newTY =  %TYa * %TYb; 

  %newTPosX = (%tTempX - %newTX);
  echo(%newTPosX);
  %newTPosY = (%tTempY - %newTY);
  %newTPosZ = (getTerrainHeight(%newTPosX, %newTPosY) - 2);

  setPosition(%target, %newTPosX, %newTPosY, %newTPosZ);
  setPosition(%target.trigger, %newTPosX, %newTPosY, %newTPosZ);

  $moveCounter++;

  if($moveCounter < 101)
  {
    schedule("gradMove("@%target@", "@%tTempX@", "@%tTempY@", "@%TVectorX@", "@%TVectorY@", "@%howFar@", "@%striker@");", 0.01);
  }
}

//====================================



function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

  // Player ScoreBoard column headings
  $ScoreBoard::PlayerColumnHeader1 = *IDMULT_SCORE_TEAM;
  $ScoreBoard::PlayerColumnHeader2 = *IDMULT_SCORE_SQUAD;

  // Player ScoreBoard column functions
  $ScoreBoard::PlayerColumnFunction1 = "getTeam";
  $ScoreBoard::PlayerColumnFunction2 = "getSquad";

  // Team ScoreBoard column headings
  $ScoreBoard::TeamColumnHeader1 = *IDMULT_SCORE_SCORE;
  $ScoreBoard::TeamColumnHeader2 = *IDMULT_SCORE_PLAYERS;

  // Team ScoreBoard column functions
  $ScoreBoard::TeamColumnFunction1 = "getTeamScore";
  $ScoreBoard::TeamColumnFunction2 = "getNumberOfPlayersOnTeam";

  // tell server to process all the scoreboard definitions defined above
  serverInitScoreBoard();
}


function getTeamScore(%team)
{
	%team = getTeamNameFromTeamId(%team);
	if(%team == *IDSTR_TEAM_PURPLE) 
	{
		return($purpleScore);
	}
	if(%team == *IDSTR_TEAM_BLUE) 
	{
		return($blueScore);
	}

	return 0;
} 



function addFlag(%color)
{
  if(%color == *IDSTR_TEAM_BLUE)
  {
    $blueFlags++;
    if($blueFlags >= $blueToWin)
    {
      say("everyone", 0, "The Blue Team has won the round!");
      $blueScore++;
      if($blueScore < $pointsToWin)
       say("everyone", 0, "Blue team needs " @ ($pointsToWin - $blueScore) @ " more points to win");
      $gameOver = 1;
      throwTrees();
    }

    if($blueScore >= $pointsToWin)
    {
      say("everyone", 0, "The Blue Team has won the game!");
      schedule("missionEndConditionMet();", 10);
      $gameOver = 1;
    }
  }

  if(%color == *IDSTR_TEAM_PURPLE)
  {
    $purpleFlags++;
    if($purpleFlags >= $purpleToWin)
    {
      say("everyone", 0, "The Purple Team has won the round!");
      $purpleScore++;
      if($purpleScore < $pointsToWin)
       say("everyone", 0, "Purple team needs " @ ($pointsToWin - $purpleScore) @ " more points to win");
      $gameOver = 1;
      throwTrees();
    }

    if($purpleScore >= $pointsToWin)
    {
      say("everyone", 0, "The Purple Team has won the game!");
      schedule("missionEndConditionMet();", 10);
      $gameOver = 1;
    }
  }
}