// FILENAME:	DM_Heavens_Peak.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DM_Invasion";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to DM_Invasion!  This map designed by ''|''mJ.  This and other maps are available at http://www6.50megs.com/temujin.  At this site you will also find Temujin's skin collections and training manual.");
}

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Newtech", "Cyberntx"); 
}

// move the map
$server::HudMapViewOffsetX = -2575;
$server::HudMapViewOffsetY = 2050;

function onMissionStart()
{
	$healRate = 100;   
	$ammoRate = 3;
   	$padWaitTime = 45;
  	$zenWaitTime = 90;
	
	temperateSounds();
}

// Healing Pad Functionality
//------------------------------------------------------------------------------

function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}

function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------

function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------

function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}

function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}

// Instant Heal/Reload function
//------------------------------------------------------------------------------

function Fire::trigger::onEnter(%this, %object) 
{
      say(%object, 0, "Repair and Reload complete...");
	Zen::work(%this, %object, 100000, 100, 0, false);
}

// Transport Pod Functionality
//------------------------------------------------------------------------------

function GoUp::trigger::onEnter(%this, %vehicleId)
{
   say(%vehicleId, 0, "Transportation to orbiter complete...");

   %x = randomInt( -2635, -2515 );
   %y = randomInt( 1990, 2110 );

   if(%x > -2585 && %x < -2565) %x = -2600;
   if(%y > 2040 && %y < 2060) %y = 2075;

   setPosition(%vehicleId, %x, %y, 2455);
}

function GoDown::trigger::onEnter(%this, %vehicleId)
{
	%roll = randomInt( 1, 12 );
      say(%vehicleId, 0, "Transportation to earth complete...");

      if(%roll == 1) {
		setPosition(%vehicleId, -2760, 2050, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod1");
		}
      else if(%roll == 2) {
		setPosition(%vehicleId, -2760, 1942, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod2");
		}
      else if(%roll == 3) {
		setPosition(%vehicleId, -2660, 1900, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod3");
		}
      else if(%roll == 4) {
		setPosition(%vehicleId, -2575, 1830, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod4");
		}
      else if(%roll == 5) {
		setPosition(%vehicleId, -2480, 1890, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod5");
		}
      else if(%roll == 6) {
		setPosition(%vehicleId, -2382, 1942, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod6");
		}
      else if(%roll == 7) {
		setPosition(%vehicleId, -2390, 2047, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod7");
		}
      else if(%roll == 8) {
		setPosition(%vehicleId, -2382, 2148, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod8");
		}
      else if(%roll == 9) {
		setPosition(%vehicleId, -2474, 2207, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod9");
		}
      else if(%roll == 10) {
		setPosition(%vehicleId, -2574, 2275, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod10");
		}
      else if(%roll == 11) {
		setPosition(%vehicleId, -2668, 2205, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod11");
		}
	else {
		setPosition(%vehicleId, -2761, 2143, 100);
 		%target = getObjectId("MissionGroup\\BLUE\\Pod12");
		}

	playAnimSequence(%target, 0, true);
	schedule("ClosePod("@%target@");", 2 );
}

function ClosePod(%this){
	playAnimSequence(%this, 0, false);
}
