// FILENAME: Server_AI_Mars_19th_Assault.cs
//Team Deathmatch Server


exec(serverLocation);
//-------------------------------------------------
//  RC file to start a server automatically
//-------------------------------------------------

//-------------------------------------------------
// Edit the parameters of this file to configure
// your server options. Use notepad, not a word
// processor. File must be saved as text only.
//-------------------------------------------------

//-------------------------------------------------
// Type the name for your server inside the quotes
// Must be less then 22 characters
//-------------------------------------------------
$server::Hostname =                                strcat("AI Mars 19th Assault");

//-------------------------------------------------
// Password Protection. Leave blank for none.
// Quotes optional.
//-------------------------------------------------
$server::Password =                                 "";

//-------------------------------------------------
// Maximum player limit. 16 is highest recommended.
//-------------------------------------------------
$server::MaxPlayers =                             2;

//-------------------------------------------------
// Number of kills before server cycles.
// If zero, kills are never reset.
//-------------------------------------------------
$server::FragLimit =                               0;

//-------------------------------------------------
// Time limit in minutes before server cycles.
// Must be a positive integer.
//-------------------------------------------------
$server::TimeLimit =                               20;

//-------------------------------------------------
// Mass limit per player
// Must be a positive integer or zero for no limit.
//-------------------------------------------------
$server::MassLimit =                               0;

//-------------------------------------------------
// Combat Value limit per player
// Must be a positive integer or zero for no limit.
//-------------------------------------------------
$server::CombatValueLimit =                         0;

//-------------------------------------------------
// Team play options. TeamPlay false =  deathmatch.
// TeamPlay true = teams
//-------------------------------------------------
$server::TeamPlay =                                true;

//-------------------------------------------------
// Team Mass limit - valid only when teamPlay is true
// Must be a positive integer or zero for no limit.
//-------------------------------------------------
$server::TeamMassLimit =                            0;

//-------------------------------------------------
// Team Combat Value Limit - valid only when teamPlay is true
// Must be a positive integer or zero for no limit.
//-------------------------------------------------
$server::TeamCombatValueLimit =                     0;

//-------------------------------------------------
// Tech Level Limit
// Must be a positive integer less then or
// equal to 128 or zero for no limit.
//-------------------------------------------------
$server::TechLevelLimit =                          0;

//-------------------------------------------------
// Drop In Progress
// Does server allow drop in progress??
//-------------------------------------------------
$server::DropInProgress =                            TRUE  ;

$server::AllowMixedTech =                            TRUE  ;
$server::FactoryVehOnly =                           FALSE  ;
$server::AllowTeamRed =                            TRUE  ;
$server::AllowTeamYellow =                          FALSE  ;
$server::AllowTeamBlue =                             false ;
$server::AllowTeamPurple =                         FALSE  ;

//-------------------------------------------------
// Mission rotation list. This is the order the
// worlds will cycle in a game with either the frag
// or time limits set.
//-------------------------------------------------
$MissionCycling::Stage0 =                          "AI_Mars_19th_Assault.cs";


//-------------------------------------------------
// Start mission. Defines which mission from the
// rotation list the server starts on.
//-------------------------------------------------
$server::Mission =                                  $MissionCycling::Stage0;

//Vehicles
exec("defaultVehicles.cs");
allowComponent(                                    all,      True );

//weapons
allowWeapon(                                       all,    True  );


// These items will be allowed by default -- your mission script can change these
// by calling allowVehicle, allowComponent, or allowWeapon
function setAllowedItems()
{
	//Vehicles
	allowVehicle( all, false);
	allowVehicle(                                           20,  TRUE  );      //Seeker
	allowVehicle(                                           21,  TRUE  );      //Goad
	allowVehicle(                                           22,  TRUE  );      //Shepherd
	allowVehicle(                                           23,  TRUE  );      //Adjudicator
	allowVehicle(                                           24,  TRUE  );      //Executioner
	allowVehicle(                                            4,  TRUE  );      //Terran Talon
	allowVehicle(                                           13,  TRUE  );      //Knight's Talon
	allowVehicle(                                            2,  TRUE  );      //Terran Minotaur
	allowVehicle(                                           11,  TRUE  );      //Knight's Minotaur
	allowVehicle(                                            5,  TRUE  );      //Terran Basilisk
	allowVehicle(                                           14,  TRUE  );      //Knight's Basilisk
	allowVehicle(                                            1,  TRUE  );      //Terran Apocalypse
	allowVehicle(                                           10,  TRUE  );      //Knight's Apocalypse
	allowVehicle(                                           40,  TRUE );      //Harabec's Apocalypse
	allowVehicle(                                            3,  TRUE  );      //Terran Gorgon
	allowVehicle(                                           12,  TRUE  );      //Knight's Gorgon
	allowVehicle(                                           30,  TRUE  );      //Emancipator
	allowVehicle(                                           33,  TRUE  );      //Olympian
	allowVehicle(                                           52,  True );      //Pirate Emancipator
	allowVehicle(                                           55,  TRUE  );      //Player Plat Adjudicator
	allowVehicle(                                           56,  TRUE  );      //Player Plat Executioner
	allowVehicle(                                           35,  TRUE  );      //Metagen Seeker
	allowVehicle(                                           36,  TRUE  );      //Metagen Goad
	allowVehicle(                                           37,  TRUE  );      //Metagen Shepherd

	allowVehicle(                                           25,  TRUE  );      //Bolo
	allowVehicle(                                           26,  TRUE  );      //Recluse
	allowVehicle(                                           41,  True );      //Predator
	allowVehicle(                                           31,  TRUE  );      //Avenger
	allowVehicle(                                           32,  TRUE  );      //Dreadlock
	allowVehicle(                                            8,  True );      //Disrupter
	allowVehicle(                                            7,  TRUE  );      //Myrmidon
	allowVehicle(                                            6,  TRUE  );      //Paladin
	allowVehicle(                                           17,  TRUE );      //Knight Disrupter
	allowVehicle(                                           16,  TRUE  );      //Knight Myrmidon
	allowVehicle(                                           15,  TRUE  );      //Knight Paladin
	allowVehicle(                                          138,  TRUE  );
	allowVehicle(                                          150,  TRUE  );

	//weapons
	allowWeapon(                                       all,     TRUE  );
	allowWeapon(                                           101,  TRUE  );      //Laser
	allowWeapon(                                           102,  TRUE  );      //Heavy Laser
	allowWeapon(                                           103,  TRUE  );      //Comp Laser
	allowWeapon(                                           104,  TRUE  );      //Twin Laser
	allowWeapon(                                           105,  TRUE  );      //Emp
	allowWeapon(                                           106,  TRUE  );      //ELF
	allowWeapon(                                           107,  TRUE  );      //Blaster
	allowWeapon(                                           108,  TRUE  );      //Heavy Blaster
	allowWeapon(                                           109,  TRUE  );      //PBW
	allowWeapon(                                           110,  TRUE  );      //Plasma
	allowWeapon(                                           111,  TRUE  );      //Blink Gun
	allowWeapon(                                           112,  TRUE  );      //Qgun
	allowWeapon(                                           113,  TRUE  );      //MFAC
	allowWeapon(                                           114,  TRUE  );      //Nano Infuser
	allowWeapon(                                           115,  TRUE  );      //Nanite Cannon
	allowWeapon(                                           116,  TRUE  );      //Autocannon
	allowWeapon(                                           117,  TRUE  );      //Hvy Autocannon
	allowWeapon(                                           118,  TRUE  );      //EMC Autocannon
	allowWeapon(                                           119,  TRUE  );      //Blast Cannon
	allowWeapon(                                           120,  TRUE  );      //Hvy Blast Can
	allowWeapon(                                           121,  TRUE  );      //Rail Gun
	allowWeapon(                                           124,  TRUE );      //Pit Viper 8
	allowWeapon(                                           125,  TRUE );      //Pit Viper 12
	allowWeapon(                                           126,  TRUE );      //Sparrow 6
	allowWeapon(                                           127,  TRUE );      //Sparrow 10
	allowWeapon(                                           128,  TRUE );      //SWARM 6
	allowWeapon(                                           129,  TRUE );      //Minion
	allowWeapon(                                           130,  TRUE );      //Shrike 8
	allowWeapon(                                           147,  TRUE );      //Aphid
	allowWeapon(                                           131,  TRUE );      //Arachnitron 4
	allowWeapon(                                           132,  TRUE );      //Arachnitron 8
	allowWeapon(                                           133,  TRUE );      //Arachnitron 12
	allowWeapon(                                           134,  TRUE );      //Proximity 6
	allowWeapon(                                           135,  TRUE );      //Proximity 10
	allowWeapon(                                           136,  TRUE );      //Proximity 15
	allowWeapon(                                           142,  TRUE  );      //Radiation Gun
	allowWeapon(                                             3,  TRUE );      //Disrupter
	allowWeapon(                                           150,  TRUE );      //SMART Gun
}