// FILENAME:	TDM_Mars_19th_Assualt.cs
//
// AUTHOR:  	Koyote
//------------------------------------------------------------------------------

$missionName = "TDM_Mars_19th_Assualt";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

//-----------------------------------------------------------------------------

Pilot Trainer
{
   id = 28;
   
   skill =1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 2000.0;
   deactivateBuff = 3000.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "Trainer";
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}

//-----------------------------------------------------------------------------

function player::onAdd(%this)
{
   for ( %i=0; %i<3; %i++ )
      %this.AI[%i] = 0;

   %this.numKills = 0;

   say(%this, 0, "Welcome to the Iron Brigade's AI 19th Mars Training!");
   say(%this, 0, "Koyote -IRON- Welcomes all Players to Mars!");
   say(%this, 0, "Two AI Hercs will Attack Each Player!");
   say(%this, 0, "Iron Brigade at http://pluto.spaceports.com/~ibrigade/main.html"); 
   say(%this, 0, "Visit Koyote's Den at http://members.xoom.com/Koyotes_Den/");
}

//-----------------------------------------------------------------------------
// When humans drop in, assign an AI to attack them.
// Remove extra AI's if they had AI's but dropped in at a lower base.

function vehicle::onAdd(%vehicle)
{
   %player = playerManager::vehicleIdToPlayerNum(%vehicle);

   if( %player ) // which means it's a human
   {
      echo ("--------- players AI[0] ", %player.AI[0] );
      echo ("--------- players AI[1] ", %player.AI[1] );
      echo ("--------- players AI[2] ", %player.AI[2] );

      if ( %player.AI[0] ) 
         schedule( "order(" @ %player.AI[0] @ ",attack," @ %vehicle @ ");", 5 );
      else
         schedule( "dropNewVehicle(" @ %player @ ");", 5 );

      if ( getTeam(%vehicle) != *IDSTR_TEAM_BLUE )
      {
         if ( %player.AI[1] ) 
            schedule( "order(" @ %player.AI[1] @ ",attack," @ %vehicle @ ");", 5 );
         else
            schedule( "dropNewVehicle(" @ %player @ ");", 5 );
      }
      else if ( %player.AI[1] )
      {
         deleteObject( %player.AI[1] );
         %player.AI[1] = 0;
      }

      if ( getTeam(%vehicle) != *IDSTR_TEAM_RED )
      {
         if ( %player.AI[2] ) 
            schedule( "order(" @ %player.AI[2] @ ",attack," @ %vehicle @ ");", 5 );
         else
            schedule( "dropNewVehicle(" @ %player @ ");", 5 );
      }
      else if ( %player.AI[2] )
      {
         deleteObject( %player.AI[2] );
         %player.AI[2] = 0;
      }
   }
}

//-----------------------------------------------------------------------------
// If player goes, get rid of his associated AI's too

function player::onRemove( %player )
{
   for ( %i=0; %i<3; %i++ )
   {
      if ( %player.AI[%i] )
         deleteObject( %player.AI[%i] );
   }
}

//-----------------------------------------------------------------------------

function vehicle::onDestroyed( %victimVeh, %destroyerVeh )
{
   if( getTeam( %destroyerVeh ) != getTeam( %victimVeh ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyerVeh );
      %player.numKills++;      
      $HumanKills++;
   }

   //----------------------------------------------------------------
   // if it's an AI, drop a new one 
   if( getTeam( %victimVeh ) == *IDSTR_TEAM_PURPLE )
   {
      for ( %i=0; %i<4; %i++ )
      {
         %player = %victimVeh.owner;
         if ( %player.AI[%i] == %victimVeh )
         {
            %player.AI[%i] = 0;
            break;
         }
      }

// if you use resapawnVehicle instead of dropNewVehicle, you'll get the
// same AI opponent back after you kill him.
//      schedule( "respawnVehicle(" @ %victimVeh @ "," @ %destroyerVeh @ ");", 5 );

      schedule( "dropNewVehicle(" @ %player @ ");", 5 );

   }
   else
      $AIKills++;
}

//-----------------------------------------------------------------------------
// this creates a new random AI Herc

function getRandomAI()
{
   // check for valid ranges
   %i = RandomInt(1,28);
   if ( %i>8 && %i<10 )
      %i = RandomInt(1,8);
   if ( %i>17 && %i<20 )
      %i = RandomInt(20,28);

   // get appropriate type Tank or Herc
   %type = Herc;
   if ( %i>5  && %i<= 8 )   %type = Tank;
   if ( %i>14 && %i<= 17 )  %type = Tank;
   if ( %i>24 && %i<= 26 )  %type = Tank;

   return NewObject( "AI" @ %i, %type, %i );
}

//-----------------------------------------------------------------------------
// this gives you a new random AI Herc

function dropNewVehicle( %player )
{
   %playerVeh = playerManager::playerNumToVehicleId(%player);                                                                                    
   %herc = getRandomAI();
   setTeam( %herc, *IDSTR_TEAM_PURPLE );
   setPilotId(%herc,28);
   %x = getPosition(%playerVeh,x)+RandomInt(-400,400);
   %y = getPosition(%playerVeh,y)+RandomInt(-400,400);
   %z = getPosition(%playerVeh,z)+150;
   setPosition( %herc, %x, %y, %z);
   schedule( "order(" @ %herc @ ",attack," @ %playerVeh @ ");", 5 );

   %herc.owner = %player;
   for ( %i=0; %i<4; %i++ )
   {
      if ( !%player.AI[%i] )
      {
         %player.AI[%i] = %herc;
         break;
      }
   }
}

//-----------------------------------------------------------------------------
// this respawns the AI Herc that just died

function respawnVehicle( %oldVeh, %destroyer )
{
   %player = playerManager::vehicleIdToPlayerNum( %destroyer );

   %x = getPosition(%destroyer,x)+200;
   %y = getPosition(%destroyer,y)+200;
   %z = getPosition(%destroyer,z)+150;

   %herc = hercVehicle(%oldVeh);
   setPosition(%herc, %x, %y, %z);
   schedule( "deleteObject(" @ %oldVeh @ ");", $respawnDealNoHq + 10 );
   addToSet( "MissionGroup", %herc );

   %herc.owner = %player;
   for ( %i=0; %i<4; %i++ )
   {
      if ( !%player.AI[%i] )
      {
         %player.AI[%i] = %herc;
         break;
      }
   }
}