// FILENAME:	Full_Force.cs | v.0.9 |
//
// AUTHOR:  	GM Mad Dog^WP^
//------------------------------------------------------------------------------

$missionName = "Full_Force";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");
exec("pilots.cs");

// to disable team damage in the server, comment these two lines
$server::TeamDamage =		true;
$enableTeamHittingPenalty = 	"true";

// Global Variables
// -------------------------------------------------------------------------
$hAd = 0; // Hercs at doors


// Default game info
// -------------------------------------------------------------------------
function setDefaultMissionOptions()
{
  $server::TeamPlay = true;
  $server::AllowDeathmatch = true;
  $server::AllowTeamPlay = true;	

  $server::AllowTeamRed = true;
  $server::AllowTeamBlue = false;
  $server::AllowTeamYellow = true;
  $server::AllowTeamPurple = false;

  $server::disableTeamRed = false;
  $server::disableTeamBlue = true;
  $server::disableTeamYellow = false;
  $server::disableTeamPurple = true;
}


// Mission load variables
// -------------------------------------------------------------------------
function onMissionLoad()
{
  %jmsg = "<f5>Full_Force v.0.9\n\n<f4>Here is one of the only all indoor maps you'll find in Starsiege; built off of Sentinal [M.I.B.]'s DM_Mineshaft. As with all Mhaddy maps, there are a ton of easter eggs scattered around. Be careful of your step and watch out for, *ahem* nevermind.";
  setGameInfo(%jmsg); 
  cdAudioCycle("Newtech", "CloudBurst", "Terror"); 
}


// When the mission starts ...
// -------------------------------------------------------------------------
function onMissionStart()
{
  marsSounds();
}


// When a player joins the game, say this ...
// -------------------------------------------------------------------------
function player::onAdd(%this)
{
  player::onAddLog(%this);
  say(%this,0,"<f4>----=(*)=----<f1>[ IMPORTANT! ]<f4>----=(*)=----");
  say(%this,0,"Click on the blinking question mark for customized game info.","F3_Riana_woo.WAV");
}  


// Open / close doors for HERCs
// -------------------------------------------------------------------------
function door::trigger::onEnter(%this, %vehicleId)
{
  if($hAd == 0)
  {
    playAnimSequence(getObjectId("MissionGroup\\Misc\\door"), 0, true);
  }
  $hAd = $hAd + 1;
}

function door::trigger::onLeave(%this, %vehicleId)
{
  $hAd = $hAd - 1;
  if($hAd == 0)
  {
    playAnimSequence(getObjectId("MissionGroup\\Misc\\door"), 0, false);
  }
}

function L2d::trigger::onEnter(%this, %vehicleId)
{
  if($hAd == 0)
  {
    playAnimSequence(getObjectId("MissionGroup\\L2\\L2dw"), 0, true);
  }
  $hAd = $hAd + 1;
}

function L2d::trigger::onLeave(%this, %vehicleId)
{
  $hAd = $hAd - 1;
  if($hAd == 0)
  {
    playAnimSequence(getObjectId("MissionGroup\\L2\\L2dw"), 0, false);
  }
}


// Heh, watch your step
// -------------------------------------------------------------------------
function boom::trigger::onContact(%this, %vehicleId)
{
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
}

function mineshaft::trigger::onEnter(%this, %vehicleId)
{
  %p = getHudName(%vehicleId);
  say("Everybody", 1, %p @ " fell down the mineshaft!");
}


// Various teleporters
// -------------------------------------------------------------------------
function Cache1::trigger::onContact(%this, %object)
{
  setPosition(%object, 703.785, 1092.5, 1789.5);
}

function Cache2::trigger::onContact(%this, %object)
{
  setPosition(%object, 706.2, 977.044, 1789.5);
}

function Cache3::trigger::onContact(%this, %object)
{
  setPosition(%object, 426.253, 405.3, 1789.5);
}

function Cache4::trigger::onContact(%this, %object)
{
  setPosition(%object, 559.101, 404.5, 1789.5);
}

function L2Cache1::trigger::onContact(%this, %object)
{
  setPosition(%object, 703.785, 1092.5, 2143.5);
}

function L2Cache2::trigger::onContact(%this, %object)
{
  setPosition(%object, 706.2, 977.044, 2143.5);
}

function L2Cache3::trigger::onContact(%this, %object)
{
  setPosition(%object, 426.253, 405.3, 2143.5);
}

function L2Cache4::trigger::onContact(%this, %object)
{
  setPosition(%object, 559.101, 404.5, 2143.5);
}


// Give us a nice fade!
// -------------------------------------------------------------------------
function foutup::trigger::onEnter(%this, %object)
{
//    fadeEvent( 0, out, 1, 0, 0, 0 );
//    schedule("fadeEvent( 0, in, 0, 0, 0, 0 );", 2);
    say(0,1,"sfx_industrial.wav");
}

function foutdown::trigger::onEnter(%this, %object)
{
//    fadeEvent( 0, out, 1, 0, 0, 0 );
//    schedule("fadeEvent( 0, in, 0, 0, 0, 0 );", 2);
    say(0,1,"sfx_industrial.wav");
}

// More ... but cool'er' teleporters
// -------------------------------------------------------------------------
function upONE::trigger::onContact(%this, %object)
{
  %w = randomInt(1, 6);
  if(%w == 1)
  {
    setPosition(%object, 1394, -36, 2337);
  }
  else if(%w == 2)
  {
    setPosition(%object, 1396, -80, 2354);
  }
  else if(%w == 3)
  {
    setPosition(%object, 1397, -132, 2374);
  }
  else if(%w == 4)
  {
    setPosition(%object, 1427, -99, 2368);
  }
  else if(%w == 5)
  {
    setPosition(%object, 1431, -58, 2353);
  }
}

function downONE::trigger::onContact(%this, %object)
{
  %w = randomInt(1, 6);
  if(%w == 1)
  {
    setPosition(%object, 1393, -121, 2016);
  }
  else if(%w == 2)
  {
    setPosition(%object, 1397, -101, 2009);
  }
  else if(%w == 3)
  {
    setPosition(%object, 1431, -86, 2010);
  }
  else if(%w == 4)
  {
    setPosition(%object, 1411, -58, 1995);
  }
  else if(%w == 5)
  {
    setPosition(%object, 1406, -19, 1979);
  }
}

function upFire::trigger::onContact(%this, %object)
{
  %w = randomInt(1, 3);
  if(%w == 1)
  {
    setPosition(%object, 616, 895, 2144);
  }
  else if(%w == 2)
  {
    setPosition(%object, 618, 900, 2144);
  }
}

function downFire::trigger::onContact(%this, %object)
{
  %w = randomInt(1, 3);
  if(%w == 1)
  {
    setPosition(%object, 634, 882, 1790);
  }
  else if(%w == 2)
  {
    setPosition(%object, 636, 880, 1790);
  }
}
