//-------Hide and Seek by ShatteredStar.-------//
//-------Thanks go to Orogogus for many componants.-------//

//-------Name map-------//

$missionName = "HaS_ForestCity";

//-------Realign HUD map-------//

$server::HudMapViewOffsetX = -500;
$server::HudMapViewOffsetY = 3500;

//-------Limit teams and set server options-------//

function setDefaultMissionOptions()
{
   $server::TeamPlay          = true;
   $server::AllowDeathmatch   = true;
   $server::AllowTeamPlay     = true;	
	
   $server::AllowTeamRed      = false;
   $server::AllowTeamBlue     = true;
   $server::AllowTeamYellow   = true;
   $server::AllowTeamPurple   = true;

   $server::disableTeamRed    = true;
   $server::disableTeamBlue   = false;
   $server::disableTeamYellow = False;
   $server::disableTeamPurple = false;

   $server::AllowMixedTech    = false ;
   $server::FactoryVehOnly    = false ;

   $server::TimeLimit         = 60;
   $server::FragLimit         = 60;
}

//-------Activate sounds-------//

function onMissionStart()
{
   marsSounds();
   stormSounds();
}

function onMissionLoad()
{
   cdAudioCycle("Mechsoul", "Cloudburst", "Yougot"); 

   schedule("say(0, 0, \"Welcome to Hide and Seek.  Check the game rules for details.\");", 2.0);
}

//-------Vehicle types-------//

function adjustTeam(%player, %vehicle)
{
  %initLetter = strAlign(1, l, %vehicle.vehicleName);
  if(%initLetter < "H") adjustTeam1(%player, %vehicle);
  else if((%initLetter >= "H") && (%initLetter < "L")) adjustTeam2(%player, %vehicle);
  else if((%initLetter >= "L") && (%initLetter < "Q")) adjustTeam3(%player, %vehicle);
  else if(%initLetter >= "Q") adjustTeam4(%player, %vehicle);
  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam1(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Adjudicator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "prom";
  }

  else if(%vehicle.vehicleName == "Apocalypse")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Avenger")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Basilisk")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Bolo")
  {
     %vehicle.type = "tank";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Disrupter")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Dreadlock")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Emancipator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Executioner")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Goad")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Gorgon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}


function adjustTeam2(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Harabec's Predator")
  {
     %vehicle.type = "tank";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Knight's Basilisk")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Apocalypse")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Disruptor")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Gorgon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Minotaur")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Myrmidon")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Paladin")
  {
     %vehicle.type = "tank";
     %vehicle.side= "knight";
  }

  else if(%vehicle.vehicleName == "Knight's Talon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "knight";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam3(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Metagen Goad")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Metagen Seeker")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Metagen Shepherd")
  {
     %vehicle.type = "herc";
     %vehicle.side= "metagen";
  }

  else if(%vehicle.vehicleName == "Minotaur")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Myrmidon")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Olympian")
  {
     %vehicle.type = "herc";
     %vehicle.side= "martian";
  }

  else if(%vehicle.vehicleName == "Paladin")
  {
     %vehicle.type = "tank";
     %vehicle.side= "terran";
  }

  else if(%vehicle.vehicleName == "Platinum Guard Adjudicator")
  {
     %vehicle.type = "herc";
     %vehicle.side= "platinum";
  }

  else if(%vehicle.vehicleName == "Platinum Guard Executioner")
  {
     %vehicle.type = "herc";
     %vehicle.side= "platinum";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

function adjustTeam4(%player, %vehicle)
{
  if(%vehicle.vehicleName == "Recluse")
  {
     %vehicle.type = "tank";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Seeker")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }
				
  else if(%vehicle.vehicleName == "Shepherd")
  {
     %vehicle.type = "herc";
     %vehicle.side= "promethean";
  }

  else if(%vehicle.vehicleName == "Talon")
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }

  else
  {
     %vehicle.type = "herc";
     %vehicle.side= "terran";
  }
}

//-------Identify droppings-------//

function vehicle::OnAdd(%vehicle)
{
  %player = playerManager::vehicleIdToPlayerNum(%vehicle);
  %player.name = getName(%player);
  %player.vehicleId = %vehicle;
  %vehicle.vehicleName = getVehicleName(%vehicle);
  %vehicle.color = getTeam(%vehicle);
  adjustTeam(%player, %vehicle);
  %xyz = getPostion(%vehicle);
  $lastDrop = getPlayerID(%player);

  %outputString =  %player.name @ " has dropped in a " @ %vehicle.vehicleName @ " on " @ %vehicle.color @ " at  " @ %xyz @ ".)";
  say(0, 0, %outputString );
}

//-------Identify joinings-------//

function player::OnAdd(%player)
{
  %player.name = getName(%player);

  %nowDate = getDate();
  %nowTime = getTime();
  %player.IP = getConnection(%player);
  %outputString =  %nowDate @ ", " @ %nowTime @ " -- " @ %player.name @ " joined the game";
  say(0, 0, %outputstring );
  resetScan();
}

//-------Scan function-------//

function vehicle::onScan(%this, %object)
{
  if ($scantime == false)
  {
   %scanner = playerManager::vehicleIdToPlayerNum(%object);
   say(%scanner, 0, "Vehicle is scanned.");
   %scannee = playerManager::vehicleIdToPlayerNum(%this);
   say(%scannee, 0, "You are being scanned!");
   $scantime = true;
   schedule( "resetScan();", 10 );
   damageObject( %this, 1000 );
  }
}

function resetScan()
{
   $scantime = false;
   $spottime = false;
} 

//-------Spot vehicle function-------//

function vehicle::onSpot(%this, %object)
{
  if ($spottime == false)
  {
   %scanner = playerManager::vehicleIdToPlayerNum(%object);
   say(%scanner, 0, "Spotting vehicle.  Plotting intercept.");
   %scannee = playerManager::vehicleIdToPlayerNum(%this);
   say(%scannee, 0, "You have been spotted.  Dropping cloak and reallocating power.");
   $spottime = true;
   schedule( "resetScan();", 10 );
   order( %object, Attack, %this );
   order( %this, Cloak, false );
   healObject( %this, 3000 );
   healObject( %object, 5000 );
  }
}

//-------Rules info-------//

function setRules()
{
  %rules = "<F2>GAME TYPE: \n<F0>Hide and Seek\n\n" @        
  "<tIDMULT_TDM_MAPNAME>"    @ 
  $missionName               @
  "\n\n<F2>CHANGES:\n"       @
  "<F0>Vehicles search for each other using limited componants.\n\n" @
  "<F0>Spottying and scanning vehicles increases your tactical advantage.\n\n" @
  "<F0>Vehicles may be manipulated by spotting and targetting.\n\n" @
  "\n\n<F2>RULES/OBJECTIVES:\n" @
  "<F0>Locate and destroy enemy vehicles.\n\n" @
  "<F0>Scan and spot vehicles (use an LTADS)\n\n" @
  "<tIDMULT_TDM_SCORING_1>"  @
  "<tIDMULT_TDM_SCORING_2>"  @
  $killPoints                @
  "<tIDMULT_TDM_SCORING_3>"  @
  "<tIDMULT_TDM_SCORING_4>"  @
  $deathPoints               @
  "<tIDMULT_TDM_SCORING_5>"  @
  "<tIDMULT_TDM_SCORING_6>"  @
  "<tIDMULT_STD_ITEMS>" ;

   setGameInfo(%rules);      
}

setRules();

//-------Activate transporters-------//

function ZenTransporter::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	randomTransport(%object, -5000, 5000, -5000, 5000);
        $lastDrop = getPlayerID(%object);
        %xyz = getPostion(%object);
        %player = playerManager::vehicleIdToPlayerNum(%object);
        %player.name = getName(%player);
        %outputString =  %player.name @ " has transported to " @ %xyz @ ".)";
        say(0, 0, %outputString );
}

function ZenTransporter2::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	randomTransport(%object, -5000, 5000, -5000, 5000);
}

function ZenTransporter3::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	randomTransport(%object, -5000, 5000, -5000, 5000);
        %xyz = getPostion(%object);
        %player = playerManager::vehicleIdToPlayerNum(%object);
        %player.name = getName(%player);
        %outputString =  %player.name @ " has transported to " @ %xyz @ ".)";
        say(0, 0, %outputString );
}

function ZenTransporter4::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 250, 250, 430);
}

function ZenTransporter5::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -700, 250, 130);
}

function ZenTransporter6::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	warp(%object, $lastDrop);
	randomTransport($lastDrop, -5000, 5000, -5000, 5000);
        %vehicle = $lastDrop
        %xyz = getPostion(%vehicle);
        %player = playerManager::vehicleIdToPlayerNum(%vehicle);
        %player.name = getName(%player);
        %outputString =  %player.name @ " has transported to " @ %xyz @ ".)";
        say(0, 0, %outputString );
}

//-------Limit vehicles and componants-------//

allowVehicle(all,TRUE);
allowComponant(all,FALSE);

allowWeapon(131,FALSE);//Arachnitron4
allowWeapon(132,FALSE);//Arachnitron8
allowWeapon(133,FALSE);//Arachnitron12
allowWeapon(134,FALSE);//Proximity6
allowWeapon(135,FALSE);//Proximity10
allowWeapon(136,FALSE);//Proximity15
allowWeapon(142,FALSE);//RadiationGun
allowWeapon(3,  FALSE);//Disrupter
allowWeapon(150,FALSE);//SMARTGun

allowComponent(200,TRUE);//HumanMicroReactor
allowComponent(201,TRUE);//SmallHumanReactor2--small
allowComponent(202,TRUE);//MediumHumanReactor1Standard
allowComponent(203,TRUE);//MediumHumanReactor2medium
allowComponent(204,TRUE);//LargeHumanReactor1--large
allowComponent(205,TRUE);//LargeHumanReactor2--Maxim
allowComponent(225,TRUE);//SmallCybridReactor1--Alpha
allowComponent(226,TRUE);//SmallCybridReactor2--Beta
allowComponent(227,TRUE);//MediumCybridReactor1--Gamma
allowComponent(228,TRUE);//MediumCybridReactor2--delta
allowComponent(229,TRUE);//LargeCybridReactor1--epsilon
allowComponent(230,TRUE);//LargeCybridReactor2--theta

allowComponent(300,TRUE);//HumanStandardShield
allowComponent(301,TRUE);//HumanProtectorShield
allowComponent(302,TRUE);//HumanGuardianShield
allowComponent(303,TRUE);//HumanFastChargeShield
allowComponent(304,TRUE);//HumanCenturianShield
allowComponent(305,TRUE);//HumanRepulsorShield
allowComponent(306,TRUE);//HumanTitanShield
allowComponent(307,TRUE);//HumanMedusaShield
allowComponent(326,TRUE);//CybridAlphaShield
allowComponent(327,TRUE);//CybridBetaShield
allowComponent(328,TRUE);//CybridGammaShield
allowComponent(329,TRUE);//CybridDeltaShield
allowComponent(330,TRUE);//CybridEpsilonShield
allowComponent(331,TRUE);//CybridZetaShield
allowComponent(332,TRUE);//CybridEtaShield
allowComponent(333,TRUE);//CybridThetaShield

allowComponent(410,TRUE);//HumanInfiltratorSensor
allowComponent(414,TRUE);//ThermalSensor
allowComponent(430,TRUE);//CybridInfiltratorSensor(Epsilon)
allowComponent(434,TRUE);//MotionDetector(Iota)

allowComponent(100,TRUE);//HumanLightVehicleEngine
allowComponent(101,TRUE);//HumanHighOutputLightEngine
allowComponent(102,TRUE);//HumanAgileLightEngine
allowComponent(103,TRUE);//HumanStandardMediumEngine
allowComponent(104,TRUE);//HumanHighOutputMediumEngine
allowComponent(105,TRUE);//HumanMediumAgilityEngine
allowComponent(106,TRUE);//HumanStandardHeavyEngine
allowComponent(107,TRUE);//HumanImprovedHeavyEngine
allowComponent(108,TRUE);//HumanHeavyCruiseEngine
allowComponent(109,TRUE);//HumanHighOutputHeavyEngine
allowComponent(110,TRUE);//HumanAgileHeavyEngine
allowComponent(111,TRUE);//HumanStandardAssaultEngine
allowComponent(112,TRUE);//HumanImprovedAssaultEngine
allowComponent(113,TRUE);//Humanheavyturbineengine
allowComponent(114,TRUE);//HighOutputTurbine(HOT)
allowComponent(115,TRUE);//Humansuperheavyengine
allowComponent(128,TRUE);//CybridAlphaLightVehicleEngine
allowComponent(129,TRUE);//CybridBetaLightAgilityEngine
allowComponent(130,TRUE);//CybridGammaStandardMediumEngine
allowComponent(131,TRUE);//CybridDeltaMediumCruiseEngine
allowComponent(132,TRUE);//CybridEpsilonImprovedMediumEngine
allowComponent(133,TRUE);//CybridZetaMediumHighOutputEngine
allowComponent(134,TRUE);//CybridEtaMediumAgilityEngine
allowComponent(135,TRUE);//CybridThetaStandardHeavyEngine
allowComponent(136,TRUE);//CybridIotaHeavyHighOutputEngine
allowComponent(137,TRUE);//CybridKappaHeavyAgilityEngine
allowComponent(138,TRUE);//CybridLamdaStandardAssaultEngine
allowComponent(139,TRUE);//CybridMuImprovedAssaultEngine
allowComponent(140,TRUE);//CybridNuHighOutputAssaultEngine
allowComponent(141,TRUE);//CybridXiHeavyAssaultEngine
allowComponent(142,TRUE);//CybridOmicronHeavyAssaultTurbine
allowComponent(143,TRUE);//CybridPiSuperHeavyTurbine

allowComponent(926,TRUE);//CarbonFiber(CARLAM)

allowComponent(800,TRUE);//HumanBasicComputer
allowComponent(801,TRUE);//HumanImprovedComputer
allowComponent(805,TRUE);//CybridBasicSystemsControl
allowComponent(806,TRUE);//CybridEnhancedSystemsControl
allowComponent(810,TRUE);//GuardianECM
allowComponent(811,TRUE);//DopplegangerECM
allowComponent(812,TRUE);//CybridAlphaECM
allowComponent(813,TRUE);//CybridBetaECM
allowComponent(820,TRUE);//ThermalDiffuser
allowComponent(830,TRUE);//Chameleon
allowComponent(831,TRUE);//Cuttlefishcloak
allowComponent(860,TRUE);//LaserTargetingModule
allowComponent(865,TRUE);//ExtraBattery

//