$missionName = "Featherlight_Oberwind";

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");

function setDefaultMissionOptions()
{
   $server::TeamPlay = True;
   $server::AllowDeathmatch = True;
   $server::AllowTeamPlay = True;	
	
   $server::AllowTeamRed = true;
   $server::AllowTeamBlue = false;
   $server::AllowTeamYellow = true;
   $server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
   venusSounds();
   stormSounds();
}

function onMissionLoad()
{
   cdAudioCycle("Purge", "Mechsoul", "Terror"); 

   schedule("say(0, 0, \"Welcome to Venus, such as it is.  Enjoy the antigrav module.  Hah.\");", 2.0);
   schedule("say(0, 0, \"Oh yeah, Customs is gonna confiscate that fancy-schmancy shield cap and those sensors.  You don't need them here anyway.\");", 3.0);
}

function player::onAdd(%playerNum)
{
  $playerNum = %playerNum;
}

function vehicle::onAdd(%this)                                                                                                                        
{                                                                                                                                                     
   %num = playerManager::vehicleIdToPlayerNum(%this);                                                                                                 
                                                                                                                                                      
   if(%num == $playerNum)                                                                                                                             
   {                                                                                                                                                  
      $playerId = playerManager::playerNumToVehicleId($playerNum);                                                                                    
   }                                                                                                                                                  
}        

function OberwindHeal::trigger::onContact(%this, %object)
{
   damageObject( %object, 4000 );
   reloadObject( %object, 100000 );
   schedule("say(0, 0, \"Whee, passing through the Oberwind.  Aren't you lucky?\");", 1.0);
}

function Warning::trigger::onContact(%this, %object)
{
   say(0, 0, "Warning: You have entered the sacred Shrine of ShatteredStar.  Approach no closer.");
}

function BigAssSlam::trigger::onContact(%this, %object)
{
   setDominantCamera( "MissionGroup/RedBase/red8" , %object);
   damageObject( %object , 1000000 );
   damageObject( "MissionGroup/RedBase/red1" , 1000000 );
   damageObject( "MissionGroup/RedBase/red2" , 1000000 );
   damageObject( "MissionGroup/RedBase/red3" , 1000000 );
   damageObject( "MissionGroup/RedBase/red4" , 1000000 );
   damageObject( "MissionGroup/RedBase/red5" , 1000000 );
   damageObject( "MissionGroup/RedBase/red6" , 1000000 );
   damageObject( "MissionGroup/RedBase/red7" , 1000000 );
   damageObject( "MissionGroup/RedBase/red8" , 1000000 );
   damageObject( "MissionGroup/RedBase/RedHealGenerator" , 1000000 );
   damageObject( "MissionGroup/RedBase/RedAmmoGenerator" , 1000000 );
   say(0, 0, "You have desecrated the Shrine of ShatteredStar!  All Venus shall feel His Holy Wrath!");
}

allowComponent(845,FALSE); //SCAP
allowComponent(400,FALSE);
allowComponent(401,FALSE);
allowComponent(408,FALSE);
allowComponent(409,FALSE);
allowComponent(410,FALSE);
allowComponent(411,FALSE);
allowComponent(412,FALSE);
allowComponent(413,FALSE);
allowComponent(414,FALSE);
allowComponent(426,FALSE);
allowComponent(427,FALSE);
allowComponent(428,FALSE);
allowComponent(429,FALSE);
allowComponent(430,FALSE);
allowComponent(431,FALSE);
allowComponent(432,FALSE);
allowComponent(433,FALSE);
allowComponent(434,FALSE);

//