// FILENAME:	CTF_Egyptian.cs
//
// AUTHOR:		Raven [M.I.B.]
//------------------------------------------------------------------------------

$missionName = "CTF_Egyptian";

$maxFlagCount  = 7;           // no of flags required by a team to end the game
$flagValue     = 5;          // points your team gets for capturing
$carrierValue  = 2;          //  "      "    "    "    " killing carrier
$killPoints    = 1;
$deathPoints   = 1;
$flagTime = 0;

exec("multiplayerStdLib.cs");
exec("CTFstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = false;
}

function onMissionLoad()
{
   cdAudioCycle("Purge", "Terror", "Watching");
}

//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to CTF Egyptian! The flags are on the roofs of the buildings, but watch out for the turrets! You can download this & other missions made by Raven [M.I.B.] in the 'MIB Map Pack 1' at www.starsiegeplayers.com. ");
}

function onMissionStart()
{
	initGlobalVars();
   
	marsSounds();
}

// Water splashing functionality
//------------------------------------------------------------------------------
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was just destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}
