// FILENAME:	Test_DM_on_the_Edge.cs
//
// AUTHORS:  	William
//------------------------------------------------------------------------------

$missionName = "Test_DM_On_The_Edge";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

$reloadRate = 50;
$repairRate = 50;
$respawnTime = 30;

Pilot Repair
{
id = 28; 
name = "Repair Herc";
skill = 1.0;
accuracy = 0.8;
aggressiveness = 0.7;
activateDist = 300.0;
deactivateBuff = 100.0;
targetFreq = 2.0;
trackFreq = 0.1;
fireFreq = 0.2;
LOSFreq = 0.1;
orderFreq = 1.0; 
};

Pilot Reload
{
id = 29; 
name = "Reload Herc";
skill = 1.0;
accuracy = 0.8;
aggressiveness = 0.7;
activateDist = 300.0;
deactivateBuff = 100.0;
targetFreq = 2.0;
trackFreq = 0.1;
fireFreq = 0.2;
LOSFreq = 0.1;
orderFreq = 1.0; 
};

Pilot Zen
{
id = 30; 
name = "Zen Herc";
skill = 1.0;
accuracy = 0.8;
aggressiveness = 0.7;
activateDist = 300.0;
deactivateBuff = 100.0;
targetFreq = 2.0;
trackFreq = 0.1;
fireFreq = 0.2;
LOSFreq = 0.1;
orderFreq = 1.0; 
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
    cdAudioCycle("Purge", "Terror", "Watching");

    $blueRepairman = getObjectId("MissionGroup\\BlueBase\\repairman");
    $blueRepairman.home = getObjectID("MissionGroup\\BlueBase\\repairH");
    $blueRepairman.busy = false;
    
    $blueReloadman = getObjectId("MissionGroup\\BlueBase\\reloadman");
    $blueReloadman.home = getObjectID("MissionGroup\\BlueBase\\reloadH");
    $blueReloadman.busy = false;
    
    $blueZenman = getObjectId("MissionGroup\\BlueBase\\zenman");
    $blueZenman.home = getObjectID("MissionGroup\\BlueBase\\zenH");
    $blueZenman.busy = false;
    
    $redRepairman = getObjectId("MissionGroup\\redBase\\repairman");
    $redRepairman.home = getObjectID("MissionGroup\\redBase\\repairH");
    $redRepairman.busy = false;
    
    $redReloadman = getObjectId("MissionGroup\\redBase\\reloadman");
    $redReloadman.home = getObjectID("MissionGroup\\redBase\\reloadH");
    $redReloadman.busy = false;
    
    $redZenman = getObjectId("MissionGroup\\RedBase\\zenman");
    $redZenman.home = getObjectID("MissionGroup\\RedBase\\zenH");
    $redZenman.busy = false;
    
    setTeam($blueRepairMan,*IDSTR_TEAM_BLUE);
    setTeam($blueReloadMan,*IDSTR_TEAM_BLUE);
    setTeam($blueZenMan,*IDSTR_TEAM_BLUE);
    setTeam($redRepairMan,*IDSTR_TEAM_RED);
    setTeam($redReloadMan,*IDSTR_TEAM_RED);
    setTeam($redZenMan,*IDSTR_TEAM_RED);
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}

function player::onAdd(%this)
{
    say(%this, 0, "Welcome to William's Map!");
    say(%this, 1, "Please read the info tab for game rules.");
    say(%this, 2, "To use the drones scan them and they will heal and/or reload you.");
}

function vehicle::onScan(%scanned, %scanner, %string)
{
    %player = playerManager::vehicleIdToPlayerNum(%scanner);
    if($server::TeamPlay == true)
    {
        if(getTeam(%scanner) != getTeam(%scanned))  //is it the same team
        {return;}
    }

    //if the truck is busy then tell others to wait
    if(%scanned.busy == true)
    {
        %message = getWaitMessage();
        if(%message != "")
        {
            say( %player, 0, getHUDName(%scanned) @": " @%message);
        }
        return;
    } 
    
    //I will not take anymore calls
    %scanned.busy = true;
    %scanner.isHealing = true;
    
    //order the truck to go to the spot
    schedule("order( "@%scanned@", Guard, "@%scanner@" );",1);
    
    //and remember what you are healing
    %scanned.patient = getObjectId(%scanner);
}

// now start the wheels in motion when the repair man arrives
function Repair::vehicle::onArrived()
{
    %truck = "";
    if ($blueRepairman.busy == true) {%truck = $blueRepairman;}
    if ($redRepairman.busy == true) {%truck = $redRepairman;}
    if (%truck != "")
    {
        %patient = %truck.patient;
        %player = playerManager::vehicleIdToPlayerNum(%patient);
        //this will take five seconds
        schedule("healObject("@%patient@", "@$repairRate@");", 1);
        schedule("healObject("@%patient@", "@$repairRate@");", 2);
        schedule("healObject("@%patient@", "@$repairRate@");", 3);
        schedule("healObject("@%patient@", "@$repairRate@");", 4);
        schedule("healObject("@%patient@", "@$repairRate@");", 5);
        schedule("returnHome("@%truck@");",6);
        say(%player, 0, getHUDName(%truck)@": Repairing.");
    }
}
function Reload::vehicle::onArrived()
{
    %truck = "";
    if ($blueReloadman.busy == true) {%truck = $blueReloadman;}
    if ($redReloadman.busy == true) {%truck = $redReloadman;}
    if (%truck != "")
    {
        %patient = %truck.patient;
        %player = playerManager::vehicleIdToPlayerNum(%patient);
        //this will take five seconds
        schedule("reloadObject("@%patient@", "@$reloadRate@");", 1);
        schedule("reloadObject("@%patient@", "@$reloadRate@");", 2);
        schedule("reloadObject("@%patient@", "@$reloadRate@");", 3);
        schedule("reloadObject("@%patient@", "@$reloadRate@");", 4);
        schedule("reloadObject("@%patient@", "@$reloadRate@");", 5);
        schedule("returnHome("@%truck@");",6);
        say(%player, 0, getHUDName(%truck)@": Reloading.");
    }
}
function ZenMan::vehicle::onArrived()
{
    %truck = "";
    if ($blueZenman.busy == true) {%truck = $blueZenman;}
    if ($redZenman.busy == true) {%truck = $redZenman;}
    if (%truck != "")
    {
        %patient = %truck.patient;
        %player = playerManager::vehicleIdToPlayerNum(%patient);
        //this will take five seconds
        schedule("healObject("@%patient@", "@$repairRate@");reloadObject("@%patient@", "@$reloadRate@");", 1);
        schedule("healObject("@%patient@", "@$repairRate@");reloadObject("@%patient@", "@$reloadRate@");", 2);
        schedule("healObject("@%patient@", "@$repairRate@");reloadObject("@%patient@", "@$reloadRate@");", 3);
        schedule("healObject("@%patient@", "@$repairRate@");reloadObject("@%patient@", "@$reloadRate@");", 4);
        schedule("healObject("@%patient@", "@$repairRate@");reloadObject("@%patient@", "@$reloadRate@");", 5);
        schedule("returnHome("@%truck@");",6);
        say(%player, 0, getHUDName(%truck)@": Repairing and Reloading.");
    }
}

function vehicle::onDestroyed(%destroyed, %destroyer)
{
   // left over from missionStdLib.cs
   vehicle::onDestroyedLog(%destroyed, %destroyer);
   
   // this is weird but %destroyer isn't necessarily a vehicle
   %message = getFancyDeathMessage(getHUDName(%destroyed), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
   
   // enforce the rules
   if($server::TeamPlay == true)
   {
      if(
         (getTeam(%destroyed) == getTeam(%destroyer)) &&
         (%destroyed != %destroyer)
      )
      {
         antiTeamKill(%destroyer);
      }
   }   
    // if the patient dies before the repair man arrives, send the repair man home
    if (%destroyed.isHealing == true)
    {
        if (%destroyed == $blueRepairman.patient) {returnHome($blueRepairman);}
        if (%destroyed == $blueReloadman.patient) {returnHome($blueReloadman);}
        if (%destroyed == $redRepairman.patient) {returnHome($redRepairman);}
        if (%destroyed == $redReloadman.patient) {returnHome($redReloadman);}
        if (%destroyed == $blueZenman.patient) {returnHome($blueZenman);}
        if (%destroyed == $redZenman.patient) {returnHome($redZenman);}
    }
}

function returnHome(%truck)
{
    %home = %truck.home; %patient = %truck.patient;
    %player = playerManager::vehicleIdToPlayerNum(%patient);
    order( %truck, Guard, %home );
    %truck.busy = false;
    %patient.isHealing = false;
    say(%player, 0, getHUDName(%truck)@": Retruning.");
}

function getWaitMessage()
{
    %x = randomInt(1, 5);
    if (%x == 1) {return "Oi, I'm busy!";}
    if (%x == 2) {return "Wait your turn buddy!";}
    if (%x == 3) {return "I'm going as fast as I can!";}
    if (%x == 4) {return "I'm coming, I'm coming!";}
    if (%x == 5) {return "Your always in such a hurry!";}
}

function Repair::vehicle::onDestroyed(%destroyed, %destroyer)
{
    %team = getTeam(%destroyed);
    if (%team == *IDSTR_TEAM_BLUE)
    {
        schedule("trevorsCloneVehicle(\"$BlueRepairMan\", "@%destroyed@");", $respawnTime);
    }
    if (%team == *IDSTR_TEAM_RED)
    {
        schedule("trevorsCloneVehicle(\"$RedRepairMan\", "@%destroyed@");", $respawnTime);
    }
    say(%team, 0, "Repair Herc destroyed!");
}
function Reload::vehicle::onDestroyed(%destroyed, %destroyer)
{
    %team = getTeam(%destroyed);
    if (%team == *IDSTR_TEAM_BLUE)
    {
        schedule("trevorsCloneVehicle(\"$BlueReloadMan\", "@%destroyed@");", $respawnTime);
    } else
    {
        schedule("trevorsCloneVehicle(\"$RedReloadMan\", "@%destroyed@");", $respawnTime);
    }
    say(%team, 0, "Reload Herc destroyed!");
}
function ZenMan::vehicle::onDestroyed(%destroyed, %destroyer)
{
    %team = getTeam(%destroyed);
    if (%team == *IDSTR_TEAM_BLUE)
    {
        schedule("trevorsCloneVehicle(\"$BlueZenMan\", "@%destroyed@");", $respawnTime);
    } else
    {
        schedule("trevorsCloneVehicle(\"$BlueZenMan\", "@%destroyed@");", $respawnTime);
    }
    say(%team, 0, "Zen Herc destroyed!");
}

function trevorsCloneVehicle(%globalVarName, %old)
{
    %clone = cloneVehicle(%old);
//    %team = getTeam(%old);
    %home = %old.home;
    addToSet("MissionGroup",%clone);
    %clone.home = %home;
    %clone.busy = false;
    %x = getPosition(%home,x);
    %y = getPosition(%home,y);
    %z = getPosition(%home,z) + 10;
    setPosition(%clone, %x, %y, %z);
    schedule( "deleteObject(" @ %old @ ");", 10 );
    schedule( %globalVarName @ " = " @ %clone @ ";", 0);
}

function setRules()
{
   if($server::TeamPlay == true)
	{
      %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
               "<tIDMULT_TDM_MAPNAME>"    @ 
               $missionName               @
               "<tIDMULT_TDM_OBJECTIVES>" @
               "<tIDMULT_TDM_SCORING_1>"  @
               "<tIDMULT_TDM_SCORING_2>"  @
               $killPoints                @
               "<tIDMULT_TDM_SCORING_3>"  @
               "<tIDMULT_TDM_SCORING_4>"  @
               $deathPoints               @
               "<tIDMULT_TDM_SCORING_5>"  @
               "<tIDMULT_TDM_SCORING_6>"  @
               "Use the Heal and Reload Drones if you want to heal or reload." @
               " To use the drones scan them and they will come and Heal/Reload you." @
               " You must also be on the same team as the drones to use them." @
               " If a drone is destroyed then it will respawn after " @
               $respawnTime@
               " seconds.";
   }
	else
	{
      %rules = "<tIDMULT_DM_GAMETYPE>"    @        
               "<tIDMULT_DM_MAPNAME>"     @ 
               $missionName               @
               "<tIDMULT_DM_OBJECTIVES>"  @
               "<tIDMULT_DM_SCORING_1>"   @
               "<tIDMULT_DM_SCORING_2>"   @
               $killPoints                @
               "<tIDMULT_DM_SCORING_3>"   @
               "<tIDMULT_DM_SCORING_4>"   @
               $deathPoints               @
               "<tIDMULT_DM_SCORING_5>"   @
               "Use the Heal and Reload Drones if you want to heal or reload." @
               " To use the drones scan them and they will come and Heal/Reload you." @
               " If a drone is destroyed then it will respawn after " @
               $respawnTime@
               " seconds.";
   }
   setGameInfo(%rules);      
}

setRules();