// FILENAME:	DM_Rome.cs
//
// AUTHORS:  	Maj. Deathrow [M.I.B.]
//------------------------------------------------------------------------------

$missionName = "DM_Rome";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = false;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to SS Rome's Death Arena! You can download this & other missions made by Maj. Deathrow [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}

}

function door1::trigger::onEnter(%this, %vehicleId){
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, true);
	}
	$hercsAtDoor1 = $hercsAtDoor1 + 1;
}
function door1::trigger::onLeave(%this, %vehicleId){
	$hercsAtDoor1 = $hercsAtDoor1 - 1;
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, false);
	}
}
function door2::trigger::onEnter(%this, %vehicleId){
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, true);
	}
	$hercsAtDoor2 = $hercsAtDoor2 + 1;
}
function door2::trigger::onLeave(%this, %vehicleId){
	$hercsAtDoor2 = $hercsAtDoor2 - 1;
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, false);
	}
}


