// FILENAME:    DM_Nova_Alexandria.cs
//
// AUTHOR:      Gen. Raven [M.I.B.]
//--------------------------------------------------------------------------------

$missionName = "DM_Nova_Alexandria";

exec("multiplayerStdLib.cs");
exec("dmStdLib.cs");

///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;

$yellowHerc1Path = "MissionGroup/yellowHerc1Path";
$yellowHerc2Path = "MissionGroup/yellowHerc2Path";
$yellowHerc3Path = "MissionGroup/yellowHerc3Path";
$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";

$yellowHqDestroyed = false;
$redHqDestroyed = false;

///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 30;
$respawnDelayNoHq = 30;
$BUILDINGS_TO_DESTROY = 6;

///////////////////////////////////////////////////////////////////////////////////////////////////
// our base defender attributes
//
// The jump from 0.9 to 1.0 is a big one. At skill 1.0 and accuracy 1.0 the AI units will aim 
// first for the weapons, then the legs. A little too much for this mission.
//
///////////////////////////////////////////////////////////////////////////////////////////////////
Pilot YellowPilot
{
   id = 28;
   
   name = "Yellow Herc Pilot";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot RedPilot
{
   id = 29;
   
   name = "Red Herc Pilot";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = False;
	$server::AllowDeathmatch = True;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionLoad()
{
   cdAudioCycle("Newtech", "Mechsoul", "Terror"); 

   // get the original ID for each AI Herc ( for use later when we clone them )
   $yellowHerc1 = getObjectId( "MissionGroup/yellowHercs/h1" );
   $yellowHerc2 = getObjectId( "MissionGroup/yellowHercs/h2" );
   $yellowHerc3 = getObjectId( "MissionGroup/yellowHercs/h3" );
   
   $redHerc1 = getObjectId( "MissionGroup/redHercs/h1" );
   $redHerc2 = getObjectId( "MissionGroup/redHercs/h2" );
   $redHerc3 = getObjectId( "MissionGroup/redHercs/h3" );
}


//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to DeathMatch Nova Alexandria! You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

function vehicle::onDestroyed( %this, %destroyer )
{   
   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------
   if( %this == $yellowHerc1 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", 32.6545, 1118.67, 141);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", 32.6545, 1118.67, 141);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", -195.453, 1102.12, 140);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", -195.453, 1102.12, 140);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc3 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", -63, -612, 1312);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", -63, -612, 1312);", $respawnDelay);
      }
   }

   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -2318, -38, 1478);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -2318, -38, 1478);", $respawnDelay);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -2654, -249, 1431);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -2654, -249, 1431);", $respawnDelay);
      }
   }
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -2514, -253, 1438);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -2514, -253, 1438);", $respawnDelay);
      }
   }

   // left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
}

function onMissionStart()
{
	desertSounds();	

   initGlobalVars();
   
   order( $yellowHerc1, guard, $yellowHerc1Path );
   order( $yellowHerc2, guard, $yellowHerc2Path );
   order( $yellowHerc3, guard, $yellowHerc3Path );
   order( $redHerc1, guard, $redHerc1Path );
   order( $redHerc2, guard, $redHerc2Path );
   order( $redHerc3, guard, $redHerc3Path );
}

function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}

