// FILENAME:	DM_MonteCarlo.cs
// AUTHORS:  	[OF] Pincushion
// VERSION:     1.0
// DATE:        17 April 2000
// DESCRIPTION:
//     This map may serve for either DM or TDM with up to 4 teams, but it
// was designed primarily for 2-team TDM (Red vs Blue or Yellow vs Purple) with
// many players.
//
// See http://www.geocities.com/SoHo/Nook/9351/maps/index.html for more info.
//------------------------------------------------------------------------------

$missionName = "DM_MonteCarlo";

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionStart()
{
	stormSounds();	
	CreateCity();
	MakeBase("yellowBase","NavYellow","YellowHeal","YellowAmmo",$minCLX,$minCLY);
}

function onMissionLoad(){
	cdAudioCycle("SS3", "SS4", "Watching"); 
}

$Buddha = "MissionGroup/Buddha";

function buddha::structure::onScan(%scannee,%scanner)
{
	if ($MCDebug == 0) return;
	Out("Buddha farts...and it is good.");
	DestroyCity();
	CreateCity();
}

// MC - Monte Carlo, automatic map generation standard library
// Created by [OF] Pincushion April 17, 2000.
// Last change May 7, 2000.

// Set to 1 to disable building creation for edit
$MCEdit = 0;

// Set to 0 to disable base creation
$MCMakeBases = 1;

$MCBBox = "MissionGroup/BBox";
$MCBBoxId = 0;
$MCCity = "MissionGroup/City";
$MCCityId = 0;
$MCDebug = 1;

function Out(%msg) {
	echo(%msg);
	Say(0,0,%msg);
}

$ObRadius = 120;
$nnOb=0;
$nOb=1;

if (0) {
// Moon buildings
$ObName[$nOb]=hbigluna1;$ObExt[$nOb++]=dis;
//$ObName[$nOb]=hbigluna2;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigluna3;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigluna4;$ObExt[$nOb++]=dis;
//$ObName[$nOb]=hbigluna5;$ObExt[$nOb++]=dis;
//$ObName[$nOb]=hbigluna6;$ObExt[$nOb++]=dis;
}

if (0) {
// Generic towers
$ObName[$nOb]=hhugescraper1;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper2;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper3;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper4;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper5;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper6;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper7;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper8;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hhugescraper9;$ObExt[$nOb++]=dis;
}

// Desert
if (0) {
$ObName[$nOb]=hDesertTroopBarracks;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hDesertSmallTroopBarracks;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hDesertSmallTroopCom;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hDesertTroopGarage;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hDesertTroopHall;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hDesertSmallTroopHQ;$ObExt[$nOb++]=dts;
}

if (0) {
$ObName[$nOb]=hpyramid;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hpyramid2;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hpyramid3;$ObExt[$nOb++]=dis;

$ObName[$nOb]=hbigsand1d;$ObExt[$nOb++]=dis;
}
$ObName[$nOb]=hbigsand2d;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigsand2d;$ObExt[$nOb++]=dis;
if (0) {
$ObName[$nOb]=hbigsand3d;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigsand4d;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigsand5d;$ObExt[$nOb++]=dis;
$ObName[$nOb]=hbigsand6d;$ObExt[$nOb++]=dis;
}

if (0) {
// hulks (these don't work, they're always invisible)
$ObName[$nOb]=hulk_10X10;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_10X20;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_20X30;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_20X40;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_40X40;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_45X30;$ObExt[$nOb++]=dts;
$ObName[$nOb]=hulk_4X5;$ObExt[$nOb++]=dts;
}

function CreateBuilding(%name,%s,%x,%y) {
	$nnOb++;
	if ($ObExt[%s] == "dts") {
		//%id = newObject($ObName[%s],$ObType[%s],$ObName[%s]@"."@$ObExt[%s]);
		%id = newObject($ObName[%s],StaticShape,$ObName[%s]@"."@$ObExt[%s]);
	} else {
		%id = newObject($ObName[%s],StaticInterior,$ObName[%s]@"."@$ObExt[%s]);
	}
Out("create "@%name@" x,y="@%x@","@%y@" "@%s@" id="@%id);
	addToSet($MCCityId, %id);
	//setTeam(%id,*IDSTR_TEAM_PURPLE);
	%z = getTerrainHeight(%x,%y);
	%rot = 90 * RandomInt(0,3);
	setPosition(%id,%x,%y,%z,%rot);
	return(%id);
}

function DestroyCity() {
	%id = 0;
	while (%id = getNextObject($MCCityId,%id)) {
//%name=GetObjectName(%id);
//Out("deleting "@%name);
		deleteObject(%id);
	}
}

// work in progress
// doesn't work right
function MakeBase(%group,%nav,%heal,%ammo,%cx,%cy) {
	if (!$MCMakeBases) return;
//say(0,0,"MakeBase "@%group);
	%rot = 0;
	%MGid = getObjectId("MissionGroup");

	%bid = newObject(%group,SimShapeGroup);
	addToSet(%MGid, %bid);

	%x = %cx;
	%y = %cy;
	%z = getTerrainHeight(%x,%y);
	%id = newObject(%nav,ESNavMarker);
	addToSet(%bid, %id);
	setPosition(%id,%x,%y,%z,%rot);

	%x = %cx - 50;
	%y = %cy - 50;
	%z = getTerrainHeight(%x,%y);
	//%id = newObject(%heal,StaticInterior,"hheal2a.dis");
	%id = newObject(%heal,StaticInterior,"hhealv.dis");
	addToSet(%bid, %id);
	setPosition(%id,%x,%y,%z,%rot);

	%x = %cx + 50;
	%y = %cy + 50;
	%z = getTerrainHeight(%x,%y);
	%id = newObject(%ammo,StaticInterior,"hammov.dis");
	//%id = newObject(%ammo,StaticInterior,"hammo2a.dis");
	addToSet(%bid, %id);
	setPosition(%id,%x,%y,%z,%rot);
}

function CreateCity() {

	// Abort if editing.
	if ($ME::varsInitialized > 0) return; //doesnt work
	
	if ($MCEdit) return;

	$MCBBoxId = getObjectId($MCBBox);
	if ( $MCBBoxId == 0 ) return;
	$minCLX = 100000;
	$minCLY = 100000;
	$maxCLX = -$minCLX;
	$maxCLY = -$minCLY;
if (0) {
	%id = 0;
	while (%id = getNextObject($MCBBoxId,%id)) {
		%x=getPosition(%id,x);
		if (%x < $minCLX) $minCLX = %x;
		if (%x > $maxCLX) $maxCLX = %x;
		%y=getPosition(%id,y);
		if (%y < $minCLY) $minCLY = %y;
		if (%y > $maxCLY) $maxCLY = %y;
	}
} else {
	for (%i=0;%i<4;%i++) {
		%n=$MCBBox@"/"@%i;
		%x=getPosition(%n,x);
		if (%x < $minCLX) $minCLX = %x;
		if (%x > $maxCLX) $maxCLX = %x;
		%y=getPosition(%n,y);
		if (%y < $minCLY) $minCLY = %y;
		if (%y > $maxCLY) $maxCLY = %y;
	}
}
	$maxOb = (($maxCLX-$minCLX) * ($maxCLY-$minCLY)) / ($ObRadius * $ObRadius);
	$MCCityId = newObject($MCCity,SimShapeGroup);
	for (%i=0;%i<$maxOb;%i++) {
		// Random building
		%s = RandomInt(1,$nOb-1);
		// Random location
		while (1) {
			%x = RandomInt($minCLX,$maxCLX);
			%y = RandomInt($minCLY,$maxCLY);
			%tooclose = 0;
			%id = 0;
if (0) {
			while (%id = getNextObject($MCCityId,%id)) {
				%dx = %x - getPosition(%id,x);
				%dy = %y - getPosition(%id,y);
				if ( sqrt(%dx*%dx+%dy*%dy) < (0.9 * $ObRadius) ) {
					%tooclose = 1;
					break;
				}
			}
}
			if (%tooclose == 0) break;
		}
		CreateBuilding("s"@%i,%s,%x,%y);
	}
	Out("CreateCity "@$minCLX@","@$minCLY@" "@$maxCLX@","@$maxCLY@
		" maxOb="@$maxOb@" nnOb="@$nnOb@" ME::varsInitialized="@$ME::varsInitialized );
}
