// FILENAME:	DM_Mineshaft.cs
//
// AUTHOR:  	Com. Sentinal [M.I.B.]
//------------------------------------------------------------------------------

$missionName = "DM_Mineshaft";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = false;
}

function onMissionStart()
{
	marsSounds();

	$HercsAtDoor1 = 0;
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to DeathMatch Mineshaft! You can download this & other missions made by Com. Sentinal [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at www.starsiegemeninblack.cjb.net.");
}

function vehicle::onAdd(%vehicleId)
{
%vehicleId.name = getHUDName(%vehicleId);
}

function onMissionLoad()
{
   cdAudioCycle("Newtech", "CloudBurst", "Terror"); 
}

function door1::trigger::onEnter(%this, %vehicleId)
{
	if($hercsAtDoor1 == 0)
      {
		playAnimSequence(getObjectId("MissionGroup\\Door1"), 0, true);
	}
	$hercsAtDoor1 = $hercsAtDoor1 + 1;
}

function door1::trigger::onLeave(%this, %vehicleId)
{
	$hercsAtDoor1 = $hercsAtDoor1 - 1;
	if($hercsAtDoor1 == 0)
      {
		playAnimSequence(getObjectId("MissionGroup\\Door1"), 0, false);
	}
}

function boom::trigger::onContact(%this, %vehicleId)
{
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
   healObject(%vehicleId, -10000);
}

function mineshaft::trigger::onEnter(%this, %vehicleId)
{
   say("Everybody", 1, %vehicleId.name @ " fell down the mineshaft!");
}

function Cache1::trigger::onContact(%this, %object)
{
	setPosition(%object, 703.785, 1092.5, 1789.5);
}

function Cache2::trigger::onContact(%this, %object)
{
	setPosition(%object, 706.2, 977.044, 1789.5);
}

function Cache3::trigger::onContact(%this, %object)
{
	setPosition(%object, 426.253, 405.3, 1789.5);
}

function Cache4::trigger::onContact(%this, %object)
{
	setPosition(%object, 559.101, 404.5, 1789.5);
}