// FILENAME:	DM_City_at_Arms.cs
//
// AUTHOR:	S-110
//
// TERRAIN & ORIGIONAL LAYOUT:	Chupie Doll & Youth in Asia
//------------------------------------------------------------------------------

$missionName = "DM_City_at_Arms";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}
function setRules()
{
   if($server::TeamPlay == true)
	{
      %rules = "<F2>GAME TYPE: \n<F0>Telepad Team Deathmatch\n\n"   @        
               "<tIDMULT_TDM_MAPNAME>"    @ 
               $missionName               @
               "<tIDMULT_TDM_OBJECTIVES>" @
               "<tIDMULT_TDM_SCORING_1>"  @
               "<tIDMULT_TDM_SCORING_2>"  @
               $killPoints                @
               "<tIDMULT_TDM_SCORING_3>"  @
               "<tIDMULT_TDM_SCORING_4>"  @
               $deathPoints               @
               "<tIDMULT_TDM_SCORING_5>"  @
               "<tIDMULT_TDM_SCORING_6>"  @
               "<F2>ITEMS OF INTEREST:\n\nThe city uses teleporting Heal, Reload, and Zen pads.\n\n"      @
               "<F5>TO USE THE PADS:\n\n" @
               "<F0>1) Move toward the middle of the pad until transportation begins. \n\n"	@
               "2) When transport BEGINS, shut down your vehicle. \n\n"		@
               "3) After healing or reloading, RESTART your vehicle to return to the city. \n\n"		@
               "<F5>NOTE: If your vehicle is running when transport completes, or the pad \n"	@
               "energy is depleted, you will be returned to the city without being healed \n"	@
               "or reloaded. Minor falling damage somtimes occurs during transport. \n\n "	@
               "<tIDMULT_STD_HEAL>"       @
               "<tIDMULT_STD_RELOAD_1>"   @
               $PadWaitTime               @
               "<tIDMULT_STD_RELOAD_2>"   @
               "<tIDMULT_STD_ZEN_1>"      @
               $ZenWaitTime               @
               "<tIDMULT_STD_ZEN_2>";
   }
	else
	{
   %rules = "<F2>GAME TYPE: \n<F0>Telepad Deathmatch\n\n"   @        
               "<tIDMULT_DM_MAPNAME>"     @ 
               $missionName               @
               "<tIDMULT_DM_OBJECTIVES>"  @
               "<tIDMULT_DM_SCORING_1>"   @
               "<tIDMULT_DM_SCORING_2>"   @
               $killPoints                @
               "<tIDMULT_DM_SCORING_3>"   @
               "<tIDMULT_DM_SCORING_4>"   @
               $deathPoints               @
               "<tIDMULT_DM_SCORING_5>"   @
               "<F2>ITEMS OF INTEREST:\n\nThe city uses teleporting Heal, Reload, and Zen pads.\n\n"      @
               "<F5>TO USE THE PADS:\n\n" @
               "<F0>1) Move toward the middle of the pad until transportation begins. \n\n"	@
               "2) When transport BEGINS, shut down your vehicle. \n\n"		@
               "3) After healing or reloading, RESTART your vehicle to return to the city. \n\n"		@
               "<F5>NOTE: If your vehicle is running when transport completes, or the pad \n"	@
               "energy is depleted, you will be returned to the city without being healed \n"	@
               "or reloaded. Minor falling damage somtimes occurs during transport. \n\n "	@
               "<tIDMULT_STD_HEAL>"       @
               "<tIDMULT_STD_RELOAD_1>"   @
               $PadWaitTime               @
               "<tIDMULT_STD_RELOAD_2>"   @
               "<tIDMULT_STD_ZEN_1>"      @
               $ZenWaitTime               @
               "<tIDMULT_STD_ZEN_2>";
                  
   // display this string in the panel
   }
   setGameInfo(%rules);      
}

// setup the rules
// this has to be called after the definition of setRules
setRules();

function onMissionLoad()
{
   cdAudioCycle("Mechsoul", "Cyberntx", "Terror");
}

function player::onAdd(%who) 

{ 

	
   if($server::TeamPlay == true)
	{
        

		say(%who, 0, "<F1>Welcome to Telepad Team Deathmatch!\n" 
		@ "<JL><F5>RULES MANDATORY READING!\n"  
		@ "<JL><F5>IMPORTANT! The Info tab contains operating instructions for " 
		@ "the HEAL, RELOAD, and ZEN pads!\n"
		@ "<JL><F0>Check the Game Info tab for rules and scoring information!"); 
       }
	else
	{
		say(%who, 0, "<F1>Welcome to Telepad Deathmatch!\n" 
		@ "<JL><F5>RULES MANDATORY READING!\n"  
		@ "<JL><F5>IMPORTANT! The Info tab contains operating instructions for " 
		@ "the HEAL, RELOAD, and ZEN pads!\n"
		@ "<JL><F0>Check the Game Info tab for rules and scoring information!"); 
       }

} 


function onMissionStart()
{
	initGlobalVars();

	// Keep tracks of hercs near a door
	$HercsAtDoor1 = 0;
	$HercsAtDoor2 = 0;

	marsSounds();
}

// Water splashing functionality
//------------------------------------------------------------------------------
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was just destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}

//operate the doors
//------------------------------------------------------------------------------
function door1::trigger::onEnter(%this, %vehicleId){
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, true);
	}
	$hercsAtDoor1 = $hercsAtDoor1 + 1;
}
function door1::trigger::onLeave(%this, %vehicleId){
	$hercsAtDoor1 = $hercsAtDoor1 - 1;
	if($hercsAtDoor1 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door1"), 0, false);
	}
}
function door2::trigger::onEnter(%this, %vehicleId){
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, true);
	}
	$hercsAtDoor2 = $hercsAtDoor2 + 1;
}
function door2::trigger::onLeave(%this, %vehicleId){
	$hercsAtDoor2 = $hercsAtDoor2 - 1;
	if($hercsAtDoor2 == 0){
		playAnimSequence(getObjectId("MissionGroup\\Stuff\\Door2"), 0, false);
	}
}


// return random teleporter function
//------------------------------------------------------------------------------

function backTransport( %object, %x1, %y1, %x2, %y2)
{
   // set the position of %object to a randow spot within the space
   // bounded by (x1, y1) and (x2, y2).  The Z coordinate is going to
   // be set to 40 meters above the terrain at the new point.
   
   %x = randomInt(%x1, %x2);
   %y = randomInt(%y1, %y2);
   %z = getTerrainHeight(%x, %y) + 15;

	%playerNum = playerManager::vehicleIdToPlayerNum(%object);
 
   // play a sound at both locations
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);
   
   if(%playerNum != 0)
   {
   	fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
   	schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 1.2);
   }
   schedule(strcat("setPosition(", %object, ",", %x,",", %y,",", %z,");"), 1.0);   
}

// teleporter pad functions


// random teleporter function
//------------------------------------------------------------------------------

function randomTransport( %object, %x1, %y1, %x2, %y2)
{
   // set the position of %object to a randow spot within the space
   // bounded by (x1, y1) and (x2, y2).  The Z coordinate is going to
   // be set to 40 meters above the terrain at the new point.
   
   %x = randomInt(%x1, %x2);
   %y = randomInt(%y1, %y2);
   %z = getTerrainHeight(%x, %y) + 80;

	%playerNum = playerManager::vehicleIdToPlayerNum(%object);
 
   // play a sound at both locations
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);
   
   if(%playerNum != 0)
   {
   	fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
   	schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 1.2);
   }
   schedule(strcat("setPosition(", %object, ",", %x,",", %y,",", %z,");"), 1.0);   
}

// teleporter pad functions
//------------------------------------------------------------------------------

//pad modificaions
function Zen::work(%trigger, %object, %healRate, %ammoRate, %reset, %shutdown)
{
   // %trigger has been activated
   // %object receives %healRate amount of healing
   // %object receives %ammoRate percent of ammo to each weapon
   // %reset is how many seconds must pass before trigger is recharged
   // %shutdown is a boolean -- whether or not trigger requires shutdown
   // if restarts then sent back to the city
      
   if(
      (
         isShutDown(%object) == true ||      // is vehicle shut down?
         %shutdown == false                  // does it even matter?
      ) &&
      (
         %trigger.wait == false ||     // is trigger ready?
         %trigger.wait == "" ||
         %trigger.special == %object   // is object special?   
      ) &&
      (
         %trigger.depleted == "" ||    // is pad not depleted
         %trigger.depleted == false
      )
   )   
   {
      if(%healRate > 0)
      {
         // do the healing bit
         healObject(%object, %healRate);
      }
      
      if(%ammoRate > 0)
      {   
         // and the reloading bit
         reloadObject(%object, %ammoRate);
      }

      if(
         %reset > 0 &&           // if we require a reset   
         %trigger.reset == ""    // and it's not already scheduled
      )
      {      
         // make this object special
         %trigger.special = %object;
         %object.pad = %trigger; // cross-link it

         // schedule the depletion time (one third of reset time)
         schedule("Zen::depleted(" @ %trigger @ ");", (%reset / 3));

         // schedule the recharge time and store it for later
         %trigger.reset = schedule("Zen::recharged(" @ %trigger @ ");", %reset);
        
         // trigger is no longer ready
         %trigger.wait = true;
      }
   }
   else
   {
      // check to see if player has shut down and started up again
   
      if(
         %object == %trigger.special &&   // if object is special
         %shutdown == true &&             // and is on a pad that requires shutdown
         isShutDown(%object) == false     // and is no longer shut down
      )
      {
         // object is no longer special
         %trigger.special.pad = "";
         %trigger.special = "";      
      }
	 backTransport(%object, -1500, -1500, 1500, 1500);
   }
}




// The following code is necessary for transporting to repair/ammo/zen pads
// ------------------------------------------------------------------------------

function ZenBlue::trigger::onEnter(%this, %vehicleId)
	{

	transportToBlueZen(%vehicleId);
}

function HealBlue::trigger::onEnter(%this, %vehicleId)
	{

	transportToBlueHeal(%vehicleId);
}

function AmmoBlue::trigger::onEnter(%this, %vehicleId)
	{

	transportToBlueAmmo(%vehicleId);
}

function ZenRed::trigger::onEnter(%this, %vehicleId)
	{

	transportToRedZen(%vehicleId);
}

function HealRed::trigger::onEnter(%this, %vehicleId)
	{

	transportToRedHeal(%vehicleId);
}

function AmmoRed::trigger::onEnter(%this, %vehicleId)
	{
	
	transportToRedAmmo(%vehicleId);
}

// transportation
//------------------------------------------------------------------------------

function transportToBlueZen(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated."); 
	echo("Transporting to Blue Zen");
	randomTransport(%vehicleId, 3556, 1616, 3556, 1616);
}
function transportToRedZen(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated.");
	echo("Transporting to Red Zen");
	randomTransport(%vehicleId, -2157, 3094, -2157, 3094);
}
function transportToBlueHeal(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated.");
	echo("Transporting to Blue Heal");
	randomTransport(%vehicleId, -3756, -2445, -3756, -2445);
}
function transportToRedHeal(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated.");
	echo("Transporting to Red Heal");
    	randomTransport(%vehicleId, 2739, -1807, 2739, -1807);
}
function transportToBlueAmmo(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated.");
	echo("Transporting to Blue Ammo");
	randomTransport(%vehicleId, 2804, 2811, 2804, 2811);
}
function transportToRedAmmo(%vehicleId)
{
   	say(%this, 0, "<F3>Telepad Activated.");
	echo("Transporting to Red Ammo");
	randomTransport(%vehicleId, -3072, 2665, -3072, 2665);
}
