// FILENAME:	DM_Canyon.cs
//
// AUTHOR:  	Gen. Raven [M.I.B.]
//
// RANDOM QUOTE: "Please get out of here."
//                          - Senator John McCain 
//------------------------------------------------------------------------------

$missionName = "DM_Canyon";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	plutoSounds();
      $boostpad1ready=true;
      $boostpad2ready=true;
      $boostpad3ready=true;
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to DeathMatch Canyon! Use the teleporters & transport pads to get around. Make sure you don't fall into the canyon. You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at www.starsiegemeninblack.cjb.net.");
}

function vehicle::onadd(%vehicleId)
{
   %vehicleId.boostpad1 = false;
   %vehicleId.boostpad2 = false;
   %vehicleId.boostpad3 = false;
}

function onMissionLoad()
{
   cdAudioCycle("NewTech", "Mechsoul", "Terror"); 
   setGameInfo("<F2>GAME TYPE:<F0>  DeathMatch\n\n<F2>MISSION:<F0>  DM_Canyon\n\nWelcome to DeathMatch Canyon. Use the teleporters & transport pads to get around. Make sure you don't fall into the canyon. To use the Transport Pads, enter one of them, then choose your destination by scanning the appropriate drone ball. You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at www.starsiegemeninblack.cjb.net.");
}

function kill::trigger::onEnter(%this,%object)
{
   healobject(%object,-50000);
   say(0,0,"<f1>" @ gethudname(%object) @ " fell into the canyon!");
}

function bluetele1::trigger::onEnter(%this,%object)
{
   setposition(%object,-1797.82,555.456,1288.35);
}

function bluetele2::trigger::onEnter(%this,%object)
{
   setposition(%object,-1262.49,568.956,1032.35);
}

function boostpad::trigger::onEnter(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad1=true;
   if($boostpad1ready==true)
   {
      say(%player,%player,"<f1>Entering Transport Pad. Scan a target drone to choose your destination.");
   }
   else if($boostpad1ready==false)
   {
      say(%player,%player,"<f1>Transport Pad is recharging. Please wait until pad is ready.");
   }
}

function boostpad2::trigger::onEnter(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad2=true;
   if($boostpad2ready==true)
   {
      say(%player,%player,"<f1>Entering Transport Pad. Scan a target drone to choose your destination.");
   }
   else if($boostpad2ready==false)
   {
      say(%player,%player,"<f1>Transport Pad is recharging. Please wait until pad is ready.");
   }
}

function boostpad3::trigger::onEnter(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad3=true;
   if($boostpad3ready==true)
   {
      say(%player,%player,"<f1>Entering Transport Pad. Scan a target drone to choose your destination.");
   }
   else if($boostpad3ready==false)
   {
      say(%player,%player,"<f1>Transport Pad is recharging. Please wait until pad is ready.");
   }
}

function boostpad::trigger::onLeave(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad1=false;
}

function boostpad2::trigger::onLeave(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad2=false;
}

function boostpad3::trigger::onLeave(%this,%object)
{
   %player=playermanager::vehicleIdtoplayerNum(%object);
   %player.boostpad3=false;
}

function basement::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad1==true)&&($boostpad1ready==true))
   {
      $boostpad1ready=false;
      goDown(%scanner);
      schedule("goDown(" @ %scanner @ ");",0.1);
      schedule("goDown(" @ %scanner @ ");",0.2);
      schedule("goDown(" @ %scanner @ ");",0.3);
      schedule("goDown(" @ %scanner @ ");",0.4);
      schedule("goDown(" @ %scanner @ ");",0.5);
      schedule("$boostpad1ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 001 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad1==true)&&($boostpad1ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function second::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad1==true)&&($boostpad1ready==true))
   {
      $boostpad1ready=false;
      goUp(%scanner);
      schedule("goUp(" @ %scanner @ ");",0.1);
      schedule("goUp(" @ %scanner @ ");",0.2);
      schedule("goUp(" @ %scanner @ ");",0.3);
      schedule("goUp(" @ %scanner @ ");",0.4);
      schedule("goUp(" @ %scanner @ ");",0.5);
      schedule("goUp(" @ %scanner @ ");",0.6);
      schedule("goUp(" @ %scanner @ ");",0.7);
      schedule("goUp(" @ %scanner @ ");",0.8);
      schedule("goUp(" @ %scanner @ ");",0.9);
      schedule("goUp(" @ %scanner @ ");",1.0);
      schedule("goUp(" @ %scanner @ ");",1.1);
      schedule("goUp(" @ %scanner @ ");",1.2);
      schedule("goUp(" @ %scanner @ ");",1.3);
      schedule("goUp(" @ %scanner @ ");",1.4);
      schedule("goUp(" @ %scanner @ ");",1.5);
      schedule("goUp(" @ %scanner @ ");",1.6);
      schedule("goUp(" @ %scanner @ ");",1.7);
      schedule("goUp(" @ %scanner @ ");",1.8);
      schedule("goUp(" @ %scanner @ ");",1.9);
      schedule("goUp(" @ %scanner @ ");",2.0);
      schedule("goUp(" @ %scanner @ ");",2.1);
      schedule("goUp(" @ %scanner @ ");",2.2);
      schedule("goUp(" @ %scanner @ ");",2.3);
      schedule("goUp(" @ %scanner @ ");",2.4);
      schedule("goUp(" @ %scanner @ ");",2.5);
      schedule("goUp(" @ %scanner @ ");",2.6);
      schedule("goUp(" @ %scanner @ ");",2.7);
      schedule("goUp(" @ %scanner @ ");",2.8);
      schedule("goUp(" @ %scanner @ ");",2.9);
      schedule("goUp(" @ %scanner @ ");",3.0);
      schedule("goUp(" @ %scanner @ ");",3.1);
      schedule("goUp(" @ %scanner @ ");",3.2);
      schedule("goUp(" @ %scanner @ ");",3.3);
      schedule("goUp(" @ %scanner @ ");",3.4);
      schedule("goUp(" @ %scanner @ ");",3.5);
      schedule("goUp(" @ %scanner @ ");",3.6);
      schedule("goUp(" @ %scanner @ ");",3.7);
      schedule("goUp(" @ %scanner @ ");",3.8);
      schedule("goUp(" @ %scanner @ ");",3.9);
      schedule("goUp(" @ %scanner @ ");",4.0);
      schedule("goUp(" @ %scanner @ ");",4.1);
      schedule("goUp(" @ %scanner @ ");",4.2);
      schedule("goUp(" @ %scanner @ ");",4.3);
      schedule("goUp(" @ %scanner @ ");",4.4);
      schedule("goUp(" @ %scanner @ ");",4.5);
      schedule("goUp(" @ %scanner @ ");",4.6);
      schedule("goUp(" @ %scanner @ ");",4.7);
      schedule("goUp(" @ %scanner @ ");",4.8);
      schedule("goUp(" @ %scanner @ ");",4.9);
      schedule("goUp(" @ %scanner @ ");",5.0);
      schedule("$boostpad1ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 001 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad1==true)&&($boostpad1ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function roof::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad1==true)&&($boostpad1ready==true))
   {
      $boostpad1ready=false;
      goUp(%scanner);
      schedule("goUp(" @ %scanner @ ");",0.1);
      schedule("goUp(" @ %scanner @ ");",0.2);
      schedule("goUp(" @ %scanner @ ");",0.3);
      schedule("goUp(" @ %scanner @ ");",0.4);
      schedule("goUp(" @ %scanner @ ");",0.5);
      schedule("goUp(" @ %scanner @ ");",0.6);
      schedule("goUp(" @ %scanner @ ");",0.7);
      schedule("goUp(" @ %scanner @ ");",0.8);
      schedule("goUp(" @ %scanner @ ");",0.9);
      schedule("goUp(" @ %scanner @ ");",1.0);
      schedule("goUp(" @ %scanner @ ");",1.1);
      schedule("goUp(" @ %scanner @ ");",1.2);
      schedule("goUp(" @ %scanner @ ");",1.3);
      schedule("goUp(" @ %scanner @ ");",1.4);
      schedule("goUp(" @ %scanner @ ");",1.5);
      schedule("goUp(" @ %scanner @ ");",1.6);
      schedule("goUp(" @ %scanner @ ");",1.7);
      schedule("goUp(" @ %scanner @ ");",1.8);
      schedule("goUp(" @ %scanner @ ");",1.9);
      schedule("goUp(" @ %scanner @ ");",2.0);
      schedule("goUp(" @ %scanner @ ");",2.1);
      schedule("goUp(" @ %scanner @ ");",2.2);
      schedule("goUp(" @ %scanner @ ");",2.3);
      schedule("goUp(" @ %scanner @ ");",2.4);
      schedule("goUp(" @ %scanner @ ");",2.5);
      schedule("goUp(" @ %scanner @ ");",2.6);
      schedule("goUp(" @ %scanner @ ");",2.7);
      schedule("goUp(" @ %scanner @ ");",2.8);
      schedule("goUp(" @ %scanner @ ");",2.9);
      schedule("goUp(" @ %scanner @ ");",3.0);
      schedule("goUp(" @ %scanner @ ");",3.1);
      schedule("goUp(" @ %scanner @ ");",3.2);
      schedule("goUp(" @ %scanner @ ");",3.3);
      schedule("goUp(" @ %scanner @ ");",3.4);
      schedule("goUp(" @ %scanner @ ");",3.5);
      schedule("goUp(" @ %scanner @ ");",3.6);
      schedule("goUp(" @ %scanner @ ");",3.7);
      schedule("goUp(" @ %scanner @ ");",3.8);
      schedule("goUp(" @ %scanner @ ");",3.9);
      schedule("goUp(" @ %scanner @ ");",4.0);
      schedule("goUp(" @ %scanner @ ");",4.1);
      schedule("goUp(" @ %scanner @ ");",4.2);
      schedule("goUp(" @ %scanner @ ");",4.3);
      schedule("goUp(" @ %scanner @ ");",4.4);
      schedule("goUp(" @ %scanner @ ");",4.5);
      schedule("goUp(" @ %scanner @ ");",4.6);
      schedule("goUp(" @ %scanner @ ");",4.7);
      schedule("goUp(" @ %scanner @ ");",4.8);
      schedule("goUp(" @ %scanner @ ");",4.9);
      schedule("goUp(" @ %scanner @ ");",5.0);
      schedule("goUp(" @ %scanner @ ");",5.1);
      schedule("goUp(" @ %scanner @ ");",5.2);
      schedule("goUp(" @ %scanner @ ");",5.3);
      schedule("goUp(" @ %scanner @ ");",5.4);
      schedule("goUp(" @ %scanner @ ");",5.5);
      schedule("goUp(" @ %scanner @ ");",5.6);
      schedule("goUp(" @ %scanner @ ");",5.7);
      schedule("goUp(" @ %scanner @ ");",5.8);
      schedule("goUp(" @ %scanner @ ");",5.9);
      schedule("goUp(" @ %scanner @ ");",6.0);
      schedule("goUp(" @ %scanner @ ");",6.1);
      schedule("goUp(" @ %scanner @ ");",6.2);
      schedule("goUp(" @ %scanner @ ");",6.3);
      schedule("goUp(" @ %scanner @ ");",6.4);
      schedule("goUp(" @ %scanner @ ");",6.5);
      schedule("goUp(" @ %scanner @ ");",6.6);
      schedule("goUp(" @ %scanner @ ");",6.7);
      schedule("goUp(" @ %scanner @ ");",6.8);
      schedule("goUp(" @ %scanner @ ");",6.9);
      schedule("goUp(" @ %scanner @ ");",7.0);
      schedule("goUp(" @ %scanner @ ");",7.1);
      schedule("goUp(" @ %scanner @ ");",7.2);
      schedule("goUp(" @ %scanner @ ");",7.3);
      schedule("$boostpad1ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 001 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad1==true)&&($boostpad1ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function first2::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad2==true)&&($boostpad2ready==true))
   {
      $boostpad2ready=false;
      goDown(%scanner);
      schedule("goDown(" @ %scanner @ ");",0.1);
      schedule("goDown(" @ %scanner @ ");",0.2);
      schedule("goDown(" @ %scanner @ ");",0.3);
      schedule("goDown(" @ %scanner @ ");",0.4);
      schedule("goDown(" @ %scanner @ ");",0.5);
      schedule("$boostpad2ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 002 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad2==true)&&($boostpad2ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function roof2::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad2==true)&&($boostpad2ready==true))
   {
      $boostpad2ready=false;
      goUp(%scanner);
      schedule("goUp(" @ %scanner @ ");",0.1);
      schedule("goUp(" @ %scanner @ ");",0.2);
      schedule("goUp(" @ %scanner @ ");",0.3);
      schedule("goUp(" @ %scanner @ ");",0.4);
      schedule("goUp(" @ %scanner @ ");",0.5);
      schedule("goUp(" @ %scanner @ ");",0.6);
      schedule("goUp(" @ %scanner @ ");",0.7);
      schedule("goUp(" @ %scanner @ ");",0.8);
      schedule("goUp(" @ %scanner @ ");",0.9);
      schedule("goUp(" @ %scanner @ ");",1.0);
      schedule("goUp(" @ %scanner @ ");",1.1);
      schedule("goUp(" @ %scanner @ ");",1.2);
      schedule("goUp(" @ %scanner @ ");",1.3);
      schedule("goUp(" @ %scanner @ ");",1.4);
      schedule("goUp(" @ %scanner @ ");",1.5);
      schedule("goUp(" @ %scanner @ ");",1.6);
      schedule("goUp(" @ %scanner @ ");",1.7);
      schedule("goUp(" @ %scanner @ ");",1.8);
      schedule("goUp(" @ %scanner @ ");",1.9);
      schedule("goUp(" @ %scanner @ ");",2.0);
      schedule("goUp(" @ %scanner @ ");",2.1);
      schedule("goUp(" @ %scanner @ ");",2.2);
      schedule("goUp(" @ %scanner @ ");",2.3);
      schedule("goUp(" @ %scanner @ ");",2.4);
      schedule("$boostpad2ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 002 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad2==true)&&($boostpad2ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function first3::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad3==true)&&($boostpad3ready==true))
   {
      $boostpad3ready=false;
      goDown(%scanner);
      schedule("goDown(" @ %scanner @ ");",0.1);
      schedule("goDown(" @ %scanner @ ");",0.2);
      schedule("goDown(" @ %scanner @ ");",0.3);
      schedule("goDown(" @ %scanner @ ");",0.4);
      schedule("goDown(" @ %scanner @ ");",0.5);
      schedule("goDown(" @ %scanner @ ");",0.6);
      schedule("goDown(" @ %scanner @ ");",0.7);
      schedule("goDown(" @ %scanner @ ");",0.8);
      schedule("goDown(" @ %scanner @ ");",0.9);
      schedule("goDown(" @ %scanner @ ");",1.0);
      schedule("goDown(" @ %scanner @ ");",1.1);
      schedule("goDown(" @ %scanner @ ");",1.2);
      schedule("goDown(" @ %scanner @ ");",1.3);
      schedule("goDown(" @ %scanner @ ");",1.4);
      schedule("goDown(" @ %scanner @ ");",1.5);
      schedule("goDown(" @ %scanner @ ");",1.6);
      schedule("goDown(" @ %scanner @ ");",1.7);
      schedule("goDown(" @ %scanner @ ");",1.8);
      schedule("goDown(" @ %scanner @ ");",1.9);
      schedule("goDown(" @ %scanner @ ");",2.0);
      schedule("goDown(" @ %scanner @ ");",2.1);
      schedule("goDown(" @ %scanner @ ");",2.2);
      schedule("goDown(" @ %scanner @ ");",2.3);
      schedule("goDown(" @ %scanner @ ");",2.4);
      schedule("goDown(" @ %scanner @ ");",2.5);
      schedule("goDown(" @ %scanner @ ");",2.6);
      schedule("goDown(" @ %scanner @ ");",2.7);
      schedule("goDown(" @ %scanner @ ");",2.8);
      schedule("goDown(" @ %scanner @ ");",2.9);
      schedule("goDown(" @ %scanner @ ");",3.0);
      schedule("$boostpad3ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 003 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad3==true)&&($boostpad3ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}

function second3::structure::onscan(%scanned,%scanner)
{
   %player=playermanager::vehicleIdtoplayerNum(%scanner);
   if((%player.boostpad3==true)&&($boostpad3ready==true))
   {
      $boostpad3ready=false;
      goDown(%scanner);
      schedule("goDown(" @ %scanner @ ");",0.1);
      schedule("goDown(" @ %scanner @ ");",0.2);
      schedule("goDown(" @ %scanner @ ");",0.3);
      schedule("goDown(" @ %scanner @ ");",0.4);
      schedule("goDown(" @ %scanner @ ");",0.5);
      schedule("$boostpad3ready=true;",10);
      schedule("say(0,0,\"<f1>Transport Pad 003 is ready.\",\"sfx_machine3.wav\");",10);
   }
   else if((%player.boostpad3==true)&&($boostpad3ready==false))
   {
      say(%player,%player,"<f1>Transport Pad is not ready.");
   }
}
     
function goDown(%scanner)
{
   %x=getposition(%scanner,x);
   %y=getposition(%scanner,y);
   %z=getposition(%scanner,z)-5;
   setposition(%scanner,%x,%y,%z);
}

function goUp(%scanner)
{
   %x=getposition(%scanner,x);
   %y=getposition(%scanner,y);
   %z=getposition(%scanner,z)+5;
   setposition(%scanner,%x,%y,%z);
}

