// FILENAME:	DM_All_the_way_up.cs
//
// AUTHOR:  	Kowh, based on DM_City_on_the_Edge
//------------------------------------------------------------------------------

$missionName = "DM_All_the_way_up";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
   // custom rules for this mission ( teleporter )
   %rules = "<tIDMULT_TDM_GAMETYPE>"   @        
            "<tIDMULT_TDM_MAPNAME>"    @ 
            $missionName               @
            "<tIDMULT_TDM_OBJECTIVES>" @
            "<tIDMULT_TDM_SCORING_1>"  @
            "<tIDMULT_TDM_SCORING_2>"  @
            $killPoints                @
            "<tIDMULT_TDM_SCORING_3>"  @
            "<tIDMULT_TDM_SCORING_4>"  @
            $deathPoints               @
            "<tIDMULT_TDM_SCORING_5>"  @
            "<tIDMULT_TDM_SCORING_6>"  @
            "<tIDMULT_STD_ITEMS>"      @
            "<tIDMULT_STD_TELEPORTER>" @
            "<tIDMULT_STD_HEAL>"       @
            "<tIDMULT_STD_RELOAD>";

   setGameInfo(%rules);
}

function myTransport( %object, %x, %y, %z)
{
   %playerNum = playerManager::vehicleIdToPlayerNum(%object);
 
   // play a sound at both locations
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %object);
   playSound(0, IDSFX_TELEPORTER, IDPRF_NEAR, %x, %y, %z);
   
   if(%playerNum != 0)
   {
   	fadeEvent(%playerNum, out, 1.0, 1.0, 1.0, 1.0);
   	schedule(strcat("fadeEvent(", %playerNum, ",in, 1.0, 1.0, 1.0, 1.0);"), 0.7);
   }
   schedule(strcat("setPosition(", %object, ",", %x,",", %y,",", %z,");"), 0.5);   
}

function monumap::structure::onAttacked(%this, %vehicleId){
	myTransport(%vehicleId, -20, 280, 510);
}

function blueup1::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 175, 290);
}

function blueup2::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 175, 390);
}

function blueup3::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 175, 510);
}

function bluedown1::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -120, 175, 390);
}

function bluedown2::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -120, 175, 290);
}

function bluedown3::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -120, 175, 190);
}

function redup1::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 400, 290);
}

function redup2::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 400, 390);
}

function redup3::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, 80, 400, 510);
}

function reddown1::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -110, 400, 390);
}

function reddown2::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -110, 400, 290);
}

function reddown3::trigger::onEnter(%this, %vehicleId){
	myTransport(%vehicleId, -110, 400, 190);
}