//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


//	Filename:		DM_NHMK_6.cs

// these two lines should begin every dm/tdm script file
exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");


function player::onAdd(%this)
{
   player::onAddLog(%this);
	
	if($server::TeamPlay == "True")
	{
	   // welcome to starsiege team deathmatch, chupie doll!
      say(%this,0,strcat(*IDMULT_RULES_WELCOME, " ", *IDMULT_TDM, ", ", getName(%this), "!"));
      // score is based on a kill-to-death ratio.
	   say(%this,0,*IDMULT_TDM_RULES1);
      // one kill is subtracted for killing a teammate.	   
      say(%this,0,*IDMULT_TDM_RULES2);
      // enemy transporters will return you to your home base
      say(%this,0,*IDMULT_CHAT_ENEMY_TRANSPORTERS);	      
   }
	else
	{
		setTeam(%this, *IDSTR_TEAM_RED);	
	
      // welcome to starsiege deathmatch, chupie doll!
      say(%this,0,strcat(*IDMULT_RULES_WELCOME, " ", *IDMULT_DM, ", ", getName(%this), "!"));
      // score is based on a kill-to-death ratio.
	   say(%this,0,*IDMULT_DM_RULES1);	
   }
}   


// Initialization
//--------------------------------------------------------------------------------

function setDefaultMissionOptions()
{
	$server::TeamPlay = True;		// for TDM_ games
	$server::AllowDeathmatch = true;
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionStart()
{
   if($server::TeamPlay == false)
   {
      // shutdown the turrets
        order("MissionGroup\\PurpleBase\\Turret_H_M_LS1", "HoldFire", true);
        order("MissionGroup\\RedBase\\Turret_H_M_LS1", "HoldFire", true);
        order("MissionGroup\\BlueBase\\Turret_H_M_LS1", "HoldFire", true);
        order("MissionGroup\\YellowBase\\Turret_H_M_LS1", "HoldFire", true);      
   }
   
      
   // some constants used
	$BlueHealTotal = 100;
	$BlueHealAmount = $BlueHealTotal;  // this will change as buildings get destroyed
   $BlueAmmoTotal = 6;
   $BlueAmmoAmount = $BlueAmmoTotal; // this will change as buildings get destroyed
   
   $RedHealTotal = 100;
	$RedHealAmount = $RedHealTotal;  // this will change as buildings get destroyed
   $RedAmmoTotal = 6;
   $RedAmmoAmount = $RedAmmoTotal; // this will change as buildings get destroyed
   
   $YellowHealTotal = 100;
	$YellowHealAmount = $YellowHealTotal;  // this will change as buildings get destroyed
   $YellowAmmoTotal = 6;
   $YellowAmmoAmount = $YellowAmmoTotal; // this will change as buildings get destroyed
   
   $PurpleHealTotal = 100;
	$PurpleHealAmount = $PurpleHealTotal;  // this will change as buildings get destroyed
   $PurpleAmmoTotal = 6;
   $PurpleAmmoAmount = $PurpleAmmoTotal; // this will change as buildings get destroyed
   
   $blastRadiusSmall = 100;   // for ammo boxes
   $blastDamageSmall = 4000;   
   
   $padWaitTime = 0; // if this changes, then additional code necessary for triggers
}



// Healing and Ammo Pads
//--------------------------------------------------------------------------------

// 	Each base has a heal and ammo pad that have the following behaviors:
//	-	Shutdown to activate
//	-	No recharge time
//  - 	Pad messages include:  "Has been entered..." && "xPad at y% Capacity" || "yPad disabled"
//	-  	Hea's and reloads and default rate

//  Healing Pads can be at 100% strength or disabled
//  This is determined by the teams Solar Power Station which has its own script class "HealC"
//		where C is the first letter of that base's colour
//		(See HealC::structure::onDestroyed(%this, %who))

//	Ammo pads can be at 100%, 50% strength, or disabled
//  This is determined by the team's Ammunitions Containers which are attached to the script class "AmmoC"
//		where C is the first letter of that base's colour
//		(See AmmoC::structure::onDestroyed(%this, %who))

function YellowHeal::trigger::onEnter(%this, %object)
{
   // no ready, no countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);
   displayPercentage(%object, ($YellowHealAmount * 100 / $YellowHealTotal));  
}
function YellowHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $YellowHealAmount, 0, $padWaitTime, true);    
}

function YellowAmmo::trigger::onEnter(%this, %object)
{
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);
   displayPercentage(%object, ($YellowAmmoAmount * 100 / $YellowAmmoTotal));     
}
function YellowAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $YellowAmmoAmount, $padWaitTime, true);    
}

function RedHeal::trigger::onEnter(%this, %object)
{
   // no ready, no countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);
   displayPercentage(%object, ($RedHealAmount * 100 / $RedHealTotal));
}
function RedHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $RedHealAmount, 0, $padWaitTime, true);    
}

function RedAmmo::trigger::onEnter(%this, %object)
{
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);
   displayPercentage(%object, ($RedAmmoAmount * 100 / $RedAmmoTotal));     
}
function RedAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $RedAmmoAmount, $padWaitTime, true);    
}

function BlueHeal::trigger::onEnter(%this, %object)
{
   // no ready, no countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);
   displayPercentage(%object, ($BlueHealAmount * 100 / $BlueHealTotal));
}
function BlueHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $BlueHealAmount, 0, $padWaitTime, true);    
}

function BlueAmmo::trigger::onEnter(%this, %object)
{
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);
   displayPercentage(%object, ($BlueAmmoAmount * 100 / $BlueAmmoTotal));     
}
function BlueAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $BlueAmmoAmount, $padWaitTime, true);    
}

function PurpleHeal::trigger::onEnter(%this, %object)
{
   // no ready, no countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);
   displayPercentage(%object, ($PurpleHealAmount * 100 / $PurpleHealTotal));
}
function PurpleHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $PurpleHealAmount, 0, $padWaitTime, true);    
}

function PurpleAmmo::trigger::onEnter(%this, %object)
{
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);
   displayPercentage(%object, ($PurpleAmmoAmount * 100 / $PurpleAmmoTotal));     
}
function PurpleAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $PurpleAmmoAmount, $padWaitTime, true);    
}




// Base Damage Functionality
//--------------------------------------------------------------------------------
function AmmoY::structure::onDestroyed(%destroyed, %destroyer)
{
	$YellowAmmoAmount -= $YellowAmmoTotal / 2;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PowerY::structure::onDestroyed(%destroyed, %destroyer)
{
	$YellowHealAmount = 0;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function AmmoR::structure::onDestroyed(%destroyed, %destroyer)
{
	$RedAmmoAmount -= $RedAmmoTotal / 2;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PowerR::structure::onDestroyed(%destroyed, %destroyer)
{
	$RedHealAmount = 0;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function AmmoB::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueAmmoAmount -= $BlueAmmoTotal / 2;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PowerB::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueHealAmount = 0;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function AmmoP::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleAmmoAmount -= $PurpleAmmoTotal / 2;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PowerP::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleHealAmount = 0;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}



// Transporters
//--------------------------------------------------------------------------------
//	Each base has four transporters of the form:  <ThisBaseColour>To<BaseColourToGoto> || <BaseColourToGoto>ToMountain
//  If a player enters a transporter on their base, it take them to <BaseColourToGoto>
//  Else they are transported to their own base...
function YellowToBlue::trigger::onEnter(%this, %who)
{
	// If this guy is not yellow
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_YELLOW
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToBlueBase(%who);
   }
}
function YellowToRed::trigger::onEnter(%this, %who)
{
	// If this guy is not yellow
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_YELLOW
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToRedBase(%who);
   }
}
function YellowToPurple::trigger::onEnter(%this, %who)
{
	// If this guy is not yellow
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_YELLOW
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToPurpleBase(%who);
   }
}
function YellowToMountain::trigger::onEnter(%this, %who)
{
	// If this guy is not yellow
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_YELLOW
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToMountain(%who);
   }
}


function RedToBlue::trigger::onEnter(%this, %who)
{
	// If this guy is not red
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_RED
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToBlueBase(%who);
   }
}
function RedToYellow::trigger::onEnter(%this, %who)
{
	// If this guy is not red
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_RED
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToYellowBase(%who);
   }
}
function RedToPurple::trigger::onEnter(%this, %who)
{
	// If this guy is not red
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_RED
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToPurpleBase(%who);
   }
}
function RedToMountain::trigger::onEnter(%this, %who)
{
	// If this guy is not red
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_RED
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToMountain(%who);
   }
}


function BlueToYellow::trigger::onEnter(%this, %who)
{
	// If this guy is not blue
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_BLUE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToYellowBase(%who);
   }
}
function BlueToRed::trigger::onEnter(%this, %who)
{
	// If this guy is not blue
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_BLUE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToRedBase(%who);
   }
}
function BlueToPurple::trigger::onEnter(%this, %who)
{
	// If this guy is not blue
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_BLUE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToPurpleBase(%who);
   }
}
function BlueToMountain::trigger::onEnter(%this, %who)
{
	// If this guy is not blue
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_BLUE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToMountain(%who);
   }
}


function PurpleToBlue::trigger::onEnter(%this, %who)
{
	// If this guy is not purple
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_PURPLE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToBlueBase(%who);
   }
}
function PurpleToRed::trigger::onEnter(%this, %who)
{
	// If this guy is not purple
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_PURPLE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToRedBase(%who);
   }
}
function PurpleToYellow::trigger::onEnter(%this, %who)
{
	// If this guy is not purple
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_PURPLE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToYellowBase(%who);
   }
}
function PurpleToMountain::trigger::onEnter(%this, %who)
{
	// If this guy is not purple
   if(
      $server::TeamPlay == true &&
      getTeam(%who) != *IDSTR_TEAM_PURPLE
   )
   {
	   transportToHomeBase(%who);
   }
	else
   {
      transportToMountain(%who);
   }
}




function transportToBlueBase(%vehicleId)
{
   randomTransport(%vehicleId, 2151, 1078, 400,    2185, 802, 400);
}
function transportToYellowBase(%vehicleId)
{
   randomTransport(%vehicleId, 582, -2016, 205,    715, -1968, 205);
}
function transportToRedBase(%vehicleId)
{
   randomTransport(%vehicleId, 669, 3201, 505,     746, 3046, 505);
}
function transportToPurpleBase(%vehicleId)
{
   randomTransport(%vehicleId, -2948, 66, 415,    -3041, -117, 415);
}
function transportToMountain(%vehicleId)
{
	// Transport to any of the following:
	%where = randomInt(1,4);
   
   if(%where == 1)
   {
      setPosition(%vehicleId, 306, 160, 840);
   }
   else if(%where == 2)
   {
      setPosition(%vehicleId, -290, 11, 918);   
   }
   else if(%where == 3)
   {
      setPosition(%vehicleId, -585, 690, 980);
   }
   else
   {
      setPosition(%vehicleId, -167, 739, 983);
   }
}
function transportToHomeBase(%vehicleId)
{
	// What colour is this person?
   %teamName = getTeam(%vehicleId);
   
	// Call the appropriate transport function (above) and get them home
   if(%teamName == *IDSTR_TEAM_YELLOW)
   {
      transportToYellowBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_RED)
   {
      transportToRedBase(%vehicleId);
   }
   else if(%teamName == *IDSTR_TEAM_BLUE)
   {
      transporttoBlueBase(%vehicleId);
   }
   else
   {
      transportToPurpleBase(%vehicleId);
   }   
}

// The following code is necessary for everything on the mountain
// ------------------------------------------------------------------------------

// ->	Must shutdown
// ->  	Complete instant heal and reload
// ->	No recharge time
// ->	Indicate "has been entered" and "Reloading/Healing" messages
function ZenAll::trigger::onEnter(%this, %who)
{
   Zen::onEnter(%this, %who, *IDMULT_CHAT_ALLPAD, false, false); 
}
function ZenAll::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 100000, 100, 0, true);
}

function ZenTransporter::trigger::onContact(%this, %object)
{
	setPosition(%object, -183, 573, 1400);
}



