//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


//	Filename:	DM_NHMK_7.cs

// these two lines should begin every dm/tdm script file
exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");


// Initialization
//--------------------------------------------------------------------------------

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;		// for TDM_ games
	$server::AllowDeathmatch = True;
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionStart()
{
   // some constants used
	$BlueHealTotal = 100;
	$BlueHealAmount = $BlueHealTotal;  // this will change as buildings get destroyed
   $BlueAmmoTotal = 6;
   $BlueAmmoAmount = $BlueAmmoTotal; // this will change as buildings get destroyed
   
   $RedHealTotal = 100;
	$RedHealAmount = $RedHealTotal;  // this will change as buildings get destroyed
   $RedAmmoTotal = 6;
   $RedAmmoAmount = $RedAmmoTotal; // this will change as buildings get destroyed
   
   $YellowHealTotal = 100;
	$YellowHealAmount = $YellowHealTotal;  // this will change as buildings get destroyed
   $YellowAmmoTotal = 6;
   $YellowAmmoAmount = $YellowAmmoTotal; // this will change as buildings get destroyed
   
   $PurpleHealTotal = 100;
	$PurpleHealAmount = $PurpleHealTotal;  // this will change as buildings get destroyed
   $PurpleAmmoTotal = 6;
   $PurpleAmmoAmount = $PurpleAmmoTotal; // this will change as buildings get destroyed
   
   $padWaitTime = 30;
}

//  Needed:

//	RedAmmo
//	RedHeal
//	BlueAmmo
//	BlueHeal
//	PurpleAmmo
//	PurpleHeal
//	YellowAmmo
//	YellowHeal

//  Anyone can use anyone elses pads
//	Pads have 30 second recharge times
//  Pads work at 100% or are disabled depending whether the script class object PowerC has been destroyed
//	Each base has one structure of this class; destruction effect that base's pads only

// Zen Healing & Ammo pad functionality
//--------------------------------------------------------------------------------

// Blue Pad Functionality
//--------------------------------------------------------------------------------
function BlueHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);
   displayPercentage(%object, ($BlueHealAmount * 100 / $BlueHealTotal));       
}
function BlueHeal::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function BlueHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $BlueHealAmount, 0, $padWaitTime, true); 
}

function BlueAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);
   displayPercentage(%object, ($BlueAmmoAmount * 100 / $BlueAmmoTotal));       
}
function BlueAmmo::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function BlueAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $BlueAmmoAmount, $padWaitTime, true); 
}



// Red Pad Functionality
//--------------------------------------------------------------------------------
function RedHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);
   displayPercentage(%object, ($RedHealAmount * 100 / $RedHealTotal));       
}
function RedHeal::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function RedHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $RedHealAmount, 0, $padWaitTime, true); 
}

function RedAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
   displayPercentage(%object, ($RedAmmoAmount * 100 / $RedAmmoTotal));  
}
function RedAmmo::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function RedAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $RedAmmoAmount, $padWaitTime, true); 
}


// Yellow Pad Functionality
//--------------------------------------------------------------------------------
function YellowHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
   displayPercentage(%object, ($YellowHealAmount * 100 / $YellowHealTotal));  
}
function YellowHeal::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function YellowHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $YellowHealAmount, 0, $padWaitTime, true); 
}

function YellowAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
   displayPercentage(%object, ($YellowAmmoAmount * 100 / $YellowAmmoTotal));  
}
function YellowAmmo::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function YellowAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $YellowAmmoAmount, $padWaitTime, true); 
}


// Purple Pad Functionality
//--------------------------------------------------------------------------------
function PurpleHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
   displayPercentage(%object, ($PurpleHealAmount * 100 / $PurpleHealTotal));  
}
function PurpleHeal::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function PurpleHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $PurpleHealAmount, 0, $padWaitTime, true); 
}

function PurpleAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
   displayPercentage(%object, ($PurpleAmmoAmount * 100 / $PurpleAmmoTotal));  
}
function PurpleAmmo::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);
}
function PurpleAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $PurpleAmmoAmount, $padWaitTime, true); 
}




// Base Damage Functionality
//--------------------------------------------------------------------------------
function PowerY::structure::onDestroyed(%destroyed, %destroyer)
{
	$YellowAmmoAmount = 0;
   $YellowHealAmount = 0;
}
function PowerR::structure::onDestroyed(%destroyed, %destroyer)
{
	$RedAmmoAmount = 0;
   $RedHealAmount = 0;
}
function PowerB::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueAmmoAmount = 0;
   $BlueHealAmount = 0;
}
function PowerP::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleAmmoAmount = 0;
   $PurpleHealAmount = 0;
}



function Transporter1::trigger::onEnter(%this, %object)
{
	setPosition(%object, -1739, 799, 320);
}

// 	Everything else is standard; no Guardians have been added.