//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


//	Filename:		DM_NHMK_3.cs

// these two lines should begin every dm/tdm script file
exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");



// Initialization
//--------------------------------------------------------------------------------

function setDefaultMissionOptions()
{
	$server::TeamPlay = False;		// for TDM_ games
	$server::AllowDeathmatch = True;
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;
}

function onMissionStart()
{
   // some constants used
   $healRate = 50;   
   $ammoRate = 5;
   $padWaitTime = 30;
   
   $blastRadius = 150;
   $blastDamage = 12000;
  
}



// Zen Healing & Ammo pad functionality
//--------------------------------------------------------------------------------

// For this mission, ZenAll should behave as follows:
//	- Announces it has been entered
//	- Automatically completely heals & reloads object (no shut-down necessary)
//	- Takes 3 minutes to recharge
//---------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   // show message
   // say whether or not it is ready and supply countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  

   // completely heal and reload instantly -- resets in 3 minutes
   // no shutdown necessary
   Zen::work(%this, %object, 100000, 100, 180, false);    
}

function ZenAll::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);  
}



//	For this mission, ZenHeal should behave as follows:
//	- Announces it has been entered
//	- Heals object at normal rate; shut-down is necessary
//	- Recharge takes 30 seconds
//---------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}

function ZenHeal::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);  
}

function ZenHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

//	For this mission, ZenAmmo should behave as follows:
//	- Announce it has been entered
//	- Reloads object at normal rate; shut-down is necessary
//	- Recharge takes 30 seconds
//---------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}




// Transporters
//--------------------------------------------------------------------------------
function ZenAllTransporter::trigger::onEnter(%this, %object)
{
   // this is the location of the zenall trigger
   setPosition(%object, 1521, -1393, 271);
}

//---------------------------------------------------------------------------
function randomTransporter::trigger::onEnter(%this, %object){
	// Transport this person to any of the following coordinates:
	//	1526,1087,332
	//      1423,511,295
	//	1187,650,280
	//	912,925,280
	//	1187,1200,280
	//	1462,925,280

   %where = randomInt(1,6);
   
   if(%where == 1)
   {
      setPosition(%object, 1526, 1087, 332);
   }
   else if(%where == 2)
   {
      setPosition(%object, 1423, 511, 295);
   }
   else if(%where == 3)
   {
      setPosition(%object, 1187, 650, 280);
   }
   else if(%where == 4)
   {
      setPosition(%object, 912, 925, 280);
   }
   else if(%where == 5)
   {
      setPosition(%object, 1187, 1200, 280);
   }
   else
   {
      setPosition(%object, 1462, 925, 280);
   } 

	// Destroy anyone within $blastRadius meters of %this (but not %object!!!)
   blast(%this, $blastRadius, $blastDamage, %object);

	transporterExplosion();		// Create cool explosion
}

// transporterExplosion()
//		Called when vehicle hits randomtransporter trigger
//---------------------------------------------------------------------------
function transporterExplosion()
{
	dropPod(1217.8, 894.2, 155, 1150, 962.0, 155);
	dropPod(1150, 962.0, 155, 1217.8, 894.2, 155);
	dropPod(1150.0, 894.3, 155, 1217.9, 961.9, 155);
	dropPod(1217.9, 961.9, 155, 1150.0, 894.3, 155);
}



