//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


//	Filename:		DM_NHMK_4.cs

// these two lines should begin every dm/tdm script file
exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

// Initialization
//--------------------------------------------------------------------------------

function setDefaultMissionOptions()
{
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

	$server::TeamPlay = True;		// for TDM_ games
	$server::AllowDeathmatch = True;
}

function onMissionStart()
{
   // some constants used
   $healRate = 100;    // normal pads
   $ammoRate = 5;

   $specialHealRate = 1500;   // special pads
   $specialAmmoRate = 25;
   
   $blastRadiusSmall = 50;   // for ammo boxes and special pads
   $blastDamageSmall = 4000;

   $blastRadiusLarge = 100;  // for fuel tanks
   $blastDamageLarge = 8000;
   
   $guardianUpdatePeriod = 15;
  
}



// Zen Healing & Ammo pad functionality
//--------------------------------------------------------------------------------

// Normal pads
// message, shutdown, no reset

function ZenHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // no reset time so always ready
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
}

function ZenHeal::trigger::onContact(%this, %object)
{
   // shutdown but no reset
   Zen::work(%this, %object, $healRate, 0, 0, true); 
}


function ZenAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // no reset time so always ready
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   // shutdown but no reset
   Zen::work(%this, %object, 0, $ammoRate, 0, true); 
}



// Special pads
// no message, no shutdown, no reset

function ZenAll1::trigger::onEnter(%this, %object)
{
	// instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);
   
   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);
   
   explosion1();   
}

function ZenAll2::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);
   
   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);   
   
 	explosion2();
}

function ZenAll3::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion3();
}

function ZenAll4::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion4();
}
function ZenAll5::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion5();
}
function ZenAll6::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion6();
}
function ZenAll7::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion7();
}
function ZenAll8::trigger::onEnter(%this, %object)
{
   // instant work, no shutdown, no reset
	Zen::work(%this, %object, $specialHealRate, $specialAmmoRate, 0, false);

   // damage everyone else within %blastRadiusSmall meters
   blast(%this, $blastRadiusSmall, $blastDamageSmall, %object);

	explosion8();
}

function explosion1()
{
	dropPod(-686, 688, 117, -759, 688, 117);
	dropPod(-759, 688, 117, -686, 688, 117);
}
function explosion2()
{
	dropPod(-686, 720, 117, -759, 720, 117);
	dropPod(-759, 720, 117, -686, 720, 117);
}
function explosion3()
{
	dropPod(-686, 752, 117, -759, 752, 117);
	dropPod(-759, 752, 117, -686, 752, 117);
}
function explosion4()
{
	dropPod(-686, 784, 117, -759, 784, 117);
	dropPod(-759, 784, 117, -686, 784, 117);
}
function explosion5()
{
	dropPod(-1176.7, 1286.6, 116.7, -1176.7, 1241.4, 116.7);
	dropPod(-1176.7, 1241.4, 116.7, -1176.7, 1286.6, 116.7);
}
function explosion6()
{
	dropPod(-1127.7, 1286.6, 116.7, -1127.7, 1241.3, 116.7);
	dropPod(-1127.7, 1241.3, 116.7, -1127.7, 1286.6, 116.7);
}
function explosion7()
{
	dropPod(-312.4, 1286.5, 116.7, -312.4, 1241.4, 116.7);
	dropPod(-312.4, 1241.4, 116.7, -312.4, 1286.5, 116.7);
}
function explosion8()
{
	dropPod(-263.3, 1282.8, 116.7, -263.3, 1241.3, 116.7);
	dropPod(-263.3, 1241.3, 116.7, -263.3, 1282.8, 116.7);
}



// Ammo boxes and special pads
//--------------------------------------------------------------------------------
function BlastDamageSmall::structure::onDestroyed(%this, %object)
{
   // blast everyone around
   // exclude nobody
   blast(%this, $blastRadiusSmall, $blastDamageSmall, 0);
}

// fuel tanks
//--------------------------------------------------------------------------------
function BlastDamageLarge::structure::onDestroyed(%this, %object)
{
   // blast everyone around
   // exclude nobody
   blast(%this, $blastRadiusLarge, $blastDamageLarge, 0);
}


// Transporters
//--------------------------------------------------------------------------------
function Transporter1::trigger::onEnter(%this, %object)
{
   setPosition(%object, -683, -435, 227);
}



// Easter Egg
//--------------------------------------------------------------------------------
function EasterEgg::trigger::onEnter(%this, %object)
{
	Say(playerManager::vehicleIdToPlayerNum(%object), %object, *IDMULT_MOON_LANDER_FOUND);
}
function EasterEgg::trigger::onContact(%this, %object)
{
	damageObject(%object, 250);
}


// Easter Egg (orignal code)
//--------------------------------------------------------------------------------
//{
//   //RYAN'S ADDED CODE HERE FOR BETA TESTING; SIMPLE GUARDIAN BEHAVIOR
//   order($guardian1, ShutDown, false);
//   order($guardian2, ShutDown, talse);
//   order($guardian3, ShutDown, false);
//   order($guardian4, ShutDown, false);
//   order($guardian2, UseActiveRadar, false);
//   order($guardian3, UseActiveRadar, false);
//   order($guardian4, UseActiveRadar, false);
//
//   order($guardian1, "Guard", "MissionGroup\\Stuff\\OuterLimits\\Apollo13");
//   order($guardian2, "Guard", "MissionGroup\\Stuff\\OuterLimits\\Apollo13");
//   order($guardian3, "Guard", "MissionGroup\\Stuff\\OuterLimits\\Apollo13");
//   order($guardian4, "Guard", "MissionGroup\\Stuff\\OuterLimits\\Apollo13");
//
//	guardianUpdate();
//}



