exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

$missionName="configTester";

Pilot redClone
{
   id = 28;
   name = "Red";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.8;
   activateDist = 400.0;
   deactivateBuff = 200.0;
   targetFreq = 1.2;
   trackFreq = 0.4;
   fireFreq = 0.2;
   LOSFreq = 0.4;
   orderFreq = 4.0;
};

Pilot blueClone
{
   id = 29;
   name = "Blue";   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.8;
   activateDist = 400.0;
   deactivateBuff = 200.0;
   targetFreq = 1.2;
   trackFreq = 0.4;
   fireFreq = 0.2;
   LOSFreq = 0.4;
   orderFreq = 4.0;
};

function onMissionLoad()
{
%msg = "You can play this DM or TDM. Clones drop anyehere if DM. You can select any team. Setup your server accordingly. 2 clones are allowed at a time. They drop alternatly red and blue at first. A Camera tracks red clone when the 2nd clone (blue) drops. After the 1st kill the next clone will be the same team as the destroyed. The wining clone is repaired and reloaded, Weapons are NOT REPLACED. The clones ARE EXACT COPIES of your vehicle, including internals and skins. To conpare different loadouts, configurture your vehicle in the herc bay and drop. Go back to the bay and repeat the process. It does not matter which team you pick, clones will drop red and blue. Clone pilots are Elite-aggressive. Purple base is safer to watch from. Pad at purple base is only RR on the map. It can be moved by scanning. Ped ZenGen is destructible at only 4000 damage points. It won't move if destroyed.";
setGameInfo(%msg);     
}

function onMissionStart()
{
$pm = "";			// pad mover is nothing
$vp = "";			// vehicle of player
$tm = "Red Team";		// team for clone
$dc = "";			// dead clone
$nc = "0";			// no clones more than 2
$rc = "";			// redClone
$bc = "";			// blueClone
$prv = "";			// previous ZenGen attacker
}

function player::onAdd(%this)
{
player::onAddLog(%this);	// needed for logging
if($server::TeamPlay == true)
 {
 say(%this,0, *IDMULT_TDM_WELCOME);	      
 }
 else
 {
 say(%this,0, *IDMULT_DM_WELCOME);
 }
%msg = "Go to herc bay, select 1st config, drop. Exit back to herc bay, select 2nd config, drop. Read info under question mark for further details.";
messageBox(%this,%msg);
} 

function vehicle::onAdd(%this)
{
%player = playerManager::vehicleIdToPlayerNum(%this);
if(%player == 0)		// prevents cloning clone
 return;
if($nc == 2)			// prevents more than 2 clones
 {
 say(%player,0,"Only two clones allowed on map. Destroy one for replacement.");
 }
 else
 {
 $vp = %this;
 $nc ++; 
 schedule("cl();",4);		// clone player vehicle
 }				// COMMENT cl BEFORE OPENING ME /////
}

function cl()
{
%clone = cloneVehicle($vp);
if($tm == "Red Team")
 {
 setPilotId(%clone,28);
 setTeam(%clone,"Red Team");
 addToSet("MissionGroup\\clones",%clone);
 $rc = %clone;
 $tm = "Blue Team";
 }
 else
 {
 setPilotId(%clone,29);
 setTeam(%clone,"Blue Team");
 addToSet("MissionGroup\\clones",%clone);
 $bc = %clone;
 $tm = "Red Team";
 }
redrop(%clone);
if($nc == 2)
 {
 setDominantCamera($rc,$bc);
 }
}

				// ---- Pad mover----	
function ZenGen::structure::onScan(%this,%scanner)
{
if($pm == "")			// pad is not hooked to a player
 {
 $pm = %scanner;		// pad is hooked to scanner
 %p=playerManager::vehicleIdToPlayerNum(%scanner);
 say(%p,0,"Scan again to place Zen"); 
 mp();				// go to move pad
 }
 else
 {
 $pm = "";			// unhook pad on 2nd scan
 pp();				// go to place pad on 2nd scan
 }
}

function mp()			// move pad
{
if($pm == "")			// prevents getPosition not found
 return;
%x = getPosition($pm,x);	// player x
%y = getPosition($pm,y);	// player y
if(%x == %y)			// player died
 {
 $pm = "";			// unhook pad
 pp();				// place pad
 }
 else				// move pad
 {
 %z = getPosition($pm,z);	// player z
 setPosition("missionGroup\\base\\ZenGen",(%x + 20),(%y + 40),(%z - 3),180,0);
 setPosition("missionGroup\\base\\ZenPad",(%x + 62),(%y + 22),(%z - 0.5));
 schedule("mp();",0.2);		// move pad again in 1/5 sec
 }
}

function ZenGen::structure::onAttacked(%this,%attacker)
{
if($prv == %attacker)		// prevents repeat calls
 return;
$prv = %attacker;		// new attacker changes $prv
%team = getTeam(%attacker);
if(%team != "Red Team")		// mostly go red
 {
 setTeam(%this,"Red Team");
 }
 else
 {
 setTeam(%this,"Blue Team");	// blue if red attacker
 }
}

function player::onRemove(%this)
{
player::onRemoveLog(%this);	// for logging
%vId = playerManager::playerNumToVehicleId(%this);
if(%vId == $pm)			// pad mover left the game
 {
 $pm = "";			// unhook pad
 pp();				// place pad
 }
}

function vehicle::onDestroyed(%destroyed,%destroyer)
{
vehicle::onDestroyedLog(%destroyed,%destroyer);	// for logging
say(0,0,getHUDName(%destroyer)@" Destroyed "@getHUDName(%destroyed));
if(%destroyed == $pm)		// pad mover is destroyed
 {
 $pm = "";			// unhook pad
 pp();				// place pad
 }
%player = playerManager::vehicleIdToPlayerNum(%destroyer);
if(%player == 0)
 {
 healObject(%destroyer,30000);
 reloadObject(%destroyer,1000);
 }
%player = playerManager::vehicleIdToPlayerNum(%destroyed);
if(%player == 0)
 {
 setPlayerCamera();
 $tm = getTeam(%Destroyed);	// sets next clone's team
 $dc = %destroyed;		// used to delete
 schedule("erase();",1);
 }
}

function erase()
{
deleteObject($dc);		// delete dead clone
$nc --;				// reduce clone count
}

function ZenGen::Structure::onDestroyed(%this,%destroyer)
{
bigExplosion(%this);		// [ZenAll has no reduced rate]
$pm = "";			// unhook pad
pp();				// place pad
}

function pp()			//place pad [ZenPad is indestructible]
{
%x = getPosition("missionGroup\\base\\ZenPad",x);
%y = getPosition("missionGroup\\base\\ZenPad",y);
%z = getTerrainHeight(%x,%y);		// find ground under pad
%nh = getTerrainHeight(%x,(%y + 25));
%sh = getTerrainHeight(%x,(%y - 25));
%tL = (%nh - %sh);			// find tilt
setPosition("missionGroup\\base\\ZenPad",%x,%y,(%z - 0.5),0,%tL);
setPosition("missionGroup\\base\\ZenAll",%x,%y,%z);
setPosition("missionGroup\\base\\ZenGen",(%x - 42),(%y + 18),(%z - 4),180,(%tl * -1));
}




