// FILENAME:	DM_City_on_the_Edge.cs
//
// AUTHORS:  	Chupie Doll & Youth in Asia
 
//------------------------------------------------------------------------------

$missionName = "DM_City_On_The_Edge";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   // what can the server admin choose for available teams
   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionStart()
{
	marsSounds();
}

function onMissionLoad(){
   cdAudioCycle("Purge", "Terror", "Watching"); 
}

// Water Tower splash functionality
function structure::onDestroyed(%this, %attackerId){
	// Which water tower was destroyed?
	if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower1")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash1"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash1"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower2")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash2"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash2"), 0, true);
	}
	else if(%this == getObjectId("MissionGroup\\BlueBase\\WaterTower3")){
		setShapeVisibility(getObjectId("MissionGroup\\BlueBase\\Splash3"), true);
		playAnimSequence(getObjectId("MissionGroup\\BlueBase\\Splash3"), 0, true);
	}
}

function setDefaultMissionItems()

//
//   exec("vanilla2.cs");
//
// at the end and put this file in your starsiege/scripts folder.

// Lights off
allowVehicle(all,FALSE);
allowWeapon(all,FALSE);
allowComponent(all,FALSE);

// Double-dog sure...
function i_said_vanilla_dammit()
{
  for (%i=-32768; %i<32768; %i++) {
    allowVehicle(%i,FALSE);
    allowWeapon(%i,FALSE);
    allowComponent(%i,FALSE);
  }
}
i_said_vanilla_dammit();

// *SNIIIIIFFFFF*  Ahhhh, fresh as a Spring morning.
// Ok, turn on the standard stuff...

//Vehicles (* denotes a non-standard vehicle)
allowVehicle(1,TRUE);//TerranApocalypse
allowVehicle(2,TRUE);//TerranMinotaur
allowVehicle(3,TRUE);//TerranGorgon
allowVehicle(4,TRUE);//TerranTalon
allowVehicle(5,TRUE);//TerranBasilisk
allowVehicle(6,TRUE);//Paladin
allowVehicle(7,TRUE);//Myrmidon
allowVehicle(8,TRUE);//Disrupter
allowVehicle(9,FALSE);// * Banshee
allowVehicle(10,TRUE);//Knight'sApocalypse
allowVehicle(11,TRUE);//Knight'sMinotaur
allowVehicle(12,TRUE);//Knight'sGorgon
allowVehicle(13,TRUE);//Knight'sTalon
allowVehicle(14,TRUE);//Knight'sBasilisk
allowVehicle(15,TRUE);//KnightPaladin
allowVehicle(16,TRUE);//KnightMyrmidon
allowVehicle(17,TRUE);//KnightDisrupter
allowVehicle(18,FALSE);// * TerranCargo
allowVehicle(19,FALSE);// * TerranEscape
allowVehicle(20,TRUE);//Seeker
allowVehicle(21,TRUE);//Goad
allowVehicle(22,TRUE);//Shepherd
allowVehicle(23,TRUE);//Adjudicator
allowVehicle(24,TRUE);//Executioner
allowVehicle(25,TRUE);//Bolo
allowVehicle(26,TRUE);//Recluse
allowVehicle(27,FALSE);// * PlatAdjucator
allowVehicle(28,FALSE);// * PlatExecutor
allowVehicle(29,FALSE);// * Prometheus
allowVehicle(30,TRUE);//Emancipator
allowVehicle(31,TRUE);//Avenger
allowVehicle(32,TRUE);//Dreadlock
allowVehicle(33,TRUE);//Olympian

allowVehicle(35,TRUE);//MetagenSeeker
allowVehicle(36,TRUE);//MetagenGoad
allowVehicle(37,TRUE);//MetagenShepherd
allowVehicle(38,FALSE);// * MetagenAdjucator
allowVehicle(39,FALSE);// * MetagenExecutor
allowVehicle(40,FALSE);// * Harabec'sApocalypse
allowVehicle(41,TRUE);//Predator
allowVehicle(42,FALSE);// * Caanon's Basilisk?
allowVehicle(43,FALSE);// * Cinematic Apocalypse
allowVehicle(44,FALSE);// * Cinematic Basilisk
allowVehicle(45,FALSE);// * Super Predator

allowVehicle(50,FALSE);// * Pirateapocalypse
allowVehicle(51,FALSE);// * Piratedreadlock
allowVehicle(52,TRUE);//PirateEmancipator

allowVehicle(55,TRUE);//PlayerPlatAdjudicator
allowVehicle(56,TRUE);//PlayerPlatExecutioner

allowVehicle(60,FALSE);// * Terran Empty Cargo
allowVehicle(61,FALSE);// * Terran Ammo
allowVehicle(62,FALSE);// * Terran Big Ammo
allowVehicle(63,FALSE);// * Terran Big Personnel
allowVehicle(64,FALSE);// * Terran Fuel
allowVehicle(65,FALSE);// * Terran (Mino?)
allowVehicle(66,FALSE);// * Rebel Empty Cargo
allowVehicle(67,FALSE);// * Rebel Ammo
allowVehicle(68,FALSE);// * Rebel Big Cargo
allowVehicle(69,FALSE);// * Rebel Big Box Cargo
allowVehicle(70,FALSE);// * Rebel Box Cargo
allowVehicle(71,FALSE);// * Terran Utility Truck
allowVehicle(72,FALSE);// * Thumper
allowVehicle(73,FALSE);// * Terran Starefield

allowVehicle(90,FALSE);// * Cybrid Artillery
allowVehicle(91,FALSE);// * Cybrid Advocate
allowVehicle(92,FALSE);// * Cybrid Dropship
allowVehicle(93,FALSE);// * Cybrid Consul Bomber
allowVehicle(94,FALSE);// * Cybrid Omnicrawler
allowVehicle(95,FALSE);// * Cybrid Protector
allowVehicle(96,FALSE);// * Cybrid Jammer

allowVehicle(110,FALSE);// * Knight's Banshee
allowVehicle(111,FALSE);// * Knight's Dropship

allowVehicle(130,FALSE);// * Terran Dropship
allowVehicle(131,FALSE);// * Draco Bomber
allowVehicle(132,FALSE);// * Conveyor
allowVehicle(133,FALSE);// * Nike
allowVehicle(134,FALSE);// * Supressor
allowVehicle(135,FALSE);// * Terran Sovereign
allowVehicle(136,FALSE);// * Terran Surveyor
allowVehicle(137,FALSE);// * Rebel Artillery
allowVehicle(138,FALSE);// * Pouncer Bike

allowVehicle(150,FALSE);// * Bus

//weapons
allowWeapon(101,TRUE);//Laser
allowWeapon(102,TRUE);//HeavyLaser
allowWeapon(103,TRUE);//CompLaser
allowWeapon(104,TRUE);//TwinLaser
allowWeapon(105,TRUE);//Emp
allowWeapon(106,TRUE);//ELF
allowWeapon(107,TRUE);//Blaster
allowWeapon(108,TRUE);//HeavyBlaster
allowWeapon(109,TRUE);//PBW
allowWeapon(110,TRUE);//Plasma
allowWeapon(111,TRUE);//BlinkGun
allowWeapon(112,TRUE);//Qgun
allowWeapon(113,TRUE);//MFAC
allowWeapon(114,TRUE);//NanoInfuser
allowWeapon(115,TRUE);//NaniteCannon
allowWeapon(116,TRUE);//Autocannon
allowWeapon(117,TRUE);//HvyAutocannon
allowWeapon(118,TRUE);//EMCAutocannon
allowWeapon(119,TRUE);//BlastCannon
allowWeapon(120,TRUE);//HvyBlastCan
allowWeapon(121,TRUE);//RailGun
allowWeapon(124,TRUE);//PitViper8
allowWeapon(125,TRUE);//PitViper12
allowWeapon(126,TRUE);//Sparrow6
allowWeapon(127,TRUE);//Sparrow10
allowWeapon(128,TRUE);//SWARM6
allowWeapon(129,TRUE);//Minion
allowWeapon(130,TRUE);//Shrike8
allowWeapon(147,TRUE);//Aphid
allowWeapon(131,TRUE);//Arachnitron4
allowWeapon(132,TRUE);//Arachnitron8
allowWeapon(133,TRUE);//Arachnitron12
allowWeapon(134,TRUE);//Proximity6
allowWeapon(135,TRUE);//Proximity10
allowWeapon(136,TRUE);//Proximity15
allowWeapon(142,TRUE);//RadiationGun
allowWeapon(3,TRUE);//Disrupter
allowWeapon(150,TRUE);//SMARTGun

//Components
//Reactors
allowComponent(200,TRUE);//HumanMicroReactor
allowComponent(201,TRUE);//SmallHumanReactor2--small
allowComponent(202,TRUE);//MediumHumanReactor1Standard
allowComponent(203,TRUE);//MediumHumanReactor2medium
allowComponent(204,TRUE);//LargeHumanReactor1--large
allowComponent(205,TRUE);//LargeHumanReactor2--Maxim
allowComponent(225,TRUE);//SmallCybridReactor1--Alpha
allowComponent(226,TRUE);//SmallCybridReactor2--Beta
allowComponent(227,TRUE);//MediumCybridReactor1--Gamma
allowComponent(228,TRUE);//MediumCybridReactor2--delta
allowComponent(229,TRUE);//LargeCybridReactor1--epsilon
allowComponent(230,TRUE);//LargeCybridReactor2--theta
//Shields
allowComponent(300,TRUE);//HumanStandardShield
allowComponent(301,TRUE);//HumanProtectorShield
allowComponent(302,TRUE);//HumanGuardianShield
allowComponent(303,TRUE);//HumanFastChargeShield
allowComponent(304,TRUE);//HumanCenturianShield
allowComponent(305,TRUE);//HumanRepulsorShield
allowComponent(306,TRUE);//HumanTitanShield
allowComponent(307,TRUE);//HumanMedusaShield
allowComponent(326,TRUE);//CybridAlphaShield
allowComponent(327,TRUE);//CybridBetaShield
allowComponent(328,TRUE);//CybridGammaShield
allowComponent(329,TRUE);//CybridDeltaShield
allowComponent(330,TRUE);//CybridEpsilonShield
allowComponent(331,TRUE);//CybridZetaShield
allowComponent(332,TRUE);//CybridEtaShield
allowComponent(333,TRUE);//CybridThetaShield

//Sensors
allowComponent(400,TRUE);//BasicHumanSensor
allowComponent(401,TRUE);//LongRangeSensor--Ranger
allowComponent(408,TRUE);//StandardHumanSensor
allowComponent(409,TRUE);//HumanLongbowSensor
allowComponent(410,TRUE);//HumanInfiltratorSensor
allowComponent(411,TRUE);//HumanCrossbowSensor
allowComponent(412,TRUE);//HumanUltralightSensor
allowComponent(413,TRUE);//HumanHoundDogSensor
allowComponent(414,TRUE);//ThermalSensor
allowComponent(426,TRUE);//BasicCybridSensor(Alpha)
allowComponent(427,TRUE);//LongRangeCybridSensor(Beta)
allowComponent(428,TRUE);//StandardCybridSensor(Gamma)
allowComponent(429,TRUE);//CybridLongbowSensor(Delta)
allowComponent(430,TRUE);//CybridInfiltratorSensor(Epsilon)
allowComponent(431,TRUE);//CybridCrossbowSensor(Zeta)
allowComponent(432,TRUE);//CybridUltralightSensor(Eta)
allowComponent(433,TRUE);//CybridHoundDogSensor(Theta)
allowComponent(434,TRUE);//MotionDetector(Iota)

//Engines
allowComponent(100,TRUE);//HumanLightVehicleEngine
allowComponent(101,TRUE);//HumanHighOutputLightEngine
allowComponent(102,TRUE);//HumanAgileLightEngine
allowComponent(103,TRUE);//HumanStandardMediumEngine
allowComponent(104,TRUE);//HumanHighOutputMediumEngine
allowComponent(105,TRUE);//HumanMediumAgilityEngine
allowComponent(106,TRUE);//HumanStandardHeavyEngine
allowComponent(107,TRUE);//HumanImprovedHeavyEngine
allowComponent(108,TRUE);//HumanHeavyCruiseEngine
allowComponent(109,TRUE);//HumanHighOutputHeavyEngine
allowComponent(110,TRUE);//HumanAgileHeavyEngine
allowComponent(111,TRUE);//HumanStandardAssaultEngine
allowComponent(112,TRUE);//HumanImprovedAssaultEngine
allowComponent(113,TRUE);//Humanheavyturbineengine
allowComponent(114,TRUE);//HighOutputTurbine(HOT)
allowComponent(115,TRUE);//Humansuperheavyengine
allowComponent(128,TRUE);//CybridAlphaLightVehicleEngine
allowComponent(129,TRUE);//CybridBetaLightAgilityEngine
allowComponent(130,TRUE);//CybridGammaStandardMediumEngine
allowComponent(131,TRUE);//CybridDeltaMediumCruiseEngine
allowComponent(132,TRUE);//CybridEpsilonImprovedMediumEngine
allowComponent(133,TRUE);//CybridZetaMediumHighOutputEngine
allowComponent(134,TRUE);//CybridEtaMediumAgilityEngine
allowComponent(135,TRUE);//CybridThetaStandardHeavyEngine
allowComponent(136,TRUE);//CybridIotaHeavyHighOutputEngine
allowComponent(137,TRUE);//CybridKappaHeavyAgilityEngine
allowComponent(138,TRUE);//CybridLamdaStandardAssaultEngine
allowComponent(139,TRUE);//CybridMuImprovedAssaultEngine
allowComponent(140,TRUE);//CybridNuHighOutputAssaultEngine
allowComponent(141,TRUE);//CybridXiHeavyAssaultEngine
allowComponent(142,TRUE);//CybridOmicronHeavyAssaultTurbine
allowComponent(143,TRUE);//CybridPiSuperHeavyTurbine

//Armor
allowComponent(926,TRUE);//CarbonFiber(CARLAM)
allowComponent(927,TRUE);//QuadBondedMetaplas(QBM)
allowComponent(928,TRUE);//DURAC(DepletetedUranium)
allowComponent(929,TRUE);//Ceramic
allowComponent(930,TRUE);//Crystaluminum
allowComponent(931,TRUE);//Quicksilver

//InternalComponents
allowComponent(800,TRUE);//HumanBasicComputer
allowComponent(801,TRUE);//HumanImprovedComputer
allowComponent(802,TRUE);//HumanAdvancedComputer
allowComponent(805,TRUE);//CybridBasicSystemsControl
allowComponent(806,TRUE);//CybridEnhancedSystemsControl
allowComponent(807,TRUE);//CybridAdvancedSystemsControl
allowComponent(810,TRUE);//GuardianECM
allowComponent(811,TRUE);//DopplegangerECM
allowComponent(812,TRUE);//CybridAlphaECM
allowComponent(813,TRUE);//CybridBetaECM
allowComponent(820,TRUE);//ThermalDiffuser
allowComponent(830,TRUE);//Chameleon
allowComponent(831,TRUE);//Cuttlefishcloak
allowComponent(840,TRUE);//ShieldModulator
allowComponent(845,TRUE);//ShieldCapacitor
allowComponent(850,TRUE);//ShieldAmplifier(increasesshieldconstant)
allowComponent(860,TRUE);//LaserTargetingModule
allowComponent(865,TRUE);//ExtraBattery
allowComponent(870,TRUE);//ReactorCapacitor
allowComponent(875,TRUE);//FieldStabilizer
allowComponent(880,TRUE);//RocketBooster
allowComponent(885,TRUE);//TurbineBoost
allowComponent(890,TRUE);//NanoRepair
allowComponent(900,TRUE);//AngleLifeSupport
allowComponent(910,TRUE);//AgravGenerator
allowComponent(912,TRUE);//ElectroHull
allowComponent(914,TRUE);//UAP



