//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


$maxFlagCount = 5;           // no of flags required by a team to end the game
$flagValue    = 25;          // points your team gets for capturing
$carrierValue =  5;          //  "      "    "    "    " killing carrier
$killPoints    = 1;
$deathPoints   = 1;
$flagTime = 180;

exec("multiplayerStdLib.cs");
exec("CTFstdLib.cs");

function setDefaultMissionOptions()
{
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = false;
}

function onMissionStart()
{
	initGlobalVars(); // a necessary call to CTFstdlib.cs
   
	$BlueHealTotal = 100;
	$BlueHealAmount = $BlueHealTotal;
	$BlueAmmoTotal = 6;
	$BlueAmmoAmount = $BlueAmmoTotal;
   
	$PurpleHealTotal = 100;
	$PurpleHealAmount = $PurpleHealTotal;
	$PurpleAmmoTotal = 6;
	$PurpleAmmoAmount = $PurpleAmmoTotal;
   
   $blastRadiusSmall = 75;   // for ammo boxes
   $blastDamageSmall = 8000;   
   
   $padWaitTime = 0; // if this is non-zero, then team triggers need an onLeave
   $superPadWaitTime = 0;  // likewise
}

// set the map coordinates

// Blue Pad Functionality
//--------------------------------------------------------------------------------
function BlueHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
	displayPercentage(%object, ($BlueHealAmount * 100 / $BlueHealTotal));
}
function BlueHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $BlueHealAmount, 0, $padWaitTime, true); 
}

function BlueAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
	displayPercentage(%object, ($BlueAmmoAmount * 100 / $BlueAmmoTotal));
}
function BlueAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $BlueAmmoAmount, $padWaitTime, true); 
}


// Purple Pad Functionality
//--------------------------------------------------------------------------------
function PurpleHeal::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
	displayPercentage(%object, ($PurpleHealAmount * 100 / $PurpleHealTotal));
}
function PurpleHeal::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, $PurpleHealAmount, 0, $padWaitTime, true); 
}

function PurpleAmmo::trigger::onEnter(%this, %object)
{
   // tell user pad has been entered
   // say whether or not it is ready and supply a countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
	displayPercentage(%object, ($PurpleAmmoAmount * 100 / $PurpleAmmoTotal));
}
function PurpleAmmo::trigger::onContact(%this, %object)
{
   Zen::work(%this, %object, 0, $PurpleAmmoAmount, $padWaitTime, true); 
}




// Zen all triggers
//-------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   // completely heal and reload instantly -- no reset time
   // no shutdown necessary
   Zen::work(%this, %object, 100000, 100, $superPadWaitTime, false); 
}


// Purple Pad Power
//--------------------------------------------------------------------------------
function PurpleAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleAmmoAmount -= ($PurpleAmmoTotal / 2);
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);   
}
function PurpleHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleHealAmount -= ($PurpleHealTotal / 2);
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);   
}

// Blue Pad Power
//--------------------------------------------------------------------------------
function BlueAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueAmmoAmount -= ($BlueAmmoTotal / 2);
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);   
}
function BlueHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueHealAmount -= ($BlueHealTotal / 2);
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);   
}

// Transporter functionality
//--------------------------------------------------------------------------------
function Transporter::trigger::onEnter(%this, %object)
{
	setPosition(%object, -210, 93, 250);	
}

function triggerUG1::trigger::onContact(%this, %object)
{
	setPosition(%object, -211, 80, -200);	
}

function triggerUG2::trigger::onContact(%this, %object)
{
	setPosition(%object, -211, 80, -200);	
}
