//
// Starsiege Beta map.
// Fixed by Karamell ^WP^ and ~MissDaisy~ ^WP^.
// Special Thanks go to Dynamix and Sierra for permission to use these maps!


$maxFlagCount = 5;           // no of flags required by a team to end the game
$flagValue    = 25;          // points your team gets for capturing
$carrierValue =  5;          //  "      "    "    "    " killing carrier
$killPoints    = 1;
$deathPoints   = 1;
$flagTime = 180;

exec("multiplayerStdLib.cs");
exec("CTFstdLib.cs");

	
   

//--------------------------------------------------------------------------------

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

}

function onMissionStart()
{
   // some constants used
	$BlueHealTotal = 100;
	$BlueHealAmount = $BlueHealTotal;  // this will change as buildings get destroyed
	$BlueAmmoTotal = 10;
	$BlueAmmoAmount = $BlueAmmoTotal; // this will change as buildings get destroyed
   
	$RedHealTotal = 100;
	$RedHealAmount = $RedHealTotal;  // this will change as buildings get destroyed
	$RedAmmoTotal = 10;
	$RedAmmoAmount = $RedAmmoTotal; // this will change as buildings get destroyed
  
	$YellowHealTotal = 100;
	$YellowHealAmount = $YellowHealTotal;  // this will change as buildings get destroyed
	$YellowAmmoTotal = 10;
	$YellowAmmoAmount = $YellowAmmoTotal; // this will change as buildings get destroyed
   
	$PurpleHealTotal = 100;
	$PurpleHealAmount = $PurpleHealTotal;  // this will change as buildings get destroyed
	$PurpleAmmoTotal = 10;
	$PurpleAmmoAmount = $PurpleAmmoTotal; // this will change as buildings get destroyed
   
   $blastRadiusSmall = 50;   // for ammo boxes
   $blastDamageSmall = 4000;   
   
   $padWaitTime = 0; // if this is non-zero, then team triggers need an onLeave
   $superPadWaitTime = 30;

	initGlobalVars();

}

// Zen Healing & Ammo pad functionality
//--------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   // show message
   // say whether or not it is ready and supply countdown
   Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  

   // completely heal and reload instantly -- resets in superPadWaitTime
   // no shutdown necessary
   Zen::work(%this, %object, 100000, 100, $superPadWaitTime, false);    
}

function ZenAll::trigger::onLeave(%this, %object)
{
   Zen::onLeave(%this, %object);  
}



// Blue Pad Functionality
//--------------------------------------------------------------------------------
function BlueHeal::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_BLUE)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);
      displayPercentage(%object, ( $BlueHealTotal));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_BLUE_PAD_REFUSE);
   }  
}
function BlueHeal::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_BLUE)
   {
      Zen::work(%this, %object, $BlueHealAmount, 0, $padWaitTime, true);
   } 
}

function BlueAmmo::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_BLUE)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
      displayPercentage(%object, ( $BlueAmmoTotal * 10 ));
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_BLUE_PAD_REFUSE);
   }  
}
function BlueAmmo::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_BLUE)
   {
      Zen::work(%this, %object, 0, $BlueAmmoAmount, $padWaitTime, true); 
   }
}


// Red Pad Functionality
//--------------------------------------------------------------------------------
function RedHeal::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_RED)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
      displayPercentage(%object, ( $RedHealTotal));
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_RED_PAD_REFUSE);
   }  
}
function RedHeal::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_RED)
   {
      Zen::work(%this, %object, $RedHealAmount, 0, $padWaitTime, true); 
   }
}

function RedAmmo::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_RED)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
      displayPercentage(%object, ( $RedAmmoTotal * 10 ));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_RED_PAD_REFUSE);
   }     
}
function RedAmmo::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_RED)
   {
      Zen::work(%this, %object, 0, $RedAmmoAmount, $padWaitTime, true); 
   }  
}


// Yellow Pad Functionality
//--------------------------------------------------------------------------------
function YellowHeal::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_YELLOW)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
      displayPercentage(%object, ($YellowHealTotal));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_YELLOW_PAD_REFUSE);
   }
}
function YellowHeal::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_YELLOW)
   {
      Zen::work(%this, %object, $YellowHealAmount, 0, $padWaitTime, true); 
   }
}

function YellowAmmo::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_YELLOW)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
      displayPercentage(%object, ( $YellowAmmoTotal * 10 ));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_YELLOW_PAD_REFUSE);
   }
}
function YellowAmmo::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_YELLOW)
   {
      Zen::work(%this, %object, 0, $YellowAmmoAmount, $padWaitTime, true); 
   }
}


// Purple Pad Functionality
//--------------------------------------------------------------------------------
function PurpleHeal::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_PURPLE)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, false, false);  
      displayPercentage(%object, ( $PurpleHealTotal));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_PURPLE_PAD_REFUSE);
   }   
}
function PurpleHeal::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_PURPLE)
   {
      Zen::work(%this, %object, $PurpleHealAmount, 0, $padWaitTime, true); 
   }
}

function PurpleAmmo::trigger::onEnter(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_PURPLE)
   {
      // tell user pad has been entered
      Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, false, false);  
      displayPercentage(%object, ( $PurpleAmmoTotal * 10 ));  
   }
   else
   {
      %player = playerManager::vehicleIdToPlayerNum(%object);
      say(%player, 0, *IDMULT_CHAT_PURPLE_PAD_REFUSE);
   }
}
function PurpleAmmo::trigger::onContact(%this, %object)
{
   if(getTeam(%object) == *IDSTR_TEAM_PURPLE)
   {
      Zen::work(%this, %object, 0, $PurpleAmmoAmount, $padWaitTime, true); 
   }
}




// Base Damage Functionality
//--------------------------------------------------------------------------------
function YellowAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$YellowAmmoAmount = $YellowAmmoTotal - ($YellowAmmoTotal / 5 );
	$YellowAmmoTotal = $YellowAmmoAmount;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PurpleAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleAmmoAmount = $PurpleAmmoTotal - ($PurpleAmmoTotal / 5 );
	$PurpleAmmoTotal = $PurpleAmmoAmount;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function BlueAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueAmmoAmount = $BlueAmmoTotal - ($BlueAmmoTotal / 5 );
	$BlueAmmoTotal = $BlueAmmoAmount;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function RedAmmo::structure::onDestroyed(%destroyed, %destroyer)
{
	$RedAmmoAmount = $RedAmmoTotal - ($RedAmmoTotal / 5 );
	$RedAmmoTotal = $RedAmmoAmount;
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function YellowHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$YellowHealAmount = 	$YellowHealTotal - ($YellowHealTotal / 5 );
     $YellowHealTotal = $YellowHealAmount;
     
    // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function PurpleHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$PurpleHealAmount = 	$PurpleHealTotal - ($PurpleHealTotal / 5 );
	$PurpleHealTotal  = $PurpleHealAmount;
	
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function BlueHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$BlueHealAmount = 	$BlueHealTotal - ($BlueHealTotal / 5 );
	$BlueHealTotal = $BlueHealAmount;
	
   // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}
function RedHeal::structure::onDestroyed(%destroyed, %destroyer)
{
	$RedHealAmount = $RedHealTotal - ($RedHealTotal / 5 );
	$RedHealTotal = $RedHealAmount;
	
	 // blast everyone around
   // exclude nobody
   blast(%destroyed, $blastRadiusSmall, $blastDamageSmall, 0);      
}



// Transporter Functionality
//--------------------------------------------------------------------------------
function RedTransporter::trigger::onEnter(%this, %object)
{
	setPosition(%object, -65, 1925, 148,      -45, 1945, 148);
}
function BlueTransporter::trigger::onEnter(%this, %object)
{
	setPosition(%object, 1363, 513, 145,      1383, 533, 145);
}
function PurpleTransporter::trigger::onEnter(%this, %object)
{
	setPosition(%object, -1424, 538, 144,     -1404, 558, 144);
}
function YellowTransporter::trigger::onEnter(%this, %object)
{
	setPosition(%object, -80, -912, 150,      -60, -892, 150);
}
