// FILENAME:	New_City_on_the_Edge.cs
//
// AUTHORS:	~Miss Daisy~ ^WP^*
//------------------------------------------------------------------------------

$missionName = "CTF_New_City_on_the_Edge";

$maxFlagCount  = 8;           // no of flags required by a team to end the game
$flagValue     = 5;          // points your team gets for capturing
$carrierValue  = 2;          //  "      "    "    "    " killing carrier
$killPoints    = 1;
$deathPoints   = 1;
$flagTime = 180;

exec("multiplayerStdLib.cs");
exec("CTFstdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = false;
}

function onMissionLoad()
{
   cdAudioCycle("Purge", "Terror", "Watching");
}

function onMissionStart()
{
	initGlobalVars();

	mercurySounds();
}

// move the map
$server::HudMapViewOffsetX = -2787;
$server::HudMapViewOffsetY = 780;

// Don't shoot aDweeb, if you like to live ........
function aDweeb::structure::onAttacked(%destroyed, %destroyer){
	%sayTo = playerManager::vehicleIdToPlayerNum(%destroyer);
	Say(%sayTo, %sayTo, *IDMULT_YOU_KILLED_BUDDHA);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
	healObject(%destroyer, -10000);
}
