//-------ATR1 by ShatteredStar.-------//
//-------Thanks go to Orogogus for many componants.-------//

//-------Name map-------//

$missionName = "ATR1_BridgesSS";

//-------Limit teams and set server options-------//

function setDefaultMissionOptions()
{
   $server::TeamPlay          = true;
   $server::AllowDeathmatch   = true;
   $server::AllowTeamPlay     = true;	
	
   $server::AllowTeamRed      = false;
   $server::AllowTeamBlue     = false;
   $server::AllowTeamYellow   = true;
   $server::AllowTeamPurple   = true;

   $server::disableTeamRed    = true;
   $server::disableTeamBlue   = true;
   $server::disableTeamYellow = False;
   $server::disableTeamPurple = false;

   $server::AllowMixedTech    = false ;
   $server::FactoryVehOnly    = false ;

   $server::TimeLimit         = 60;
   $server::FragLimit         = 60;
}

//-------Activate sounds-------//

function onMissionStart()
{
   marsSounds();
   windSounds();
}

function onMissionLoad()
{
   cdAudioCycle("Newtech", "Yougot", "Mechsoul"); 

   schedule("say(0, 0, \"Welcome to ATR1 Simulation.  Check the game rules for details.\");", 2.0);
}

//-------Identify droppings-------//

function vehicle::OnAdd(%vehicle)
{
  %player = playerManager::vehicleIdToPlayerNum(%vehicle);
  %player.name = getName(%player);
  %player.vehicleId = %vehicle;
  %vehicle.vehicleName = getVehicleName(%vehicle);
  say(%vehicle, 0, %vehicle.vehicleName @ " - checking configuration ");

  if(%vehicle.vehicleName == "Basilisk")
  {
   checkBasconfig(%vehicle);
  }
  else if(%vehicle.vehicleName == "Emancipator")
  {
   checkEmanconfig(%vehicle);
  }
  else if(%vehicle.vehicleName == "Goad")
  {
   checkGoadconfig(%vehicle);
  } 
}

function checkBasconfig(%vehicle)
{
  %weaponCount = getWeaponCount(%this);
  %index = 0;
  $hl = 0;
  $pv = 0;
  while (%index < %weaponCount) 
  {
    %id = getWeaponId(%vehicle, %index);
	%theName = nameGunbas(%id);
	say(%vehicle, 0, %theName);
    %index++;
  }
}

function checkGoadconfig(%vehicle)
{
  %weaponCount = getWeaponCount(%this);
  %index = 0;

  while (%index < %weaponCount) 
  {
    %id = getWeaponId(%this, %index);
	%theName = nameGungoad(%id);
	say(%player, 0, %theName);
    %index++;
  }
}

function checkEmanconfig(%vehicle)
{
  %weaponCount = getWeaponCount(%this);
  %index = 0;

  while (%index < %weaponCount) 
  {
    %id = getWeaponId(%this, %index);
	%theName = nameGuneman(%id);
	say(%player, 0, %theName);
    %index++;
  }
}

function nameGunbas(%thingie)
{
	if(%thingie == 102)
	{
		return("Heavy Laser - Approved");
                $hl++;
          if($hl == 3)
	  {
		damageObject(%vehicle, 1000000);
	  }
	}
	else if(%thingie == 107)
	{
		damageObject(%vehicle, 1000000);
	}
	else if(%thingie == 118)
	{
		damageObject(%vehicle, 1000000);
	}
	else if(%thingie == 124)
	{
		return("Pit Viper Missile 8 - Approved");
                $pv++;
          if($pv == 3)
	  {
		damageObject(%vehicle, 1000000);
	  }
	}
}

function nameGuneman(%thingie)
{
	else if(%thingie == 107)
	{
		return("Blaster - Approved");
	}
	else
	{
		damageObject(%vehicle, 1000000);
        }
}

function nameGungoad(%thingie)
{

	if(%thingie == 118)
	{
		return("Autocannon - Approved");
	}
	else
	{
		damageObject(%vehicle, 1000000);
        }
}

//-------Identify joinings-------//

function player::OnAdd(%player)
{
  %player.name = getName(%player);

  %nowDate = getDate();
  %nowTime = getTime();
  %player.IP = getConnection(%player);
  %outputString =  %nowDate @ ", " @ %nowTime @ " -- " @ %player.name @ " joined the game";
  say(0, 0, %outputstring );
  resetScan();
}

//-------Rules info-------//

function setRules()
{
  %rules = "<F2>GAME TYPE: \n<F0>ATR1 Style\n\n" @        
  "<tIDMULT_TDM_MAPNAME>"    @ 
  $missionName               @
  "\n\n<F2>CHANGES:\n"       @
  "<F0>ATR1 style combat.\n\n" @
  "<F0>Allowed configurations are ATR1 only!\n\n" @
  "\n\n<F2>RULES/OBJECTIVES:\n" @
  "<F0>Locate and destroy enemy vehicles.\n\n" @
  "<tIDMULT_TDM_SCORING_1>"  @
  "<tIDMULT_TDM_SCORING_2>"  @
  $killPoints                @
  "<tIDMULT_TDM_SCORING_3>"  @
  "<tIDMULT_TDM_SCORING_4>"  @
  $deathPoints               @
  "<tIDMULT_TDM_SCORING_5>"  @
  "<tIDMULT_TDM_SCORING_6>"  @
  "<tIDMULT_STD_ITEMS>" ;

   setGameInfo(%rules);      
}

setRules();

//-------Activate transporters-------//

function ZenTransporter::trigger::onContact(%this, %object)
{
  %vehicle.vehicleName = getVehicleName(%object);
  if(%vehicle.vehicleName == "Basilisk")
  {
   damageObject(%object, 3000);
   setPosition(%object, 0, 0, 2000);
  }
  else if(%vehicle.vehicleName == "Emancipator")
  {
   Zen::work(%this, %object, 100000, 100, 0, false);
   setPosition(%object, 0, 0, 2000);
  }
  else if(%vehicle.vehicleName == "Goad")
  {
   damageObject(%object, 3000);
   randomTransport(%object, -3000, 3000, -3000, 3000);
  } 
}

function ZenTransporter2::trigger::onContact(%this, %object)
{
  Zen::work(%this, %object, 100000, 100, 0, false);
  %vehicle.vehicleName = getVehicleName(%object);
  if(%vehicle.vehicleName == "Basilisk")
  {
   damageObject(%object, 3000);
   setPosition(%object, 0, 250, 430);
  }
  else if(%vehicle.vehicleName == "Emancipator")
  {
   Zen::work(%this, %object, 100000, 100, 0, false);
   setPosition(%object, 0, 250, 430);
  }
  else if(%vehicle.vehicleName == "Goad")
  {
   damageObject(%object, 3000);
   randomTransport(%object, -3000, 3000, -3000, 3000);
  } 
}

function ZenTransporter3::trigger::onContact(%this, %object)
{
  Zen::work(%this, %object, 100000, 100, 0, false);
  %vehicle.vehicleName = getVehicleName(%object);
  if(%vehicle.vehicleName == "Basilisk")
  {
   damageObject(%object, 3000);
   setPosition(%object, -250, 250, 430);
  }
  else if(%vehicle.vehicleName == "Emancipator")
  {
   Zen::work(%this, %object, 100000, 100, 0, false);
   setPosition(%object, -250, 250, 430);
  }
  else if(%vehicle.vehicleName == "Goad")
  {
   damageObject(%object, 3000);
   randomTransport(%object, -3000, 3000, -3000, 3000);
  }
}

function ZenTransporter4::trigger::onContact(%this, %object)
{
  Zen::work(%this, %object, 100000, 100, 0, false);
  %vehicle.vehicleName = getVehicleName(%object);
  if(%vehicle.vehicleName == "Basilisk")
  {
   damageObject(%object, 3000);
   setPosition(%object, 250, 250, 430);
  }
  else if(%vehicle.vehicleName == "Emancipator")
  {
   Zen::work(%this, %object, 100000, 100, 0, false);
   setPosition(%object, 250, 250, 430);
  }
  else if(%vehicle.vehicleName == "Goad")
  {
   damageObject(%object, 3000);
   randomTransport(%object, -3000, 3000, -3000, 3000);
  }
}

function ZenTransporter5::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, -700, 250, 130);
}

function ZenTransporter6::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 600, -200, 130);
}

//-------Limit vehicles and componants-------//

allowVehicle(all,FALSE);
allowWeapon(all,FALSE);
allowComponant(all,FALSE);

allowVehicle(5,TRUE);//TerranBasilisk
allowVehicle(21,TRUE);//Goad
allowVehicle(30,TRUE);//Emancipator


allowWeapon(102,TRUE);//HeavyLaser
allowWeapon(107,TRUE);//Blaster
allowWeapon(118,TRUE);//EMCAutocannon
allowWeapon(124,TRUE);//PitViper8

allowComponent(201,TRUE);//SmallHumanReactor2--small
allowComponent(225,TRUE);//SmallCybridReactor1--Alpha

allowComponent(304,TRUE);//HumanCenturianShield
allowComponent(330,TRUE);//CybridEpsilonShield

allowComponent(411,TRUE);//HumanCrossbowSensor
allowComponent(431,TRUE);//CybridCrossbowSensor(Zeta)

allowComponent(100,TRUE);//HumanLightVehicleEngine
allowComponent(101,TRUE);//HumanHighOutputLightEngine
allowComponent(102,TRUE);//HumanAgileLightEngine
allowComponent(103,TRUE);//HumanStandardMediumEngine
allowComponent(104,TRUE);//HumanHighOutputMediumEngine
allowComponent(105,TRUE);//HumanMediumAgilityEngine
allowComponent(128,TRUE);//CybridAlphaLightVehicleEngine
allowComponent(129,TRUE);//CybridBetaLightAgilityEngine
allowComponent(130,TRUE);//CybridGammaStandardMediumEngine
allowComponent(131,TRUE);//CybridDeltaMediumCruiseEngine
allowComponent(132,TRUE);//CybridEpsilonImprovedMediumEngine
allowComponent(133,TRUE);//CybridZetaMediumHighOutputEngine
allowComponent(134,TRUE);//CybridEtaMediumAgilityEngine

allowComponent(928,TRUE);//DURAC(DepletetedUranium)

allowComponent(801,TRUE);//HumanImprovedComputer
allowComponent(806,TRUE);//CybridEnhancedSystemsControl
allowComponent(830,TRUE);//Chameleon
allowComponent(840,TRUE);//ShieldModulator

//