// FILENAME:	Asteroid_Assault.cs | v.1.5 |
//
// AUTHOR:  	GM Mad Dog^WP^
//------------------------------------------------------------------------------

$missionName = "Asteroid_Assault";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");
exec("AApilots.cs");


// Global Variables
// -------------------------------------------------------------------------

$blueHerc1RespawnTime = 0;
$blueHerc2RespawnTime = 0;
$blueHerc3RespawnTime = 0;
$blueHerc4RespawnTime = 0;
$blueHerc5RespawnTime = 0;
$blueHerc6RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;
$redHerc4RespawnTime = 0;
$redHerc5RespawnTime = 0;
$redHerc6RespawnTime = 0;

$blueHerc1Path = "MissionGroup/blueHerc1Path";
$blueHerc2Path = "MissionGroup/blueHerc2Path";
$blueHerc3Path = "MissionGroup/blueHerc3Path";
$blueHerc4Path = "MissionGroup/blueHerc4Path";
$blueHerc5Path = "MissionGroup/blueHerc5Path";
$blueHerc6Path = "MissionGroup/blueHerc6Path";
$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";
$redHerc4Path = "MissionGroup/redHerc4Path";
$redHerc5Path = "MissionGroup/redHerc5Path";
$redHerc6Path = "MissionGroup/redHerc6Path";

$cargoHerc1Path = "MissionGroup/cargoHerc1Path";
$cargoHerc2Path = "MissionGroup/cargoHerc2Path";
$cargoHerc3Path = "MissionGroup/cargoHerc3Path";
$cargoHerc4Path = "MissionGroup/cargoHerc4Path";

$prommieHerc1Path = "MissionGroup/prommieHerc1Path";
$prommieHerc2Path = "MissionGroup/prommieHerc2Path";

function initGlobalVars()
{
   $scoringFreeze = false;
   
   %playerCount = playerManager::getPlayerCount();
	// clear all points for the players
   for (%p = 0; %p < %playerCount; %p++)
	{
		%player = playerManager::getPlayerNum(%p);
      %player.numKills = 0;
      %player.buildingsDestroyed = 0;
   }
}





// Game Info Tab wants this
// -------------------------------------------------------------------------
$respawnDelay = 60;


// Default game info
// -------------------------------------------------------------------------
function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

	$server::disableTeamRed = false;
	$server::disableTeamBlue = false;
	$server::disableTeamYellow = true;
	$server::disableTeamPurple = true;
}



// Mission load variables
// -------------------------------------------------------------------------

function onMissionLoad()
{
  %jmsg = "<f5>Asteroid_Assault v.1.5\n\n<f4>";
  setGameInfo(%jmsg);  

   cdAudioCycle("Purge", "Newtech", "Cyberntx"); 

   // get the original ID for each AI Herc ( for use later when we clone them )
    $blueHerc1 = getObjectId( "MissionGroup/blueHercs/h1" );
    $blueHerc2 = getObjectId( "MissionGroup/blueHercs/h2" );
    $blueHerc3 = getObjectId( "MissionGroup/blueHercs/h3" );
    $blueHerc4 = getObjectId( "MissionGroup/blueHercs/h4" );
    $blueHerc5 = getObjectId( "MissionGroup/blueHercs/h5" );
    $blueHerc6 = getObjectId( "MissionGroup/blueHercs/h6" );
 
    $redHerc1 = getObjectId( "MissionGroup/redHercs/h1" );
    $redHerc2 = getObjectId( "MissionGroup/redHercs/h2" );
    $redHerc3 = getObjectId( "MissionGroup/redHercs/h3" );
    $redHerc4 = getObjectId( "MissionGroup/redHercs/h4" );
    $redHerc5 = getObjectId( "MissionGroup/redHercs/h5" );
    $redHerc6 = getObjectId( "MissionGroup/redHercs/h6" );

    $cargoHerc1 = getObjectId( "MissionGroup/cargoHercs/bus1" );
    $cargoHerc2 = getObjectId( "MissionGroup/cargoHercs/bike2" );
    $cargoHerc3 = getObjectId( "MissionGroup/cargoHercs/bike3" );
    $cargoHerc4 = getObjectId( "MissionGroup/cargoHercs/bike4" );

    $prommieHerc1 = getObjectId( "MissionGroup/prommieHercs/h1" );
    $prommieHerc2 = getObjectId( "MissionGroup/prommieHercs/h2" );

 }



// Position the map
$server::HudMapViewOffsetX = 4048;
$server::HudMapViewOffsetY = 1055;



// When the mission starts ...
// -------------------------------------------------------------------------

function onMissionStart()
{
//	say(%player, 0, 1, "cin he2.wav");
	moonSounds();
	windSounds();

	initGlobalVars();
   
	order( $blueHerc1, guard, $blueHerc1Path );
	order( $blueHerc2, guard, $blueHerc2Path );
	order( $blueHerc3, guard, $blueHerc3Path );
	order( $blueHerc4, guard, $blueHerc4Path );
	order( $blueHerc5, guard, $blueHerc5Path );
	order( $blueHerc6, guard, $blueHerc6Path );
	order( $redHerc1, guard, $redHerc1Path );
	order( $redHerc2, guard, $redHerc2Path );
	order( $redHerc3, guard, $redHerc3Path );
	order( $redHerc4, guard, $redHerc4Path );
	order( $redHerc5, guard, $redHerc5Path );
	order( $redHerc6, guard, $redHerc6Path );
	order( $cargoHerc1, guard, $cargoHerc1Path );
	order( $cargoHerc2, guard, $cargoHerc2Path );
	order( $cargoHerc3, guard, $cargoHerc3Path );
	order( $cargoHerc4, guard, $cargoHerc4Path );
}



// When a player joins the game, say this ...
// -------------------------------------------------------------------------
function player::onAdd(%this)
{
	player::onAddLog(%this);
		say(%this,0,"<f4>----=(*)=----<f1>[ IMPORTANT! ]<f4>----=(*)=----");
		say(%this,0,"This is a TDM only map, stick with your teammates and create a plan before engaging.","F3_Riana_woo.WAV");
}   



// Get the player's name when they join the game
// -------------------------------------------------------------------------
function vehicle::onAdd(%vehicleId)
{
	%vehicleId.name = getHUDName(%vehicleId);
}


// Pretty Colours
// --------------------------------------------------------------------------

function fire::trigger::onContact(%this, %vehicleId)
{
	%p = getHUDName(%vehicleId);
	say("Everybody", 1, %p @ " got a little too close to fire.","F4_Tiger_Imscorched.WAV");
	healObject(%vehicleId, -2000);
}


// Let's give the enemy a way point to your base!
// --------------------------------------------------------------------------
function vehicle::onAdd(%this)
{
   // See if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );
}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_BLUE )
   {
      setNavMarker( "MissionGroup/RedBase/n1", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/BlueBase/n1", true, %this );
   }
}



// Drop Pod Mayhem
// --------------------------------------------------------------------------
function touch::trigger::onEnter(%this, %vehicleId)
{
	%p = getHUDName(%vehicleId);
	say("Everybody", 1, %p @ " was warned not to touch MD's drop pod, now he will pay the consequences.","M12_HMan_thatll.WAV");
	setPosition(%vehicleId, 7914, 2245, 238);
}


// Warning...
// --------------------------------------------------------------------------
function WarnTouch::trigger::onEnter(%this, %vehicleId)
{
	%p = getHUDName(%vehicleId);
	say("Everybody", 1, %p @ ", please do not touch MD's drop pod, it is for your own safety that you obey this warning...","M3_TDM_fallback.wav");
//	Say(%player, %player, "Please do not touch MD's drop pod, it is for your own safety that you obey this warning...","M3_TDM_fallback.wav");
}



// What's that?
// --------------------------------------------------------------------------
function gorg::trigger::onEnter(%this, %vehicleId)
{
	%p = getHUDName(%vehicleId);
	say("Everybody", 1, %p @ ", you don't know what you're in for!","F2_DM_somebodycall.wav");
	setPosition(%vehicleId, 2506, -2999, 0);
}



// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}



// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}



// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_ALLPAD, true, true);  
}
function ZenAll::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, $ammoRate, $padWaitTime, true); 
}


// Open Up!
// --------------------------------------------------------------------------
function beacon::structure::onDestroyed( %this, %who )
{
  playAnimSequence(getObjectId("MissionGroup\\Misc\\hut"), 0, true);

  schedule("death();", 4 );

  %py = getHUDName(%vehicleId);
  say("Everybody", 1, %py @ " just opened Prometheus' Hut!","F8_G_ogod.WAV");
}



// Unleash the Prommie's!
// --------------------------------------------------------------------------
function death()
{
  setPosition(%prommieHerc1, -1229, 4438, -8);
  setPosition(%prommieHerc2, -1176, 4452, -8);

  order( $prommieHerc1, guard, $prommieHerc1Path );
  order( $prommieHerc2, guard, $prommieHerc2Path );

  say( 0, 0, "", "C1_executecore.WAV");
}



// End film
// --------------------------------------------------------------------------
function mogen1::structure::onDestroyed( %this, %who )
{
  stopAnimSequence("MissionGroup\\RedBase\\film\\movie", Sequence01);

  %player = playerManager::vehicleIdToPlayerNum( %who );
  if(%player != 0)

  %txt = "<F5>" @ getHUDName(%who) @ " from the blue team stopped the movie at your drive in!";
  say(IDSTR_TEAM_RED, 1234, %txt, "F2_DM_iloveitwhen.wav");    


  %txt = "<F5>" @ getHUDName(%who) @ " stopped the movie at the Cybrid drive in!";
  say(IDSTR_TEAM_BLUE, 1234, %txt, "F2_DM_iloveitwhen.wav");
}


// Clone and spawn AI HERCs
// --------------------------------------------------------------------------
function vehicle::onDestroyed( %this, %destroyer )
{
   if( %this == $blueHerc1 )
   {
         schedule( "clone(\"$blueHerc1\", " @ %this @ ", 3809, -431, 0);", $respawnDelay);
   }
   if( %this == $blueHerc2 )
   {
         schedule( "clone(\"$blueHerc2\", " @ %this @ ", 3505, 134, -1);", $respawnDelay);
   }
   if( %this == $blueHerc3 )
   {
         schedule( "clone(\"$blueHerc3\", " @ %this @ ", 3575, -490, 0);", $respawnDelay);
   }

// 'Bek was strong enough the first time around, we don't want him to spawn again.
// --------------------------------------------------------------------------
//   if( %this == $blueHerc4 )
//  {
//         schedule( "clone(\"$blueHerc4\", " @ %this @ ", 3508, -364, 0);", $respawnDelay);
//   }
// --------------------------------------------------------------------------

   if( %this == $blueHerc5 )
   {
         schedule( "clone(\"$blueHerc5\", " @ %this @ ", 3596, -240, 0);", $respawnDelay);
   }
   if( %this == $blueHerc6 )
   {
         schedule( "clone(\"$blueHerc6\", " @ %this @ ", 3366, -403, 0);", $respawnDelay);
   }
   if( %this == $redHerc1 )
   {
         schedule( "clone(\"$redHerc1\", " @ %this @ ", 2656, 2056, 10);", $respawnDelay);
   }
   if( %this == $redHerc2 )
   {
         schedule( "clone(\"$redHerc2\", " @ %this @ ", 2157, 2047, 18);", $respawnDelay);
   }
   if( %this == $redHerc3 )
   {
         schedule( "clone(\"$redHerc3\", " @ %this @ ", 2355, 2399, 32);", $respawnDelay);
   }
   if( %this == $redHerc4 )
   {
         schedule( "clone(\"$redHerc4\", " @ %this @ ", 2748, 2575, 127);", $respawnDelay);
   }

// Prommie was strong enough the first time around, we don't want him to spawn again!
// --------------------------------------------------------------------------
//   if( %this == $redHerc5 )
//   {
//         schedule( "clone(\"$redHerc5\", " @ %this @ ", 2329, 2269, 3);", $respawnDelay);
//   }
// --------------------------------------------------------------------------

   if( %this == $redHerc6 )
   {
         schedule( "clone(\"$redHerc6\", " @ %this @ ", 3077, 2159, 0);", $respawnDelay);
   }


   // Left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
   if(
      (getTeam(%this) == getTeam(%destroyer)) &&
      (%this != %destroyer)
   )
   {
      antiTeamKill(%destroyer);
   }
}


// Clone 'em
// --------------------------------------------------------------------------
function clone(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDelay );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}

// Have to delete the AI ghosts at the mission end for ded server cycling.
//------------------------------------------------------------------------------
function onMissionEnd()
{
  deleteObject($blueHerc1);
  deleteObject($blueHerc2);
  deleteObject($blueHerc3);
  deleteObject($blueHerc4);
  deleteObject($blueHerc5);
  deleteObject($blueHerc6);

  deleteObject($redHerc1);
  deleteObject($redHerc2);
  deleteObject($redHerc3);
  deleteObject($redHerc4);
  deleteObject($redHerc5);
  deleteObject($redHerc6);

  deleteObject($prommieHerc1);
  deleteObject($prommieHerc2);

  deleteObject($cargoHerc1);
  deleteObject($cargoHerc2);
  deleteObject($cargoHerc3);
  deleteObject($cargoHerc4);
}