// FILENAME:	TDM_AI_Warfare.cs
//
// AUTHOR:  	Com. Sentinal [M.I.B.]
//------------------------------------------------------------------------------

$missionName = "TDM_AI_Warfare";

exec("multiplayerStdLib.cs");
exec("dmStdLib.cs");

///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;

$yellowHerc1Path = "MissionGroup/yellowHerc1Path";
$yellowHerc2Path = "MissionGroup/yellowHerc2Path";
$yellowHerc3Path = "MissionGroup/yellowHerc3Path";
$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";

$yellowHqDestroyed = false;
$redHqDestroyed = false;

$redirectfire = false;

$server::HudMapViewOffsetX = -6300;
$server::HudMapViewOffsetY = 2400;

///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 60;
$respawnDelayNoHq = 120;
$BUILDINGS_TO_DESTROY = 6;

///////////////////////////////////////////////////////////////////////////////////////////////////
// our base defender attributes
//
// The jump from 0.9 to 1.0 is a big one. At skill 1.0 and accuracy 1.0 the AI units will aim 
// first for the weapons, then the legs. A little too much for this mission.
//
///////////////////////////////////////////////////////////////////////////////////////////////////
Pilot RedPilot
{
   id = 28;
   
   name = "Red Herc Pilot";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

Pilot BluePilot
{
   id = 29;
   
   name = "Blue Herc Pilot";
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 850.0;
   deactivateBuff = 300.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.2;
   orderFreq = 2.0;
};

function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = True;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = false;

   $server::disableTeamRed = false;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = true;
}

function onMissionLoad()
{
   cdAudioCycle("CloudBurst", "Newtech", "Terror"); 

   // get the original ID for each AI Herc ( for use later when we clone them )
   $yellowHerc1 = getObjectId( "MissionGroup/yellowHercs/h1" );
   $yellowHerc2 = getObjectId( "MissionGroup/yellowHercs/h2" );
   $yellowHerc3 = getObjectId( "MissionGroup/yellowHercs/h3" );
   
   $redHerc1 = getObjectId( "MissionGroup/redHercs/h1" );
   $redHerc2 = getObjectId( "MissionGroup/redHercs/h2" );
   $redHerc3 = getObjectId( "MissionGroup/redHercs/h3" );
}


//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to Team DeathMatch AI Warfare! You can download this & other missions made by Com. Sentinal [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
   say("Everybody", 1, "ADJUDICATOR: Hurt//maim//kill.", "C1_hurtmaimkill.WAV");
}

function vehicle::onAdd(%this)
{
   // see if it is a player
   %player = playerManager::vehicleIdToPlayerNum(%this);
   if(%player == 0) 
      return;

   schedule( "setEnemyNavPoint(" @ %this @ ");", 1 );
}

function setEnemyNavPoint( %this )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
      setNavMarker( "MissionGroup/RedBase/n1", true, %this );
   }
   else
   {
      setNavMarker( "MissionGroup/YellowBase/n1", true, %this );
   }
}

function vehicle::OnAttacked(%attacked, %attacker)
{
   if((%attacked == $yellowHerc2) && (getTeam(%attacker) == getTeam(%attacked)) && ($redirectfire == false))
   {
      $redirectfire=true;
      say("Everybody", 1, "EXECUTIONER: Redirect fire.", "C2_Redirectfire.WAV");
      schedule("$redirectfire = false;", 2);
   }
}

function vehicle::onDestroyed(%this, %destroyer)
{
   if(%destroyer == $yellowHerc1) 
   {
       say("Everybody", 1, "ADJUDICATOR: Target executed.","C7_targetexec.WAV");
   }
   else if(%destroyer == $yellowHerc2) 
   {
       say("Everybody", 1, "EXECUTIONER: Target eliminated.", "C3_targeteliminated.WAV");
   }
   else if(%destroyer == $yellowHerc3) 
   {    
       say("Everybody", 1, "GOAD: Huh. Seem to have destroyed you. Sorry.", "ee_pd36.WAV");
   }
   else if(%destroyer == $redHerc1) 
   {
       say("Everybody", 1, "BASILISK: Yeah! Boom-baby-boom! hahah.","M6_Saxon_yeahboom.WAV");
   }
   else if(%destroyer == $redHerc2) 
   {
       say("Everybody", 1, "APOCALYPSE: Squikked the bastard.","M4_squikked.WAV");
   }
   else if(%destroyer == $redHerc3) 
   {
       say("Everybody", 1, "EMANCIPATOR: Target eliminated.", "M9_Delta6_targetel.WAV");
   }
   if(%this == $yellowHerc1) 
   {
       say("Everybody", 1, "ADJUDICATOR: We//is your programming deficient?!","C7_weisyourprog.WAV");
   }
   else if(%this == $yellowHerc2) 
   {
       say("Everybody", 1, "EXECUTIONER: This human is durable.","C2_Thishuman.WAV");
   }
   else if(%this == $yellowHerc3) 
   {    
       say("Everybody", 1, "GOAD: Anyone seen my sensor pod?","ee_pd40.WAV");
   }
   else if(%this == $redHerc1) 
   {
       say("Everybody", 1, "BASILISK: Well shit.","M6_Saxon_wellshit.WAV");
   }
   else if(%this == $redHerc2) 
   {
       say("Everybody", 1, "APOCALYPSE: Niiiceone!","M7_niiiceone.WAV");
   }
   else if(%this == $redHerc3) 
   {
       say("Everybody", 1, "EMANCIPATOR: Death is irrelevant.","M9_Delta6_deathis.WAV");
   }
   if( getTeam(%this) == *IDSTR_TEAM_RED )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }

   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------
   if( %this == $yellowHerc1 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", -5146.86, 3484.55, 18);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", -5146.86, 3484.55, 18);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", -4922.34, 3498.43, 19);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", -4922.34, 3498.43, 19);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc3 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", -5040.57, 3465.1, 13);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", -5040.57, 3465.1, 13);", $respawnDelay);
      }
   }

   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -4727.54, 1746.3, 41);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -4727.54, 1746.3, 41);", $respawnDelay);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -4981.75, 1752.69, 41);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -4981.75, 1752.69, 41);", $respawnDelay);
      }
   }
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -4862.46, 1772.54, 41);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -4862.46, 1772.54, 41);", $respawnDelay);
      }
   }

   // left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }

   // rules enforcement
   if(
      (getTeam(%this) == getTeam(%destroyer)) &&
      (%this != %destroyer)
   )
   {
      antiTeamKill(%destroyer);
   }
}

function onMissionStart()
{
	$healRate = 100;   
	$ammoRate = 3;
 	$padWaitTime = 45;

   windSounds();
	marsSounds();	

   initGlobalVars();
   
   order( $yellowHerc1, guard, $yellowHerc1Path );
   order( $yellowHerc2, guard, $yellowHerc2Path );
   order( $yellowHerc3, guard, $yellowHerc3Path );
   order( $redHerc1, guard, $redHerc1Path );
   order( $redHerc2, guard, $redHerc2Path );
   order( $redHerc3, guard, $redHerc3Path );
}

// Healing Pad Functionality
//------------------------------------------------------------------------------
function ZenHeal::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_HEALPAD, true, true);  
}
function ZenHeal::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, $healRate, 0, $padWaitTime, true); 
}

// Ammo Pad Functionality
//------------------------------------------------------------------------------
function ZenAmmo::trigger::onEnter(%this, %object)
{
   	Zen::onEnter(%this, %object, *IDMULT_CHAT_AMMOPAD, true, true);  
}

function ZenAmmo::trigger::onContact(%this, %object)
{
   	Zen::work(%this, %object, 0, $ammoRate, $padWaitTime, true); 
}
 
function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   
   if(%old == $yellowHerc1) 
   {
       say("Everybody", 1, "ADJUDICATOR: Submit to giver//of//will.","C1_submitto.WAV");
   }
   else if(%old == $yellowHerc2) 
   {
       say("Everybody", 1, "EXECUTIONER: Success is the sole judge of right and wrong.","C2_success.WAV");
   }
   else if(%old == $yellowHerc3) 
   {    
       say("Everybody", 1, "GOAD: Watch me blow up your throat human.","ee_pd07.WAV");
   }
   else if(%old == $redHerc1) 
   {
       say("Everybody", 1, "BASILISK: Hahaa...Music to my ears!","M6_Saxon_musictomyears.WAV");
   }
   else if(%old == $redHerc2) 
   {
       say("Everybody", 1, "APOCALYPSE: Gonna burn you now scrub!","M7_gonnaburn.WAV");
   }
   else if(%old == $redHerc3) 
   {
       say("Everybody", 1, "EMANCIPATOR: There can be only one.","M9_Delta6_therecan.WAV");
   }

   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}

