// FILENAME:   TDM_AI_TagTeam.cs
//
// AUTHOR:     Com. Sentinal [M.I.B.]
//
// COMMENTS:   Special thanks to Orogogus for his help on this script.
//------------------------------------------------------------------------------

$missionName = "TDM_AI_TagTeam";
exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

//-----------------------------------------------------------------------------
function setDefaultMissionOptions()
{
   $server::TeamPlay        = true;
   $server::AllowTeamPlay   = true;   
   $server::AllowDeathmatch = false;
   
   $server::AllowTeamYellow = true;
   $server::AllowTeamBlue   = true;
   $server::AllowTeamRed    = true;
   $server::AllowTeamPurple = true;
   $server::disableTeamYellow = false;
   $server::disableTeamBlue   = false;
   $server::disableTeamRed    = false;
   $server::disableTeamPurple = false;
}

//-----------------------------------------------------------------------------
function onMissionStart()
{
   desertSounds();
}

function player::OnAdd(%this)
{   
   say(%this, 0, "Welcome to Team DeathMatch AI TagTeam! An AI shepherd is assigned to guard every player that enters the game. They are given the name \"Buddy\". You can download this & other missions made by Com. Sentinal [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

function vehicle::OnAdd(%vehicleId)
{
      %player = playerManager::vehicleIdToPlayerNum(%vehicleId);
      if(%player == 0) return;
      %vehicleId.name = getHUDName(%vehicleId);
      %color = getTeam(%vehicleId);
      %herc = NewObject("Buddy", Herc, 22); 
      setTeam( %herc, %color );
      setPilotId(%herc, 28);
      %vehicleId.buddy = %herc;
      %x = getPosition(%vehicleId,x)+RandomInt(-400,400);
      %y = getPosition(%vehicleId,y)+RandomInt(-400,400);
      %z = getPosition(%vehicleId,z)+150;
      setPosition(%vehicleId.buddy, %x, %y, %z);
      schedule( "order(" @ %vehicleId.buddy @ ",guard," @ %vehicleId @ ");", 5 );
      %herc.owner = %player;
}

//-----------------------------------------------------------------------------
Pilot Buddy
{
   id = 28;
   
   skill = 1.5;
   accuracy = 1.0;
   aggressiveness = 1.5;
   activateDist = 650.0;
   deactivateBuff = 1250.0;
   targetFreq = 4.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   name = "Buddy";
};

function vehicle::OnDestroyed(%destroyed, %destroyer)
{
   // this is weird but %destroyer isn't necessarily a vehicle
   %message = getFancyDeathMessage(getHUDName(%destroyed), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
   %victim = playerManager::vehicleIdToPlayerNum(%destroyed);
   if(%victim == 0) return;
   schedule("deleteObject(" @ %destroyed.buddy @ ");", 2);
   // left over from missionStdLib.cs
   vehicle::OnDestroyedLog(%destroyed, %destroyer);
   
   // enforce the rules
   if($server::TeamPlay == true)
   {
      if
      (
         (getTeam(%destroyed) == getTeam(%destroyer)) &&
         (%destroyed != %destroyer)
      )
      {
         antiTeamKill(%destroyer);
      }
   }   
}

//-----------------------------------------------------------------------------
function onMissionLoad()
{
   cdAudioCycle("CloudBurst", "Newtech", "Terror"); 
   setGameInfo("<F2>GAME TYPE:<F0>  Team DeathMatch\n\n<F2>MISSION:<F0>  TDM_AI_TagTeam\n\nWelcome to Team DeathMatch AI TagTeam! An AI shepherd is assigned to guard every player that enters the game. They are given the name \"Buddy\". You can download this & other missions made by Com. Sentinal [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

//-----------------------------------------------------------------------------
// If player goes, get rid of his associated AI's too
function player::OnRemove(%player)
{
   %vehicle = playerManager::PlayerNumToVehicleId(%player);
   deleteObject(%vehicle.buddy);
}
