// FILENAME:	AI_Rebellion.cs
//
// AUTHOR:  	Raven [M.I.B.] 
//
// RANDOM ADVICE: If you put hershey's syrup in milk, it turns brown. It also tastes like chocolate.
//------------------------------------------------------------------------------

$missionName = "AI_Rebellion";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");

///////////////////////////////////////////////////////////////////////////////////////////////////
// Lots O' Globals
///////////////////////////////////////////////////////////////////////////////////////////////////
$redKills = 0;
$yellowKills = 0;

$redBuildingsDestroyed = 0;
$yellowBuildingsDestroyed = 0;

$yellowHerc1RespawnTime = 0;
$yellowHerc2RespawnTime = 0;
$yellowHerc3RespawnTime = 0;
$redHerc1RespawnTime = 0;
$redHerc2RespawnTime = 0;
$redHerc3RespawnTime = 0;

$yellowHerc1Path = "MissionGroup/yellowHerc1Path";
$yellowHerc2Path = "MissionGroup/yellowHerc2Path";
$yellowHerc3Path = "MissionGroup/yellowHerc3Path";
$redHerc1Path = "MissionGroup/redHerc1Path";
$redHerc2Path = "MissionGroup/redHerc2Path";
$redHerc3Path = "MissionGroup/redHerc3Path";

$yellowHqDestroyed = false;
$redHqDestroyed = false;

$padWaitTime = 50;
$zenWaitTime = 50;

///////////////////////////////////////////////////////////////////////////////////////////////////
// the Game Info tab uses these variables in the rules
///////////////////////////////////////////////////////////////////////////////////////////////////
$respawnDelay = 30;
$respawnDelayNoHq = 30;
$BUILDINGS_TO_DESTROY = 6;

///////////////////////////////////////////////////////////////////////////////////////////////////
// our base defender attributes
//
// The jump from 0.9 to 1.0 is a big one. At skill 1.0 and accuracy 1.0 the AI units will aim 
// first for the weapons, then the legs. A little too much for this mission.
//
///////////////////////////////////////////////////////////////////////////////////////////////////
Pilot Harabec
{
   id = 28;
   
   name = "Harabec";
   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 350.0;
   deactivateBuff = 700.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

Pilot Prometheus
{
   id = 29;
   
   name = "Prometheus";
   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 350.0;
   deactivateBuff = 700.0;
   targetFreq = 2.0;
   trackFreq = 0.0;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};


function setDefaultMissionOptions()
{
	$server::TeamPlay = True;
	$server::AllowDeathmatch = False;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = false;
	$server::AllowTeamYellow = true;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = true;
   $server::disableTeamYellow = false;
   $server::disableTeamPurple = false;
}


function onMissionLoad(){
   cdAudioCycle("Yougot", "Newtech", "Mechsoul"); 

// get the original ID for each AI Herc ( for use later when we clone them )
   $yellowHerc1 = getObjectId( "MissionGroup/yellowHercs/h1" );
   $yellowHerc2 = getObjectId( "MissionGroup/yellowHercs/h2" );
   $yellowHerc3 = getObjectId( "MissionGroup/yellowHercs/h3" );
   
   $redHerc1 = getObjectId( "MissionGroup/redHercs/h1" );
   $redHerc2 = getObjectId( "MissionGroup/redHercs/h2" );
   $redHerc3 = getObjectId( "MissionGroup/redHercs/h3" );
}

//-------------------------------------------------------------
function player::onAdd(%this)
{
   say(%this, 0, "Welcome to AI Rebellion! You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

function vehicle::onAdd(%this)
{
   // Spawn them all on yellow team
   if(getTeam(%this) == *IDSTR_TEAM_PURPLE)
   {
      setTeam(%this, *IDSTR_TEAM_YELLOW);
      redrop(%this);
   }
   else if(getTeam(%this) == *IDSTR_TEAM_YELLOW)
   {
      setTeam(%this, *IDSTR_TEAM_YELLOW);
      redrop(%this);
   }

}

function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam( %this ) == *IDSTR_TEAM_RED )
   {
      $yellowKills++;
   }
   else
   {
      $redKills++;
   }

   // award the player a kill ( if the enemy is a different color )
   if( getTeam( %destroyer ) != getTeam( %this ) )
   {
      %player = playerManager::vehicleIdToPlayerNum( %destroyer );
      if(%player != 0)
      {
         %player.numKills++;      
      }
   }
   
   //----------------------------------------------------------------
   // If any of our AI hercs die, give a message and re-clone/drop them
   //----------------------------------------------------------------
   if( %this == $yellowHerc1 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", 546.648, 181.031, 101);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc1\", " @ %this @ ", 546.648, 181.031, 101);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc2 )
   {
      $yellowHercsDestroyed++;

      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 541.693, -221.528, 101);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc2\", " @ %this @ ", 541.693, -221.528, 101);", $respawnDelay);
      }
   }
   if( %this == $yellowHerc3 )
   {
      $yellowHercsDestroyed++;
      
      if( $yellowHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", 453.893, 832.191, 101);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$yellowHerc3\", " @ %this @ ", 453.893, 832.191, 101);", $respawnDelay);
      }
   }

   if( %this == $redHerc1 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -552.9, 204.717, 105);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc1\", " @ %this @ ", -552.9, 204.717, 105);", $respawnDelay);
      }
   }
   if( %this == $redHerc2 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -455.85, 699.703, 101);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc2\", " @ %this @ ", -455.85, 699.703, 101);", $respawnDelay);
      }
   }
   if( %this == $redHerc3 )
   {
      $redHercsDestroyed++;
      
      if( $redHqDestroyed == false )
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -339.113, -364.393, 101);", $respawnDelay);
      }
      else
      {
         schedule( "trevorsCloneVehicle(\"$redHerc3\", " @ %this @ ", -339.113, -364.393, 101);", $respawnDelay);
      }
   }

   // left over from missionStdLib.cs
   vehicle::onDestroyedLog(%this, %destroyer);
   
   // give the death messages...
   %message = getFancyDeathMessage(getHUDName(%this), getHUDName(%destroyer));
   if(%message != "")
   {
      say( 0, 0, %message);
   }
}

function onMissionStart()
{

 	$padWaitTime = 50;
  	$zenWaitTime = 50;

	marsSounds();	

   initGlobalVars();
   
   order( $yellowHerc1, guard, $yellowHerc1Path );
   order( $yellowHerc2, guard, $yellowHerc2Path );
   order( $yellowHerc3, guard, $yellowHerc3Path );
   order( $redHerc1, guard, $redHerc1Path );
   order( $redHerc2, guard, $redHerc2Path );
   order( $redHerc3, guard, $redHerc3Path );
}

function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", $respawnDealNoHq + 10 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup", %clone );

   %path = %globalVarName @ "Path";
   schedule( "order( " @ %clone @ ", guard, " @ %path @ " );", 1 );
}
