$missionName = "La_J_Titan";

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = true;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamYellow = true;
	
	$server::disableTeamYellow = false;
	$server::disableTeamBlue = true;
	$server::disableTeamRed = false;
	$server::disableTeamPurple = true;
}

function onMissionStart()
{
	windSounds();
        turretMove();
        lajRoam();
}

Pilot LaJ
{
   id = 52;   
   name = "La J";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 0.1;
   activateDist = 1000.0;
   deactivateBuff = 1000.0;
   targetFreq = 0.1;
   trackFreq = 0.1;
   fireFreq = 0.5;
   LOSFreq = 0.1;
   orderFreq = 2.0;
};

function onMissionLoad()
{
    cdAudioCycle("SS3", "SS4", "SS1");
    $LAJ	   =	 "MissionGroup/LaJ/Herc1";
    $Turret	   =	 "MissionGroup/LaJ/Turret";
    $MF1	   =	 "MissionGroup/Scatter2/mf1";
    $MF2	   =	 "MissionGroup/Scatter2/mf2";
    $MF3	   =	 "MissionGroup/Scatter2/mf3";
    $MF4	   =	 "MissionGroup/Scatter2/mf4";
    $MF5	   =	 "MissionGroup/Scatter2/mf5";

}

function player::onAdd(%this)
{
    say( 0, 0, "La J:  Welcome to Titan.  Hope you have fun." );
    $playerNum = %this;
}

function vehicle::onAdd(%this)
{
    %num = playerManager::vehicleIdToPlayerNum(%this);
    if(%num == $playerNum) 
    {
        $playerId = playerManager::playerNumToVehicleId($playerNum);
    }
}

function turretMove()
{
    warp( $Turret, $PlayerID);
    schedule( "turretRun();", 30);
}


function turretRun()
{
    say( 0, 0, "La J:  Bad Turret!  Shame on you!" );
    warp( $Turret, $LAJ);
    schedule( "turretMove();", 90);
    healObject( $Turret, 20000 );
}

function lajRoam()
{
    setDominantCamera( $LAJ, $Turret );
    schedule( "lajRoam();", 150);
    order( $LAJ, Guard, "MissionGroup/LaJ/Path2" );
    reloadObject( $LAJ, 20000 );
    healObject( $LAJ, 20000 );
    warp( $MF5, $LAJ);
    warp( $MF4, $Turret);
    randomTransport( $MF2, -5000, -5000, 5000, 5000);
    randomTransport( $MF1, -5000, -5000, 5000, 5000);
}

function building::onAttacked( %this, %attacker )
{
    say( 0, 0, "La J:  Oh that was bright." );
    setDominantCamera( $LAJ, %this );
    warp( $MF3, %attacker);
    warp( $MF2, $LAJ);
    damageObject( %attacker, 20000 );
}

function vehicle::onAttacked( %this, %attacker )
{
        if( %this == $LAJ )
	   {
	     setDominantCamera( $LAJ, %attacker );
             warp( $MF1, $LAJ);
	     damageObject( %attacker, 20000 );
	     schedule( "lajRoam();", 150);
	     randomTransport( $LAJ, -5000, -5000, 5000, 5000);
	     order( $LAJ, Guard, "MissionGroup/LaJ/Path2" );
	   }
}
function vehicle::onDestroyed( %this, %destroyer )
{
       say( 0, 0, "La J:  Ooh nice kill!" );
       warp( $MF3, %this);
       randomTransport( %destroyer, -5000, -5000, 5000, 5000);
   
}

function vehicle::onScan(%this, %object, %string)
{
  %player = playerManager::vehicleIdToPlayerNum(%object);
  %player.IP = getConnection(%this);
	say(%player, 0, %player.IP);
  %componentCount = getComponentCount(%this);
  %index = 0;
  while (%index < %componentCount) 
  {
    %id = getComponentId(%this, %index);
    %theName = nameStuff(%id);
	say(%player, 0, %theName);
	%index++;
  }
}

function nameStuff(%thingie)
{
	if ((%thingie >= 100) && (%thingie <= 115))
	{
		return(nameEngineA(%thingie));
	}

	else if ((%thingie >= 128) && (%thingie <= 143))
	{
		return(nameEngineB(%thingie));
	}

	else if ((%thingie >= 200) && (%thingie <=230))
	{
		return(nameReactor(%thingie));
	}

	else if ((%thingie >= 300) && (%thingie <= 333))
	{
		return(nameShield(%thingie));
	}

	else if ((%thingie >= 400) && (%thingie <= 434))
	{
		return(nameSensor(%thingie));
	}

	else if ((%thingie >= 800) && (%thingie <= 807))
	{
		return(nameComputer(%thingie));
	}

	else if ((%thingie >= 926) && (%thingie <= 931))
	{
		return(nameArmor(%thingie));
	}

	else if ((%thingie >= 810) && (%thingie <= 914))
	{
		return(nameSpecial(%thingie));
	}

	else return("Unknown component");
}


function nameEngineA(%thingie)
{
	return("Human Engine");
}

function nameEngineB(%thingie)
{
	return("Cybrid Engine");
}

function nameReactor(%thingie)
{
	if (%thingie == 200)
	{
		return("Human Micro Reactor");
	}
	else if(%thingie == 201)
	{
		return("Human Small Reactor");
	}
	else if(%thingie == 202)
	{
		return("Human Standard Reactor");
	}
	else if(%thingie == 203)
	{
		return("Human Medium Reactor");
	}
	else if(%thingie == 204)
	{
		return("Human Large Reactor");
	}
	else if(%thingie == 205)
	{
		return("Human Maxim Reactor");
	}
	else if(%thingie == 225)
	{
		return("Cybrid Alpha Reactor");
	}
	else if(%thingie == 226)
	{
		return("Cybrid Beta Reactor");
	}
	else if(%thingie == 227)
	{
		return("Cybrid Gamma Reactor");
	}
	else if(%thingie == 228)
	{
		return("Cybrid Delta Reactor");
	}
	else if(%thingie == 229)
	{
		return("Cybrid Epsilon Reactor");
	}
	else if(%thingie == 230)
	{
		return("Cybrid Zeta Reactor");
	}
	else return("Unknown reactor");
}


function nameShield(%thingie)
{
	if(%thingie == 300)
	{
		return("Human Standard Shield");
	}
	else if(%thingie == 301)
	{
		return("Human Protector Shield");
	}
	else if(%thingie == 302)
	{
		return("Human Guardian Shield");
	}
	else if(%thingie == 303)
	{
		return("Human FastCharge Shield");
	}
	else if(%thingie == 304)
	{
		return("Human Centurion Shield");
	}
	else if(%thingie == 305)
	{
		return("Human Repulsor Shield");
	}
	else if(%thingie == 306)
	{
		return("Human Titan Shield");
	}
	else if(%thingie == 307)
	{
		return("Human Medusa Shield");
	}
	else if(%thingie == 326)
	{
		return("Cybrid Alpha Shield");
	}
	else if(%thingie == 327)
	{
		return("Cybrid Beta Shield");
	}
	else if(%thingie == 328)
	{
		return("Cybrid Gamma Shield");
	}
	else if(%thingie == 329)
	{
		return("Cybrid Delta Shield");
	}
	else if(%thingie == 330)
	{
		return("Cybrid Epsilon Shield");
	}
	else if(%thingie == 331)
	{
		return("Cybrid Zeta Shield");
	}
	else if(%thingie == 332)
	{
		return("Cybrid Eta Shield");
	}
	else if(%thingie == 333)
	{
		return("Cybrid Theta Shield");
	}
	else return("Unknown shield");
}


function nameSensor(%thingie)
{
	if(%thingie == 400)
	{
		return("Human Basic Sensor");
	}
	else if(%thingie == 401)
	{
		return("Human Ranger Sensor");
	}
	else if(%thingie == 408)
	{
		return("Human Standard Sensor");
	}
	else if(%thingie == 409)
	{
		return("Human Longbow Sensor");
	}
	else if(%thingie == 410)
	{
		return("Human Infiltrator Sensor");
	}
	else if(%thingie == 411)
	{
		return("Human Crossbow Sensor");
	}
	else if(%thingie == 412)
	{
		return("Human Ultralight Sensor");
	}
	else if(%thingie == 413)
	{
		return("Human Bloodhound Sensor");
	}
	else if(%thingie == 414)
	{
		return("Human Thermal Sensor");
	}
	else if(%thingie == 426)
	{
		return("Cybrid Alpha Sensor - Basic");
	}
	else if(%thingie == 427)
	{
		return("Cybrid Beta Sensor - Long Range");
	}
	else if(%thingie == 428)
	{
		return("Cybrid Gamma Sensor - Standard");
	}
	else if(%thingie == 429)
	{
		return("Cybrid Delta Sensor - Longbow");
	}
	else if(%thingie == 430)
	{
		return("Cybrid Epsilon Sensor - Infiltrator");
	}
	else if(%thingie == 431)
	{
		return("Cybrid Zeta Sensor - Crossbow");
	}
	else if(%thingie == 432)
	{
		return("Cybrid Eta Sensor - Ultralight");
	}
	else if(%thingie == 433)
	{
		return("Cybrid Theta Sensor - Hound");
	}
	else if(%thingie == 434)
	{
		return("Cybrid Iota Sensor - Motion Detector");
	}
	else return("Unknown sensor");
}


function nameArmor(%thingie)
{
	if(%thingie == 926)
	{
		return("Carbon Fiber Laminate Armor");
	}
	else if(%thingie == 927)
	{
		return("Quad Bonded Metaplas Armor");
	}
	else if(%thingie == 928)
	{
		return("Depleted Uranium Armor");
	}
	else if(%thingie == 929)
	{
		return("Ceramic Armor");
	}
	else if(%thingie == 930)
	{
		return("Crystaluminum Armor");
	}
	else if(%thingie == 931)
	{
		return("Quicksilver Armor");
	}
	else return("Unknown armor");
}


function nameComputer(%thingie)
{
	if(%thingie == 800)
	{
		return("Human Basic Computer - 166");
	}
	else if(%thingie == 801)
	{
		return("Human Improved Computer - 300");
	}
	else if(%thingie == 802)
	{
		return("Human Advanced Computer - 450");
	}
	else if(%thingie == 805)
	{
		return("Cybrid Basic Systems Control - Alpha");
	}
	else if(%thingie == 806)
	{
		return("Cybrid Enhanced Systems Control - Beta");
	}
	else if(%thingie == 807)
	{
		return("Cybrid Advanced Systems Control");
	}
	else return("Unknown computer");
}


function nameSpecial(%thingie)
{
	if(%thingie == 810)
	{
		return("Human Guardian ECM");
	}
	else if(%thingie == 811)
	{
		return("Human Doppleganger ECM");
	}
	else if(%thingie == 812)
	{
		return("Cybrid Alpha ECM");
	}
	else if(%thingie == 813)
	{
		return("Cybrid Beta ECM");
	}
	else if(%thingie == 820)
	{
		return("Thermal Diffuser");
	}
	else if(%thingie == 830)
	{
		return("Chameleon Cloak");
	}
	else if(%thingie == 831)
	{
		return("Cuttlefish Cloak");
	}
	else if(%thingie == 840)
	{
		return("Shield Modulator");
	}
	else if(%thingie == 845)
	{
		return("Shield Capacitor");
	}
	else if(%thingie == 850)
	{
		return("Shield Amplifier");
	}
	else if(%thingie == 860)
	{
		return("Laser Targeting Module");
	}
	else if(%thingie == 865)
	{
		return("Auxiliary Power Storage Battery");
	}
	else if(%thingie == 870)
	{
		return("Reactor Capacitor");
	}
	else if(%thingie == 875)
	{
		return("Field Stabilizer");
	}
	else if(%thingie == 880)
	{
		return("Rocket Booster");
	}
	else if(%thingie == 885)
	{
		return("Turbine Booster");
	}
	else if(%thingie == 890)
	{
		return("Nanorepair");
	}
	else if(%thingie == 900)
	{
		return("Angel Life Support");
	}
	else if(%thingie == 910)
	{
		return("AntiGrav Generator");
	}
	else if(%thingie == 912)
	{
		return("Electrohull");
	}
	else if(%thingie == 914)
	{
		return("Universal Ammunition Pack");
	}
}

///