$missionName = "Goad_Beatdown";

exec("multiplayerStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;
	
	$server::AllowTeamRed = true;

	$server::disableTeamYellow = true;
	$server::disableTeamBlue = true;
	$server::disableTeamRed = false;
	$server::disableTeamPurple = true;	
}

function onMissionStart()
{
	moonSounds();

   	$blastRadiusLarge = 10000;
   	$blastDamageLarge = 80000;
   
	cdAudioCycle("Watching", "Terror", "Mechsoul"); 
}

Pilot GoddamnedGoad
{
   id = 52;   
   name = "Goddamned Goad";
   skill = 1.0;
   accuracy = 0.6;
   aggressiveness = 0.6;
   activateDist = 900.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 0.3;
   fireFreq = 0.2;
   LOSFreq = 0.4;
   orderFreq = 2.0;
};

function onMissionLoad()
{
    $squikked = 0;
    $squikkedwrong = 0;
    $squikkedlately = 0;
    $roaming = 1;
    $scoringFreeze = false;
    initScoreBoard();
}

function player::onAdd(%playerNum)
{
  $playerNum = %playerNum;
  say(%playerNum,0,"Goddamned Goads.  Kill the things would you?");
}

function vehicle::onAdd(%this)                                                                                                                        
{                                                                                                                                                     
   %num = playerManager::vehicleIdToPlayerNum(%this);                                                                                                 
                                                                                                                                                      
   if(%num == $playerNum)                                                                                                                             
   {                                                                                                                                                  
      $playerId = playerManager::playerNumToVehicleId($playerNum);                                                                                    
   }                                                                                                                                                  
}        

function vehicle::onDestroyed( %this, %destroyer )
{
   if( getTeam(%this) == *IDSTR_TEAM_YELLOW )
   {
   schedule( "trevorsCloneVehicle(\"$Copy1\", " @ %this @ ", -900, 600, 400);", 1);
   schedule( "trevorsCloneVehicle(\"$Copy2\", " @ %this @ ", -900, 800, 400);", 1);
   $roaming++;
   $squikked++;
   $squikkedlately++;
   schedule( "$squikkedlately--;", 120);
   }

   if( %this == $playerID )
   {
     $squikkedwrong++;
     order( "MissionGroup/Goads" , cloak, true );
     if( $roaming >= 5 )
     {
     schedule( "trevorsCloneVehicle(\"$Copy1\", " @ %this @ ", -600, 600, 400);", 1);
     }
   }

   healObject( %destroyer, 10000 );
   reloadObject( %destroyer, 5000 );

}

function trevorsCloneVehicle(%globalVarName, %old, %x, %y, %z)
{
   %clone = cloneVehicle(%old);
   setPosition(%clone, %x, %y, %z);

   schedule( "deleteObject(" @ %old @ ");", 1 );

   schedule( %globalVarName @ " = " @ %clone @ ";", 0);

   addToSet( "MissionGroup/Goads", %clone );
}


function initScoreBoard()
{
   deleteVariables("$ScoreBoard::PlayerColumn*");
   deleteVariables("$ScoreBoard::TeamColumn*");

	$ScoreBoard::PlayerColumnHeader1 = "Team";
	$ScoreBoard::PlayerColumnHeader2 = "Goads squikked";
	$ScoreBoard::PlayerColumnHeader3 = "Squikked wrong";

	$ScoreBoard::PlayerColumnFunction1 = "getTeam2";
	$ScoreBoard::PlayerColumnFunction2 = "getKills";
	$ScoreBoard::PlayerColumnFunction3 = "getBuildingsDestroyed";

   $ScoreBoard::TeamColumnHeader1 = "Goads roaming";
   $ScoreBoard::TeamColumnHeader2 = "Goads squikked lately";
   $ScoreBoard::TeamColumnFunction1 = "getTeam22";
   $ScoreBoard::TeamColumnFunction2 = "getKills2";
 
   serverInitScoreBoard();
}

function getTeam2(%player)
{
   return *IDMULT_RED;
}

function getKills(%player)
{
   return $squikked;
}

function getBuildingsDestroyed(%player)
{
   return $squikkedwrong;
}

function getTeam22(%player)
{
   return $roaming;
}

function getKills2(%player)
{
   return $squikkedlately;
}

function BlastDamageLarge::structure::onDestroyed(%this, %object)
{
   blast(%this, $blastRadiusLarge, $blastDamageLarge, 0);
}
