$missionName = "GhostTown";

exec("multiplayerStdLib.cs");
exec("DMStdLib.cs");

function setDefaultMissionOptions()
{
	$server::TeamPlay = false;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	
	
	$server::AllowTeamRed = true;
	$server::AllowTeamPurple = true;

	$server::disableTeamYellow = true;
	$server::disableTeamBlue = true;
	$server::disableTeamRed = false;
	$server::disableTeamPurple = false;
}

function onMissionStart()
{
	earthquakeSounds();
	windSounds();
	iceSounds();

      clearGeneralOrders();
}

Pilot ShatteredStar
{
   id = 52;   
   name = "ShatteredStar";
   skill = 0.8;
   accuracy = 1.0;
   aggressiveness = 0.9;
   activateDist = 900.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.4;
   orderFreq = 2.0;
};

Pilot EagleEye
{
   id = 25;   
   name = "EagleEye";
   skill = 0.7;
   accuracy = 1.0;
   aggressiveness = 0.7;
   activateDist = 1100.0;
   deactivateBuff = 100.0;
   targetFreq = 3.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Perihelion
{
   id = 26;   
   name = "Perihelion";
   skill = 0.8;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 600.0;
   deactivateBuff = 100.0;
   targetFreq = 5.0;
   trackFreq = 0.2;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Estri
{
   id = 27;   
   name = "Estri";
   skill = 1.0;
   accuracy = 0.6;
   aggressiveness = 0.8;
   activateDist = 800.0;
   deactivateBuff = 100.0;
   targetFreq = 4.0;
   trackFreq = 0.3;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Annie
{
   id = 28;   
   name = "Annie Oakley";
   skill = 1.0;
   accuracy = 0.8;
   aggressiveness = 0.6;
   activateDist = 700.0;
   deactivateBuff = 100.0;
   targetFreq = 2.0;
   trackFreq = 0.1;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Grailen
{
   id = 29;   
   name = "Grailen Infernos";
   skill = 1.0;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 700.0;
   deactivateBuff = 200.0;
   targetFreq = 2.0;
   trackFreq = 0.3;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Ghost
{
   id = 30;   
   name = "Europan Ghost";
   skill = 1.0;
   accuracy = 0.5;
   aggressiveness = 0.8;
   activateDist = 900.0;
   deactivateBuff = 100.0;
   targetFreq = 1.0;
   trackFreq = 0.3;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

Pilot Master
{
   id = 31;   
   name = "Europan Master";
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.0;
   activateDist = 2000.0;
   deactivateBuff = 500.0;
   targetFreq = 5.0;
   trackFreq = 0.1;
   fireFreq = 0.2;
   LOSFreq = 0.1;
   orderFreq = 1.0;    
};

function onMissionLoad()
{
	cdAudioCycle("SS4", "SS3", "SS1");

    $SS	   =	 "MissionGroup/Actors/SS/Herc1";
    $EE	   =	 "MissionGroup/Actors/EE/Herc1";
    $Peri	   =	 "MissionGroup/Actors/Peri/Herc1";
    $Estri	   =	 "MissionGroup/Actors/Estri/Herc1";
    $AO	   =   "MissionGroup/Actors/AO/Herc1";
    $GI	   =   "MissionGroup/Actors/GI/Herc1";
    $Flyer	   =   "MissionGroup/Flyer/Flyer1";
    $Actors	   =   "MissionGroup/Actors";
    $Ghosts1   =   "MissionGroup/Ghosts1";
    $Ghosts2   =   "MissionGroup/Ghosts2";
    $Ghosts3   =   "MissionGroup/Ghosts3";
    $Ghosts4   =   "MissionGroup/Ghosts4";
    $Ghosts5   =   "MissionGroup/Ghosts5";
    $Masters   =   "MissionGroup/Masters";
    $Saved   = 0;
    $Alive   = 6;
    $SSId     = getObjectId( $SS );
    $EEId     = getObjectId( $EE );
    $PeriId   = getObjectId( $Peri );
    $EstriId  = getObjectId( $Estri );
    $AOId     = getObjectId( $AO );
    $GIId     = getObjectId( $GI );
    $FlyerId     = getObjectId( $Flyer );

    order( $Actors, Speed, Medium );
    order( $SS, MakeLeader, True );
    order( $Actors, Guard, "MissionGroup/Actors/Path" );
    order( $Actors, holdPosition, True );

    order( $Ghosts2, Speed, Medium );
    order( $Ghosts3, Speed, Medium );
    order( $Ghosts4, Speed, Medium );
    order( $Ghosts1, Speed, High );
    order( $Masters, Speed, High );
    order( $Ghosts1, Attack, "MissionGroup/Actors" );
    order( $Ghosts2, Guard, "MissionGroup/Ghosts2/Path" );
    order( $Ghosts3, Guard, "MissionGroup/Ghosts3/Path" );
    order( $Ghosts4, Guard, "MissionGroup/Ghosts4/Path" );
    order( $Masters, Guard, "MissionGroup/Masters/Path" );

   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  The dropship is waiting for us about fifteen klicks southwest.\");", 25.0);
   schedule("say(IDSTR_TEAM_PURPLE, 0, \"HQ:  The Alliance seems to have dispatched a sizable force to bring their captaured materials home.  Stop them.\");", 25.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  I don't like the look of these scans, sir...\");", 32.0);
   schedule("say(IDSTR_TEAM_PURPLE, 0, \"HQ:  We are reading signs of their vehicles approaching Nav Two, and also some other motion in the vicinity.\");", 36.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Oh?\");", 37.0);
   schedule("say(IDSTR_TEAM_PURPLE, 0, \"HQ:  Make sure you check it out... strange things happen around here so watch your back...\");", 43.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  Yeah.  I think I am reading vehicle signatures but they are very faint and erratic...\");", 44.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Estri: A town was sited here some centuries ago.  You can see the ruins.  Perhaps it's haunted.  Meep...\");", 52.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Annie Oakley:  A town of legend?\");", 57.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Estri: A town of nightmares, from what I've heard.  Someone said something about the Masters having visited here.\");", 66.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Annie Oakley:  Hmmmm...\");", 70.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Perihelion:  Well let's get moving.  This place gives me the creeps.\");", 75.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Indeed.  Set course for Nav Omega.  We have to get these materials to the Alliance.\");", 85.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Grailen Infernos:  No problem.  Nothing here anyway, just ice.\");", 92.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  Definately getting readings...\");", 162.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Grailen Infernos:  The beasties coming out to get us?\");", 170.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  I don't know but they're in the fifty-ton range.\");", 177.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Noted.  Maintain radio silence and charge weaponry.  They may be hostile.\");", 183.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Perihelion:  Understood.\");", 187.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Annie Oakley:  It's your party.  Weapons hot, radio cold.  Out.\");", 188.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Grailen Infernos:  What the hell was that?\");", 423.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Predator-class vehicle.  The Masters might be here after all.  Did you get a scan of the pilot?\");", 433.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  Quite clear, sir... there wasn't one...\");", 438.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Estri:  Meeep!\");", 441.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Stay close.  There may be more of them...\");", 447.0);
   schedule("order( $Ghosts2, Attack, $Actors );", 500.0);
   schedule("order( $Ghosts3, Attack, $Actors );", 700.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Yeah looks like there are more of them...\");", 750.0);
   schedule("setPosition($Estri, 0, 0, 500);", 775.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Estri:  Meeep!  Where am I??\");", 777.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Annie Oakley:  Estri!  What happened?\");", 781.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"Estri:  I don't know, I just appeared somewhere else!  I'm near Nav Alpha...\");", 784.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Proceed to the dropship, Estri, and hurry... there are a lot of them around here...\");", 790.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"EagleEye:  Oh now this just sucks.\");", 800.0);
   schedule("say(IDSTR_TEAM_RED, 0, \"ShatteredStar:  Indeed...\");", 805.0);
   schedule("order( $Ghosts4, Attack, $Actors );", 900.0);
   schedule("order( $Masters, Attack, $Actors );", 1000.0);
}

function vehicle::onAttacked(%this, %attacker)
{
        if( %this == $FlyerID )
	   {
		order( %attacker, Attack, $Actors );
		healObject( $Flyer, 10000 );
	   }
}

function vehicle::onDestroyed(%this, %destroyer)
{
        if( %this == $EstriID )
	   {
	    say(0, 0, \"Estri is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

        if( %this == $SSID )
	   {
	    say(0, 0, \"ShatteredStar is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

        if( %this == $AOID )
	   {
	    say(0, 0, \"Annie Oakley is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

        if( %this == $EEID )
	   {
	    say(0, 0, \"EagleEye is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

        if( %this == $PeriID )
	   {
	    say(0, 0, \"Perihelion is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

        if( %this == $GIID )
	   {
	    say(0, 0, \"Grailen Infernos is dead.\");
            $Alive--;
	    setDominantCamera( %destroyer, %this );
	   }

	if( $Alive == 0 )
	   {
            purpleWins();
	   }
}

function ZenTransporter::trigger::onContact(%this, %object)
{
	Zen::work(%this, %object, 100000, 100, 0, false);
	setPosition(%object, 0, 0, -5000);
}

function ZenFinish::trigger::onContact(%this, %object)
{
        if( %object == $EstriID )
	   {
	    say(0, 0, \"Estri has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
        if( %object == $SSID )
	   {
	    say(0, 0, \"ShatteredStar has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
        if( %object == $EEID )
	   {
	    say(0, 0, \"EagleEye has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
        if( %object == $PeriID )
	   {
	    say(0, 0, \"Perihelion has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
        if( %object == $AOID )
	   {
	    say(0, 0, \"Annie Oakley has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
        if( %object == $GIID )
	   {
	    say(0, 0, \"Grailen Infernos has reached the dropship.\");
	    setPosition(%object, 5000, 5000, 300);
	    Saved++;    
	   }
	if( $Alive == $Saved )
	   {
            redWins();
	   }
}

function purpleWins()
{
      fadeEvent( 0, out, 10, 1.0, 0, 1.0 ); 
      schedule( "missionEndConditionMet();", 11 );               
      %txt = "Purple team wins!";
      messageBox(0, %txt);
}

function redWins()
{
      order( $Flyer, Guard, "MissionGroup/Flyer/Path" );
      setDominantCamera( $Flyer, "MissionGroup/Flyer/Stick" );
      fadeEvent( 0, out, 59, 1.0, 0, 0 ); 
      schedule( "missionEndConditionMet();", 60 );               
      %txt = "Red team wins!";
      messageBox(0, %txt);
}
