// FILENAME:	TDM_Capture_the_AI.cs
//
// AUTHOR:  	Gen. Raven [M.I.B.]
//
// SPECIAL THANKS: Orogogus, johnrich, & mike the goad
//------------------------------------------------------------------------------

$missionName = "TDM_Capture_the_AI";

exec("multiplayerStdLib.cs");
exec("DMstdLib.cs");


Pilot Exec
{
   id = 28;
   
   skill = 0.9;
   accuracy = 0.9;
   aggressiveness = 1.0;
   activateDist = 600.0;
   deactivateBuff = 500.0;
   targetFreq = 2.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   name = "Platinum Guard Executioner";
};

Pilot Goad
{
   id = 29;
   
   skill = 1.0;
   accuracy = 1.0;
   aggressiveness = 1.5;
   activateDist = 750.0;
   deactivateBuff = 500.0;
   targetFreq = 2.0;
   trackFreq = 0.1;
   fireFreq = 0.1;
   LOSFreq = 0.1;
   name = "Goad";
};


$startX = 12.8684; 
$startY = 460.486;
$startZ = 154;
$startX2 = -105.952; 
$startY2 = 583.334;
$startZ2 = 155;
$startX3 = 1158.42; 
$startY3 = 440.131;
$startZ3 = 111;
$startX4 = 1155.68; 
$startY4 = 602.035;
$startZ4 = 111;
$startX5 = -1158.47; 
$startY5 = 611.08;
$startZ5 = 111;
$startX6 = -1160.25; 
$startY6 = 468.191;
$startZ6 = 111;

$Exec1Path = "MissionGroup/Exec1Path";
$Exec2Path = "MissionGroup/Exec2Path";
$Goad3Path = "MissionGroup/Goad3Path";
$Goad4Path = "MissionGroup/Goad4Path";
$Goad5Path = "MissionGroup/Goad5Path";
$Goad6Path = "MissionGroup/Goad6Path";

function setDefaultMissionOptions()
{
	$server::TeamPlay = true;
	$server::AllowDeathmatch = false;
	$server::AllowTeamPlay = true;	

   // what can the client choose for a team
	$server::AllowTeamRed = false;
	$server::AllowTeamBlue = true;
	$server::AllowTeamYellow = false;
	$server::AllowTeamPurple = true;

   // what can the server admin choose for available teams
   $server::disableTeamRed = true;
   $server::disableTeamBlue = false;
   $server::disableTeamYellow = true;
   $server::disableTeamPurple = false;
}

function onMissionLoad()
{
   cdAudioCycle("Newtech", "Mechsoul", "CloudBurst");
   setGameInfo("<F2>GAME TYPE:<F0>  Team DeathMatch\n\n<F2>MISSION:<F0>  TDM_Capture_The_AI\n\n Welcome to Team DeathMatch Capture The AI! Power down on the zen pads for <F3>5<F0> seconds to capture the AI hercs at that nav. You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

function onMissionStart()
{
	initGlobalVars();
  
	
	$lastVehicleOnZen = "";
	$lastVehicleOnRedZen = "";
	$lastVehicleOnBlueZen = "";
	$secondsToGain = 0;
	$secondsToGainRedZen = 0;
	$secondsToGainBlueZen = 0;

      titanSounds();
}

function player::onAdd(%this)
{
   say(%this, 0, "Welcome to Team DeathMatch Capture The AI! Power down on the zen pads for 5 seconds to capture the AI hercs at that nav. You can download this & other missions made by Gen. Raven [M.I.B.] in the \"MIB Map Packs\" at www.starsiegeplayers.com or on the MIB Website at http://mibhq.4mg.com");
}

function vehicle::onAdd(%vehicleId)
{
      %vehicleId.name = getHUDName(%vehicleId);
     	%yourteam = getTeam(%vehicleId);
	if(%yourteam == *IDSTR_TEAM_PURPLE) %player.color = "Purple Team";
	if(%yourteam == *IDSTR_TEAM_BLUE) %player.color = "Blue Team";
}

// ZenAll Pad Functionality
//------------------------------------------------------------------------------
function ZenAll::trigger::onEnter(%this, %vehicleId)
{  
   Zen::onEnter(%this, %vehicleId, *IDMULT_CHAT_ALLPAD, true, true);  
}  

function ZenAll::trigger::onContact(%this, %vehicleId)
{
   	%team = getTeam(%vehicleId);
      Zen::work(%this, %vehicleId, $yellowZenHealRate, $yellowZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%vehicleId)){
		if(%vehicleId != $lastVehicleOnZen){
			$lastVehicleOnZen = %vehicleId;
			$secondsToGain = 1;
		}
		else{
			$secondsToGain = $secondsToGain + 1;
		}
		if(($secondsToGain == 5) && (getTeam(%vehicleId) == getTeam($Benedict)))
            {
                      say(Everybody, 1, %team @ " already owns the Executioners!");
            }
            else if(($secondsToGain == 5) && (getTeam(%vehicleId) != getTeam($Benedict)))
            {
            say("Everybody", 1, %vehicleId.name @ " has captured the Executioners for " @ %team @ "!");
            deleteobject($Benedict);
            %color = getTeam(%vehicleId);
            setTeam("MissionGroup/center/NavZen", %color);
            %herc = NewObject("Exec", Herc, 28 ); 
            setTeam( %herc, %color );
            setPilotId(%herc,28);
            $Benedict = %herc;
            setPosition($Benedict, $startX, $startY, $startZ);
            order( $Benedict, guard, $Exec1Path );
          
            deleteobject($Benedict2);
            %color2 = getTeam(%vehicleId);
            %herc2 = NewObject("Exec", Herc, 28 ); 
            setTeam( %herc2, %color2 );
            setPilotId(%herc2,28);
            $Benedict2 = %herc2;
            setPosition($Benedict2, $startX2, $startY2, $startZ2);
            order( $Benedict2, guard, $Exec2Path );
            }
	}
}

function vehicle::OnDestroyed( %victim, %destroyer )
{
  %message = getFancyDeathMessage(getHUDName(%victim), getHUDName(%destroyer));
  if(%message != "") say( 0, 0, %message);
  if(%victim == $Benedict)
  {
    %color = getTeam($Benedict);
    schedule("deleteobject(" @ $Benedict @ ");", 60);  
    %herc = NewObject("Exec", Herc, 28 ); 
    setTeam( %herc, %color );
    setPilotId(%herc,28);
    $Benedict = %herc;
    setPosition($Benedict, -7000, 2000, 1000); //set them off the map
    schedule("setPosition($Benedict, $startX, $startY, $startZ);", 90); //move them 90 seconds later
    schedule("order( $Benedict, guard, $Exec1Path );", 91);
  }
  else if(%victim == $Benedict2)
  {    
    %color2 = getTeam($Benedict2);
    schedule("deleteobject(" @ $Benedict2 @ ");", 60);  
    %herc2 = NewObject("Exec", Herc, 28 ); 
    setTeam( %herc2, %color2 );
    schedule("setPilotId(%herc2,28);", 60);
    $Benedict2 = %herc2;
    setPosition($Benedict2, -7300, 2000, 1000);
    schedule("setPosition($Benedict2, $startX2, $startY2, $startZ2);", 90);
    schedule("order( $Benedict2, guard, $Exec2Path );", 91);
  }
  else if(%victim == $Benedict3)
  {    
    %color3 = getTeam($Benedict3);
    schedule("deleteobject(" @ $Benedict3 @ ");", 60);  
    %herc3 = NewObject("Goad", Herc, 21 ); 
    setTeam( %herc3, %color3 );
    setPilotId(%herc3,29);
    $Benedict3 = %herc3;
    setPosition($Benedict3, 7000, 2000, 1000);
    schedule("setPosition($Benedict3, $startX3, $startY3, $startZ3);", 30);
    schedule("order( $Benedict3, guard, $Goad3Path );", 31);
  }
  else if(%victim == $Benedict4)
  {    
    %color4 = getTeam($Benedict4);
    schedule("deleteobject(" @ $Benedict4 @ ");", 60);  
    %herc4 = NewObject("Goad", Herc, 21 ); 
    setTeam( %herc4, %color4 );
    setPilotId(%herc4,29);
    $Benedict4 = %herc4;
    setPosition($Benedict4, 7300, 2000, 1000);
    schedule("setPosition($Benedict4, $startX4, $startY4, $startZ4);", 30);
    schedule("order( $Benedict4, guard, $Goad4Path );", 31);
  }
  else if(%victim == $Benedict5)
  {    
    %color5 = getTeam($Benedict5);
    schedule("deleteobject(" @ $Benedict5 @ ");", 60);  
    %herc5 = NewObject("Goad", Herc, 21 ); 
    setTeam( %herc5, %color5 );
    setPilotId(%herc5,29);
    $Benedict5 = %herc5;
    setPosition($Benedict5, 9000, 2000, 1000);
    schedule("setPosition($Benedict5, $startX5, $startY5, $startZ5);", 30);
    schedule("order( $Benedict5, guard, $Goad5Path );", 31);
  }
  else if(%victim == $Benedict6)
  {    
    %color6 = getTeam($Benedict6);
    schedule("deleteobject(" @ $Benedict6 @ ");", 60);  
    %herc6 = NewObject("Goad", Herc, 21 ); 
    setTeam( %herc6, %color6 );
    setPilotId(%herc6,29);
    $Benedict6 = %herc6;
    setPosition($Benedict6, 9300, 2000, 1000);
    schedule("setPosition($Benedict6, $startX6, $startY6, $startZ6);", 30);
    schedule("order( $Benedict6, guard, $Goad6Path );", 31);
  }
}

// RedZen Pad Functionality
//------------------------------------------------------------------------------
function RedZen::trigger::onEnter(%this, %vehicleId)
{  
   Zen::onEnter(%this, %vehicleId, *IDMULT_CHAT_ALLPAD, true, true);  
}  

function RedZen::trigger::onContact(%this, %vehicleId)
{
   	%team = getTeam(%vehicleId);
      Zen::work(%this, %vehicleId, $RedZenHealRate, $RedZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%vehicleId)){
		if(%vehicleId != $lastVehicleOnRedZen){
			$lastVehicleOnRedZen = %vehicleId;
			$secondsToGainRedZen = 1;
		}
		else{
			$secondsToGainRedZen = $secondsToGainRedZen + 1;
		}
		if(($secondsToGainRedZen == 5) && (getTeam(%vehicleId) == getTeam($Benedict3)))
            {
                      say(Everybody, 1, %team @ " already owns the Alpha Goads!");
            }
            else if(($secondsToGainRedZen == 5) && (getTeam(%vehicleId) != getTeam($Benedict3)))
            {
            say("Everybody", 1, %vehicleId.name @ " has captured the Alpha Goads for " @ %team @ "!");
            deleteobject($Benedict3);
            %color3 = getTeam(%vehicleId);
            setTeam("MissionGroup/center/NavZenRed", %color3);
            %herc3 = NewObject("Goad", Herc, 21 ); 
            setTeam( %herc3, %color3 );
            setPilotId(%herc3,29);
            $Benedict3 = %herc3;
            setPosition($Benedict3, $startX3, $startY3, $startZ3);
            order( $Benedict3, guard, $Goad3Path );
          
            deleteobject($Benedict4);
            %color4 = getTeam(%vehicleId);
            %herc4 = NewObject("Goad", Herc, 21 ); 
            setTeam( %herc4, %color4 );
            setPilotId(%herc4,29);
            $Benedict4 = %herc4;
            setPosition($Benedict4, $startX4, $startY4, $startZ4);
            order( $Benedict4, guard, $Goad4Path );
            }
	}
}

// BlueZen Pad Functionality
//------------------------------------------------------------------------------
function BlueZen::trigger::onEnter(%this, %vehicleId)
{  
   Zen::onEnter(%this, %vehicleId, *IDMULT_CHAT_ALLPAD, true, true);  
}  

function BlueZen::trigger::onContact(%this, %vehicleId)
{
   	%team = getTeam(%vehicleId);
      Zen::work(%this, %vehicleId, $BlueZenHealRate, $BlueZenAmmoRate, $zenWaitTime, true);
	if(isShutDown(%vehicleId)){
		if(%vehicleId != $lastVehicleOnBlueZen){
			$lastVehicleOnBlueZen = %vehicleId;
			$secondsToGainBlueZen = 1;
		}
		else{
			$secondsToGainBlueZen = $secondsToGainBlueZen + 1;
		}
		if(($secondsToGainBlueZen == 5) && (getTeam(%vehicleId) == getTeam($Benedict5)))
            {
                      say(Everybody, 1, %team @ " already owns the Omega Goads!");
            }
            else if(($secondsToGainBlueZen == 5) && (getTeam(%vehicleId) != getTeam($Benedict5)))
            {
            say("Everybody", 1, %vehicleId.name @ " has captured the Omega Goads for " @ %team @ "!");
            deleteobject($Benedict5);
            %color5 = getTeam(%vehicleId);
            setTeam("MissionGroup/center/NavZenBlue", %color5);
            %herc5 = NewObject("Goad", Herc, 21 ); 
            setTeam( %herc5, %color5 );
            setPilotId(%herc5,29);
            $Benedict5 = %herc5;
            setPosition($Benedict5, $startX5, $startY5, $startZ5);
            order( $Benedict5, guard, $Goad5Path );
          
            deleteobject($Benedict6);
            %color6 = getTeam(%vehicleId);
            %herc6 = NewObject("Goad", Herc, 21 ); 
            setTeam( %herc6, %color6 );
            setPilotId(%herc6,29);
            $Benedict6 = %herc6;
            setPosition($Benedict6, $startX6, $startY6, $startZ6);
            order( $Benedict6, guard, $Goad6Path );
            }
	}
}

function boom::trigger::OnContact(%this, %object)
{
   setposition(%object, 0, 521.5, 2000);
}

