
/* Program to load pcx files - 8 bit  (256 colors) - version 5
  You are free to use this file. I do not expect any money from you.
  All I want you to do is to keep this program header with it.

 Important :
 ----------
  You need to have SVGA256.bgi in the same directory as this file.

 Programmed by G.Anil kumar,Madras,India
 Programmed on 12-10-98


Contact information
-------------------

Please feel free to report any bugs, comments, or questions that you may
have to:

  - ganilk@hotmail.com

If I find that there are bugs, I will do my best to correct them and make
the new version of the program avavilable.  I hope that this utility will
help somebody out there.  :)
*/

#include<iostream.h>
#include<conio.h>
#include<fstream.h>
#include<stdio.h>
#include<string.h>
#include<graphics.h>
int huge detectSVGA(void)
{
	return(2);
}
void init_graphics()
{
	int gdriver,gmode;
	gdriver=installuserdriver("SVGA256",detectSVGA);
	gdriver=DETECT;
	gmode=1;
	initgraph(&gdriver,&gmode,"");
}
void close_graphics()
{
	if (!getch()) getch();
	closegraph();
}
class pcx
{
	private:
	char *filepath;
	fstream file;
	int x,y;
	unsigned char ch,no;
	int color;
	int xwidth,ywidth;
	struct pcx_header
	{
		char manufacturer;
		char version_number;
		char type_of_encoding;
		char bits_per_pixel;
		int xmin,ymin;
		int xmax,ymax;
		int x_res,y_res;
		char ega_palette[48];
		char reserved1;
		char num_planes;
		int bytes_per_line;
		int palette_type;
		char reserved2[58];
	} header;
	struct RGB_type
	{
		unsigned char red;
		unsigned char green;
		unsigned char blue;
	} rgb;
	int open_file()
	{
		file.open(filepath,ios::in|ios::binary);
		if (file.fail())  return(1); else return(0);
	}
	public:
	pcx(char *fpath)
	{
		strcpy(filepath,fpath);
	}
	void show_pcx()
	{
	     if (open_file()) return;
	     file.read((char *)&header,sizeof(header));   // loading header
	     xwidth=header.xmax-header.xmin;
	     ywidth=header.ymax-header.ymin;
	     init_graphics();
	     file.seekg(-769,ios::end);		// going to palette location
	     char temp;
	     file.read((char *)&temp,sizeof(temp));
	     if (temp==12&&header.version_number==5)
	     {
		color=1;
		while (color<=256)			// loading palette
		{
			file.read((char *)&rgb,sizeof(rgb));
			setrgbpalette(color,rgb.red>>2,rgb.green>>2,rgb.blue>>2);
			color++;
		}
		file.seekg(128,ios::beg);		// loading pixel data
		x = 1;y=1 ;
		while (y<=ywidth)
		{
			file.read((char *)&ch,sizeof(ch));
			if (ch>=192 && ch<=255)
			{
				no = ch -192;
				file.read((char *)&ch,sizeof(ch));
				while (no>0)
				{
					putpixel(x,y,ch+1);
					x++;
					if (x>header.num_planes*header.bytes_per_line) { x=1;y++; }
					no--;
				}
			}
			else
			{
				putpixel(x,y,ch+1);
				x++;
				if (x>header.num_planes*header.bytes_per_line) { x=1;y++; }
			}
		}
	     }
	     close_graphics();
	     file.close();
	}
};
void main()
{
	char *fpath="";
	clrscr();
	cout<<"Enter file path : ";
	cin>>fpath;
	pcx test(fpath);
	test.show_pcx();
}